// plugin.cpp : Defines the initialization routines for the DLL.
//

#include "stdafx.h"
#include "plugin.h"
#include "AboutDialog.h"
#include "../qerplugin.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//
//	Note!
//
//		If this DLL is dynamically linked against the MFC
//		DLLs, any functions exported from this DLL which
//		call into MFC must have the AFX_MANAGE_STATE macro
//		added at the very beginning of the function.
//
//		For example:
//
//		extern "C" BOOL PASCAL EXPORT ExportedFunction()
//		{
//			AFX_MANAGE_STATE(AfxGetStaticModuleState());
//			// normal function body here
//		}
//
//		It is very important that this macro appear in each
//		function, prior to any calls into MFC.  This means that
//		it must appear as the first statement within the 
//		function, even before any object variable declarations
//		as their constructors may generate calls into the MFC
//		DLL.
//
//		Please see MFC Technical Notes 33 and 58 for additional
//		details.
//

/////////////////////////////////////////////////////////////////////////////
// CPluginApp

BEGIN_MESSAGE_MAP(CPluginApp, CWinApp)
	//{{AFX_MSG_MAP(CPluginApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPluginApp construction

CPluginApp::CPluginApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CPluginApp object

CPluginApp theApp;

// Radiant function table
// use to access what Radiant provides
_QERFuncTable_1 g_FuncTable;

// plugin name
const char *PLUGIN_NAME = "Sample plugin";
// commands in the menu
const char *PLUGIN_COMMANDS = "About...;-;Command 2;Scan brushes";

LPVOID WINAPI QERPlug_GetFuncTable()
{
  return &g_FuncTable;
}

LPCSTR WINAPI QERPlug_Init(HMODULE hApp, HWND hwndMain)
{
   AFX_MANAGE_STATE(AfxGetStaticModuleState());
   memset(&g_FuncTable, 0, sizeof(_QERFuncTable_1));
   g_FuncTable.m_fVersion = 1.00;
   g_FuncTable.m_nSize = sizeof(_QERFuncTable_1);
   
   return "MFC DLL sample QERadiant plugin";
}

LPCSTR WINAPI QERPlug_GetName()
{
  return PLUGIN_NAME;
}

LPCSTR WINAPI QERPlug_GetCommandList()
{
  return PLUGIN_COMMANDS;
}

char	*TranslateString (char *buf)
{
	static	char	buf2[32768];
	int		i, l;
	char	*out;

	l = strlen(buf);
	out = buf2;
	for (i=0 ; i<l ; i++)
	{
		if (buf[i] == '\n')
		{
			*out++ = '\r';
			*out++ = '\n';
		}
		else
			*out++ = buf[i];
	}
	*out++ = 0;

	return buf2;
}

void Sys_Printf (char *text, ...)
{
	va_list argptr;
	char	buf[32768];
	char	*out;

	va_start (argptr,text);
	vsprintf (buf, text,argptr);
	va_end (argptr);

	out = TranslateString (buf);

	g_FuncTable.m_pfnSysMsg ( out );
}

void WINAPI QERPlug_Dispatch(LPCSTR p, vec3_t vMin, vec3_t vMax, BOOL bSingleBrush)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState());
	Sys_Printf("Command \"%s\"\n",p);
	if (!strcmp(p,"About..."))
	{
		CAboutDialog Dlg;
		Dlg.DoModal();
	}
	else if (!strcmp(p,"Scan brushes"))
	{
		// ensure we have something selected
		if( g_FuncTable.m_pfnSelectedBrushCount() < 1 )
		{
			Sys_Printf("nothing selected\n");
			return; 
		}
		// lets scan the selected brushes
		// tell Radiant we want to access the selected brushes
		g_FuncTable.m_pfnAllocateSelectedBrushHandles();
		int brushCount = g_FuncTable.m_pfnSelectedBrushCount();
		Sys_Printf("Scanning %d brushes\n",brushCount);
		// now start scanning
		int brushNum;
		for( brushNum = 0 ; brushNum < brushCount ; brushNum++ )
		{
			brush_t *brush;
			brush = (brush_t *)g_FuncTable.m_pfnGetSelectedBrushHandle(brushNum);
			int faceCount = g_FuncTable.m_pfnGetFaceCount(brush);
			int faceNum;
			for( faceNum = 0 ; faceNum < faceCount ; faceNum++ )
			{
				_QERFaceData	*face;
				face = g_FuncTable.m_pfnGetFaceData(brush, faceNum);
				// here DO SOMETHING !
			}
		}
		// tell Radiant we are done
		g_FuncTable.m_pfnReleaseSelectedBrushHandles();
	}
}
