/*- JBSP.C -------------------------------------------------------------------*
 JBsp v 1.02, aunque no se ha borrado lo que escribi Colin Reed.
 Junio 1997.

 Node builder for DOOM levels (c) 1996 Colin Reed, version 1.5 (dos extended)

 Grficos por LsJmDM, Corrales, Zamora, Espaa.
 Diversas modificaciones hechas, aunque, hay que reconorcerlo, la mayora
 del trabajo lo han hecho  otros, por ahora...
 Incorporado un algoritmo que calcula la reject(cosa que no haca BSP 1.5x).
 
 Performance increased 200% over 1.2x

 Many thanks to Mark Harrison for finding a bug in 1.1 which caused some
 texture align problems when a flipped SEG was split.

 Credit to:-

 Raphael Quinet (A very small amount of code has been borrowed from DEU).
 Matt Fell for the doom specs.
 Lee Killough for performance tuning.

 Also, the original idea for some of the techniques where also taken from the
 comment at the bottom of OBJECTS.C in DEU, and the doc by Matt Fell about
 the nodes.

 Use this code for your own editors, but please credit me.

*---------------------------------------------------------------------------*/
/*-----Funciones del que consturyen los nodos segn Colin Reed---*/
static __inline__ int SplitDist(struct Seg *ts)
{
	double t,dx,dy;

	if(ts->flip==0)
		{
		dx = (double)(vertices[linedefs[ts->linedef].start].x)-(vertices[ts->start].x);
		dy = (double)(vertices[linedefs[ts->linedef].start].y)-(vertices[ts->start].y);

		if(dx == 0 && dy == 0) printf("Problema en SplitDist %f,%f\n",dx,dy);
		t = sqrt((dx*dx) + (dy*dy));
		return (int)t;
		}
	else
		{
		dx = (double)(vertices[linedefs[ts->linedef].end].x)-(vertices[ts->start].x);
		dy = (double)(vertices[linedefs[ts->linedef].end].y)-(vertices[ts->start].y);

		if(dx == 0 && dy == 0) printf("Problema en SplitDist %f,%f\n",dx,dy);
		t = sqrt((dx*dx) + (dy*dy));
		return (int)t;
		}
}
/*--------------------------------------------------------------------------*/
/* Find limits from a list of segs, does this by stepping through the segs*/
/* and comparing the vertices at both ends.*/
/*--------------------------------------------------------------------------*/

static __inline__ void FindLimits(struct Seg *ts)
{
	int minx,miny,maxx,maxy;
	int fv,tv;

	minx = 32767;
	maxx = -32767;
	miny = 32767;
	maxy = -32767;

	for(;;)	{
		fv = ts->start;
		tv = ts->end;
/*		printf("%d : %d,%d\n",n,vertices[n].x,vertices[n].y);*/
		if(vertices[fv].x < minx) minx = vertices[fv].x;
		if(vertices[fv].x > maxx) maxx = vertices[fv].x;
		if(vertices[fv].y < miny) miny = vertices[fv].y;
		if(vertices[fv].y > maxy) maxy = vertices[fv].y;
		if(vertices[tv].x < minx) minx = vertices[tv].x;
		if(vertices[tv].x > maxx) maxx = vertices[tv].x;
		if(vertices[tv].y < miny) miny = vertices[tv].y;
		if(vertices[tv].y > maxy) maxy = vertices[tv].y;
		if(ts->next == NULL) break;
		ts = ts->next;
		}
	lminx = minx;
	lmaxx = maxx;
	lminy = miny;
	lmaxy = maxy;
}


/*--------------------------------------------------------------------------*/
/*- initially creates all segs, one for each line def ----------------------*/

static __inline__ struct Seg *CreateSegs15()
{
	struct Seg *cs = NULL;	/* current and temporary Segs*/
	struct Seg *ts = NULL;
	struct Seg *fs = NULL;	/* first Seg in list*/
/*fs es la lista principal */
	short	n,fv,tv;
	int	dx,dy;
        if(!gfxsi && !ver)
	   printf("Creando Segs ..........\n");

	for(n=0; n < num_lines; n++)/* step through linedefs and get side*/
		{					/* numbers*/
		fv = linedefs[n].start;
		tv = linedefs[n].end;

		if(linedefs[n].sidedef1 != -1)
			{	/* create normal seg*/
               if (sidedefs[linedefs[n].sidedef1].sector==-1)
                   printf("\nWarning: Linedef %d has no sector referenced in right sidedef (Z_CheckHeap)\n\n",n);
               ts = GetMemory( sizeof( struct Seg));   /* get mem for Seg*/
			if(cs)//Si no es la primera vez
				{
				cs->next = ts;
				cs = ts;
				cs->next = NULL;
				}
			else//Si es la primera vez
				{
				fs = cs = ts;
				cs->next = NULL;
				}
			cs->start = fv;
			cs->end = tv;
                     /* printf("%d,%d\n",fv,tv);*/
			dx = (vertices[tv].x-vertices[fv].x);
			dy = (vertices[tv].y-vertices[fv].y);
			cs->angle = ComputeAngle(dx,dy);
			cs->linedef = n;
			cs->dist = 0;
			cs->flip = 0;
			num_tsegs++;
			}
               else
                     printf("\nWarning: Linedef %d has no right sidedef\n\n",n);
	     if(linedefs[n].sidedef2 != -1)
			{	/* create flipped seg*/
               if (sidedefs[linedefs[n].sidedef2].sector==-1)
                     printf("\nWarning: Linedef %d has no sector referenced in left sidedef (Z_CheckHeap)\n\n",n);
			ts = GetMemory( sizeof( struct Seg));
			/* get mem for Seg*/
			if(cs)
				{
				cs->next = ts;
				cs = ts;
				cs->next = NULL;
				}
			else
				{
				fs = cs = ts;
				cs->next = NULL;
				}
			cs->start = tv;
			cs->end = fv;
			dx = (vertices[fv].x-vertices[tv].x);
			dy = (vertices[fv].y-vertices[tv].y);
			cs->angle = ComputeAngle(dx,dy);
			cs->linedef = n;
			cs->dist = 0;
			cs->flip = 1;
			num_tsegs++;
			}
/* NOTA: tv y fv son vrtices */
		}
	return fs;
}
static __inline__ struct Seg *CreateSegs21()
{
	struct Seg *cs = NULL;					/* current and temporary Segs*/
	struct Seg *ts = NULL;
	struct Seg *fs = NULL;					/* first Seg in list*/

	short	n,fv,tv;
	int	dx,dy;

	puts("Creating Segs ..........");

	for(n=0; n < num_lines; n++)			/* step through linedefs and get side*/
		{											/* numbers*/
		fv = linedefs[n].start;
		tv = linedefs[n].end;

		if(linedefs[n].sidedef1 != -1)
			{														/* create normal seg*/
                        if (sidedefs[linedefs[n].sidedef1].sector==-1)
                          printf("\nWarning: Linedef %d has no sector referenced in right sidedef (Z_CheckHeap)\n\n",n);
			ts = GetMemory( sizeof( struct Seg));		/* get mem for Seg*/
			if(cs)
				{
				cs->next = ts;
				cs = ts;
				cs->next = NULL;
				}
			else
				{
				fs = cs = ts;
				cs->next = NULL;
				}
			cs->start = fv;
			cs->end = tv;
/*			printf("%d,%d\n",fv,tv);*/
			dx = (vertices[tv].x-vertices[fv].x);
			dy = (vertices[tv].y-vertices[fv].y);
  		        cs->angle = ComputeAngle(dx,dy);
                        if (linedefs[n].tag==999)
                           cs->angle=(cs->angle + (unsigned)(sidedefs[linedefs[n].sidedef1].xoff*(65536.0/360.0))) & 65535u;
			cs->linedef = n;
			cs->dist = 0;
			cs->flip = 0;
/*			num_tsegs++; */
			}
                   else
                     printf("\nWarning: Linedef %d has no right sidedef\n\n",n);

		if(linedefs[n].sidedef2 != -1)
			{														/* create flipped seg*/
                        if (sidedefs[linedefs[n].sidedef2].sector==-1)
                          printf("\nWarning: Linedef %d has no sector referenced in left sidedef (Z_CheckHeap)\n\n",n);
			ts = GetMemory( sizeof( struct Seg));		/* get mem for Seg*/
			if(cs)
				{
				cs->next = ts;
				cs = ts;
				cs->next = NULL;
				}
			else
				{
				fs = cs = ts;
				cs->next = NULL;
				}
			cs->start = tv;
			cs->end = fv;
			dx = (vertices[fv].x-vertices[tv].x);
			dy = (vertices[fv].y-vertices[tv].y);
  		        cs->angle = ComputeAngle(dx,dy);
                        if (linedefs[n].tag==999)
                           cs->angle=(cs->angle + (unsigned)(sidedefs[linedefs[n].sidedef2].xoff*(65536.0/360.0))) & 65535u;
			cs->linedef = n;
			cs->dist = 0;
			cs->flip = 1;
/*			num_tsegs++; */
			}
		}

	return fs;
}
/*--------------------------------------------------------------------------*/

static __inline__ int IsLineDefInside(int ldnum, int xmin, int ymin, int xmax, int ymax )
{
 int x1 = vertices[ linedefs[ ldnum].start].x;
 int y1 = vertices[ linedefs[ ldnum].start].y;
 int x2 = vertices[ linedefs[ ldnum].end].x;
 int y2 = vertices[ linedefs[ ldnum].end].y;
 int count=2;

 for (;;)
   if (y1>ymax)
    {
     if (y2>ymax)
       return(FALSE);
     x1=x1+(x2-x1)*(ymax-y1)/(y2-y1);
     y1=ymax;
     count=2;
    }
   else
     if (y1<ymin)
      {
       if (y2<ymin)
         return(FALSE);
       x1=x1+(x2-x1)*(ymin-y1)/(y2-y1);
       y1=ymin;
       count=2;
      }
     else
       if (x1>xmax)
        {
         if (x2>xmax)
           return(FALSE);
         y1=y1+(y2-y1)*(xmax-x1)/(x2-x1);
         x1=xmax;
         count=2;
        }
       else
         if (x1<xmin)
          {
           if (x2<xmin)
             return(FALSE);
           y1=y1+(y2-y1)*(xmin-x1)/(x2-x1);
           x1=xmin;
           count=2;
          }
         else
          {
           int t;
           if (!--count)
             return(TRUE);
           t=x1;x1=x2;x2=t;
           t=y1;y1=y2;y2=t;
          }
}

/*- Create blockmap --------------------------------------------------------*/

static __inline__ long CreateBlockmap()
{
	long blockoffs = 0;
	int x,y,n;
	int blocknum = 0;

	blockhead.minx = mapminx&-8;
	blockhead.miny = mapminy&-8;
	blockhead.xblocks = ((mapmaxx - (mapminx&-8)) / 128) + 1;
	blockhead.yblocks = ((mapmaxy - (mapminy&-8)) / 128) + 1;
                    
	blockptrs_size = (blockhead.xblocks*blockhead.yblocks)*2;
	blockptrs = GetMemory(blockptrs_size);

	for(y=0;y<blockhead.yblocks;y++)
		{
		for(x=0;x<blockhead.xblocks;x++)
			{
               progress();

			blockptrs[blocknum]=(blockoffs+4+(blockptrs_size/2));			
			blocklists = ResizeMemory(blocklists,((blockoffs+1)*2));
			blocklists[blockoffs]=0;
			blockoffs++;
			if(gfxsi)
			   Dibujanodo((blockhead.minx+(x*128)),(blockhead.miny+(y*128)),(blockhead.minx+(x*128))+127,(blockhead.miny+(y*128))+127, GRAY);
			for(n=0;n<num_lines;n++)
				{
				if(IsLineDefInside(n,(blockhead.minx+(x*128)),(blockhead.miny+(y*128)),(blockhead.minx+(x*128))+127,(blockhead.miny+(y*128))+127))
					{
//					if(!gfxsi)
//					   printf("found line %d in block %d\n",n,blocknum);
					blocklists = ResizeMemory(blocklists,((blockoffs+1)*2));
					blocklists[blockoffs]=n;
					blockoffs++;
					}
				}
			blocklists = ResizeMemory(blocklists,((blockoffs+1)*2));
			blocklists[blockoffs]=-1;
			blockoffs++;

			blocknum++;
			}
		}
	return blockoffs*2;
}

/*--------------------------------------------------------------------------*/

static void ReverseNodes(struct Node *tn)
{
	if((tn->chright & 0x8000) == 0)
		{
		ReverseNodes(tn->nextr);
		tn->chright = tn->nextr->node_num;
		}
	if((tn->chleft & 0x8000) == 0)
		{
		ReverseNodes(tn->nextl);
		tn->chleft = tn->nextl->node_num;
		}
	pnodes[pnode_indx].x = tn->x;
	pnodes[pnode_indx].y = tn->y;
	pnodes[pnode_indx].dx = tn->dx;
	pnodes[pnode_indx].dy = tn->dy;
	pnodes[pnode_indx].maxy1 = tn->maxy1;
	pnodes[pnode_indx].miny1 = tn->miny1;
	pnodes[pnode_indx].minx1 = tn->minx1;
	pnodes[pnode_indx].maxx1 = tn->maxx1;
	pnodes[pnode_indx].maxy2 = tn->maxy2;
	pnodes[pnode_indx].miny2 = tn->miny2;
	pnodes[pnode_indx].minx2 = tn->minx2;
	pnodes[pnode_indx].maxx2 = tn->maxx2;
	pnodes[pnode_indx].chright = tn->chright;
	pnodes[pnode_indx].chleft = tn->chleft;
	pnode_indx++;
	tn->node_num = num_pnodes++;
}
/************
*************
==========================
MAKENODE.C
==========================
*************
************/
/* NOTA: ahora todo el constructor est en un nico fichero fuente */
/*- MAKENODE.C --------------------------------------------------------------*
 Recursively create nodes and return the pointers.
*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*
 Split a list of segs (ts) into two using the method described at bottom of
 file, this was taken from OBJECTS.C in the DEU5beta source.

 This is done by scanning all of the segs and finding the one that does
 the least splitting and has the least difference in numbers of segs on either
 side.
 If the ones on the left side make a SSector, then create another SSector
 else put the segs into lefts list.
 If the ones on the right side make a SSector, then create another SSector
 else put the segs into rights list.
*---------------------------------------------------------------------------*/

static __inline__ void DivideSegs15(struct Seg *ts,struct Seg **rs,struct Seg **ls)
{
     struct Seg *rights,*lefts;
	struct Seg *tmps,*best,*news,*prev;
	struct Seg *add_to_rs,*add_to_ls;
  	struct Seg *new_best=NULL,*new_rs,*new_ls;
	
	struct Seg *strights,*stlefts;
        int num_new=0;
/*
	int num_secs_r,num_secs_l,last_sec_r,last_sec_l;
	int num,least_splits,least;
	int fv,tv,num_new = 0;
	int bangle,cangle,cangle2,cfv,ctv,dx,dy;
*/
	short int x,y,val;

	FindLimits(ts);							/* Find limits of this set of Segs*/

	sp.halfsx = (lmaxx - lminx) / 2;		/* Find half width of Node*/
	sp.halfsy = (lmaxy - lminy) / 2;
	sp.halfx = lminx + sp.halfsx;			/* Find middle of Node*/
	sp.halfy = lminy + sp.halfsy;

     best = PickNode15(ts);		/* Pick best node to use.*/

     if(best == NULL) ProgError("No se encuentra una lnea de particin!");

	node_x = vertices[best->start].x;
	node_y = vertices[best->start].y;
	node_dx = vertices[best->end].x-vertices[best->start].x;
	node_dy = vertices[best->end].y-vertices[best->start].y;

     if(gfxsi)
           Dibujalinea(best->start, best->end, GREEN);
/* When we get to here, best is a pointer to the partition seg.
	Using this partition line, we must split any lines that are intersected
	into a left and right half, flagging them to be put their respective sides
	Ok, now we have the best line to use as a partitioning line, we must
   split all of the segs into two lists (rightside & leftside).				 */

	rights = NULL;									/* Start off with empty*/
	lefts = NULL;									/* lists.*/
	strights = NULL;								/* Start off with empty*/
	stlefts = NULL;								/* lists.*/

	psx = vertices[best->start].x;			/* Partition line coords*/
	psy = vertices[best->start].y;
	pex = vertices[best->end].x;
	pey = vertices[best->end].y;
	pdx = psx - pex;								/* Partition line DX,DY*/
	pdy = psy - pey;

	for(tmps=ts;tmps;tmps=tmps->next)
		{
          progress();      /* Something for the user to look at.*/

		add_to_rs = NULL;
		add_to_ls = NULL;
		if(tmps != best)
			{
			lsx = vertices[tmps->start].x;	/* Calculate this here, cos it doesn't*/
			lsy = vertices[tmps->start].y;	/* change for all the interations of*/
			lex = vertices[tmps->end].x;		/* the inner loop!*/
			ley = vertices[tmps->end].y;
			val = DoLinesIntersect();
			if((val&2 && val&64) || (val&4 && val&32))/* If intersecting !!*/
				{
                    ComputeIntersection15(&x,&y);
//				if(!gfxsi)
//				  printf("Splitting Linedef %d at %d,%d\n",tmps->linedef,x,y);

				vertices = ResizeMemory(vertices, sizeof(struct Vertex) * (num_verts+1));
				vertices[num_verts].x = x;
				vertices[num_verts].y = y;
	
				news = GetMemory(sizeof( struct Seg));

				news->next = tmps->next;
				tmps->next = news;
				news->start = num_verts;
				news->end = tmps->end;
				tmps->end = num_verts;
				news->linedef = tmps->linedef;
				news->angle = tmps->angle;
				news->flip = tmps->flip;
				news->dist = SplitDist(news);
//				if(!gfxsi)
//				{
//				  printf("splitting dist = %d\n",news->dist);
//				  printf("splitting vertices = %d,%d,%d,%d\n",tmps->start,tmps->end,news->start,news->end);
//				}  
				if(val&32) add_to_ls = tmps;
				if(val&64) add_to_rs = tmps;
				if(val&2) add_to_ls = news;
				if(val&4) add_to_rs = news;
				tmps = news;
				num_verts++;
				num_new++;
				}
			else
				{											/* Not split, which side ?*/
				if(val&34) add_to_ls = tmps;
				if(val&68) add_to_rs = tmps;
				if(val&1 && val&16)					/* On same line*/
					{
					if(tmps->flip == best->flip) add_to_rs = tmps;
					if(tmps->flip != best->flip) add_to_ls = tmps;
					}
				}
			}
		else add_to_rs = tmps;						/* This is the partition line*/
		
/*		printf("Val = %X\n",val);*/

		if(add_to_rs)							/* CHECK IF SHOULD ADD RIGHT ONE */
			{
			new_rs = GetMemory(sizeof(struct Seg));
			if(add_to_rs == best) new_best = new_rs;
			new_rs->start = add_to_rs->start;
			new_rs->end = add_to_rs->end;
			new_rs->linedef = add_to_rs->linedef;
			new_rs->angle = add_to_rs->angle;
			new_rs->flip = add_to_rs->flip;
			new_rs->dist = add_to_rs->dist;
			new_rs->next = NULL;
			if(!rights) strights = rights = new_rs;
			else
				{
				rights->next = new_rs;
				rights = new_rs;
				}
			}
				
		if(add_to_ls)							/* CHECK IF SHOULD ADD LEFT ONE */
			{
			new_ls = GetMemory(sizeof(struct Seg));
			if(add_to_ls == best) new_best = new_ls;
			new_ls->start = add_to_ls->start;
			new_ls->end = add_to_ls->end;
			new_ls->linedef = add_to_ls->linedef;
			new_ls->angle = add_to_ls->angle;
			new_ls->flip = add_to_ls->flip;
			new_ls->dist = add_to_ls->dist;
			new_ls->next = NULL;
			if(!lefts) stlefts = lefts = new_ls;
			else
				{
				lefts->next = new_ls;
				lefts = new_ls;
				}
			}
		}

	if(strights == NULL)
		{
/*		printf("No right side, moving partition into right side\n");*/
		strights = rights = new_best;
		prev = NULL;
		for(tmps=stlefts;tmps;tmps=tmps->next)
			{
			if(tmps == new_best)
				{
				if(prev != NULL) prev->next=tmps->next;
				else stlefts=tmps->next;
				}
			prev=tmps;
			}
		prev->next = NULL;
		}
	
	if(stlefts == NULL)
		{
/*		printf("No left side, moving partition into left side\n");*/
		stlefts = lefts = new_best;
		prev = NULL;
		for(tmps=strights;tmps;tmps=tmps->next)
			{
			if(tmps == new_best)
				{
				if(prev != NULL) prev->next=tmps->next;
				else strights=tmps->next;
				}
			prev=tmps;
			}
		stlefts->next = NULL;
		prev->next = NULL;								/* Make sure end of list = NULL*/
		}

	if(rights->next != NULL) rights->next = NULL;
	if(lefts->next != NULL) lefts->next = NULL;

	for(tmps=ts;tmps;tmps=best)
		{
		best=tmps->next;
		free(tmps);
		}

/*	printf("Made %d new Vertices and Segs\n",num_new);*/

	*rs = strights ; *ls = stlefts;
}

static __inline__ void DivideSegs21(struct Seg *ts,struct Seg **rs,struct Seg **ls)
{
	struct Seg *rights,*lefts;
	struct Seg *tmps,*best,*news,*prev;
	struct Seg *add_to_rs,*add_to_ls;
  	struct Seg *new_best=NULL,*new_rs,*new_ls;

	struct Seg *strights,*stlefts;
        int num_new=0;
/*
	int num_secs_r,num_secs_l,last_sec_r,last_sec_l;
	int num,least_splits,least;
	int fv,tv,num_new = 0;
	int bangle,cangle,cangle2,cfv,ctv,dx,dy;
*/
	short int x,y,val;

	FindLimits(ts);							/* Find limits of this set of Segs*/
#if 0
	sp.halfsx = (lmaxx - lminx) / 2;		/* Find half width of Node*/
	sp.halfsy = (lmaxy - lminy) / 2;
	sp.halfx = lminx + sp.halfsx;			/* Find middle of Node*/
	sp.halfy = lminy + sp.halfsy;
#endif
     best = PickNode21(ts);			/* Pick best node to use.*/

	if(best == NULL) ProgError("Couldn't pick nodeline!");

	node_x = vertices[best->start].x;
	node_y = vertices[best->start].y;
	node_dx = vertices[best->end].x-vertices[best->start].x;
	node_dy = vertices[best->end].y-vertices[best->start].y;

	if(gfxsi)
           Dibujalinea(best->start, best->end, GREEN);
/* When we get to here, best is a pointer to the partition seg.
	Using this partition line, we must split any lines that are intersected
	into a left and right half, flagging them to be put their respective sides
	Ok, now we have the best line to use as a partitioning line, we must
   split all of the segs into two lists (rightside & leftside).				 */

	rights = NULL;									/* Start off with empty*/
	lefts = NULL;									/* lists.*/
	strights = NULL;								/* Start off with empty*/
	stlefts = NULL;								/* lists.*/

	psx = vertices[best->start].x;			/* Partition line coords*/
	psy = vertices[best->start].y;
	pex = vertices[best->end].x;
	pey = vertices[best->end].y;
	pdx = psx - pex;								/* Partition line DX,DY*/
	pdy = psy - pey;

	for(tmps=ts;tmps;tmps=tmps->next)
		{
		progress();		/* Something for the user to look at.*/

		add_to_rs = NULL;
		add_to_ls = NULL;
		if(tmps != best)
			{
			lsx = vertices[tmps->start].x;	/* Calculate this here, cos it doesn't*/
			lsy = vertices[tmps->start].y;	/* change for all the interations of*/
			lex = vertices[tmps->end].x;		/* the inner loop!*/
			ley = vertices[tmps->end].y;
			val = DoLinesIntersect();
			if((val&2 && val&64) || (val&4 && val&32))	/* If intersecting !!*/
				{
                    ComputeIntersection21(&x,&y);
/*				printf("Splitting Linedef %d at %d,%d\n",tmps->linedef,x,y);*/
                    vertices = ResizeMemory(vertices, sizeof(struct Vertex) * (num_verts+1));
				vertices[num_verts].x = x;
				vertices[num_verts].y = y;

				news = GetMemory(sizeof( struct Seg));

				news->next = tmps->next;
				tmps->next = news;
				news->start = num_verts;
				news->end = tmps->end;
				tmps->end = num_verts;
				news->linedef = tmps->linedef;
				news->angle = tmps->angle;
				news->flip = tmps->flip;
				news->dist = SplitDist(news);
/*				printf("splitting dist = %d\n",news->dist);*/
/*				printf("splitting vertices = %d,%d,%d,%d\n",tmps->start,tmps->end,news->start,news->end);*/
				if(val&32) add_to_ls = tmps;
				if(val&64) add_to_rs = tmps;
				if(val&2) add_to_ls = news;
				if(val&4) add_to_rs = news;
				tmps = news;
				num_verts++;
				num_new++;
				}
			else
				{											/* Not split, which side ?*/
				if(val&34) add_to_ls = tmps;
				if(val&68) add_to_rs = tmps;
				if(val&1 && val&16)					/* On same line*/
					{
/* 06/01/97 Lee Killough: this fixes a bug ever since 1.2x,
   probably 1.0, of BSP: when partitioning a parallel seg,
   you must take its vertices' orientation into account, NOT the
   flip bits, to determine which side of the partitioning line a
   parallel seg should go on. If you simply flip the linedef in
   question, you will be flipping both its vertices and sidedefs,
   and the flip bits as well, even though the basic geometry has
   not changed. Thus you need to use the vertices' orientation
   (whether the seg is in the same direction or not, regardless
   of its original linedef's being flipped or not), into account.

   Originally, some segs were partitioned backwards, and if
   it happened that there were different sectors on either
   side of the seg being partitioned, it could leave holes
   in space, causing either invisible barriers or disappearing
   Things, because the ssector would be associated with the
   wrong sector.

   The old logic of tmps->flip != best->flip seems to rest on
   the assumption that if two segs are parallel, they came
   from the same linedef. This is clearly not always true.   */

              /*  if (tmps->flip != best->flip)   old logic -- wrong!!! */

              /* We know the segs are parallel or nearly so, so take their
                 dot product to determine their relative orientation. */

		if ( (lsx-lex)*pdx + (lsy-ley)*pdy < 0)
  	         add_to_ls = tmps;
	 	else
		 add_to_rs = tmps;
					}
				}
			}
		else add_to_rs = tmps;						/* This is the partition line*/

/*		printf("Val = %X\n",val);*/

		if(add_to_rs)							/* CHECK IF SHOULD ADD RIGHT ONE */
			{
			new_rs = GetMemory(sizeof(struct Seg));
			if(add_to_rs == best) new_best = new_rs;
			new_rs->start = add_to_rs->start;
			new_rs->end = add_to_rs->end;
			new_rs->linedef = add_to_rs->linedef;
			new_rs->angle = add_to_rs->angle;
			new_rs->flip = add_to_rs->flip;
			new_rs->dist = add_to_rs->dist;
			new_rs->next = NULL;
			if(!rights) strights = rights = new_rs;
			else
				{
				rights->next = new_rs;
				rights = new_rs;
				}
			}
				
		if(add_to_ls)							/* CHECK IF SHOULD ADD LEFT ONE */
			{
			new_ls = GetMemory(sizeof(struct Seg));
			if(add_to_ls == best) new_best = new_ls;
			new_ls->start = add_to_ls->start;
			new_ls->end = add_to_ls->end;
			new_ls->linedef = add_to_ls->linedef;
			new_ls->angle = add_to_ls->angle;
			new_ls->flip = add_to_ls->flip;
			new_ls->dist = add_to_ls->dist;
			new_ls->next = NULL;
			if(!lefts) stlefts = lefts = new_ls;
			else
				{
				lefts->next = new_ls;
				lefts = new_ls;
				}
			}
		}

	if(strights == NULL)
		{
/*		printf("No right side, moving partition into right side\n");*/
		strights = rights = new_best;
		prev = NULL;
		for(tmps=stlefts;tmps;tmps=tmps->next)
			{
			if(tmps == new_best)
				{
				if(prev != NULL) prev->next=tmps->next;
				else stlefts=tmps->next;
				}
			prev=tmps;
			}
		prev->next = NULL;
		}
	
	if(stlefts == NULL)
		{
/*		printf("No left side, moving partition into left side\n");*/
		stlefts = lefts = new_best;
		prev = NULL;
		for(tmps=strights;tmps;tmps=tmps->next)
			{
			if(tmps == new_best)
				{
				if(prev != NULL) prev->next=tmps->next;
				else strights=tmps->next;
				}
			prev=tmps;
			}
		stlefts->next = NULL;
		prev->next = NULL;								/* Make sure end of list = NULL*/
		}

	if(rights->next != NULL) rights->next = NULL;
	if(lefts->next != NULL) lefts->next = NULL;

	for(tmps=ts;tmps;tmps=best)
		{
		best=tmps->next;
		free(tmps);
		}

/*	printf("Made %d new Vertices and Segs\n",num_new);*/

	*rs = strights ; *ls = stlefts;
}
/*--------------------------------------------------------------------------*/

static __inline__ int IsItConvex15( struct Seg *ts)
{
   struct Seg *line,*check;
   int   sector,val;

   if (ts->flip) sector = sidedefs[linedefs[ ts->linedef].sidedef2].sector;
   else sector = sidedefs[linedefs[ts->linedef].sidedef1].sector;
   
	for (line = ts->next; line; line = line->next)
   	{
      if (line->flip)
      	{
			if (sidedefs[ linedefs[ line->linedef].sidedef2].sector != sector)
				return TRUE;
      	}
      else
      	{
			if (sidedefs[ linedefs[ line->linedef].sidedef1].sector != sector)
	    		return TRUE;
			}
   	}
   
	/* all of the segs must be on the same side all the other segs */

	for(line=ts;line;line=line->next)
		{
		psx = vertices[line->start].x;
		psy = vertices[line->start].y;
		pex = vertices[line->end].x;
		pey = vertices[line->end].y;
		pdx = (psx - pex);									/* Partition line DX,DY*/
		pdy = (psy - pey);
		for(check=ts;check;check=check->next)
			{
			if(line!=check)
				{
				lsx = vertices[check->start].x;	/* Calculate this here, cos it doesn't*/
				lsy = vertices[check->start].y;	/* change for all the interations of*/
				lex = vertices[check->end].x;		/* the inner loop!*/
				ley = vertices[check->end].y;
				val = DoLinesIntersect();
				if(val&34) return TRUE;
				}
			}
		}

	/* no need to split the list: these Segs can be put in a SSector */
   return FALSE;
}

static __inline__ int IsItConvex21( struct Seg *ts)
{
   struct Seg *line=ts,*check;
   int   sector,val;

/* All ssectors must come from same sector unless it's marked
   "special" with sector tag >= 900. Original idea, Lee Killough */

   sector = sidedefs[ts->flip ? linedefs[ts->linedef].sidedef2 :
                                linedefs[ts->linedef].sidedef1].sector;
   if (sectors[sector].tag < 900)
     while ((line=line->next)!=0)
      {
       int ts=sidedefs[line->flip ? linedefs[line->linedef].sidedef2 :
                                    linedefs[line->linedef].sidedef1].sector;
       if (ts != sector && sectors[ts].tag < 900)
           return TRUE;
      }

   /* all of the segs must be on the same side all the other segs */

	for(line=ts;line;line=line->next)
		{
		psx = vertices[line->start].x;
		psy = vertices[line->start].y;
		pex = vertices[line->end].x;
		pey = vertices[line->end].y;
		pdx = (psx - pex);									/* Partition line DX,DY*/
		pdy = (psy - pey);
		for(check=ts;check;check=check->next)
			{
			if(line!=check)
				{
				lsx = vertices[check->start].x;	/* Calculate this here, cos it doesn't*/
				lsy = vertices[check->start].y;	/* change for all the interations of*/
				lex = vertices[check->end].x;		/* the inner loop!*/
				ley = vertices[check->end].y;
				val = DoLinesIntersect();
				if(val&34) return TRUE;
				}
			}
		}

	/* no need to split the list: these Segs can be put in a SSector */
   return FALSE;
}
/*--------------------------------------------------------------------------*/

static __inline__ int CreateSSector(struct Seg *tmps)
{
	int n;

	if(num_ssectors == 0)
          ssectors = GetMemory(sizeof(struct SSector));
	else
		ssectors = ResizeMemory(ssectors,sizeof(struct SSector)*(num_ssectors+1));

	ssectors[num_ssectors].first = num_psegs;

	n = num_psegs;
	
/*	printf("\n");*/

	for(;tmps;tmps=tmps->next)
		{
		if(num_psegs == 0)
               psegs = GetMemory(sizeof(struct Pseg));
		else
			psegs = ResizeMemory(psegs,sizeof(struct Pseg)*(num_psegs+1));

		psegs[num_psegs].start = tmps->start;
		psegs[num_psegs].end = tmps->end;
		psegs[num_psegs].angle = tmps->angle;
		psegs[num_psegs].linedef = tmps->linedef;
		psegs[num_psegs].flip = tmps->flip;
		psegs[num_psegs].dist = tmps->dist;
/*
		printf("%d,%d,%u,%d,%d,%u\n",
			psegs[num_psegs].start,
			psegs[num_psegs].end,
			psegs[num_psegs].angle,
			psegs[num_psegs].linedef,
			psegs[num_psegs].flip,
			psegs[num_psegs].dist);
*/
		num_psegs++;
		}

	ssectors[num_ssectors].num = num_psegs-n;

	num_ssectors++;

	return num_ssectors-1;
}

/*- translate (dx, dy) into an integer angle value (0-65535) ---------------*/

static __inline__ unsigned ComputeAngle( int dx, int dy)
{
   double w;

	w = (atan2( (double) dy , (double) dx) * (double)(65536/(M_PI*2)));

	if(w<0) w = (double)65536+w;

	return (unsigned) w;
}

static struct Node *CreateNode(struct Seg *ts)
{
	struct Node *tn;
	struct Seg *rights = NULL;
	struct Seg *lefts = NULL;

	tn = GetMemory( sizeof( struct Node));	/* Create a node*/
 
     if(bsp15)
 		DivideSegs15(ts,&rights,&lefts);	/* Divide node in two*/
     if(bsp21)
     	DivideSegs21(ts,&rights,&lefts);

	num_nodes++;

	tn->x = node_x;											/* store node line info*/
	tn->y = node_y;
	tn->dx = node_dx;
	tn->dy = node_dy;

	FindLimits(lefts);										/* Find limits of vertices	*/

	tn->maxy2 = lmaxy;
	tn->miny2 = lminy;
	tn->minx2 = lminx;
	tn->maxx2 = lmaxx;
        
        if(gfxsi)        
           Dibujanodo( lminx, lminy, lmaxx, lmaxy, RED);
        
     if(bsp15)
     {
        if(IsItConvex15(lefts))	/* Check lefthand side*/
	   {
		tn->nextl = CreateNode(lefts);					/* still segs remaining*/
		tn->chleft = 0;
	   }
	   else
	   {
		tn->nextl = NULL;
		tn->chleft = CreateSSector(lefts) | 0x8000;
	   }
     }
     if(bsp21)
     {
       if(IsItConvex21(lefts))	/* Check lefthand side*/
	   {
		tn->nextl = CreateNode(lefts);	/* still segs remaining*/
		tn->chleft = 0;
	   }
	   else
	   {
		tn->nextl = NULL;
		tn->chleft = CreateSSector(lefts) | 0x8000;
	   }
     }
     FindLimits(rights);										/* Find limits of vertices*/
	
	tn->maxy1 = lmaxy;
	tn->miny1 = lminy;
	tn->minx1 = lminx;
	tn->maxx1 = lmaxx;

	if(gfxsi)
           Dibujanodo( lminx, lminy, lmaxx, lmaxy, BLUE);
	
     if(bsp15)
     {
		if(IsItConvex15(rights))		/* Check righthand side*/
		{
			tn->nextr = CreateNode(rights);/* still segs remaining*/
			tn->chright = 0;
		}
		else
		{
			tn->nextr = NULL;
			tn->chright =  CreateSSector(rights) | 0x8000;
		}
     }
     if(bsp21)
     {
          if(IsItConvex21(rights))		/* Check righthand side*/
		{
			tn->nextr = CreateNode(rights);/* still segs remaining*/
			tn->chright = 0;
		}
		else
		{
			tn->nextr = NULL;
			tn->chright =  CreateSSector(rights) | 0x8000;
		}
     }
     return tn;
}

/*---------------------------------------------------------------------------*
   
	This message has been taken, complete, from OBJECTS.C in DEU5beta source.
	It outlines the method used here to pick the nodelines.

	IF YOU ARE WRITING A DOOM EDITOR, PLEASE READ THIS:

   I spent a lot of time writing the Nodes builder.  There are some bugs in
   it, but most of the code is OK.  If you steal any ideas from this program,
   put a prominent message in your own editor to make it CLEAR that some
   original ideas were taken from DEU.  Thanks.

   While everyone was talking about LineDefs, I had the idea of taking only
   the Segs into account, and creating the Segs directly from the SideDefs.
   Also, dividing the list of Segs in two after each call to CreateNodes makes
   the algorithm faster.  I use several other tricks, such as looking at the
   two ends of a Seg to see on which side of the nodeline it lies or if it
   should be split in two.  I took me a lot of time and efforts to do this.

   I give this algorithm to whoever wants to use it, but with this condition:
   if your program uses some of the ideas from DEU or the whole algorithm, you
   MUST tell it to the user.  And if you post a message with all or parts of
   this algorithm in it, please post this notice also.  I don't want to speak
   legalese; I hope that you understand me...  I kindly give the sources of my
   program to you: please be kind with me...

   If you need more information about this, here is my E-mail address:
   Raphael.Quinet@eed.ericsson.se (Raphal Quinet).

   Short description of the algorithm:
     1 - Create one Seg for each SideDef: pick each LineDef in turn.  If it
	 has a "first" SideDef, then create a normal Seg.  If it has a
	 "second" SideDef, then create a flipped Seg.
     2 - Call CreateNodes with the current list of Segs.  The list of Segs is
	 the only argument to CreateNodes.
     3 - Save the Nodes, Segs and SSectors to disk.  Start with the leaves of
	 the Nodes tree and continue up to the root (last Node).

   CreateNodes does the following:
     1 - Pick a nodeline amongst the Segs (minimize the number of splits and
	 keep the tree as balanced as possible).
     2 - Move all Segs on the right of the nodeline in a list (segs1) and do
	 the same for all Segs on the left of the nodeline (in segs2).
     3 - If the first list (segs1) contains references to more than one
	 Sector or if the angle between two adjacent Segs is greater than
	 180, then call CreateNodes with this (smaller) list.  Else, create
	 a SubSector with all these Segs.
     4 - Do the same for the second list (segs2).
     5 - Return the new node (its two children are already OK).

   Each time CreateSSector is called, the Segs are put in a global list.
   When there is no more Seg in CreateNodes' list, then they are all in the
   global list and ready to be saved to disk.

*---------------------------------------------------------------------------*/
/******
PICKNODE.C
******/
/*- PICKNODE.C --------------------------------------------------------------*
 To be able to divide the nodes down, this routine must decide which is the
 best Seg to use as a nodeline. It does this by selecting the line with least
 splits and has least difference of Segs on either side of it.

 Credit to Raphael Quinet and DEU, this routine is a copy of the nodeline
 picker used in DEU5beta. I am using this method because the method I
 originally used was not so good.

 Rewritten by Lee Killough to significantly improve performance, while
 not affecting results one bit in >99% of cases (some tiny differences
 due to roundoff error may occur, but they are insignificant).
*---------------------------------------------------------------------------*/

#define FACTOR 8  /* This is the original "factor" used by previous versions
                     of the code -- it must be maintained in a macro to avoid
                     mistakes if we are to keep the tradition of using it,
                     and being able to modify it.
		   */

static int factor=2*FACTOR+1;

static __inline__ struct Seg *PickNode15(struct Seg *ts)
{
 struct Seg *best=ts;	         /* Set best to first (failsafe measure)*/
 int bestgrade=~(1<<(8*sizeof(int)-1));  /* Portable definition of INT_MAX */
 struct Seg *part;
 int cnt;

 for (cnt=0,part=ts;part;part=part->next,cnt++) /* Count once and for all */
  {
   double dx=(long) (part->psx = vertices[part->start].x)
                  - (part->pex = vertices[part->end].x);
   double dy=(long) (part->psy = vertices[part->start].y)
                  - (part->pey = vertices[part->end].y);
   if (! (part->tmpdist=sqrt(dx*dx+dy*dy)))
       ProgError("Problema en PickNode dx, dy");
  }

 for (part=ts;part;part = part->next)	/* Use each Seg as partition*/
  {
   short psx = part->psx;
   short psy = part->psy;
   long pdx  = (long) psx - part->pex;	/* Partition line DX,DY*/
   long pdy  = (long) psy - part->pey;
   long ptmp = pdx*psy-psx*pdy;		/* Used to decrease arithmetic */
                                        /* inside the inner loop       */
   struct Seg *check;
   int partflip=part->flip;
   int tot=cnt,grade=cnt,diff=cnt*2;    /* cnt computed before loops */

   progress();          /* Something for the user to look at.*/

   for (check=ts;check;check=check->next) /* Check partition against all Segs*/
    {
        /*     get state of lines' relation to each other    */
     register long a=pdx * check->psy - pdy * check->psx - ptmp;
     register long b=pdx * check->pey - pdy * check->pex - ptmp;

     if ((a^b) < 0)
       if (a && b)
	{                           /* Line is split; a,b nonzero, opposite sign */
	 long l=check->tmpdist;     /* Length of segment, previously computed */
	 long d=a*l/(a-b);          /* How far from start the intersection is */
	 if (d >= 2)                /* Only consider >=2 ; dist<2 is special */
	  {
        grade+=factor;
	   if (grade > bestgrade)   /* This is the heart of my pruning idea - */
          {
	     goto prune;            /* it catches bad segs early on. Killough */
	     }   
	   tot++;
	  }
	 else                       /* Distance from start is less than 2; */
           if (l-d < 2 ? check->flip != partflip : b < 0)
             diff-=2;               /* Check distance from end */
	}
       else
         diff-=2;
     else
       if (a<=0 && (a!=0 || (check->flip!=partflip && b<=0)))
         diff-=2;
    }

   diff-=tot;

   if (diff < 0)        /* Take absolute value. diff is being used to obtain the */
     diff= -diff;       /* min/max values by way of: max(a,b)=(a+b+abs(a-b))/2   */

   if (diff < tot)	/* Make sure at least one Seg is*/
    {		        /* on either side of the partition*/
     grade+=diff;
     if (grade < bestgrade)
      {
       bestgrade = grade;
       best = part;	/* and remember which Seg*/
      }
    }
  prune:;                 /* early exit and skip past the tests above */
  
  }
 return best;		/* all finished, return best Seg*/
}
/*------------------------------------------------------------------------*/

static __inline__ struct Seg *PickNode21(struct Seg *ts)
{
 struct Seg *best=ts;
 unsigned long bestcost=~0ul;
 struct Seg *part;
 int cnt=0;

 for (part=ts;part;part=part->next,cnt++) /* Count once and for all */
  {
    double dx=(long) (part->psx = vertices[part->start].x)
                   - (part->pex = vertices[part->end].x);
    double dy=(long) (part->psy = vertices[part->start].y)
                   - (part->pey = vertices[part->end].y);
    if (! (part->tmpdist=sqrt(dx*dx+dy*dy)))
      ProgError("Trouble in PickNode dx, dy");
  }

 for (part=ts;part;part = part->next)	/* Use each Seg as partition*/
  {
   short psx = part->psx;
   short psy = part->psy;
   long pdx  = (long) psx - part->pex;	/* Partition line DX,DY*/
   long pdy  = (long) psy - part->pey;
   long ptmp = pdx*psy-psx*pdy;		/* Used to decrease arithmetic */
                                        /* inside the inner loop       */
   struct Seg *check;
   unsigned long cost=0;
   int tot=0,diff=cnt;

   progress();                /* Something for the user to look at.*/

   for (check=ts;check;check=check->next) /* Check partition against all Segs*/
    {
        /*     get state of lines' relation to each other    */
     long a=pdx * check->psy - pdy * check->psx - ptmp;
     long b=pdx * check->pey - pdy * check->pex - ptmp;

     if ((a^b) < 0)
       if (a && b)
	{                           /* Line is split; a,b nonzero, opposite sign */
	 long l=check->tmpdist;     /* Length of segment, previously computed */
	 long d=a*l/(a-b);          /* How far from start the intersection is */
	 if (d >= 2)                /* Only consider >=2 ; dist<2 is special */
	  {
           cost += factor;

        /* If the linedef associated with this seg has a sector tag >= 900,
           treat it as precious; i.e. don't split it unless all other options
           are exhausted. This is used to protect deep water and invisible
           lifts/stairs from being messed up accidentally by splits. */

           if (linedefs[check->linedef].tag >= 900)
	     cost += factor*64;

	   if (cost > bestcost)     /* This is the heart of my pruning idea - */
	     goto prune;            /* it catches bad segs early on. Killough */

           tot++;
	  }
	 else                       /* Distance from start is less than 2; */
           if (l-d < 2 ? (check->psx-check->pex)*pdx +
                         (check->psy-check->pey)*pdy < 0 : b < 0)
             diff-=2;               /* Check distance from end */
        }
       else
         diff-=2;
     else
       if (a<=0 && (a || (!b && (check->psx-check->pex)*pdx +
                                (check->psy-check->pey)*pdy < 0 )))
         diff-=2;
    }

   if ((diff-=tot) < 0) /* Take absolute value. diff is being used to obtain the */
     diff= -diff;       /* min/max values by way of: min(a,b)=(a+b-abs(a-b))/2   */

   if ((tot+=cnt) > diff) /* Make sure at least one Seg is*/
    {		          /* on either side of the partition*/
     cost+=diff;
     if (cost < bestcost)
      {
       bestcost = cost;
       best = part;	/* and remember which Seg*/
      }
    }
prune:;                 /* early exit and skip past the tests above */
  }
 return best;		/* all finished, return best Seg*/
}
/*---------------------------------------------------------------------------*
 Calculate the point of intersection of two lines. ps?->pe? & ls?->le?
 returns int xcoord, int ycoord
*---------------------------------------------------------------------------*/

static __inline__ void ComputeIntersection15(short int *outx,short int *outy)
{
	double a,b,a2,b2,l2,w,d,z;

	long dx,dy,dx2,dy2;

	dx = pex - psx;
	dy = pey - psy;
	dx2 = lex - lsx;
	dy2 = ley - lsy;

	if (dx == 0 && dy == 0) ProgError("Trouble in ComputeIntersection dx,dy");
/*	l = (long)sqrt((float)((dx*dx) + (dy*dy)));  unnecessary - killough */
	if(dx2 == 0 && dy2 == 0) ProgError("Problema en ComputeIntersection dx2,dy2");
	l2 = (long)sqrt((float)((dx2*dx2) + (dy2*dy2)));

	a = dx /* / l */;  /* no normalization of a,b necessary,   */
	b = dy /* / l */;  /* since division by d in formula for w */
	a2 = dx2 / l2;     /* cancels it out. */
	b2 = dy2 / l2;
	d = b * a2 - a * b2;
	w = lsx;
	z = lsy;
	if(d != 0.0)
		{
		w = (((a*(lsy-psy))+(b*(psx-lsx))) / d);

/*		printf("Intersection at (%f,%f)\n",x2+(a2*w),y2+(b2*w));*/

		a = lsx+(a2*w);
		b = lsy+(b2*w);
		modf((float)(a)+ ((a<0)?-0.5:0.5) ,&w);
		modf((float)(b)+ ((b<0)?-0.5:0.5) ,&z);
		}

	*outx = w;
	*outy = z;
}
static __inline__ void ComputeIntersection21(short int *outx,short int *outy)
{
	double a,b,a2,b2,l2,w,d;

	long dx,dy,dx2,dy2;

	dx = pex - psx;
	dy = pey - psy;
	dx2 = lex - lsx;
	dy2 = ley - lsy;

	if (dx == 0 && dy == 0) ProgError("Trouble in ComputeIntersection dx,dy");
/*	l = (long)sqrt((double)((dx*dx) + (dy*dy)));  unnecessary - killough */
	if(dx2 == 0 && dy2 == 0) ProgError("Trouble in ComputeIntersection dx2,dy2");
	l2 = (long)sqrt((double)((dx2*dx2) + (dy2*dy2)));

	a = dx /* / l */;  /* no normalization of a,b necessary,   */
	b = dy /* / l */;  /* since division by d in formula for w */
	a2 = dx2 / l2;     /* cancels it out. */
	b2 = dy2 / l2;
	d = b * a2 - a * b2;
	if (d)
		{
		w = ((a*(lsy-psy))+(b*(psx-lsx))) / d;

/*		printf("Intersection at (%f,%f)\n",x2+(a2*w),y2+(b2*w));*/

		a = lsx+(a2*w);
		b = lsy+(b2*w);
                *outx=(a<0) ? -(int)(.5-a) : (int)(.5+a);
                *outy=(b<0) ? -(int)(.5-b) : (int)(.5+b);
/*
		modf(a + ((a<0)?-0.5:0.5) ,&w);
		modf(b + ((b<0)?-0.5:0.5) ,&d);
                *outx = w;
                *outy = d;
*/
		}
              else
               {
         	*outx = lsx;
        	*outy = lsy;
               }
}
/*---------------------------------------------------------------------------*
 Because this is (was) used a horrendous amount of times in the inner loops, the
 coordinate of the lines are setup outside of the routine in global variables
 psx,psy,pex,pey = partition line coordinates
 lsx,lsy,lex,ley = checking line coordinates
 The routine returns 'val' which has 3 bits assigned to the the start and 3
 to the end. These allow a decent evaluation of the lines state.
 bit 0,1,2 = checking lines starting point and bits 4,5,6 = end point
 these bits mean 	0,4 = point is on the same line
 						1,5 = point is to the left of the line
						2,6 = point is to the right of the line
 There are some failsafes in here, these mainly check for small errors in the
 side checker.
*---------------------------------------------------------------------------*/

static __inline__ int DoLinesIntersect()
{
	short int x,y,val = 0;

	long dx2,dy2,dx3,dy3,a,b,l;

	dx2 = psx - lsx;				/* Checking line -> partition*/
	dy2 = psy - lsy;
	dx3 = psx - lex;
	dy3 = psy - ley;

	a = pdy*dx2 - pdx*dy2;
	b = pdy*dx3 - pdx*dy3;
	if ( (a ^ b) < 0 && a && b)		/* Line is split, just check that*/
		{
          if(bsp15)
			ComputeIntersection15(&x,&y);
          else
               ComputeIntersection21(&x,&y);
		dx2 = lsx - x;									/* Find distance from line start*/
		dy2 = lsy - y;									/* to split point*/
		if(dx2 == 0 && dy2 == 0) a = 0;
		else
			{
			l = (long) dx2*dx2+(long) dy2*dy2;		                        /* If either ends of the split*/
			if (l < 4) a = 0;							/* are smaller than 2 pixs then*/
			}												/* assume this starts on part line*/
		dx3 = lex - x;									/* Find distance from line end*/
		dy3 = ley - y;									/* to split point*/
		if(dx3 == 0 && dy3 == 0) b = 0;
		else
			{
			l = (long) dx3*dx3 + (long) dy3*dy3;					/* same as start of line*/
			if (l < 4) b = 0;
			}
		}

	if(a == 0) val = val | 16;								/* start is on middle*/
         else
	if(a < 0) val = val | 32;						/* start is on left side*/
        else
	/* if(a > 0) */ val = val | 64;		/* start is on right side*/

	if (b == 0) val = val | 1;						/* end is on middle*/
        else
	if(b < 0) val = val | 2;						/* end is on left side*/
        else
	/* if(b > 0) */ val = val | 4;						/* end is on right side*/

	return val;
}
/*--------------------------------------------------------------------------*/
/*=== CreaReject( By LsJmDM ) Funcin aadida por lsjmdm, Corrales, Zamora,
Espaa. Febrero, 1997.*/
/* ALGORITMO: Comprueba que cada vrtice de los que componen un sector est
a la distancia de 600 de los vrtices que componen otro sector, usando
fuerza bruta, es decir, comprobando TODOS los vrtices de un sector
con TODOS los vrtices de los dems sectores
*/
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
void *CreaReject(int distancia)
{
  static long x, i;
  size_t bytes = 0 , ir;
  static char *rejectabla;
  static char *datos;//OJO con esta lnea. Antes era un puntero void.
       
  rejectabla = GetMemory((num_sects * num_sects)+8);
  memset (rejectabla, 0, (size_t)(num_sects * num_sects));  
  /*
     Tienes que probar con todos los sectores, comenzando por el 0
  */
  for(x=0; x<num_sects; ++x)
  {
    /* Un pequeo dibujo del sector */ 
    if(gfxsi)
       Dibujasector(x, GRAY);
    
    for(i=0; i<num_sects; ++i)
    {
      /* DistMin devuelve VERDAD si la distancia entre sectores es MAYOR */
      /* Si es mayor hay que poner en la REJECT un uno */
      progress();

      if(DistMin( x, i, distancia) == VERDAD)
      {
         rejectabla[bytes] = 1;
      }
      ++bytes;  
    }/* del segundo for */
  }/* del primer for *//* aqu ya ha acabdo con el reject */
  
  /* crea ahora la tabla de bits */
  bytes = reject_size;
  datos = GetMemory(reject_size);
  for (ir = 0; ir < bytes; ir++)
    {
      datos[ir] =(rejectabla[0]) + (rejectabla[1] << 1) + 
                 (rejectabla[2] << 2) + (rejectabla[3] << 3) + 
                 (rejectabla[4] << 4) + (rejectabla[5] << 5) + 
                 (rejectabla[6] << 6) + (rejectabla[7] << 7);
      rejectabla += 8;
   }
  
  return datos;
}
/*
    Devuelva la distancia mnima de un sector a otro
*/
static __inline__ Bool DistMin(int sector1, int sector2, int distancia)
{
  static double temp;
  static int distanciaminima=60000;/* distanciaminima con un valor alto */
  static long z,y; /*usados en los bucles */
  /* De cada vrtice del sector de origen, comprueba con todos los del
     segundo, y comprueba la distancia mnima */
  for(z=0;z < num_lines;z++)
   {
     /* Cada vez que se obtenga de aqu un linedef, calcula con
     todas las posiciones del sector2*/
     if(sidedefs[linedefs[z].sidedef1].sector == sector1)
     {   
       for ( y=0; y<num_lines; y++)
       {
         if(sidedefs[linedefs[y].sidedef1].sector == sector2)
         {
           /* Llegados a este punto, vertices[linedefs[y].start].x y
           vertices[linedefs[y].end].y contienen las coordenadas del vrtice
           del sector1, y nalogamente, cambiando las y por las z, las del
           sector 2. Calculando su distancia ( mdulo ) y asignando a la 
           variable distanciaminima si es menor que el que tena. Para
           acelerar el proceso, si la distancia es 0, retorna directamente */
           /* Calcula la distancia entre los dos vrtices mediante la 
           frmula SQR((x2-x1)^2+(y2-y1)^2) */
           temp=sqrt(pow(((double)vertices[linedefs[y].start].x-(double)vertices[linedefs[z].start].x),(double)2) +
	   pow(((double)vertices[linedefs[y].end].x-(double)vertices[linedefs[z].end].x), 2));	   
	   
	   if((int)temp < (int)distanciaminima)
	      distanciaminima = (long)temp;
           if((int)temp < distancia)
              return MENTIRA;
         }
         else if(linedefs[y].sidedef2 != -1)
         {
           if(sidedefs[linedefs[y].sidedef2].sector == sector2)
           {
             temp=sqrt(pow(((double)vertices[linedefs[y].start].x-(double)vertices[linedefs[z].start].x),(double)2) +
	     pow(((double)vertices[linedefs[y].end].x-(double)vertices[linedefs[z].end].x), 2));	   
	   
	     if(temp < distanciaminima)
	        distanciaminima = (long)temp;
	     if((int)temp < distancia)
              return MENTIRA;
           }
         }  
       }/* del for(;;) secundario */
     } /* del primer if despus del for(;;) del principio */
     else if(linedefs[z].sidedef2 != -1)
     {
       if(sidedefs[linedefs[z].sidedef2].sector == sector1)
       {    
       for(y=0; y < num_lines; y++)
       {
         if(sidedefs[linedefs[y].sidedef1].sector == sector2)
         {
           /* Calcula la distancia entre los dos vrtices mediante la 
           frmula SQR((x2-x1)^2+(y2-y1)^2) */
           temp=sqrt(pow(((double)vertices[linedefs[y].start].x-(double)vertices[linedefs[z].start].x),(double)2) +
	   pow(((double)vertices[linedefs[y].end].x-(double)vertices[linedefs[z].end].x), 2));	   
	   
	   if((int)temp < (int)distanciaminima)
	      distanciaminima = (long)temp;
	   if((int)temp < distancia)
              return MENTIRA;
	 }
         else if(linedefs[y].sidedef2 != -1)
         {
           if(sidedefs[linedefs[y].sidedef2].sector == sector2)
           {
             temp=sqrt(pow(((double)vertices[linedefs[y].start].x-(double)vertices[linedefs[z].start].x),(double)2) +
	     pow(((double)vertices[linedefs[y].end].x-(double)vertices[linedefs[z].end].x), 2));	   
	     
	     if((int)temp < (int)distanciaminima)
	        distanciaminima = (long)temp;
	     if((int)temp < distancia)
              return MENTIRA;
           }
         }  
       } /* del for(;;) secundario */       
       }
      /* el if del else if primario */
     } /* del else del if else primario */
   } /* del for(;;) del principio */ 
   
   return 1;
}
/*--FIN-DE-CreaReject-y-sus-funciones-asociadas_____________________________*/
/*----DEU reject(aunque la de deu est copiada de DOOMBSP, por id software-*/
/*
 Transportado a jbsp por LSJmDM, 1997
*/
#define FLAG_TWOSIDED   4

/*! description missing */
void ClearBBox (bbox_t *box)
{
  box->xl = box->yl =  32767;
  box->xh = box->yh = -32767;
}


/*! description missing */
void AddToBBox (bbox_t *box, Int16 x, Int16 y)
{
  if (x < box->xl) box->xl = x;
  if (x > box->xh) box->xh = x;
  if (y < box->yl) box->yl = y;
  if (y > box->yh) box->yh = y;
}


/*! description missing */
/* Returns side 0 (front), 1 (back), or -1 (colinear) */
Int16 BPointOnSide (bpoint_t *pt, bdivline_t *l)
{
  Int16      dx,   dy;
  Int16      left, right;

  if (!l->dx)
    {
      if (pt->x < l->x) return (l->dy>0);
                        return (l->dy<0);
    }
  if (!l->dy)
    {
      if (pt->y < l->y) return (l->dx<0);
                        return (l->dx>0);
    }

  dx = pt->x - l->x;
  dy = pt->y - l->y;

  left  = l->dy * dx;
  right = dy * l->dx;

  if (right < left) return 0;      /* front side */
                    return 1;      /* back side */
}


/*!RP made them static */
static bdivline_t  ends[2], sides[2];
static Int16       end0out, end1out, side0out, side1out;
static bbox_t      sweptarea;

/*! description missing */
Bool DoesChainBlock (bchain_t *chain)
{
  bpoint_t     *pt;
  Int16         side, startside;
  Int16         p;
  /* if a solid line can be walked from one side to the other without going out
     an end, the path is blocked */

  /* don't check if bounds don't intersect */
  if (sweptarea.xl > chain->bounds.xh  || sweptarea.xh < chain->bounds. xl
      || sweptarea.yl > chain->bounds. yh || sweptarea.yh < chain->bounds. yl)
    return FALSE;

  startside = -1;      /* not started yet */

  for (p = 0, pt = chain->points; p < chain->numpoints; p++, pt++)
    {
      /* find side for pt */

      if (BPointOnSide (pt, &ends[0]) == end0out)
        {
          startside = -1;   /* off end */
          continue;
        }
      if (BPointOnSide (pt, &ends[1]) == end1out)
        {
          startside = -1;   /* off end */
          continue;
        }
      if (BPointOnSide (pt, &sides[0]) == side0out)
        side = 0;
      else if (BPointOnSide (pt, &sides[1]) == side1out)
        side = 1;
      else
        continue; /* in middle */

      /* point is on one side or the other */
      if (startside == -1 || startside == side)
        {
          startside = side;
          continue;
        }

      /* opposite of startside */
      return TRUE;      /* totally crossed area */
    }
  return FALSE;
}


/*! description missing */
enum {si_north, si_east, si_south, si_west};

/*! description missing */
void BuildConnections (void)
{
  Int16     blockcount, passcount;
  Int16     i,j, k, s, bn;
  Int16     x = 0, y = 0;
  bbox_t   *bbox[2];
  Int16     walls[4];
  bpoint_t  points[2][2];

  /* look for obscured sectors */
  blockcount = passcount = 0;
  bbox[0] = secboxes;
  for (i = 0; i < num_sects - 1; i++, bbox[0]++)
    {
      
      if(gfxsi)
         Dibujasector(i, GRAY);
      bbox[1] = bbox[0] + 1;
      if (bbox[0]->xh - bbox[0]->xl < 64 || bbox[0]->yh - bbox[0]->yl < 64)
        continue; /* ignore small sectors */

      for (j = i + 1; j < num_sects; j++, bbox[1]++)
        {
          progress();

          if (bbox[1]->xh - bbox[1]->xl < 64 || bbox[1]->yh - bbox[1]->yl < 64)
            continue; /* ignore small sectors */

          if (bbox[1]->xl <= bbox[0]->xh && bbox[1]->xh >= bbox[0]->xl &&
              bbox[1]->yl <= bbox[0]->yh && bbox[1]->yh >= bbox[0]->yl)
            {
              passcount++;
              continue;      /* touching sectors are never blocked */
            }

          sweptarea.xl = bbox[0]->xl < bbox[1]->xl ? bbox[0]->xl : bbox[1]->xl;
          sweptarea.xh = bbox[0]->xh > bbox[1]->xh ? bbox[0]->xh : bbox[1]->xh;
          sweptarea.yl = bbox[0]->yl < bbox[1]->yl ? bbox[0]->yl : bbox[1]->yl;
          sweptarea.yh = bbox[0]->yh > bbox[1]->yh ? bbox[0]->yh : bbox[1]->yh;

          /* calculate the swept area between the sectors */
          for (bn = 0; bn < 2; bn++)
            {
              memset (walls, 0, sizeof(walls));
              if (bbox[bn]->xl <= bbox[!bn]->xl) walls[si_west]  = 1;
              if (bbox[bn]->xh >= bbox[!bn]->xh) walls[si_east]  = 1;
              if (bbox[bn]->yl <= bbox[!bn]->yl) walls[si_south] = 1;
              if (bbox[bn]->yh >= bbox[!bn]->yh) walls[si_north] = 1;

              for (s = 0; s < 5; s++)
                {
                  switch (s & 3)
                    {
                    case si_north:
                      x = bbox[bn]->xl;
                      y = bbox[bn]->yh;
                      break;
                    case si_east:
                      x = bbox[bn]->xh;
                      y = bbox[bn]->yh;
                      break;
                    case si_south:
                      x = bbox[bn]->xh;
                      y = bbox[bn]->yl;
                        break;
                    case si_west:
                      x = bbox[bn]->xl;
                      y = bbox[bn]->yl;
                      break;
                    }
                  if (! walls[(s - 1) & 3] && walls[s & 3])
                    {
                      points[bn][0].x = x;
                      points[bn][0].y = y;
                    }
                  if (walls[(s - 1) & 3] && ! walls[s & 3])
                    {
                      points[bn][1].x = x;
                      points[bn][1].y = y;
                    }
                }

              ends[bn].x  = points[bn][0].x;
              ends[bn].y  = points[bn][0].y;
              ends[bn].dx = points[bn][1].x - points[bn][0].x;
              ends[bn].dy = points[bn][1].y - points[bn][0].y;
            }

          sides[0].x  = points[0][0].x;
          sides[0].y  = points[0][0].y;
          sides[0].dx = points[1][1].x - points[0][0].x;
          sides[0].dy = points[1][1].y - points[0][0].y;

          sides[1].x  = points[0][1].x;
          sides[1].y  = points[0][1].y;
          sides[1].dx = points[1][0].x - points[0][1].x;
          sides[1].dy = points[1][0].y - points[0][1].y;

          end0out  = ! BPointOnSide (&points[1][0], &ends[0]);
          end1out  = ! BPointOnSide (&points[0][0], &ends[1]);
          side0out = ! BPointOnSide (&points[0][1], &sides[0]);
          side1out = ! BPointOnSide (&points[0][0], &sides[1]);

          /* look for a line change that covers the swept area */
          for (k = 0; k < numbchains; k++)
            {
              if (!DoesChainBlock (&bchains[k]))
                continue;
              blockcount++;
              connections[(size_t)(i * numsectors + j)] =
                connections[(size_t)(j * numsectors + i)] = 1;
              goto blocked;
            }

          /* nothing definately blocked the path */
          passcount++;
blocked: ;
        } /* End for(j) */
    } /* End for (i) */
Dibujasector(num_sects-1, GRAY);
}

/*! description missing */
static bpoint_t** bchPtr;

/*! description missing */
void BuildBlockingChains(void)
{
  Bool         *used;
  Int16         i, j;
  bpoint_t     *temppoints, *pt_p;
  bline_t      *li1, *li2;
  bchain_t      bch;
  Int16         cx, cy;

  bchPtr = (bpoint_t **)GetMemory(numblines * sizeof(*bchPtr));
  memset(bchPtr, 0, numblines * sizeof(*bchPtr));

  used = (Bool *)GetMemory(numblines * sizeof (*used));
  memset (used, 0, numblines * sizeof (*used));

  temppoints = (bpoint_t *)GetMemory(numblines * sizeof (*temppoints));

  chains_i = (STORAGE *)GetMemory(sizeof(STORAGE));
  chains_i->data  = (bchain_t *)GetMemory(sizeof(bchain_t));
  chains_i->count = 0;
  chains_i->size  = sizeof(bchain_t);

  li1 = blines;
  for (i = 0; i < numblines; i++, li1++)
    {
      if (used[i]) continue;
      used[i] = VERDAD;

      /* start a new chain */
      pt_p = temppoints;
      pt_p->x = li1->p1.x;
      pt_p->y = li1->p1.y;
      pt_p++;
      pt_p->x = cx = li1->p2.x;
      pt_p->y = cy = li1->p2.y;
      pt_p++;

      ClearBBox (&bch.bounds);
      AddToBBox (&bch.bounds, li1->p1.x, li1->p1.y);
      AddToBBox (&bch.bounds, cx, cy);

      /* look for connected lines */
      for (;;)
        {
          li2 = li1 + 1;
          for (j = i  + 1; j < numblines; j++, li2++)
            if (!used[j] && li2->p1.x == cx && li2->p1.y == cy)
              break;

          if (j == numblines)
            break; /* no more lines in chain */

          /* add to chain */
          used[j] = VERDAD;
          pt_p->x = cx = li2->p2.x;
          pt_p->y = cy = li2->p2.y;
          pt_p++;
          AddToBBox (&bch.bounds, cx, cy);
        }

      /* save the block chain */
      bch.numpoints =(UInt16)(pt_p - temppoints);
      bch.points = bchPtr[i] = (bpoint_t *)GetMemory(bch.numpoints * sizeof(*bch.points));
      memcpy (bch.points, temppoints, bch.numpoints * sizeof(*bch.points));

      memcpy((bchain_t *) chains_i->data+chains_i->count, &bch, sizeof(bchain_t));
      chains_i->count += 1;
      chains_i->data  = (bchain_t *)ResizeMemory(chains_i->data, sizeof(bchain_t) * (chains_i->count + 1));
    }
  numbchains = chains_i->count;
  bchains = (bchain_t *)chains_i->data;
}


/*! description missing */
void ProcessConnections (void)
{
  Int16      i, count;
  bbox_t    *secbox;
  bline_t    bline;
  Int16      sec;
  Int16      RonsLines = 0;

  numsectors = num_sects;
  count      = num_lines;

  /* +8 : allow rounding to bytes */
  connections = (Int8 *) GetMemory((size_t)(numsectors * numsectors + 8));
  memset (connections, 0, (size_t)(numsectors * numsectors));

  secboxes = secbox = (bbox_t *) GetMemory(numsectors * sizeof(bbox_t));
  for (i = 0; i < numsectors; i++, secbox++)
    ClearBBox (secbox);

  for (i = 0; i < count; i++)
    {
      /*
      LDPtr pld = &level->linedefs[i];
      VPtr  vs  = &level->vertexes[pld->start];
      VPtr  ve  = &level->vertexes[pld->end];*/

      if (linedefs[i].sidedef1 != -1)
        {
          /*sec = level->sidedefs[pld->sidedef1].sector;*/
          sec = sidedefs[linedefs[i].sidedef1].sector;
          /*AddToBBox (&secboxes[sec], vs->x, vs->y);*/
          AddToBBox(&secboxes[sec], vertices[linedefs[i].start].x, 
                   vertices[linedefs[i].start].y);
          /*AddToBBox (&secboxes[sec], ve->x, ve->y);*/
          AddToBBox(&secboxes[sec], vertices[linedefs[i].end].x, 
                   vertices[linedefs[i].end].y);
          /*
          Dibujanodo(vertices[linedefs[i].start].x, 
                     vertices[linedefs[i].start].y,
                     vertices[linedefs[i].end].x,
                     vertices[linedefs[i].end].y, GREEN);
          */                      
        }
    }

  /* make a list of only the solid lines */
  for (i=0; i<count; i++)
    {
      if (linedefs[i].flags & FLAG_TWOSIDED)
        continue;
      RonsLines++;
    }

  lines = (STORAGE *) GetMemory(sizeof(STORAGE));
  lines->data  = (bline_t *) GetMemory(RonsLines * sizeof(bline));
  lines->count = 0;
  lines->size  = sizeof(bline);

  for (i = 0; i < count; i++)
    {
      /*
      LDPtr pld = &level->linedefs[i];
      VPtr  vs  = &level->vertexes[pld->start];
      VPtr  ve  = &level->vertexes[pld->end];*/

      if (/*pld->flags*/linedefs[i].flags  & FLAG_TWOSIDED)
        continue; /* don't add two sided lines */
      bline.p1.x = /*vs->x*/vertices[linedefs[i].start].x;
      bline.p1.y = /*vs->y*/vertices[linedefs[i].start].y;
      bline.p2.x = /*ve->x*/vertices[linedefs[i].end].x;
      bline.p2.y = /*ve->y*/vertices[linedefs[i].end].y;
      memcpy((bline_t *) lines->data+lines->count, &bline, sizeof(bline));
      lines->count += 1;
    }

  blines = (bline_t *)lines->data;
  numblines = lines->count;

  BuildBlockingChains();
  BuildConnections();
}


/*! description missing */
void *OutputConnections(void)
{
  size_t  i;
  size_t  bytes;
  Int8   *cons;
  Int8   *bits;
  Int16   n;

  cons = connections;
  bytes = (numsectors * numsectors + 7) / 8;
  bits = (Int8 *) GetMemory(bytes);

  for (i = 0; i < bytes; i++)
    {
      bits[i] = cons[0] + (cons[1] << 1) + (cons[2] << 2) + (cons[3] << 3)
                        + (cons[4] << 4) + (cons[5] << 5) + (cons[6] << 6)
                        + (cons[7] << 7);
      cons += 8;
   }

  /*! RP There were FreeFarMemory for memory allocated with SafeMalloc
         I replaced SafeMalloc by GetMemory and so FreeFarMemory
         by FreeMemory. Maybe we should use GetFar/FreeFar instead ? */
  free((void*) connections);
  free((void*) secboxes);
  free((void*) blines);
  free((void*) bchains);
  for (n = 0; n < numblines; n++)
    if (bchPtr[n])
      free((void*) bchPtr[n]);
  free((void*) bchPtr);
  free((void*) chains_i);
  free((void*) lines);

  return (void *)bits;
}


/*! description missing */
void *CreateRejectData(void)
{
  void *rejectdata;

  /*RP Copy level info to global static var */
  /*RP removed! */
  /* memcpy(&loc_level, level, sizeof(struct LevelInfo)); */

  /* Size of reject data */
//*rejectsize = (level->num_sectors * level->num_sectors + 7) / 8;
   rejectdata = calloc( reject_size, 1);
   ProcessConnections();
   rejectdata = OutputConnections();
  
  return rejectdata;
}
/* end of file */
