function int itof(int x) { return x << 16; }
function int ftoi(int x) { return x >> 16; }

function int getMaxHealth(void)
{
    int maxHP = GetActorProperty(0, APROP_SpawnHealth);

    if ((maxHP == 0) && (PlayerNumber() != -1))
    {
        maxHP = 100;
    }

    return maxHP;
}

function int unusedTID(int start, int end) 
{
    int ret = start - 1; 
    int tidNum;

    if (start > end) { start ^= end; end ^= start; start ^= end; }  // good ol' XOR swap
    
    while (ret++ != end) 
    {    
        if (ThingCount(0, ret) == 0)
        {
            return ret; 
        }
    }    
    
    return -1;
}

function int min(int x, int y)
{
    if (x < y) { return x; }
    return y;
}

function int max(int x, int y)
{
    if (x > y) { return x; }
    return y;
}

function int middle(int x, int y, int z)
{
    if ((x < z) && (y < z)) { return max(x, y); }
    return max(min(x, y), z);
}

function int Futility_Skill(void)
{
    if (WithSamsara) { return GetCVar("skill"); }
    return GameSkill();
}


function int SectorPopulation(int sector)
{
    int ignorable, i;

    for (i = 0; i < IGNORECOUNT; i++)
    {
        ignorable += ThingCountNameSector(IgnorableItems[i], 0, sector);
    }

    return ThingCountSector(0,0, sector) - ignorable;
}


function int Futility_PossibleMonster(int isSpider)
{
    int highest = 0;
    int choice;
    int points = MonsterScale;
    int pointmult;
    int pointadd = 0;
    int i;

    switch (Futility_Skill())
    {
        case 0: pointmult = 0.60; pointadd = 0;  break; 
        case 1: pointmult = 0.75; pointadd = 10; break; 
        case 2: pointmult = 0.90; pointadd = 20; break; 
        case 3: pointmult = 1.00; pointadd = 30; break; 
        case 4: pointmult = 1.50; pointadd = 50; break;
    }

    points = FixedMul(points, pointmult) + pointadd;

    for (i = 0; i < MONSTERCOUNT; i++)
    {
        if ((points >= MonsterCosts[i][0]) && (isSpider || (MonsterCosts[i][1] == 0)))
        {
            PossibleMonsters[highest++] = i;
        }
    }

    if (highest == 0) { return -1; }
    choice = PossibleMonsters[random(0, highest-1)];

    return choice;
}


function int Futility_Spawn(int tid, int montid, int isSpider)
{
    int nospawnroll = random(0, 1024);
    if (nospawnroll > max(MonsterScale, 96)) { return 0; }

    int monIndex = Futility_PossibleMonster(isSpider);
    if (monIndex == -1) { return 0; }

    int monName = MonsterNames[monIndex];
    int monCost = MonsterCosts[monIndex][0];
    int x = GetActorX(tid);
    int y = GetActorY(tid);
    int z = GetActorZ(tid);
    int a = VectorAngle(-x, -y) >> 8;

    int spawncount = Spawn(monName, x, y, z, montid, a);

    if (spawncount != 1)
    {
        if (spawncount > 1)
        {
            Thing_Destroy(montid);
            Log(s:"\cgERROR:\c- Somehow spawned ", d:spawncount, s:" monsters on spot ", d:tid);
        }
        return 0;
    }

    if (GetActorZ(montid) != z)
    {
        Thing_Destroy(montid);
        return 0;
    }

    Spawn("TeleportFog", x,y,z);

    SetActivator(montid);

    GiveInventory("Futility_DisableRespawn", 1);
    ACS_ExecuteWithResult(11, monIndex);
    Thing_ChangeTID(0, 0);

    SetActivator(-1);

    return 1;
}

function int SpawnAtPad(int which, int pad)
{
    int padTID;
    int itemTID;
    int i;

    if (which < 0 || which > ITEMCOUNT) { return 0; }

    switch (pad)
    {
      case PAD_ARMORY: padTID = random(301, 304); break;
      case PAD_HEALTH: padTID = random(311, 318); break;
      default: return 0;
    }

    int va = random(0, 1.0);
    int vm = random(2.0, 4.0);

    int vx = FixedMul(vm, cos(va));
    int vy = FixedMul(vm, sin(va));
    int vz = random(1.0, 3.0);

    int x = GetActorX(padTID) + vx;
    int y = GetActorY(padTID) + vy;
    int z = GetActorZ(padTID) + vz;

    itemTID = unusedTID(15000, 25000);

    int itemToSpawn = SpawnableItems[which][0];
    int normalSpawn = 1;

    if (WithSamsara)
    {
        if (SamsaraItems[which][0] != 0)
        {
            itemToSpawn = SamsaraItems[which][0];
        }
    }

    if (WithLelweps)
    {
        if (LelwepsItems[which][0] != 0)
        {
            normalSpawn = 0;

            for (i = 0; i < LELCOUNT; i++)
            {
                if (LelwepsItems[which][i] == 0) { break; }

                Spawn(LelwepsItems[which][i], x,y,z, itemTID);
                Spawn("ItemFog", x,y,z);
                ThingSound(itemTID, "misc/spawn", 64);
                SetActorVelocity(itemTID, vx,vy,vz, 0,0);
                Thing_ChangeTID(itemTID, 0);
            }
        }
    }

    if (normalSpawn)
    {
        Spawn(itemToSpawn, x,y,z, itemTID);
        Spawn("ItemFog", x,y,z);
        ThingSound(itemTID, "misc/spawn", 64);
        SetActorVelocity(itemTID, vx,vy,vz, 0,0);
        Thing_ChangeTID(itemTID, 0);
    }

    ItemsSpawned[which] += 1;
    return 1;
}

function void Futility_AddItemPoints(int index)
{
    int count = MonsterItems[index][0];
    int i;
    int item, wmin, wmax;

    for (i = 0; i < count; i++)
    {
        item = MonsterItems[index][1 + (i*3)];
        wmin = MonsterItems[index][2 + (i*3)];
        wmax = MonsterItems[index][3 + (i*3)];
        
        ItemPoints[item] += random(wmin, wmax);
    }
}

function void Futility_SpawnItems(void)
{
    int i;
    int points, pad;
    int spawncount;

    int necessaryPoints = 60;
    
    int skill;

    switch (Futility_Skill())
    {
        case 0: necessaryPoints = 30; break; 
        case 1: necessaryPoints = 40; break; 
        case 2: necessaryPoints = 60; break; 
        case 3: necessaryPoints = 80; break; 
        case 4: necessaryPoints = 60; break;
    }

    for (i = 0; i < ITEMCOUNT; i++)
    {
        points = ItemPoints[i];
        pad    = ItemPads[i][0];

        spawncount = 0;

        if (ItemPads[i][1])
        {
            if (points >= necessaryPoints && !ItemsSpawned[i])
            {
                spawncount += 1;
                ItemsSpawned[i]++;
            }
        }
        else
        {
            while (points >= necessaryPoints)
            {
                spawncount += SpawnAtPad(i, pad);
                points -= necessaryPoints;
            }

            ItemPoints[i] = points;
        }

        if (spawncount > 0)
        {
            Futility_AddItemDisplay(i, spawncount);
        }
    }
}

function void Futility_EnsureGiven(int i)
{
    int checkitem, item;

    if (WithSamsara && SamsaraItems[i][0] != 0)
    {
        item      = SamsaraItems[i][0];
        checkitem = SamsaraItems[i][2];

        if (!CheckInventory(checkitem)) { GiveInventory(item, 1); }
    }
    else if (WithLelweps && LelwepsItems[i][0] != 0)
    {
        int j;

        for (j = 0; j < LELCOUNT; j++)
        {
            item = LelwepsItems[i][j];

            if (item == 0) { break; }
            if (!CheckInventory(item)) { GiveInventory(item, 1); }
        }
    }
    else
    {
        item = SpawnableItems[i][0];
        if (!CheckInventory(item)) { GiveInventory(item, 1); }
    }
}


function int Futility_AddItemDisplay(int item, int count)
{
    int tic = Timer();
    int i;
    int itemIndex = -1;
    int freeIndex = -1;

    for (i = 0; i < ITEMCOUNT; i++)
    {
        if (ItemDisplayMessages[i][0] == item)
        {
            itemIndex = i;
            break;
        }

        if (ItemDisplayMessages[i][0] == -1 && freeIndex == -1)
        {
            freeIndex = i;
        }
    }

    if (itemIndex == -1)
    {
        if (freeIndex != -1)
        {
            itemIndex = freeIndex;
            ItemDisplayMessages[itemIndex][0] = item;
            ItemDisplayMessages[itemIndex][1] = 0;
        }
        else { return 0; }
    }

    ItemDisplayMessages[itemIndex][1] += count;
    ItemDisplayMessages[itemIndex][2]  = tic;

    return itemIndex;
}

function void Futility_RemoveItemDisplay(int index)
{
    ItemDisplayMessages[index][0] = -1;
    ItemDisplayMessages[index][1] = -1;
    ItemDisplayMessages[index][2] = -1;
}

function int LelwepsItemCount(int item)
{
    int ret = 0;
    int i;

    for (i = 0; i < LELCOUNT; i++)
    {
        if (LelwepsItems[item][i] == 0) { break; }
        ret++;
    }

    return ret;
}

function int LelwepsItemNames(int item, int color)
{
    int ret = "";
    int count = LelwepsItemCount(item);
    int i;

    for (i = 0; i < count; i++)
    {
        ret = StrParam(s:ret, s:"\c", s:color, s:LelwepsItems[item][i], s:"\c-");

        if (i != count-1)
        {
            ret = StrParam(s:ret, s:", ");
        }
    }

    return ret;
}

function void Futility_DisplayItems(void)
{
    int curtic = Timer();
    int item, icount, itic;
    int i;

    for (i = 0; i < ITEMCOUNT; i++)
    {
        item    = ItemDisplayMessages[i][0];
        icount  = ItemDisplayMessages[i][1];
        itic    = ItemDisplayMessages[i][2];

        if (item == -1) { continue; }

        if (itic + 35 < curtic)
        {
            Futility_RemoveItemDisplay(i);
        }

        if (itic == curtic)
        {
            SetHudSize(1024, 768, 1);
            SetFont("SMALLFONT");
            
            if (ItemPads[item][1])
            {
                if (WithLelweps && LelwepsItems[item][0] != 0)
                {
                    if (LelwepsItemCount(item) > 1)
                    {
                        HudMessage(s:LelwepsItemNames(item, "f"), s:"\c- given!";
                            HUDMSG_FADEOUT, 1400 + i, CR_WHITE, 900.2, itof(250 + (i * 16)), 1.0, 0.5);
                    }
                    else
                    {
                        HudMessage(s:"The ", s:LelwepsItems[item][0], s:"\c- has been given!";
                            HUDMSG_FADEOUT, 1400 + i, CR_WHITE, 900.2, itof(250 + (i * 16)), 1.0, 0.5);
                    }
                }
                else if (WithSamsara && SamsaraItems[item][0] != 0)
                {
                    HudMessage(s:"The \cf", s:SamsaraItems[item][1], s:"\c- has been given!";
                            HUDMSG_FADEOUT, 1400 + i, CR_WHITE, 800.1, itof(250 + (i * 16)), 1.0, 0.5);
                }
                else
                {
                    HudMessage(s:"The \cf", s:SpawnableItems[item][1], s:"\c- has been given!";
                            HUDMSG_FADEOUT, 1400 + i, CR_WHITE, 800.1, itof(250 + (i * 16)), 1.0, 0.5);
                }
            }
            else
            {
                if (WithLelweps && LelwepsItems[item][0] != 0)
                {
                    HudMessage(s:"\cd+", d:icount, s:"\c- ", s:LelwepsItemNames(item, "-");
                            HUDMSG_FADEOUT, 1400 + i, CR_WHITE, 900.2, itof(250 + (i * 16)), 1.0, 0.5);
                }
                if (WithSamsara && SamsaraItems[item][0] != 0)
                {
                    HudMessage(s:"\cd+", d:icount, s:"\c- ", s:SamsaraItems[item][1];
                            HUDMSG_FADEOUT, 1400 + i, CR_WHITE, 800.1, itof(250 + (i * 16)), 1.0, 0.5);
                }
                else
                {
                    HudMessage(s:"\cd+", d:icount, s:"\c- ", s:SpawnableItems[item][1];
                            HUDMSG_FADEOUT, 1400 + i, CR_WHITE, 800.1, itof(250 + (i * 16)), 1.0, 0.5);
                }
            }
        }
    }
}


// Minimap width and height are ints
// Everything else is fixed-point

function void PlotOnMap(int graphic, int size, int x, int y)
{
    int mapx  =   x - MAP_ORIGIN_X;
    int mapy  = -(y - MAP_ORIGIN_Y);
    int mapid = ++MinimapIDCounter;

    int hudx  = FixedDiv(1024, MINIMAP_SCALE_X);
    int hudy  = FixedDiv(768,  MINIMAP_SCALE_Y);

    if (size > 0)
    {
        int hudx2 = FixedDiv(hudx, 0.05 * size);
        int hudy2 = FixedDiv(hudy, 0.05 * size);

        mapx = FixedDiv(mapx, MAP_WIDTH)  * MINIMAP_WIDTH;
        mapy = FixedDiv(mapy, MAP_HEIGHT) * MINIMAP_HEIGHT;

        mapx += MINIMAP_ORIGIN_X;
        mapy += MINIMAP_ORIGIN_Y;

        int relx = FixedMul(hudx2, FixedDiv(mapx, hudx));
        int rely = FixedMul(hudy2, FixedDiv(mapy, hudy));

        relx = itof(ftoi(relx)) + 0.1;
        rely = itof(ftoi(rely)) + 0.1;

        SetHudSize(hudx2, hudy2, 1);

        SetFont(graphic);
        HudMessageBold(s:"A"; HUDMSG_FADEOUT, mapid, CR_UNTRANSLATED, relx, rely, 0.65, 0.5);
    }
    else
    {
        SetHudSize(hudx, hudy, 1);
        SetFont("FUTILMAP");
        HudMessageBold(s:"A"; HUDMSG_PLAIN,   100099,  CR_UNTRANSLATED, MINIMAP_ORIGIN_X, MINIMAP_ORIGIN_Y, 0);
        SetFont("SMALLFONT");
        SetHudSize(0, 0, 0);
    }
}
