/*
THE COMPUTER CODE CONTAINED HEREIN IS THE SOLE PROPERTY OF PARALLAX
SOFTWARE CORPORATION ("PARALLAX").  PARALLAX, IN DISTRIBUTING THE CODE TO
END-USERS, AND SUBJECT TO ALL OF THE TERMS AND CONDITIONS HEREIN, GRANTS A
ROYALTY-FREE, PERPETUAL LICENSE TO SUCH END-USERS FOR USE BY SUCH END-USERS
IN USING, DISPLAYING,  AND CREATING DERIVATIVE WORKS THEREOF, SO LONG AS
SUCH USE, DISPLAY OR CREATION IS FOR NON-COMMERCIAL, ROYALTY OR REVENUE
FREE PURPOSES.  IN NO EVENT SHALL THE END-USER USE THE COMPUTER CODE
CONTAINED HEREIN FOR REVENUE-BEARING PURPOSES.  THE END-USER UNDERSTANDS
AND AGREES TO THE TERMS HEREIN AND ACCEPTS THE SAME BY USE OF THIS FILE.  
COPYRIGHT 1993-1998 PARALLAX SOFTWARE CORPORATION.  ALL RIGHTS RESERVED.
*/

#include "fix.h"
#include "gr.h"
#include "texmap.h"
#include "texmapl.h"

#ifdef TMAP_PER_QUAD
#if SIZEOF_LONG == 8 // adb: is this what was intended?
void c_tmap_scanline_per()
{
  ubyte * const r_fade_table = gr_fade_table;
  ubyte * const r_pixptr = pixptr;

  ubyte * dest;
  unsigned long c;
  long u, v, l, dudx, dvdx, dldx, dudx1, dvdx1;
  long x = fx_xright - fx_xleft + 1;

  // Quadratic setup stuff:
  {
    float a0, a1, a2, b0, b1, b2;
    float dx = x;
    float u0 = fx_u;
    float u2 = u0 + (float)fx_du_dx * dx;
    float v0 = fx_v;
    float v2 = v0 + (float)fx_dv_dx * dx;
    float w0 = fx_z;
    float w2 = w0 + (float)fx_dz_dx * dx;
    float iw02 = 1.0f / (w0+w2);
    float iw0 = 1.0f / w0;
    float iw2 = 1.0f / w2;
    float u1 = (u0+u2)*iw02;
    float v1 = (v0+v2)*iw02;
    float idx = 1.0f / dx;

    // Divide Z out.  This should be in outer loop
    u0 = u0 * iw0;
    v0 = v0 * iw0;
    u2 = u2 * iw2;
    v2 = v2 * iw2;
    a0 = u0;
    b0 = v0;
    a1 = (-3*u0+4*u1-u2)*idx;
    b1 = (-3*v0+4*v1-v2)*idx;
    a2 = (2*(u0-2*u1+u2))*(idx*idx);
    b2 = (2*(v0-2*v1+v2))*(idx*idx);
    dudx = (a1+a2) * 4294967296.0f;
    dvdx = (b1+b2) * 4294967296.0f;
    dudx1 = (a2+a2) * 4294967296.0f;
    dvdx1 = (b2+b2) * 4294967296.0f;
    u = u0 * 4294967296.0f;
    v = v0 * 4294967296.0f;
  }

  // Normal lighting setup
  l = fx_l>>8;
  dldx = fx_dl_dx>>8;
	
  // Normal destination pointer setup
  dest = (ubyte *)(write_buffer + fx_xleft + (bytes_per_row * fx_y)  );

  if (!Transparency_on)
    {
#define DOIT(R)							\
      (c = r_pixptr[((v >> (32 - 6))&07700)|((u >> 32)&63)],	\
       (R) = r_fade_table[(l&0xff00) + c],			\
       l += dldx,						\
       u += dudx,						\
       v += dvdx,						\
       dudx += dudx1,						\
       dvdx += dvdx1)

      x = fx_xright-fx_xleft+1;

      if (x >= 4)
	{
	  switch ((long)dest & 3)
	    {
	    case 1:
	      DOIT(*dest++);
	      --x;
	    case 2:
	      DOIT(*dest++);
	      --x;
	    case 3:
	      DOIT(*dest++);
	      --x;
	    default:
	    }
	  while (x >= 4)
	    {
	      unsigned long d0, d1, d2, d3;
	      DOIT(d0);
	      DOIT(d1);
	      DOIT(d2);
	      DOIT(d3);
	      *(int *)dest = d0 | (d1 << 8) | (d2 << 16) | (d3 << 24);
	      dest += 4;
	      x -= 4;
	    }
	}
      if (x & 2)
	{
	  unsigned long d0, d1;
	  DOIT(d0);
	  DOIT(d1);
	  *(short *)dest = d0 | (d1 << 8);
	  dest += 2;
	}
      if (x & 1)
	{
	  DOIT(*dest);
	}

#undef DOIT
    }
  else
    {
#define DOIT1(R)							 \
      (c = r_pixptr[(f2i(v)&63)*64 + (f2i(u)&63)],			 \
       c != TRANSPARENCY_COLOR ? (R) = r_fade_table[(l&0xff00) + c] : 0, \
       l += dldx,							 \
       u += dudx,							 \
       v += dvdx,							 \
       dudx += dudx1,							 \
       dvdx += dvdx1)
      
#define DOIT2(R, O)					\
      (c = r_pixptr[(f2i(v)&63)*64 + (f2i(u)&63)],	\
       (R) = r_fade_table[(l&0xff00) + c],		\
       (c == TRANSPARENCY_COLOR ? (R) = (O) : 0),	\
       l += dldx,					\
       u += dudx,					\
       v += dvdx,					\
       dudx += dudx1,					\
       dvdx += dvdx1)
      
      x = fx_xright-fx_xleft+1;

      if (x >= 4)
	{
	  switch ((long)dest & 4)
	    {
	    case 1:
	      DOIT1(*dest);
	      dest++;
	      --x;
	    case 2:
	      DOIT1(*dest);
	      dest++;
	      --x;
	    case 3:
	      DOIT1(*dest);
	      dest++;
	      --x;
	    default:
	    }
	  while (x >= 4)
	    {
	      unsigned int d0, d1, d2, d3;
	      unsigned int orig, o0, o1, o2, o3;

	      orig = *(int *)dest;
	      o0 = orig & 0xff;
	      DOIT2(d0, o0);

	      o1 = (orig >> 8) & 0xff;
	      DOIT2(d1, o1);
	      d0 |= d1 << 8;

	      o2 = (orig >> 16) & 0xff;
	      DOIT2(d2, o2);
	      d0 |= d2 << 16;

	      o3 = (orig >> 24) & 0xff;
	      DOIT2(d3, o3);
	      d0 |= d3 << 24;

	      *(int *)dest = d0;
	      dest += 4;
	      x -= 4;
	    }
	}
      if (x & 2)
	{
	  unsigned long d0, d1;
	  DOIT1(dest[0]);
	  DOIT1(dest[1]);
	  dest += 2;
	}
      if (x & 1)
	{
	  DOIT1(*dest);
	}

#undef DOIT1
#undef DOIT2
    }
}
#else /* if SIZEOF_LONG == 8 */
void c_tmap_scanline_per()
{
	ubyte *dest;
	uint c;
	int x;
	fix u,v,l,dudx, dvdx, dldx;

	// Quadratic setup stuff:
	fix a0, a1, a2, b0, b1, b2, dudx1, dvdx1;
	fix u0 = fx_u;
	fix u2 = fx_u + fx_du_dx*(fx_xright-fx_xleft+1);	// This just needs to be uright from outer loop
	fix v0 = fx_v;
	fix v2 = fx_v + fx_dv_dx*(fx_xright-fx_xleft+1);	// This just needs to be vright from outer loop
	fix w0 = fx_z;
	fix w2 = fx_z + fx_dz_dx*(fx_xright-fx_xleft+1);	// This just needs to be zright from outer loop
	fix u1 = fixdiv((u0+u2),(w0+w2));						
	fix v1 = fixdiv((v0+v2),(w0+w2));
	int dx = fx_xright-fx_xleft+1;		
	u0 = fixdiv( u0, w0 );	// Divide Z out.  This should be in outer loop
	v0 = fixdiv( v0, w0 );	// Divide Z out.  This should be in outer loop
	u2 = fixdiv( u2, w2 );	// Divide Z out.  This should be in outer loop
	v2 = fixdiv( v2, w2 );	// Divide Z out.  This should be in outer loop
	a0 = u0;									
	b0 = v0;
	a1 = (-3*u0+4*u1-u2)/dx;			
	b1 = (-3*v0+4*v1-v2)/dx;
	a2 = (2*(u0-2*u1+u2))/(dx*dx);	
	b2 = (2*(v0-2*v1+v2))/(dx*dx);
	dudx = a1 + a2;
	dvdx = b1 + b2;
	dudx1 = 2*a2;
	dvdx1 = 2*b2;
	u = u0;
	v = v0;

	// Normal lighting setup
	l = fx_l>>8;
	dldx = fx_dl_dx>>8;
	
	// Normal destination pointer setup
	dest = (ubyte *)(write_buffer + fx_xleft + (bytes_per_row * fx_y)  );

	if (!Transparency_on)	{
		for (x= fx_xright-fx_xleft+1 ; x > 0; --x ) {
			*dest++ = gr_fade_table[ (l&(0xff00)) + (uint)pixptr[  (f2i(v)&63)*64 + (f2i(u)&63) ] ];
			l += dldx;
			u += dudx;
			v += dvdx;
			dudx += dudx1;		// Extra add for quadratic!
			dvdx += dvdx1;		// Extra add for quadratic!
		}
	} else {
		for (x= fx_xright-fx_xleft+1 ; x > 0; --x ) {
			c = (uint)pixptr[  (f2i(v)&63)*64 + (f2i(u)&63) ];
			if ( c!=255)
				*dest = gr_fade_table[ (l&(0xff00)) + c ];
			dest++;
			l += dldx;
			u += dudx;
			v += dvdx;
			dudx += dudx1;		// Extra add for quadratic!
			dvdx += dvdx1;		// Extra add for quadratic!
		}
	}
}
#endif /* if SIZEOF_LONG == 8 */
#endif
