/*
THE COMPUTER CODE CONTAINED HEREIN IS THE SOLE PROPERTY OF PARALLAX
SOFTWARE CORPORATION ("PARALLAX").  PARALLAX, IN DISTRIBUTING THE CODE TO
END-USERS, AND SUBJECT TO ALL OF THE TERMS AND CONDITIONS HEREIN, GRANTS A
ROYALTY-FREE, PERPETUAL LICENSE TO SUCH END-USERS FOR USE BY SUCH END-USERS
IN USING, DISPLAYING,  AND CREATING DERIVATIVE WORKS THEREOF, SO LONG AS
SUCH USE, DISPLAY OR CREATION IS FOR NON-COMMERCIAL, ROYALTY OR REVENUE
FREE PURPOSES.  IN NO EVENT SHALL THE END-USER USE THE COMPUTER CODE
CONTAINED HEREIN FOR REVENUE-BEARING PURPOSES.  THE END-USER UNDERSTANDS
AND AGREES TO THE TERMS HEREIN AND ACCEPTS THE SAME BY USE OF THIS FILE.  
COPYRIGHT 1993-1998 PARALLAX SOFTWARE CORPORATION.  ALL RIGHTS RESERVED.
*/

#ifndef _WEAPON_H
#define _WEAPON_H

#include "inferno.h"
#include "gr.h"
#include "game.h"
#include "piggy.h"

typedef struct weapon_info {
	byte	render_type	__attribute__((packed));				// How to draw 0=laser, 1=blob, 2=object
	byte	model_num	__attribute__((packed));					// Model num if rendertype==2.
	byte	model_num_inner	__attribute__((packed));			// Model num of inner part if rendertype==2.
	byte	persistent	__attribute__((packed));					//	0 = dies when it hits something, 1 = continues (eg, fusion cannon)

	byte	flash_vclip	__attribute__((packed));				// What vclip to use for muzzle flash
	short	flash_sound	__attribute__((packed));				// What sound to play when fired
	byte	robot_hit_vclip	__attribute__((packed));			// What vclip for impact with robot
	short	robot_hit_sound	__attribute__((packed));			// What sound for impact with robot

	byte	wall_hit_vclip	__attribute__((packed));			// What vclip for impact with wall
	short	wall_hit_sound	__attribute__((packed));			// What sound for impact with wall
	byte	fire_count	__attribute__((packed));					//	Number of bursts fired from EACH GUN per firing.  For weapons which fire from both sides, 3*fire_count shots will be fired.
	byte	ammo_usage	__attribute__((packed));					//	How many units of ammunition it uses.

	byte	weapon_vclip	__attribute__((packed));				//	Vclip to render for the weapon, itself.
	byte	destroyable	__attribute__((packed));				//	If !0, this weapon can be destroyed by another weapon.
	byte	matter	__attribute__((packed));						//	Flag: set if this object is matter (as opposed to energy)
	byte	bounce	__attribute__((packed));						//	Flag: set if this object bounces off walls

	byte	homing_flag	__attribute__((packed));				//	Set if this weapon can home in on a target.
	byte	dum1	__attribute__((packed));
	byte	dum2	__attribute__((packed));
	byte	dum3	__attribute__((packed));

	fix	energy_usage	__attribute__((packed));				//	How much fuel is consumed to fire this weapon.
	fix	fire_wait	__attribute__((packed));					//	Time until this weapon can be fired again.

	bitmap_index bitmap	__attribute__((packed));				// Pointer to bitmap if rendertype==0 or 1.

	fix	blob_size	__attribute__((packed));					// Size of blob if blob type
	fix	flash_size	__attribute__((packed));					// How big to draw the flash
	fix	impact_size	__attribute__((packed));				// How big of an impact
	fix	strength[NDL]	__attribute__((packed));				// How much damage it can inflict
	fix	speed[NDL]	__attribute__((packed));					// How fast it can move, difficulty level based.
	fix	mass	__attribute__((packed));							// How much mass it has
	fix	drag	__attribute__((packed));							// How much drag it has
	fix	thrust	__attribute__((packed));						//	How much thrust it has
	fix	po_len_to_width_ratio	__attribute__((packed));	// For polyobjects, the ratio of len/width. (10 maybe?)
	fix	light	__attribute__((packed));						//	Amount of light this weapon casts.
	fix	lifetime	__attribute__((packed));					//	Lifetime in seconds of this weapon.
	fix	damage_radius	__attribute__((packed));				//	Radius of damage caused by weapon, used for missiles (not lasers) to apply to damage to things it did not hit
//-- unused--	fix	damage_force;				//	Force of damage caused by weapon, used for missiles (not lasers) to apply to damage to things it did not hit
// damage_force was a real mess.  Wasn't Difficulty_level based, and was being applied instead of weapon's actual strength.  Now use 2*strength instead. --MK, 01/19/95
	bitmap_index	picture	__attribute__((packed));				// a picture of the weapon for the cockpit
} weapon_info;

#define	REARM_TIME					(F1_0)

#define	WEAPON_DEFAULT_LIFETIME	(F1_0*12)	//	Lifetime of an object if a bozo forgets to define it.

#define WEAPON_TYPE_WEAK_LASER	0
#define WEAPON_TYPE_STRONG_LASER	1
#define WEAPON_TYPE_CANNON_BALL	2
#define WEAPON_TYPE_MISSILE		3
#define MAX_WEAPON_TYPES 			30

#define WEAPON_RENDER_NONE			-1
#define WEAPON_RENDER_LASER		0
#define WEAPON_RENDER_BLOB			1
#define WEAPON_RENDER_POLYMODEL	2
#define WEAPON_RENDER_VCLIP		3

#define	MAX_PRIMARY_WEAPONS		5
#define	MAX_SECONDARY_WEAPONS	5

//	Weapon flags, if player->weapon_flags & WEAPON_FLAG is set, then the player has this weapon
#define	HAS_LASER_FLAG				0x001
#define	HAS_VULCAN_FLAG			0x002
#define	HAS_SPREADFIRE_FLAG		0x004
#define	HAS_PLASMA_FLAG			0x008
#define	HAS_FUSION_FLAG			0x010

#define	HAS_CONCUSSION_FLAG		0x001
#define	HAS_HOMING_FLAG			0x002
#define	HAS_PROXIMITY_FLAG		0x004
#define	HAS_SMART_FLAG				0x008
#define	HAS_MEGA_FLAG				0x010

#define	CLASS_PRIMARY				0
#define	CLASS_SECONDARY			1

#define	LASER_INDEX					0
#define	VULCAN_INDEX				1
#define	SPREADFIRE_INDEX			2
#define	PLASMA_INDEX				3
#define	FUSION_INDEX				4

#define	CONCUSSION_INDEX			0
#define	HOMING_INDEX				1
#define	PROXIMITY_INDEX			2
#define	SMART_INDEX					3
#define	MEGA_INDEX					4

#define	NUM_SHAREWARE_WEAPONS	3		//in shareware, old get first 3 of each

#define	VULCAN_AMMO_SCALE		(0x198300/2)		//multiply ammo by this before displaying

extern weapon_info Weapon_info[];
extern int N_weapon_types;
extern void do_weapon_select(int weapon_num, int secondary_flag);
extern void show_weapon_status(void);

extern byte	Primary_weapon, Secondary_weapon;

extern ubyte Primary_weapon_to_weapon_info[MAX_PRIMARY_WEAPONS];
extern ubyte Secondary_weapon_to_weapon_info[MAX_SECONDARY_WEAPONS];
extern void auto_select_weapon(int weapon_type);		//parm is primary or secondary
extern void select_weapon(int weapon_num, int secondary_flag, int print_message,int wait_for_rearm);

extern char	*Primary_weapon_names_short[];
extern char	*Secondary_weapon_names_short[];
extern char	*Primary_weapon_names[];
extern char	*Secondary_weapon_names[];
extern int	Primary_ammo_max[MAX_PRIMARY_WEAPONS];
extern ubyte	Secondary_ammo_max[MAX_PRIMARY_WEAPONS];

#define	HAS_WEAPON_FLAG	1
#define	HAS_ENERGY_FLAG	2
#define	HAS_AMMO_FLAG		4
#define  HAS_ALL (HAS_WEAPON_FLAG|HAS_ENERGY_FLAG|HAS_AMMO_FLAG)

//	------------------------------------------------------------------------------------
//	Return:
// Bits set:
//		HAS_WEAPON_FLAG
//		HAS_ENERGY_FLAG
//		HAS_AMMO_FLAG	
extern int player_has_weapon(int weapon_num, int secondary_flag);

//called when one of these weapons is picked up
//when you pick up a secondary, you always get the weapon & ammo for it
int pick_up_secondary(int weapon_index,int count);

//called when a primary weapon is picked up
//returns true if actually picked up
int pick_up_primary(int weapon_index);

//called when ammo (for the vulcan cannon) is picked up
int pick_up_ammo(int class_flag,int weapon_index,int ammo_count);

#endif
