#ifndef _ROBOT_H
#define _ROBOT_H

#include "vecmat.h"
#include "object.h"
#include "game.h"

#define MAX_GUNS 8		//should be multiple of 4 for ubyte array

//Animation states
#define AS_REST			0
#define AS_ALERT			1
#define AS_FIRE			2
#define AS_RECOIL			3
#define AS_FLINCH			4
#define N_ANIM_STATES	5

#define	RI_CLOAKED_NEVER					0
#define	RI_CLOAKED_ALWAYS					1
#define	RI_CLOAKED_EXCEPT_FIRING		2

//describes the position of a certain joint
typedef struct jointpos {
	short jointnum		__attribute__((packed));
	vms_angvec angles	__attribute__((packed));
} jointpos;

//describes a list of joint positions
typedef struct jointlist {
	short n_joints;
	short offset;
} jointlist;

//	Robot information
typedef struct robot_info {
	int			model_num	__attribute__ ((packed));							// which polygon model?
	int			n_guns		__attribute__ ((packed));								// how many different gun positions
	vms_vector	gun_points[MAX_GUNS]	__attribute__ ((packed));			// where each gun model is
	ubyte			gun_submodels[MAX_GUNS]	__attribute__ ((packed));		// which submodel is each gun in?
	short 		exp1_vclip_num		__attribute__ ((packed));
	short			exp1_sound_num	__attribute__ ((packed));
	short 		exp2_vclip_num		__attribute__ ((packed));
	short			exp2_sound_num	__attribute__ ((packed));
	short			weapon_type	__attribute__ ((packed));
	byte			contains_id	__attribute__ ((packed));						//	ID of powerup this robot can contain.
	byte			contains_count	__attribute__ ((packed));					//	Max number of things this instance can contain.
	byte			contains_prob	__attribute__ ((packed));						//	Probability that this instance will contain something in N/16
	byte			contains_type	__attribute__ ((packed));						//	Type of thing contained, robot or powerup, in bitmaps.tbl, !0=robot, 0=powerup
	int			score_value	__attribute__ ((packed));						//	Score from this robot.
	fix			lighting	__attribute__ ((packed));							// should this be here or with polygon model?
	fix			strength	__attribute__ ((packed));							// Initial shields of robot

	fix		mass			__attribute__ ((packed));										// how heavy is this thing?
	fix		drag			__attribute__ ((packed));										// how much drag does it have?

	fix		field_of_view[NDL]	__attribute__ ((packed));					// compare this value with forward_vector.dot.vector_to_player, if field_of_view <, then robot can see player
	fix		firing_wait[NDL]	__attribute__ ((packed));						//	time in seconds between shots
	fix		turn_time[NDL]		__attribute__ ((packed));						// time in seconds to rotate 360 degrees in a dimension
	fix		fire_power[NDL]		__attribute__ ((packed));						//	damage done by a hit from this robot
	fix		shield[NDL]		__attribute__ ((packed));							//	shield strength of this robot
	fix		max_speed[NDL]		__attribute__ ((packed));						//	maximum speed attainable by this robot
	fix		circle_distance[NDL]	__attribute__ ((packed));				//	distance at which robot circles player

	byte		rapidfire_count[NDL]	__attribute__ ((packed));				//	number of shots fired rapidly
	byte		evade_speed[NDL]	__attribute__ ((packed));						//	rate at which robot can evade shots, 0=none, 4=very fast
	byte		cloak_type		__attribute__ ((packed));								//	0=never, 1=always, 2=except-when-firing
	byte		attack_type		__attribute__ ((packed));							//	0=firing, 1=charge (like green guy)
	byte		boss_flag		__attribute__ ((packed));								//	0 = not boss, 1 = boss.  Is that surprising?
	ubyte		see_sound		__attribute__ ((packed));								//	sound robot makes when it first sees the player
	ubyte		attack_sound		__attribute__ ((packed));							//	sound robot makes when it attacks the player
	ubyte		claw_sound		__attribute__ ((packed));								//	sound robot makes as it claws you (attack_type should be 1)

	//animation info
	jointlist anim_states[MAX_GUNS+1][N_ANIM_STATES]	__attribute__ ((packed));

	int		always_0xabcd		__attribute__ ((packed));							// debugging

} robot_info;


#define	MAX_ROBOT_TYPES	30				// maximum number of robot types

#define	ROBOT_NAME_LENGTH	16
extern char	Robot_names[MAX_ROBOT_TYPES][ROBOT_NAME_LENGTH];

//the array of robots types
extern robot_info Robot_info[];			// Robot info for AI system, loaded from bitmaps.tbl.

//how many kinds of robots
extern	int	N_robot_types;		// Number of robot types.  We used to assume this was the same as N_polygon_models.

//test data for one robot
#define MAX_ROBOT_JOINTS 600
extern jointpos Robot_joints[MAX_ROBOT_JOINTS];
extern int	N_robot_joints;

//given an object and a gun number, return position in 3-space of gun
//fills in gun_point
void calc_gun_point(vms_vector *gun_point,object *obj,int gun_num);
//void calc_gun_point(vms_vector *gun_point,int objnum,int gun_num);

//	Tells joint positions for a gun to be in a specified state.
//	A gun can have associated with it any number of joints.  In order to tell whether a gun is a certain
//	state (such as FIRE or ALERT), you should call this function and check the returned joint positions
//	against the robot's gun's joint positions.  This function should also be called to determine how to
//	move a gun into a desired position.
//	For now (May 30, 1994), it is assumed that guns will linearly interpolate from one joint position to another.
//	There is no ordering of joint movement, so it's impossible to guarantee that a strange starting position won't
//	cause a gun to move through a robot's body, for example.

//	Given:
//		jp_list_ptr		pointer to list of joint angles, on exit, this is pointing at a static array
//		robot_type		type of robot for which to get joint information.  A particular type, not an instance of a robot.
//		gun_num			gun number.  If in 0..Robot_info[robot_type].n_guns-1, then it is a gun, else it refers to non-animating parts of robot.
//		state				state about which to get information.  Legal states in range 0..N_ANIM_STATES-1, defined in robot.h, are:
//								AS_REST, AS_ALERT, AS_FIRE, AS_RECOIL, AS_FLINCH

//	On exit:
//		Returns number of joints in list.
//		jp_list_ptr is stuffed with a pointer to a static array of joint positions.  This pointer is valid forever.
extern int robot_get_anim_state(jointpos **jp_list_ptr,int robot_type,int gun_num,int state);

#endif
