/*
THE COMPUTER CODE CONTAINED HEREIN IS THE SOLE PROPERTY OF PARALLAX
SOFTWARE CORPORATION ("PARALLAX").  PARALLAX, IN DISTRIBUTING THE CODE TO
END-USERS, AND SUBJECT TO ALL OF THE TERMS AND CONDITIONS HEREIN, GRANTS A
ROYALTY-FREE, PERPETUAL LICENSE TO SUCH END-USERS FOR USE BY SUCH END-USERS
IN USING, DISPLAYING,  AND CREATING DERIVATIVE WORKS THEREOF, SO LONG AS
SUCH USE, DISPLAY OR CREATION IS FOR NON-COMMERCIAL, ROYALTY OR REVENUE
FREE PURPOSES.  IN NO EVENT SHALL THE END-USER USE THE COMPUTER CODE
CONTAINED HEREIN FOR REVENUE-BEARING PURPOSES.  THE END-USER UNDERSTANDS
AND AGREES TO THE TERMS HEREIN AND ACCEPTS THE SAME BY USE OF THIS FILE.  
COPYRIGHT 1993-1998 PARALLAX SOFTWARE CORPORATION.  ALL RIGHTS RESERVED.
*/

#ifndef _NEWDEMO_H
#define _NEWDEMO_H

#ifdef NEWDEMO

#define ND_STATE_NORMAL				0
#define ND_STATE_RECORDING			1
#define ND_STATE_PLAYBACK			2
#define ND_STATE_PAUSED				3
#define ND_STATE_REWINDING			4	 
#define ND_STATE_FASTFORWARD		5
#define ND_STATE_ONEFRAMEFORWARD	6
#define ND_STATE_ONEFRAMEBACKWARD	7
#define ND_STATE_PRINTSCREEN		8

// Gives state of recorder
extern int Newdemo_state;
extern int NewdemoFrameCount;
extern int Newdemo_game_mode;

extern int Newdemo_vcr_state;
extern byte Newdemo_do_interpolate;

//Does demo start automatically?
extern int Auto_demo;

// Functions called during recording process...
extern void newdemo_record_start_demo();
extern void newdemo_record_start_frame(int frame_number, fix frame_time );
extern void newdemo_record_render_object(object * obj);
extern void newdemo_record_viewer_object(object * obj);
extern void newdemo_record_sound_3d( int soundno, int angle, int volume );
extern void newdemo_record_sound_3d_once( int soundno, int angle, int volume );
extern void newdemo_record_sound_once( int soundno );
extern void newdemo_record_sound( int soundno );
extern void newdemo_record_wall_hit_process( int segnum, int side, int damage, int playernum );
extern void newdemo_record_trigger( int segnum, int side, int objnum );
extern void newdemo_record_hostage_rescued( int hostage_num );
extern void newdemo_record_morph_frame();
extern void newdemo_record_player_stats(int shields, int energy, int score );
extern void newdemo_record_wall_toggle(int segnum, int side );
extern void newdemo_record_control_center_destroyed();
extern void newdemo_record_hud_message(char *s);
extern void newdemo_record_palette_effect(short r, short g, short b);
#ifdef SHAREWARE
extern void newdemo_record_player_energy(int);
extern void newdemo_record_player_shields(int);
#else
extern void newdemo_record_player_energy(int, int);
extern void newdemo_record_player_shields(int, int);
#endif
extern void newdemo_record_player_flags(uint, uint);
extern void newdemo_record_player_weapon(int, int);
extern void newdemo_record_effect_blowup(short, int, vms_vector *);
extern void newdemo_record_homing_distance(fix);
extern void newdemo_record_letterbox(void);
extern void newdemo_record_rearview(void);
extern void newdemo_record_restore_cockpit(void);
extern void newdemo_record_wall_set_tmap_num1(short seg,ubyte side,short cseg,ubyte cside,short tmap);
extern void newdemo_record_wall_set_tmap_num2(short seg,ubyte side,short cseg,ubyte cside,short tmap);
extern void newdemo_record_multi_cloak(int pnum);
extern void newdemo_record_multi_decloak(int pnum);
extern void newdemo_set_new_level(int level_num);
extern void newdemo_record_restore_rearview(void);

#ifndef SHAREWARE
extern void newdemo_record_multi_death(int pnum);
extern void newdemo_record_multi_kill(int pnum, byte kill);
extern void newdemo_record_multi_connect(int pnum, int new_player, char *new_callsign);
extern void newdemo_record_multi_reconnect(int pnum);
extern void newdemo_record_multi_disconnect(int pnum);
extern void newdemo_record_player_score(int score);
extern void newdemo_record_multi_score(int pnum, int score);
extern void newdemo_record_primary_ammo(int old_ammo, int new_ammo);
extern void newdemo_record_secondary_ammo(int old_ammo, int new_ammo);
extern void newdemo_record_door_opening(int segnum, int side);
extern void newdemo_record_laser_level(byte old_level, byte new_level);
#endif

// Functions called during playback process...
extern void newdemo_object_move_all();
extern void newdemo_playback_one_frame();
extern void newdemo_goto_end();
extern void newdemo_goto_beginning();

// Interactive functions to control playback/record;
extern void newdemo_start_playback( char * filename );
extern void newdemo_stop_playback();
extern void newdemo_start_recording();
extern void newdemo_stop_recording();

extern int newdemo_get_percent_done();			

#endif

#endif
