// scanline_flat.s
//
// Straight conversion of the PC's assembly flat texmap drawer
// Done by Peter Hawkins(dph-man@iname.com)

#include "assyntax.h"	

	FILE("scanline_flat.s")
	AS_BEGIN

	SEG_TEXT
	ALIGNTEXT4
	GLOBL	GLNAME(asm_tmap_scanline_flat)
	
GLNAME(asm_tmap_scanline_flat:)
	pusha	
	MOV_L	(GLNAME(fx_y), EAX)
	CMP_L	(GLNAME(fx_y), EAX)
	JA	(none_to_do)
  
	IMUL_L	(GLNAME(bytes_per_row), EAX)
	MOV_L	(EAX, EDI)
	MOV_L	(GLNAME(fx_xleft), EAX)
	TEST_L	(EAX, EDI)
	JNS	(eax_ok)
	XOR_L	(EAX, EAX)
eax_ok:
	ADD_L	(EAX, EDI)
	ADD_L	(GLNAME(write_buffer), EDI)
	
	MOV_L	(GLNAME(fx_xright), EAX)
	CMP_L	(GLNAME(window_right), EAX)
	JL	(eax_ok1)
	MOV_L	(GLNAME(window_right), EAX)
eax_ok1:
	CMP_L	(GLNAME(window_left), EAX)
	JG	(eax_ok2)
	MOV_L	(GLNAME(window_left), EAX)
eax_ok2:
	MOV_L	(GLNAME(fx_xleft), EBX)
	SUB_L	(EBX, EAX)
	JS	(none_to_do)
	CMP_L	(GLNAME(window_width), EAX)
	JBE	(ok_to_do)
	MOV_L	(GLNAME(window_width), EAX)
	DECL	(EAX)
ok_to_do:
	MOV_L	(EAX, ECX)
	CMP_L	($0, (CONTENT(GLNAME(tmap_flat_cthru_table))))
	JNE	(do_flat_cthru)

	MOV_B	(GLNAME(tmap_flat_color), AL)
	INC_L	(ECX)
	TEST_L	($1, EDI)
	JE	(edi_even)
	MOV_B	(AL, ( EDI ))
	INC_L	(EDI)
	DEC_L	(ECX)
	JZ	(none_to_do)
edi_even:
	JE	(no_full_words)
	MOV_B	(AL,AH)
	REP
	STOS_W
no_full_words:
	ADC_L	(ECX, ECX)
	REP
	STOS_B
	popa
	RET
do_flat_cthru:
	MOV_L	(GLNAME(tmap_flat_cthru_table), ESI)
	XOR_L	(EAX, EAX)
	CMP_L	($0, ECX)
	JE	(none_to_do)
flat_cthru_loop:
	MOV_B	( ( EDI ), AL)
	MOV_B	((EAX,ESI),AL)
	MOV_B	(AL, ( EDI ))
	INC_L	(EDI)
	DEC_L	(ECX)
	JNZ	(flat_cthru_loop)
none_to_do:
	popa
	RET
