/*
THE COMPUTER CODE CONTAINED HEREIN IS THE SOLE PROPERTY OF PARALLAX
SOFTWARE CORPORATION ("PARALLAX").  PARALLAX, IN DISTRIBUTING THE CODE TO
END-USERS, AND SUBJECT TO ALL OF THE TERMS AND CONDITIONS HEREIN, GRANTS A
ROYALTY-FREE, PERPETUAL LICENSE TO SUCH END-USERS FOR USE BY SUCH END-USERS
IN USING, DISPLAYING,  AND CREATING DERIVATIVE WORKS THEREOF, SO LONG AS
SUCH USE, DISPLAY OR CREATION IS FOR NON-COMMERCIAL, ROYALTY OR REVENUE
FREE PURPOSES.  IN NO EVENT SHALL THE END-USER USE THE COMPUTER CODE
CONTAINED HEREIN FOR REVENUE-BEARING PURPOSES.  THE END-USER UNDERSTANDS
AND AGREES TO THE TERMS HEREIN AND ACCEPTS THE SAME BY USE OF THIS FILE.  
COPYRIGHT 1993-1998 PARALLAX SOFTWARE CORPORATION.  ALL RIGHTS RESERVED.
*/

#include "mem.h"

#include "gr.h"
#include "grdef.h"

#include "intrface.h"

void gr_upixel( int x, int y )
{
	switch(TYPE) {
	case BM_LINEAR:
		DATA[(ROWSIZE*y)+x] = COLOR;
		return;
	case BM_MODEX: {
			int newoff=(ROWSIZE*y)+(x>>2);
			int_gr_modex_plane(x&3);
			DATA[newoff]=COLOR;
			return;
		}
	case BM_SVGA: {
			int offset=(long)DATA+(ROWSIZE*y)+x;
			int gran=int_gr_get_gran();
			int bank=offset/gran;
			int newoff=offset%gran;
			int_gr_bank(bank);
			gr_video_memory[newoff]=COLOR;
			return;
		}
	}
}

void gr_pixel( int x, int y )
{
	if ((x<0) || (y<0) || (x>=GWIDTH) || (y>=GHEIGHT)) return;

	switch(TYPE) {
	case BM_LINEAR:
		DATA[(ROWSIZE*y+x)] = COLOR;
		return;
	case BM_MODEX: {
			int newoff=(ROWSIZE*y)+(x>>2);
			int_gr_modex_plane(x&3);
			DATA[newoff]=COLOR;
			return;
		}
	case BM_SVGA: {
			int offset=(long)DATA+(ROWSIZE*y)+x;
			int gran=int_gr_get_gran();
			int bank=offset/gran;
			int newoff=offset%gran;
			int_gr_bank(bank);
			gr_video_memory[newoff]=COLOR;
			return;
		}
	}
}

void gr_bm_upixel( grs_bitmap * bm, int x, int y, unsigned char color )
{
	switch(bm->bm_type) {
	case BM_LINEAR:
		bm->bm_data[(bm->bm_rowsize*y)+x]=color;
		return;
	case BM_MODEX: {
			int newoff=(bm->bm_rowsize*y)+(x>>2);
			int_gr_modex_plane(x&3);
			bm->bm_data[newoff]=color;
			return;
		}
	case BM_SVGA: {
			int offset=(long)bm->bm_data+(bm->bm_rowsize*y)+x;
			int gran=int_gr_get_gran();
			int bank=offset/gran;
			int newoff=offset%gran;
			int_gr_bank(bank);
			gr_video_memory[newoff]=color;
			return;
		}
	}
}

void gr_bm_pixel( grs_bitmap * bm, int x, int y, unsigned char color )
{
	if ((x<0) || (y<0) || (x>=bm->bm_w) || (y>=bm->bm_h)) return;

	switch(bm->bm_type) {
	case BM_LINEAR:
		bm->bm_data[(bm->bm_rowsize*y)+x]=color;
		return;
	case BM_MODEX: {
			int newoff=(bm->bm_rowsize*y)+(x>>2);
			int_gr_modex_plane(x&3);
			bm->bm_data[newoff]=color;
			return;
		}
	case BM_SVGA: {
			int offset=(long)bm->bm_data+(bm->bm_rowsize*y)+x;
			int gran=int_gr_get_gran();
			int bank=offset/gran;
			int newoff=offset%gran;
			int_gr_bank(bank);
			gr_video_memory[newoff]=color;
			return;
		}
	}
}
