/*
THE COMPUTER CODE CONTAINED HEREIN IS THE SOLE PROPERTY OF PARALLAX
SOFTWARE CORPORATION ("PARALLAX").  PARALLAX, IN DISTRIBUTING THE CODE TO
END-USERS, AND SUBJECT TO ALL OF THE TERMS AND CONDITIONS HEREIN, GRANTS A
ROYALTY-FREE, PERPETUAL LICENSE TO SUCH END-USERS FOR USE BY SUCH END-USERS
IN USING, DISPLAYING,  AND CREATING DERIVATIVE WORKS THEREOF, SO LONG AS
SUCH USE, DISPLAY OR CREATION IS FOR NON-COMMERCIAL, ROYALTY OR REVENUE
FREE PURPOSES.  IN NO EVENT SHALL THE END-USER USE THE COMPUTER CODE
CONTAINED HEREIN FOR REVENUE-BEARING PURPOSES.  THE END-USER UNDERSTANDS
AND AGREES TO THE TERMS HEREIN AND ACCEPTS THE SAME BY USE OF THIS FILE.  
COPYRIGHT 1993-1998 PARALLAX SOFTWARE CORPORATION.  ALL RIGHTS RESERVED.
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#ifdef HAVE_SVGALIB
#include <vga.h>
#include <vgagl.h>
#endif
#include "types.h"
#include "mem.h"
#include "gr.h"
#include "grdef.h"
#include "error.h"
#include "mono.h"
#include "palette.h"
#include "intrface.h"

unsigned char *gr_video_memory;

char gr_pal_default[768];

int gr_installed = 0;

int gr_show_screen_info = 0;

void gr_close()
{
	gr_set_current_canvas(NULL);
	gr_clear_canvas( BM_XRGB(0,0,0) );
	if (gr_installed==1)
	{
		gr_installed = 0;
		mem_free(grd_curscreen);
		gr_set_mode(SM_ORIGINAL);
	}
}

int gr_set_mode(int mode)
{
	int w, h;
	
	switch (mode) {
		case SM_ORIGINAL:
			int_gr_set_mode(mode);
			return 0;
		case 0:
			w=320; h=200;
			int_gr_set_mode(mode);
			break;
		case SM_320x400U:
			w=320; h=400;
			int_gr_set_mode(mode);
			break;
		case SM_640x480V:
			w=640; h=480;
			int_gr_set_mode(mode);
			break;
		case SM_800x600V:
			w=800; h=600;
			int_gr_set_mode(mode);
			break;
		default:
			fprintf(stderr,"gr_set_mode: illegal vidmode %d\n",mode);
			exit(1);
			break;
			
	}
	gr_palette_clear();
	grd_curscreen->sc_mode = mode;
	grd_curscreen->sc_w = w;
	grd_curscreen->sc_h = h;
	// hack to fix aspect ratio in X
	if (cur_interface == INTERFACE_X11)
		grd_curscreen->sc_aspect = 0x10000;
	else // assume 4:3 screen (fullscreen VGA)
		grd_curscreen->sc_aspect = fixdiv(grd_curscreen->sc_w*3,grd_curscreen->sc_h*4);
//	grd_curscreen->sc_aspect = 0x10000;
	grd_curscreen->sc_canvas.cv_bitmap.bm_x = 0;
	grd_curscreen->sc_canvas.cv_bitmap.bm_y = 0;
	grd_curscreen->sc_canvas.cv_bitmap.bm_type = int_gr_bm_type();
	grd_curscreen->sc_canvas.cv_bitmap.bm_h = h;
	gr_video_memory=(ubyte *)int_gr_get_buffer();

	if (grd_curscreen->sc_canvas.cv_bitmap.bm_type == BM_SVGA)
		grd_curscreen->sc_canvas.cv_bitmap.bm_data = (ubyte *)0;
	else
		grd_curscreen->sc_canvas.cv_bitmap.bm_data = gr_video_memory;

	if (grd_curscreen->sc_canvas.cv_bitmap.bm_type==BM_MODEX) {
		grd_curscreen->sc_canvas.cv_bitmap.bm_w = w;
		grd_curscreen->sc_canvas.cv_bitmap.bm_rowsize = w/4;
	} else {
		grd_curscreen->sc_canvas.cv_bitmap.bm_w = w;
		grd_curscreen->sc_canvas.cv_bitmap.bm_rowsize = w;
	}
	gr_set_current_canvas(NULL);

	//gr_enable_default_palette_loading();
	
	return 0;
}

extern void gr_build_mac_gamma(double correction);
extern double gamma_corrections[9];
extern ubyte gr_palette_gamma;

int gr_init(int mode)
{
	int retcode;
	
	// Only do this function once!
	if (gr_installed==1)
		return 1;

	// Save the current palette, and fade it out to black.

	MALLOC( grd_curscreen,grs_screen,1 );
	memset( grd_curscreen, 0, sizeof(grs_screen));
	
// initialize the macintosh window that we will use -- including picking the
// monitor

	// Set the mode.
	if ((retcode=gr_set_mode(mode)))
		return retcode;

//JOHNgr_disable_default_palette_loading();

	gr_build_mac_gamma(gamma_corrections[gr_palette_gamma]);

	// Set all the screen, canvas, and bitmap variables that
	// aren't set by the gr_set_mode call:
	grd_curscreen->sc_canvas.cv_color = 0;
	grd_curscreen->sc_canvas.cv_drawmode = 0;
	grd_curscreen->sc_canvas.cv_font = NULL;
	grd_curscreen->sc_canvas.cv_font_fg_color = 0;
	grd_curscreen->sc_canvas.cv_font_bg_color = 0;
	gr_set_current_canvas( &grd_curscreen->sc_canvas );
        
	// Set flags indicating that this is installed.
	gr_installed = 1;
	atexit(gr_close);

	return 0;
}

int gr_check_mode(int mode) {
	return 0; // *shrug*
}
