/*
THE COMPUTER CODE CONTAINED HEREIN IS THE SOLE PROPERTY OF PARALLAX
SOFTWARE CORPORATION ("PARALLAX").  PARALLAX, IN DISTRIBUTING THE CODE TO
END-USERS, AND SUBJECT TO ALL OF THE TERMS AND CONDITIONS HEREIN, GRANTS A
ROYALTY-FREE, PERPETUAL LICENSE TO SUCH END-USERS FOR USE BY SUCH END-USERS
IN USING, DISPLAYING,  AND CREATING DERIVATIVE WORKS THEREOF, SO LONG AS
SUCH USE, DISPLAY OR CREATION IS FOR NON-COMMERCIAL, ROYALTY OR REVENUE
FREE PURPOSES.  IN NO EVENT SHALL THE END-USER USE THE COMPUTER CODE
CONTAINED HEREIN FOR REVENUE-BEARING PURPOSES.  THE END-USER UNDERSTANDS
AND AGREES TO THE TERMS HEREIN AND ACCEPTS THE SAME BY USE OF THIS FILE.  
COPYRIGHT 1993-1998 PARALLAX SOFTWARE CORPORATION.  ALL RIGHTS RESERVED.
*/

#include "mem.h"
#include "gr.h"
#include "grdef.h"
#include "intrface.h"
#include <string.h>
#include <stdio.h>

int Gr_scanline_darkening_level = GR_FADE_LEVELS;

void gr_linear_darken(ubyte * dest, int darkening_level, int count, ubyte * fade_table) {
	register int i;

	for (i=0;i<count;i++)
		*dest=fade_table[(*dest++)+(darkening_level*256)];
}

void gr_modex_darken(ubyte *dest, int darken_level, int x1, int x2, int y, ubyte *fade_table) {
	int plane,w;
	ubyte *ystart=dest+(y*ROWSIZE);
	w=x2-x1; if (w<=0) return;
	for (plane=0;plane<4;plane++) {
		ubyte *ourstart=ystart+((plane+x1)>>2);
		int myw2=(w>>2)+(((w&3)>plane)?1:0);
		int i;
		int_gr_modex_plane(plane);
		for (i=0;i<myw2;i++)
			*ourstart=fade_table[(*ourstart++)+(darken_level<<8)];
	}
}

void gr_svga_darken(ubyte *dest, int darken_level, int x1, int x2, int y, ubyte *fade_table) {
	int amount;
	int cur_start;
	int gran=int_gr_get_gran();
	int bank;
	
	if ((amount=x2-x1+1)<=0) return;
	cur_start=(long)dest+(ROWSIZE*y)+x1;
	bank=cur_start/gran;
	
	while(amount>0) {
		int moo=cur_start%gran;
		ubyte *our_data=gr_video_memory+moo;
		int our_amount=MIN(amount,gran-moo);
		int i;
		int_gr_bank(bank++);
		for (i=0;i<our_amount;i++)
			*our_data=fade_table[(*our_data++)+(darken_level*256)];
		amount-=our_amount; cur_start+=our_amount;
	}
}

void gr_linear_stosd(ubyte * dest, ubyte color, int count) {
	memset(dest,color,count);
}

void gr_modex_stosd(ubyte *dest, int x1, int x2, int y, int color) {
	int plane,w;
	ubyte *ystart=dest+(y*ROWSIZE);
	w=x2-x1; if (w<=0) return;
	for (plane=0;plane<4;plane++) {
		ubyte *ourstart=ystart+(((x1+4)-plane)>>2);
		int myw2=(w>>2)+(((w&3)>plane)?1:0);
		int_gr_modex_plane(plane);
		if (myw2) memset(ourstart,color,myw2);
	}
}

void gr_svga_stosd(ubyte *dest, int x1, int x2, int y, int color) {
	int amount;
	int cur_start;
	int gran=int_gr_get_gran();
	int bank;
	
	if ((amount=x2-x1+1)<=0) return;
	cur_start=(long)dest+(ROWSIZE*y)+x1; bank=cur_start/gran;
	
	while(amount>0) {
		register int moo=cur_start%gran;
		register int our_amount=MIN(amount,gran-moo);
		int_gr_bank(bank++);
		memset(gr_video_memory+moo,color,our_amount);
		amount-=our_amount; cur_start+=our_amount;
	}
}

void gr_uscanline( int x1, int x2, int y )
{
	if (Gr_scanline_darkening_level >= GR_FADE_LEVELS )	{
		switch(TYPE) {
		case BM_LINEAR:
			gr_linear_stosd( DATA + ROWSIZE*y + x1, COLOR, x2-x1+1);
			break;
		case BM_MODEX:
			gr_modex_stosd(DATA, x1,x2,y,COLOR);
			break;
		case BM_SVGA:
			gr_svga_stosd(DATA, x1,x2,y,COLOR);
			break;
		}
	} else {
		switch(TYPE) {
		case BM_LINEAR:
			gr_linear_darken( DATA + ROWSIZE*y + x1, Gr_scanline_darkening_level, x2-x1+1, gr_fade_table);
			break;
		case BM_MODEX:
			gr_modex_darken(DATA, x1,x2,y,Gr_scanline_darkening_level, gr_fade_table);
			break;
		case BM_SVGA:
			gr_svga_darken(DATA, x1,x2,y,Gr_scanline_darkening_level, gr_fade_table);
			break;
		}
	}
}

void gr_scanline( int x1, int x2, int y )
{
	if ((y<0)||(y>MAXY)) return;

	if (x2 < x1 ) x2 ^= x1 ^= x2;

	if (x1 > MAXX) return;
	if (x2 < MINX) return;

	if (x1 < MINX) x1 = MINX;
	if (x2 > MAXX) x2 = MAXX;

	if (Gr_scanline_darkening_level >= GR_FADE_LEVELS )	{
		switch(TYPE) {
		case BM_LINEAR:
			gr_linear_stosd( DATA + ROWSIZE*y + x1, COLOR, x2-x1+1);
			break;
		case BM_MODEX:
			gr_modex_stosd(DATA, x1,x2,y,COLOR);
			break;
		case BM_SVGA:
			gr_svga_stosd(DATA, x1,x2,y,COLOR);
			break;
		}
	} else {
		switch(TYPE) {
		case BM_LINEAR:
			gr_linear_darken( DATA + ROWSIZE*y + x1, Gr_scanline_darkening_level, x2-x1+1, gr_fade_table);
			break;
		case BM_MODEX:
			gr_modex_darken(DATA, x1,x2,y,Gr_scanline_darkening_level, gr_fade_table);
			break;
		case BM_SVGA:
			gr_svga_darken(DATA, x1,x2,y,Gr_scanline_darkening_level, gr_fade_table);
			break;
		}
	}
}

