/****************************************************/
/* Turn off Archiving for all products in a Fixpak. */
/* Copyright IBM Corporation, 1998                  */
/****************************************************/
'@Echo off'
ver='v1.0'
Parse source whoami
Parse value whoami with . . whoami

curdir=Directory()        /* remember where we are */

/***********************************/
/* Register all REXXUTIL functions */
/***********************************/
rc=RxFuncAdd('SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs')
If rc>1 then
  Do
    Say 'Unable to register REXXUTIL functions.'
    Signal Done
  End
Call SysLoadFuncs
Say Filespec('NAME',whoami) ver
Say 'Copyright (c) IBM Corporation, 1998.'

Arg archive fixpak_source .
If fixpak_source='' Then
  Signal Tell
If right(fixpak_source,1)='\' Then
  fixpak_source=left(fixpak_source,length(fixpak_source)-1)

On='01'x
Off='00'x
signature='ffff'x||'SYSLEVEL'            /* Identifies a valid SRV_PROD file */
src=fixpak_source||'\FIX\???.?'
Call SysFileTree src,'dirs','DO'
Say 'Product directories found in Fixpak:' dirs.0
Do j=1 To dirs.0
  Name=Filespec('NAME',dirs.j)
  Parse Value Name With ext'.'.
  srv_file=dirs.j||'\SRV_PROD.'||ext
  If stream(srv_file,'C','Query Exists')='' Then
    Do
      Say 'No 'srv_file' found in 'dirs.j
      Signal Done
    End
  /************************************/
  /* Read in all of the SRV_PROD file */
  /************************************/
  size=stream(srv_file,'C','Query Size')
  Call stream srv_file,'C','Open Read'
  data=charin(srv_file,1,size)                      /* Read in all of file */
  Call stream srv_file,'C','Close'
  If substr(data,1,length(signature))<>signature Then       /* Valid file? */
    Do
      Say srv_file' is not a valid SRV_PROD file, does not start with ffffSYSLEVEL'
      Signal Done
    End
  arch=substr(data,20,1)                                 /* Archive, 01=on */
  Select
  When archive='OFF' & arch=On Then               /* Turn off and it's on? */
    Do
      data=overlay(Off,data,20)                             /* Turn it off */
      Call SysFileDelete(srv_file)                      /* Delete old file */
      Call Stream srv_file,'C','Open Write'
      Call Charout srv_file,data                          /* Write new one */
      Call Stream srv_file,'C','Close'
      Say 'Archiving turned OFF in' srv_file
    End
  When archive='OFF' & arch=Off Then          /* Turn off and already off? */
    Say 'Archiving already OFF in 'srv_file
  When archive='ON' & arch=Off Then               /* Turn on and it's off? */
    Do
      data=overlay(On,data,20)                               /* Turn it on */
      Call SysFileDelete(srv_file)                      /* Delete old file */
      Call Stream srv_file,'C','Open Write'
      Call Charout srv_file,data                          /* Write new one */
      Call Stream srv_file,'C','Close'
      Say 'Archiving turned ON in' srv_file
    End
  Otherwise                                   /* Turn off and already off? */
    Say 'Archiving already ON in 'srv_file
  End
End

/*******************************/
/* Only exit from this program */
/* Cleanup then exit           */
/*******************************/
Done:
Call directory curdir    /* put us back where we started */
Exit

/**************************************/
/* Display help info for this program */
/**************************************/
Tell:
Say 'Form: ARCHCTL ON|OFF fixpak_source'
Say
Say '"ON" or "OFF" - action to perform. ON enables Archiving, OFF disables it.'
Say '"fixpak_source" will normally be the drive the first Fixpak diskette is in'
Say 'but it could be the root of the Fixpak when copied to harddisk (where the'
Say '\FIX subdirectory is located). Default for OS/2 Fixpaks is ON.'
Say
Say 'For OFF, will change the Archive bit (SRV_PROD byte 20) from 01 to 00'
Say 'For ON, will change the Archive bit (SRV_PROD byte 20) from 00 to 01'
Say
Say 'Turn Archiving OFF Examples:'
Say 'Place first Fixpak diskette in A:'
Say '   enter ARCHCTL OFF A:'
Say 'XCOPY all fixpak diskette data to a N:\FIXES\FP32'
Say '    enter ARCHCTL OFF N:\FIXES\FP32'
Say
Say 'Turn Archiving ON Examples:'
Say 'Place first Fixpak diskette in A:'
Say '   enter ARCHCTL ON A:'
Say 'XCOPY all fixpak diskette data to a N:\FIXES\FP32'
Say '    enter ARCHCTL ON N:\FIXES\FP32'
Signal Done
