


TRN(1)                                                     TRN(1)


NNAAMMEE
       trn - threaded read news program

SSYYNNOOPPSSIISS
       ttrrnn [[ooppttiioonnss]] [[nneewwssggrroouuppss]]

DDEESSCCRRIIPPTTIIOONN
       _T_r_n  is  a  threaded version of _r_n_, which is a replacement
       for the readnews(1) program.  Being "threaded" means  that
       the articles are interconnected in reply order.  Each dis-
       cussion thread is a tree of articles where all  the  reply
       (child)  articles  branch off from their respective origi-
       nating (parent) articles.  A representation of  this  tree
       (or a portion of it) is displayed in the article header as
       you are reading news.  This gives you a  better  feel  for
       how all the articles are related, and even lets you see at
       a glance when an article has replies -- a  good  thing  to
       check  before  posting.   In  addition,  _t_r_n  has a thread
       selector that allows you to quickly browse through a  list
       of  subjects  and  choose  the  ones you find interesting.
       This thread selector sorts articles according  to  various
       criteria  and  can  be switched into various display modes
       that allows  you  to  pick  all  the  subjects  separately
       (threads can have multiple subjects) or even pick individ-
       ual articles.  Any items you don't select can be saved for
       reading later or marked as read with a single keystroke.

       If  you are already familiar with _t_r_n you may just want to
       read the _W_H_A_T_'_S _N_E_W section.   People  upgrading  from  _r_n
       will probably want to pay attention to the sections on _T_h_e
       _S_e_l_e_c_t_o_r, _T_h_e _T_r_e_e _D_i_s_p_l_a_y, and the aforementioned  _W_H_A_T_'_S
       _N_E_W.   If  you're impatient, just dive in and get started.
       All the regular commands will be familiar to an _r_n or  _t_r_n
       user,  and the on-line help will give you a quick run-down
       of what commands are available (just  type  'h'  from  any
       prompt).  I'd also suggest using the command:

           trn -x -X

       to make sure some of the best features are turned on.

       SSttaarrttiinngg TTrrnn

       If  no  newsgroups are specified, all the newsgroups which
       have unread news will be presented  to  the  user  in  the
       order  in  which  they  occur in the _._n_e_w_s_r_c file.  At the
       prompt for each group you can choose to read it, skip  it,
       move  it, etc.  If a list of newsgroups is provided on the
       command line, _t_r_n will start up in "add" mode,  using  the
       list  as  a  set  of  patterns  to  add new newsgroups and
       restrict which newsgroups are displayed (see also the dis-
       cussion  of  the  'a'  command  on the newsgroup-selection
       level).




                              LOCAL                             1





TRN(1)                                                     TRN(1)


       _T_r_n  operates  on  four  levels:  the  newsgroup-selection
       level, the thread selector, the article-reading level, and
       the paging level.  Each level has its own set of commands,
       and  its  own  help menu.  At the paging level (the bottom
       level) _t_r_n behaves much like the _m_o_r_e(1) program.  At  the
       article-reading level articles are presented to you in the
       order of their replies, with the subjects being ordered by
       the  date  of  the oldest unread article (though there are
       commands for changing the default display order).  In  the
       thread  selector  you  are presented with the subjects and
       (usually) authors associated with each discussion  thread,
       and  given  a chance to choose which ones you wish to read
       now, save for later, or manipulate in some  way.   At  the
       newsgroup-selection level (the top level), you may specify
       which newsgroup you want next, or read them in the default
       order,  which  is  the  order that the newsgroups occur in
       your _._n_e_w_s_r_c file.  (You will therefore want to  rearrange
       your  _._n_e_w_s_r_c  file to put the most interesting newsgroups
       first.  This can be done with the 'm' command on the News-
       group  Selection  level.  WARNING: invoking readnews/vnews
       (the old user interface) in any way (including as  a  news
       checker  in  your login sequence!) will cause your _._n_e_w_s_r_c
       to be disarranged again.)

       On any level, at ANY prompt, help is available  by  typing
       an  'h'.   This  gives you a summary of available commands
       and what they do.  Remember this command, you'll need  it.

       Typing space to any question means to do the normal thing.
       You will know what that is because every prompt has a list
       of several plausible commands enclosed in square brackets.
       The first command in the list is the  one  which  will  be
       done  if  you  type a space.  (All input is done in cbreak
       mode, so carriage returns should not be typed to terminate
       anything  except  certain multi-character commands.  Those
       commands will be obvious in the discussion  below  because
       they take an argument.)

       Upon startup, _t_r_n will do several things:

       1.  It will look for your _._n_e_w_s_r_c file, which is your list
           of subscribed-to newsgroups.  If _t_r_n  doesn't  find  a
           _._n_e_w_s_r_c,  it will create one.  If it does find one, it
           will back it up under the name ".oldnewsrc".

       2.  It will input your _._n_e_w_s_r_c file, listing out the first
           several newsgroups with unread news.

       3.  It  will  perform  certain  consistency checks on your
           _._n_e_w_s_r_c.  If your _._n_e_w_s_r_c is out of  date  in  any  of
           several  ways,  _t_r_n  will warn you and patch it up for
           you, but you may have to wait a little longer  for  it
           to start up.




                              LOCAL                             2





TRN(1)                                                     TRN(1)


       4.  _T_r_n  will next check to see if any new newsgroups have
           been created, and give you the opportunity to add them
           to your _._n_e_w_s_r_c.

       5.  _T_r_n  goes  into the top prompt level -- the newsgroup-
           selection level.

       NNeewwssggrroouupp SSeelleeccttiioonn LLeevveell

       In this section the words "next" and "previous"  refer  to
       the  ordering  of the newsgroups in your _._n_e_w_s_r_c file.  On
       the newsgroup-selection level, the prompt looks like this:

       ======  17  unread  articles  in  talk.blurfl -- read now?
       [ynq]

       unless the group is set for unthreaded reading,  in  which
       case the first six characters are "******".  The following
       commands may be given at this level:

       +       Enter this newsgroup through the selector.

       y       Begin reading this newsgroup now.

       SP      Enter the newsgroup by executing the default  com-
               mand listed in []'s.

       .command
               Do  this newsgroup now, but execute _c_o_m_m_a_n_d before
               displaying anything.  The command will  be  inter-
               preted as if typed on the article selection level.

       =       Start this newsgroup,  but  list  subjects  before
               displaying articles.

       U       Enter  this  newsgroup  through  the  "Set unread"
               prompt.

       t       Toggle  the   newsgroup   between   threaded   and
               unthreaded  reading.  The default is threaded, and
               the current setting is stored in your .newsrc.

       n       Go to the next newsgroup with unread news.

       N       Go to the next newsgroup.

       p       Go to the previous newsgroup with unread news.  If
               there is none, stay at the current newsgroup.

       P       Go to the previous newsgroup.

       -       Go  to the previously displayed newsgroup (regard-
               less of whether it is before or after the  current
               one in the list).



                              LOCAL                             3





TRN(1)                                                     TRN(1)


       1       Go to the first newsgroup.

       ^       Go to the first newsgroup with unread news.

       $       Go to the end of the newsgroups list.

       g newsgroup
               Go  to _n_e_w_s_g_r_o_u_p, which can be the group's name or
               a zero-relative  number  of  the  groups  in  your
               .newsrc   (see   the  'L'  command  to  list  your
               .newsrc).  If it isn't  currently  subscribed  to,
               you will be asked if you want to subscribe.

       /pattern
               Scan  forward  for  a  newsgroup matching _p_a_t_t_e_r_n.
               Patterns do globbing like filenames, i.e.,  use  *
               to  match  any  sequence  of characters, and [] to
               specify a list of characters to match.  Use  .  to
               match  a single character.  Unlike normal filename
               globbing, newsgroup-searching is not  anchored  to
               the  front  and  back of the filename, i.e. "/ski"
               will find rec.skiing.  You  may  use  ^  or  $  to
               anchor  the front or back of the search: "/^test$"
               will find newsgroup test and nothing else  If  you
               want to include newsgroups with 0 unread articles,
               append /r.  If the newsgroup is not found  between
               the  current newsgroup and the last newsgroup, the
               search will wrap around to the beginning.

       ?pattern
               Same as /, but search backwards.

       u       Unsubscribe from the current newsgroup.

       l string
               List newsgroups not subscribed  to  which  contain
               the string specified.

       L       Lists the current state of the _._n_e_w_s_r_c, along with
               status information.

                        Status     Meaning
                        <number>   Count of unread articles in newsgroup.
                        READ       No unread articles in newsgroup.
                        UNSUB      Unsubscribed newsgroup.
                        BOGUS      Bogus newsgroup.
                        JUNK       Ignored line in .newsrc
                                   (e.g. readnews "options" line).

               (A bogus newsgroup is one that is not in the  list
               of  active newsgroups in the active file, which on
               most systems is  /usr/lib/news/active  unless  you
               use NNTP.)




                              LOCAL                             4





TRN(1)                                                     TRN(1)


       m {name}
               Move  the  named  newsgroup  somewhere else in the
               _._n_e_w_s_r_c.  If no name is given, the  current  news-
               group  is  moved.   There  are a number of ways to
               specify where you want the newsgroup -- type h for
               help when it asks where you want to put it.

       c       Catch up -- mark all unread articles in this news-
               group as read.

       A       Abandon the changes made to the current  newsgroup
               since  _t_r_n  was started.  Useful when you acciden-
               tally mark a group as read.

       o {pattern}

       O {pattern}
               Only display those newsgroups whose  name  matches
               _p_a_t_t_e_r_n.   Patterns  are  the  same as for the '/'
               command.  Multiple patterns may  be  separated  by
               spaces, just as on the command line.  The restric-
               tion will remain in effect either until there  are
               no  articles  left  in the restricted set of news-
               groups, or another restriction command  is  given.
               Since  _p_a_t_t_e_r_n  is  optional,  'o'  by itself will
               remove the restriction.  Using 'O' will omit empty
               groups from the cycle.

       a pattern
               Add  unsubscribed newsgroups matching _p_a_t_t_e_r_n.  If
               any matching newsgroups are  found,  you  will  be
               asked  for  each one whether you would like to add
               it.  If you want to add all  the  newsgroups,  you
               can type 'Y' and they will be added the the end of
               the _._n_e_w_s_r_c file.  If you don't want to subscribe,
               all  the remaining groups can be ignored by typing
               'N'.  After any new newsgroups  have  been  added,
               the  'a' command also restricts the current set of
               newsgroups just like the 'O' command does.

       &       Print  out  the  current  status  of  command-line
               switches and any newsgroup restrictions.

       &switch {switch}
               Set additional command-line switches.

       &&      Print out the current macro definitions.

       &&keys commands
               Define additional macros.

       !command
               Escape  to  a  subshell.  One exclamation mark (!)
               leaves you in your own news directory.   A  double



                              LOCAL                             5





TRN(1)                                                     TRN(1)


               exclamation  mark  (!!)  leaves  you  in the spool
               directory   for    news,    which    is    usually
               /usr/spool/news  unless  you're using NNTP to read
               news.  The environment variable SHELL will be used
               if  defined.   If  _c_o_m_m_a_n_d is null, an interactive
               shell is started.

       v       Print the current version number  and  information
               on where to send bug reports.

       q       Quit.

       x       Quit, restoring .newsrc to its state at startup of
               _t_r_n.  The .newsrc you would have had  if  you  had
               exited with 'q' will be called .newnewsrc, in case
               you didn't really want to type 'x'.

       ^K      Edit the global list of memorized commands (in the
               global KILL file) that you wish to be performed in
               every newsgroup as it is started up (that is, when
               it  is selected at the newsgroup-selection level).
               This file contains commands (one per line) such as
               /subject/:j or /author/f:+ to kill or select arti-
               cles  based  on  the  indicated  search  criteria.
               There  is  also  a local list of commands for each
               newsgroup that can contain kill/selection commands
               tailored  for each specific group.  Because of the
               overhead involved in  searching  for  articles  to
               kill, it is better if possible to use a local list
               rather than the global one.  Local memorized  com-
               mands  are  usually maintained by using the 'A' or
               'T' commands from the article/pager  level  or  in
               the  selector.   There is also a K search modifier
               that appends any search command you desire to add.
               It is also possible to manually edit the file with
               the '^K' command from anywhere inside a newsgroup.
               If  either  of the environment variables VISUAL or
               EDITOR  is  set,  the  specified  editor  will  be
               invoked;  otherwise a default editor is invoked on
               the KILL file.

       TThhee SSeelleeccttoorr

       Most people who don't have all day to read news will  want
       to  enter  a  newsgroup  by  way of the selector.  This is
       accomplished by using the '+' command  at  the  newsgroup-
       selection  or  article/pager levels.  In fact, this may be
       the default command for entering a newsgroup, depending on
       how your version of _t_r_n was configured and your use of the
       --XX option.

       The selector displays a list of articles by their subjects
       and  (usually)  authors.   The  articles  are grouped into
       threads by default (which may list multiple  subjects  per



                              LOCAL                             6





TRN(1)                                                     TRN(1)


       selectable item if the subject has changed during the dis-
       cussion) and ordered by the date of  their  oldest  unread
       article.   Thread  or subject groups are also shown with a
       count of the number  of  articles  in  each  group.   Each
       selectable item is preceded by a letter or number that can
       be typed to toggle its selection.  Items that are selected
       are  flagged  with  a '+' after their letter.  Groups that
       have only some of their articles selected are flagged with
       a  '*'.   You can change the selector's mode (to pick each
       subject separately or pick individual articles), order the
       list  by a variety of sort criteria, and switch the author
       display between its long, medium and  short  styles  using
       the commands detailed below.

       The following commands are available in the selector:

       a-z,0-9,A-Z
               Select/deselect  the  indicated item by its letter
               or number.  There are quite a few letters  omitted
               from  the alpha characters to be typed as commands
               -- see below.  Also, the variable  SELECTCHARS  is
               available  to  customize which characters you want
               to be used as selection letters, overriding  their
               command function.

       SP      Perform  the  default  command.  This is usually >
               for most pages, and Z on the last page (although D
               and X are also quite popular).

       CR      Begin  reading.   If no articles are selected, the
               current item is selected (unless you've marked  it
               as killed).

       Z,TAB   Begin  reading.  If no articles are selected, read
               all unread articles.

       '.'     Toggle the current item's selection (the one under
               the cursor).

       *       Same  as  '.'  except that it affects all articles
               with the  same  subject  (useful  in  the  article
               selector).

       #       Make  an  overriding selection that reads the cur-
               rent item only,  temporarily  ignoring  all  other
               selections.

       k, ','  Mark the current item as killed.

       m, \    Unmark the current item.

       -       Set  a range, as in a - k.  Repeats the last mark-
               ing action: selection,  deselection,  killing,  or
               unmarking.



                              LOCAL                             7





TRN(1)                                                     TRN(1)


       @       Toggle all visible selections.

       M       Mark  the  current  item's article(s) to return on
               newsgroup exit and kill the item.

       Y       Yank back and select  the  marked-to-return  arti-
               cles, clearing their to-return status.

       E       Exclude  all  unselected  items from the selection
               list (narrow the display).  Press it again to pick
               from all available items.

       n, ]    Move  down  to  the  next item (try the down-arrow
               keypad key also).

       p, [    Move up to the previous  item  (try  the  up-arrow
               keypad key also).

       <       Go to previous page (try the left-arrow keypad key
               also).

       >       Go to next page (try the  right-arrow  keypad  key
               also).

       ^       Go to the first page.

       $       Go to the last page.

       S       Set the items the selector displays: threads, sub-
               jects or articles.  If  the  group  is  unthreaded
               setting this to threads will thread the group.

       =       Switch  between  the article selector and the sub-
               ject/thread selector.

       O       Pick the  order  for  the  items:  date,  subject,
               author,  item  count  (for thread/subject groups),
               and a subject-date grouping  of  individual  arti-
               cles.   Typing  the  selection  in lower-case will
               sort the articles in the default direction,  while
               using  upper-case will reverse the sort.  There is
               a  separate  default  sort  order  for  the   sub-
               ject/thread  selector  and  the  article selector.
               See the --OO option to set  your  favorite  selector
               mode and sort order as the default.

       R       Reverse the current sort order.

       L       Switch  the  selector's  display between the long,
               medium and  short  display  styles.   See  the  --xx
               option  to set your favorite style as the default.

       U       Switch between selecting unread/read articles.




                              LOCAL                             8





TRN(1)                                                     TRN(1)


       X       Mark all unselected articles  as  read  and  start
               reading.

       D       Mark  unselected  articles  on the current page as
               read and begin reading if articles  are  selected,
               otherwise go to the next page.

       J       Mark  all  selected articles as read (useful after
               performing some action on them with the  ':'  com-
               mand).

       c       Catch  up  --  marks  ALL articles as read without
               affecting their cross-posted counterparts.

       A       Add a subject-search command to the memorized list
               (a.k.a.  a  KILL  file)  for  this group.  You are
               prompted to choose  selection  (+),  junking  (j),
               selection  including  all  replies  (.) or junking
               including all replies (,).  If the thread has more
               than one subject the first subject is the one cho-
               sen for the memorized command.

       T       Add a thread-oriented  command  to  the  memorized
               list  for  this group.  You are prompted to choose
               selecting the thread (+), junking the thread  (j),
               or  clearing  the  auto-selection/junking  for the
               thread (c).  (Note: there are three other  options
               ('.',  ',',  and 'C') on the article-reading level
               -- look there for an explanation of their use.)

       ^K      Edit the local list of memorized commands  (a.k.a.
               a  KILL  file)  for  this  newsgroup.   A detailed
               description of memorized commands is found in  the
               Article Selection section.

       :command
               Apply  a  command  to  all the selected threads or
               their selected articles.  You can also use ":E" to
               end  a  binary  extraction  or  ":p" to post a new
               article.  Use "::command" to apply it to all  non-
               selected threads/articles.

               Applicable      commands      include      '+'/'-'
               (select/deselect    an     article),     "++"/"--"
               (select/deselect  a thread), "T+" (auto-select the
               entire  thread),  "Tj"   (auto-junk   the   entire
               thread),  't'  (display  article  tree),  "s dest"
               (save article to a destination), "e dir"  (extract
               to directory), 'E' (end partial uudecode), as well
               as: S, |, w, W, m, M, j, = and ','.

       :.command
               Apply a command  to  the  current  thread  or  the
               selected  articles  in  the  current  thread.  Use



                              LOCAL                             9





TRN(1)                                                     TRN(1)


               "::.command" to apply a command to the  unselected
               articles in the current thread.

       /pattern
               Scan all articles for a subject containing _p_a_t_t_e_r_n
               and select it.

       /pattern/modifiers:command{:command}
               Apply the commands listed to articles matching the
               search  command  (possibly  with  h, a, b, r, or K
               modifiers).  The default action, if no command  is
               specified,  is to select the article's item in the
               selector (e.g. the entire  thread  ("++")  in  the
               thread  selector).   See  the  section  on Regular
               Expressions and the description of pattern search-
               ing in the Article Selection section.

               One example: to scan all the unread articles look-
               ing for "topic" anywhere in the article  and  then
               select  its  group  and  save  the articles to the
               files topic.1, topic.2,  etc.  use  "/topic/a:++:s
               topic.%#".

       N       Go to the next newsgroup with unread news.

       P       Go to the previous newsgroup with unread news.

       &       Display  or set the current status of command-line
               switches.

       &&      Display or set the current macro definitions.

       !command
               Escape to a subshell.

       q       Quit this group.

       ESC,+   Quit the selector to the article level.  Note: ESC
               won't  work if trn has mapped your arrow keys with
               default macros and the first character  that  your
               arrow keys send is an ESC.

       Q       Quit the current newsgroup and return to the news-
               group-selection prompt for this group.

       AArrttiiccllee--RReeaaddiinngg LLeevveell

       On the article-reading level, _t_r_n displays unread articles
       in  thread  sequence (reading each article and its replies
       before going on to another topic) unless threads are  dis-
       abled  for  a  particular group, in which case the default
       order is the order they  arrived  at  your  site  (numeric
       sequence).   In  either case if you use the subject-search
       command (^N) you will switch to reading  the  articles  in



                              LOCAL                            10





TRN(1)                                                     TRN(1)


       date  order  within each matching subject.  (Making selec-
       tions in the subject selector or using the --SS switch  will
       automatically turn subject search mode on in an unthreaded
       group.)

       On the article-reading level you are _n_o_t asked whether you
       want  to  read an article before the article is displayed;
       rather, _t_r_n simply displays the first page (or portion  of
       a  page,  at low baud rates) of an article and asks if you
       want to continue.  The normal article-reading prompt comes
       at  the  END  of an article (although article-reading com-
       mands can also be given from within the middle of an arti-
       cle  in addition to the pager level commands).  The prompt
       at the end of an article looks like this:

       End of article 248 (of 257) -- what next? [npq]

       The following are the options at this point:

       n,SP    Scan forward for next unread article.  (Note:  the
               'n'  (next)  command  when  typed at the end of an
               article does not mark the article as  read,  since
               an  article  is automatically marked as read after
               the last line of it is printed.  It  is  therefore
               possible to type a sequence such as 'mn' and leave
               the article marked as unread.  The  fact  that  an
               article  is  marked as read by typing n, N, ^N, e,
               s, S, |, w, or W within the MIDDLE of the  article
               is in fact a special case.)

       N       Go to the next article.

       ^N      Find  the  next  article  with the same subject in
               date order.  This also makes subject  search  mode
               (^N) the default command at the end of an article.

       p       Scan backward for  previous  unread  article.   If
               there is none, stay at the current article.

       P       Go to the previous article.

       -       Go to the previously displayed article (regardless
               of whether that article is before  or  after  this
               article in the normal sequence).

       ^P      Find the previous article with the same subject in
               date order.  Makes subject search  mode  (^N)  the
               default.

       _N      Go to the next article in numeric sequence.

       _P      Go to the previous article in numeric sequence.





                              LOCAL                            11





TRN(1)                                                     TRN(1)


       <, >    Browse  the previous/next selected thread/subject.
               If no selections have been made, all  the  threads
               that  had  unread  news when you entered the news-
               group (or last left the selector) are  treated  as
               selected.   Entering  an empty newsgroup makes all
               the already-read threads available for browsing.

       [, ]    Proceed to the left/right  in  the  article  tree.
               Visits  already-read  articles  as  well  as empty
               nodes.  Try using the left-/right-arrow keys also.

       {, }    Go  to  the root/leaf of the article tree, even if
               the node is already read or  empty.   Proceeds  to
               the  very  first/last  node if you're already at a
               root/leaf in a multi-root thread.

       (, )    Go to the previous/next  sibling  in  the  thread,
               including   "cousin"   siblings.   Try  using  the
               up-/down-arrow keys also.

       t       Display the entire article tree and all its  asso-
               ciated  subjects.   If  the group is not currently
               threaded, it will become threaded to process  this
               command.

       ^R      Restart the current article.

       v       Restart  the current article verbosely, displaying
               the entire header.

       ^L      Refresh the screen.

       ^X      Restart the current  article,  and  decrypt  as  a
               rot13 message.

       X       Refresh  the  screen,  and decrypt as a rot13 mes-
               sage.

       b       Back up one page.

       ^E      Display the last page of the article.

       q       Quit this newsgroup and go back to the  newsgroup-
               selection level.

       ^       Go to the first unread article.

       $       Go  to  the  last  article (actually, one past the
               last article).

       number  Go to the numbered article.

       _C      Switch to next available charset conversion.




                              LOCAL                            12





TRN(1)                                                     TRN(1)


       range{,range}:command{:command}
               Apply a set of commands to a set of  articles.   A
               range  consists  of  either  <article  number>  or
               <article number>-<article number>.  A dot '.' rep-
               resents the current article, and a dollar sign '$'
               represents the last article.

               Applicable commands include 'm' (mark as  unread),
               'M' (mark as read-until-exit), 'j' (mark as read),
               "s dest" (save to a destination), "e dir" (extract
               to  directory),  "!command"  (shell  escape),  "="
               (print the subject), '+'/'-' (select/deselect  the
               article),  'T+'  (auto-select  the entire thread),
               'Tj'  (auto-junk  the  entire  thread),  "++"/"--"
               (select/deselect the associated thread), 'C' (can-
               cel), as well as S, |, w, W, and t.

       :command
               Apply a command to all  the  selected  threads  or
               their selected articles.  Use "::command" to apply
               it  to  all  non-selected  threads/articles.   For
               applicable  commands, see the discussion above for
               the range command.

       :.command
               Apply a command  to  the  current  thread  or  the
               selected  articles  in  the  current  thread.  Use
               "::.command" to apply a command to the  unselected
               articles in the current thread.

       j       Junk  the  current article (i.e. mark it as read).
               If this command is used from  within  an  article,
               you  are  left  at  the end of the article, unlike
               'n', which looks for the next article.

       m       Mark the current article as still unread.  (If you
               don't  want to see this article for a while you're
               probably better off using M instead of  m,  other-
               wise  this  article  might get picked again as the
               first available article sooner than you'd like.)

       M       Mark the current article to  return  on  newsgroup
               exit.   Until  then,  the  current article will be
               marked as read.  This is useful for  returning  to
               an article in another session.

       Y       Yank  back the marked-to-return articles, clearing
               their  to-return  status.   If  you  are   reading
               selected  articles,  the yanked articles come back
               selected.

       /pattern
               Scan forward for article containing _p_a_t_t_e_r_n in the
               subject.   See  the  Regular  Expressions section.



                              LOCAL                            13





TRN(1)                                                     TRN(1)


               Together with  the  escape  substitution  facility
               described  later,  it  becomes  easy to search for
               various attributes of the current article, such as
               subject, article ID, author name, etc.  The previ-
               ous pattern can be recalled with ESC.  If  _p_a_t_t_e_r_n
               is omitted, the previous pattern is assumed.

       /pattern/f
               Scan forward for article containing _p_a_t_t_e_r_n in the
               from line.  If you  are  using  thread  files  the
               article  data you are matching against MAY contain
               only the real name of the user.  If  you  want  to
               always match the full from line, see the following
               header-matching option that will read in the  full
               from-line data if it is not already available.

       /pattern/Hheader
               Scan forward for article containing _p_a_t_t_e_r_n in the
               indicated _h_e_a_d_e_r_.   Because  we  scan  the  entire
               string  up to the end of the modifiers, this modi-
               fier  must  be  the  last   one.    For   example,
               "/jsmoe@somesite.com/rHfrom:m+"   will   mark  all
               articles from "jsmoe@somesite.com" as  unread  and
               select  them.   Note that if the header line isn't
               one that trn  recognizes  in  its  header  parser,
               you'll  have  to  use  the  following  full-header
               matching.

       /pattern/h
               Scan forward for an article containing _p_a_t_t_e_r_n  in
               the header.

       /pattern/a
               Scan  forward  for  an  article containing _p_a_t_t_e_r_n
               anywhere in the article.

       /pattern/b
               Scan forward for an article containing _p_a_t_t_e_r_n  in
               the  body  of  the article, but not the signature.
               (The signature must be properly  delimited  to  be
               ignored, however.)

       /pattern/B
               Scan  forward  for  an  article containing _p_a_t_t_e_r_n
               anywhere in the body of the article.

       /pattern/r
               Scan read articles also.

       /pattern/c
               Make search case sensitive.  Ordinarily upper- and
               lower-case are considered the same.





                              LOCAL                            14





TRN(1)                                                     TRN(1)


       /pattern/t
               Force  the search to start at the top of the group
               (useful while reading the group, since the default
               is to start at the current article).

       /pattern/I
               Force the search to ignore the THRU line when exe-
               cuted as a memorized command.  If the command por-
               tion is a selection command (i.e. it starts with a
               '+' or a '.') this is the default behavior.

       /pattern/N
               Force the search to NOT ignore the THRU line  when
               executed  as a memorized command (useful on selec-
               tion commands -- see also -k).

       /pattern/modifiers:command{:command}
               Apply the commands listed to articles matching the
               search  command (possibly with h, a, b, or r modi-
               fiers).  Applicable commands include 'm' (mark  as
               UNread),  'M' (mark as read-until-exit), 'j' (junk
               -- mark as read in all groups), 'x' (mark as  read
               in this group), "s dest" (save to a dest), "e dir"
               (extract to dir), "!command" (shell  escape),  "="
               (print the subject), '+' (select the article), '-'
               deselect the article, 'T+' (auto-select the entire
               thread),  'Tj' (auto-junk the entire thread), "++"
               (select the associated thread), "--" deselect  the
               associated  thread),  and  'C'  (cancel).   If the
               first  command  is  'm'  or  'M',  modifier  r  is
               assumed.   A  K  may  be included in the modifiers
               (not the commands) to  cause  the  entire  command
               (sans K) to be saved to the local KILL file, where
               it will be applied to every article that shows  up
               in the newsgroup.

               For example, to save all articles in a given news-
               group to the line printer and mark them read,  use
               "/^/|lpr:j".   If you type "/^/K|lpr:j", this will
               happen every time you enter the newsgroup.

       ?pattern
               Scan backward for article  containing  _p_a_t_t_e_r_n  in
               the  subject.   May  be  modified  as  the forward
               search is: ?pattern?modifiers[:commands].   It  is
               likely that you will want an r modifier when scan-
               ning backward.

       k       Mark as read all articles with the same subject as
               the  current  article.   (Note: there is no single
               character command to temporarily mark as  read  (M
               command)  articles  matching  the current subject.
               That can be done with "/<ESC>s/M", however.)




                              LOCAL                            15





TRN(1)                                                     TRN(1)


               Mark the current article and all  its  replies  as
               read.

       J       Junk  all the articles in the current thread, even
               if it contains multiple subjects.

       A       Add a subject-search command to the memorized list
               for  this  group  (in  the  KILL  file).   You are
               prompted to choose  selection  (+),  junking  (j),
               selection  including  all  replies  (.) or junking
               including all replies (,).

       K       This is a synonym for the command "Aj" which  adds
               a command to junk the current subject to the memo-
               rized commands for the group.  See also the K mod-
               ifier on searches above.

       T       Add  a  thread-oriented  command  to the memorized
               list for this group.  You are prompted  to  choose
               selection  of entire thread (+), junking of entire
               thread  (j),  selection  of  an  article  and  its
               replies (.), junking of an article and its replies
               (,), clearing the auto-selection/junking for  this
               thread (c), or clearing the auto-selection/junking
               for an article and its replies (C).

       ^K      Edit the local list of memorized commands  (a.k.a.
               a KILL file) for this newsgroup.  Each line of the
               KILL file is either a subject-affecting command of
               the  form /pattern/x or a thread-affecting command
               of the form <message-id> Tx.  The  first  line  in
               the  KILL file has the form "THRU <number>", which
               tells _t_r_n the maximum article number that the KILL
               file  has been applied to.  The THRU value is usu-
               ally only used to keep header or article  searches
               from  happening multiple times.  Subject and from-
               line searches are quite  fast  if  the  group  has
               cached  data  around  (e.g. a .thread or .overview
               file).  If it doesn't, the THRU line  is  used  to
               set  a  lower  boundary  on the search to keep the
               startup time as short as possible.  If trn skipped
               some selections (or you're not sure), wait for the
               group to finish being cached  (e.g.  visiting  the
               selector  forces  the  caching of all unread arti-
               cles), quit the group, and re-enter.

               To see only newgroup articles in the control news-
               group, for instance, you might include the line

               /newgroup/:+

               which  selects all subjects containing "newgroup".
               You can add lines automatically via the  A  and  T
               commands  as  well  as  the K search modifier, but



                              LOCAL                            16





TRN(1)                                                     TRN(1)


               editing is the only way to remove subject commands
               (thread  commands  die automatically as the thread
               dies).  If either  of  the  environment  variables
               VISUAL or EDITOR is set, the specified editor will
               be invoked; otherwise a default  editor  (normally
               vi) is invoked on the KILL file.

               The  KILL  file  may  also  contain switch-setting
               lines beginning  with  '&'  (see  the  section  on
               "Options")  and  special  commands  beginning with
               '*'.  There are two such commands at  the  moment:
               "*j"  (junk  all  articles from THRU to the end of
               the group) and "*X" (junk all _u_n_s_e_l_e_c_t_e_d  articles
               from THRU to the end of the group).  Additionally,
               any line beginning with 'X' is  executed  on  exit
               from  the newsgroup rather than on entrance.  This
               can be used to set  switches  back  to  a  default
               value.  One use for this capability is to set your
               save directory to a custom value upon entry  to  a
               newsgroup  and  set  it  back  on  exit  using the
               -ESAVEDIR option.  See  also  the  --//  option  for
               another  solution  to  multiple  save  directories
               without using KILL files.

       r       Reply through net mail.  The environment variables
               MAILPOSTER  and  MAILHEADER  may be used to modify
               the mailing behavior of _t_r_n (see  the  environment
               section).   If  the current article does not exist
               (such as the "End of newsgroup" pseudo-article you
               can get to with a '$' command), invokes the mailer
               to nobody in particular.

       R       Reply, including the current article in the header
               file  generated.   (See  'F'  command below).  The
               YOUSAID environment variable controls  the  format
               of the attribution line.

       ^F      Forward the current article.

       f       Submit  a follow-up article.  If the current arti-
               cle does not exist (such as the "End of newsgroup"
               pseudo-article you can get to with a '$' command),
               posts an original (root) article.

       F       Submit a follow-up article, and  include  the  old
               article,  with  lines prefixed either by ">" or by
               the argument to the --FF switch.  _T_r_n  will  attempt
               to  provide  an  attribution  line in front of the
               quoted article, generated from the From:  line  of
               the   article.    Unfortunately,  the  From:  line
               doesn't always contain the right name; you  should
               double  check  it against the signature and change
               it if necessary, or you may have to apologize  for
               quoting   the   wrong   person.   The  environment



                              LOCAL                            17





TRN(1)                                                     TRN(1)


               variables NEWSPOSTER, NEWSHEADER  and  ATTRIBUTION
               may  be used to modify the posting behavior of _t_r_n
               (see environment section).

       C       Cancel the current article, but only  if  you  are
               the contributor or superuser.

       z       Supersede the current article, but only if you are
               the contributor.

       Z       Same as the 'z' command, but you start with a copy
               of the original article to work with.

       c       Catch  up  in this newsgroup; i.e., mark all arti-
               cles as read.

       U       Mark some or all  articles  as  unread.   You  can
               choose to mark the current thread, sub-thread (the
               current article and its replies),  all  the  arti-
               cles,  or start up the selector to choose specific
               articles to set unread.

       u       Unsubscribe from this newsgroup.

       s destination
               Save to a filename or pipe using sh.  If the first
               character  of  the  destination is a vertical bar,
               the rest of the command is considered a shell com-
               mand  to which the article is passed through stan-
               dard input.  The command is  subject  to  filename
               expansion.   (See  also  the  environment variable
               PIPESAVER.)  If the  destination  does  not  begin
               with  a  vertical  bar, the rest of the command is
               assumed to be a filename of some sort.  An initial
               tilde  '~'  will  be translated to the name of the
               home directory, and an initial  environment  vari-
               able  substitution  is  also  allowed.   If only a
               directory name is specified, the environment vari-
               able SAVENAME is used to generate the actual name.
               If a non-absolute filename is specified, the envi-
               ronment  variable SAVEDIR will be used to generate
               the actual directory.  If  nothing  is  specified,
               then obviously both variables will be used.  Since
               the current directory for _t_r_n while doing  a  save
               command  is your private news directory, typing "s
               ./filename" will  force  the  file  to  your  news
               directory.   Save  commands are also run through %
               interpretation,  so  that   you   can   enter   "s
               %O/filename"  to save to the directory you were in
               when you ran _t_r_n, and "s %t" to save to a filename
               consisting  of the Internet address of the sender.

               After generating the full pathname of the file  to
               save   to,  _t_r_n  determines  if  the  file  exists



                              LOCAL                            18





TRN(1)                                                     TRN(1)


               already, and if  so,  appends  to  it.   _t_r_n  will
               attempt  to  determine  if  an  existing file is a
               mailbox or a normal file, and save the article  in
               the  same format.  If the output file does not yet
               exist, _t_r_n will by default ask  you  which  format
               you  want,  or  you  can make it skip the question
               with either the --MM or --NN switch.  If  the  article
               is  to  be saved in mailbox format, the command to
               do so is generated from the  environment  variable
               MBOXSAVER.  Otherwise, NORMSAVER is used.

       S destination
               Save  to  a  filename  or  pipe  using a preferred
               shell, such as csh.  Which shell is  used  depends
               first  on  what  you have the environment variable
               SHELL set to, and in the absence of that, on  what
               your  news  administrator  set  for  the preferred
               shell when he or she installed _t_r_n.

       | command
               Shorthand for "s | command".

       w destination
               The same as "s destination", but saves without the
               header.

       W destination
               The same as "S destination", but saves without the
               header.

       e directory
               Extract a shell archive or uuencoded binary to the
               designated   directory.    The  article  is  first
               scanned to try  discover  what  type  of  data  is
               encapsulated.   If a "cut here" line is found, the
               first non-blank line after it must be  either  the
               start  of a shar header, or the "begin" or "table"
               line of  a  uuencoded  binary.   The  default  for
               extracting  shars  is  to send the data portion of
               the file to /bin/sh, but that  can  be  overridden
               with the UNSHAR variable (see the ENVIRONMENT sec-
               tion).  Uudecoding is done internally by a decoder
               that  can handle the data being split up over mul-
               tiple articles, and extracted one piece at a time.
               To decode a multi-article file, either execute the
               'e' command in each article in  sequence,  use  an
               article  range  to execute the command, or use the
               ":e" command to repeat the command for each of the
               currently selected articles.  When the 'e' command
               is not followed by any arguments, it  will  repeat
               the  arguments  from  the  last  extraction.   All
               directory specifications are relative to the value
               of  SAVEDIR,  so  you can use the command "e ." to
               force an  extraction  to  SAVEDIR  itself.   If  a



                              LOCAL                            19





TRN(1)                                                     TRN(1)


               uudecoding  is  in  progress  (i.e. the last piece
               wasn't extracted yet) and you exit the group,  the
               partial file will be removed.  This also occurs if
               you start to extract a new uuencoded  file  before
               the  previous  one was finished.  See also the 'E'
               command for ending a multi-part  uudecoding  manu-
               ally.

               There  is one special case that is handled differ-
               ently: if the first file in  a  recognizable  shar
               file  is  a  uuencoded binary that was packed with
               lines starting with an 'X', we will not unshar the
               file  but  instead  uudecode  it.   If this causes
               problems, you can override the default  extraction
               method by following the directory with an explicit
               command to execute, as described below.

       e directory|command
               This form of the 'e' command allows you to extract
               other data formats than shar or uuencoded files or
               to override the decisions made  by  the  automatic
               extraction  selection  described above.  In normal
               operation, all data following what we recognize as
               a  "cut  here"  line will be sent to the specified
               command.  Additionally, the distinctive  beginning
               of  a  shell  archive is also recognized without a
               preceding cut line.  When the command is run,  the
               default  directory  will  be  set to the specified
               directory, or the value of SAVEDIR if unspecified.
               Entering  the  'e'  command without arguments will
               repeat your previous extract command.  You can use
               the command "e dir|" to extract to a new directory
               using the previously-specified command.

       E       This command ends any  multi-part  uuencoded  file
               extraction  that  you  began,  but  are unable (or
               unwilling) to complete.  The  partially  extracted
               file is removed.

       &       Print  out  the  current  status  of  command-line
               switches.

       &switch {switch}
               Set additional command-line switches.

       &&      Print out current macro definitions.

       &&keys commands
               Define an additional macro.

       !command
               Escape to a subshell.  One  exclamation  mark  (!)
               leaves  you  in your own news directory.  A double
               exclamation mark (!!)  leaves  you  in  the  spool



                              LOCAL                            20





TRN(1)                                                     TRN(1)


               directory  of the current newsgroup.  The environ-
               ment variable SHELL will be used if  defined.   If
               _c_o_m_m_a_n_d  is null, an interactive shell is started.

               You can use  escape  key  substitutions  described
               later to get to many run-time values.  The command
               is also run through % interpretation, in  case  it
               is being called from a range or search command.

       +       Start  the selector in the last-used mode.  If the
               newsgroup is unthreaded and the  default  selector
               mode  is threads, we temporarily switch to subject
               selection unless manually overridden.

       _a      Start the selector in article mode.

       _s      Start the selector in subject mode.

       _t      Start the selector in thread mode.

       _T      Start the selector in thread mode unless the group
               isn't  threaded,  in  which case we settle for the
               subject selector.

       =       List subjects of unread articles.

       #       Print last article number.

       _+      Select the entire thread associated with the  cur-
               rent article.

       _-      Deselect  the  entire  thread  associated with the
               current article.

       PPaaggeerr LLeevveell

       At the pager level (within an article), the  prompt  looks
       like this:

       --MORE--(17%)

       and a number of commands may be given:

       SP      Display next page.

       x       Display  next page and decrypt as a rot13 message.

       d       Display half a page more.

       CR      Display one more line.

       q       Go to the end of the current article  (don't  mark
               it  either  read  or  unread).   Leaves you at the
               "What next?" prompt.



                              LOCAL                            21





TRN(1)                                                     TRN(1)


       j       Junk the current article.  Mark it read and go  to
               the end of the article.

       ^L      Refresh the screen.

       X       Refresh the screen and decrypt as a rot13 message.

       b       Back up one page.

       ^E      Display the last page of the article.

       _C      Switch to next available charset conversion.

       t       Display the entire  article  tree,  including  its
               associated subjects, and continue reading.  If the
               group  is  not  currently  threaded,  it  will  be
               threaded first.

       gpattern
               Goto  (search  forward for) _p_a_t_t_e_r_n within current
               article.  Note that there is no space between  the
               command and the pattern.  If the pattern is found,
               the page containing the pattern will be displayed.
               Where  on  the  page the line matching the pattern
               goes depends on the value of the  --gg  switch.   By
               default  the  matched  line goes at the top of the
               screen.

       G       Search for g pattern again.

       ^G      This is a special version of the 'g' command  that
               is  for  skipping  articles  in  a  digest.  It is
               equivalent to setting "-g4" and then executing the
               command "g^Subject:".

       TAB     This is another special version of the 'g' command
               that is for skipping inclusions of older articles.
               It is equivalent to setting "-g4" and then execut-
               ing the command "g^[^c]", where  _c  is  the  first
               character  of  the  last  line  on the screen.  It
               searches for the first  line  that  doesn't  begin
               with  the  same  character as the last line on the
               screen.

       !command
               Escape to a subshell.

       The following commands skip the rest of the current  arti-
       cle,  then  behave  just  as  if typed to the "What next?"
       prompt at the end of the article.  See  the  documentation
       at the article selection level for these commands.

           #  $ & / = ? A c C f F k K T ^K J , m M r R ^R u U v Y
       ^



                              LOCAL                            22





TRN(1)                                                     TRN(1)


           p P ^P - < > [ ] { } number
           range{,range} command{:command}

       The following commands also skip to the end of  the  arti-
       cle, but have the additional effect of marking the current
       article as read:

           n N ^N e s S | w W


       MMiisscceellllaanneeoouuss ffaaccttss aabboouutt ccoommmmaannddss

       An 'n' typed at either the "Last newsgroup"  prompt  or  a
       "Last  article"  prompt  will cycle back to the top of the
       newsgroup or article list, whereas a  'q'  will  quit  the
       level.   (Note  that  'n'  does  not mean "no", but rather
       "next".)  A space will of course do whatever is  shown  as
       the  default,  which  will  vary  depending on whether _t_r_n
       thinks you have more articles or newsgroups to read.

       The 'b' (backup page) command may be  repeated  until  the
       beginning  of the article is reached.  If _t_r_n is suspended
       (via a ^Z), then when the job is resumed, a  refresh  (^L)
       will  automatically  be done (Berkeley-type systems only).
       If you type a command such as '!' or 's' which  takes  you
       from  the middle of the article to the end, you can always
       get back into the middle by typing '^L'.

       In multi-character commands such as '!',  's',  '/',  etc,
       you  can  interpolate  various  run-time  values by typing
       escape and a character.  To find out what you can interpo-
       late, type escape and 'h', or check out the single charac-
       ter %  substitutions  for  environment  variables  in  the
       Interpretation  and  Interpolation  section, which are the
       same.  Additionally, typing a double escape will cause any
       %  substitutions  in  the  string  already  typed in to be
       expanded.

       TThhee TTrreeee DDiissppllaayy

       When reading a threaded newsgroup, _t_r_n displays a  charac-
       ter  representation of the article tree in the upper right
       corner of the header.  For example, consider the following
       display:

           (1)+-(1)--(_2)--_[_2_]
              |-(1)+-<3>
              |    \-[1]
              \-(1)+-[1]--[1]
                   \-[1]

       This  tree  represents  an  initial article that has three
       direct replies (the second column with three (1)'s).  Each
       reply has further replies branching off from them.  In two



                              LOCAL                            23





TRN(1)                                                     TRN(1)


       cases the subject line was altered in the reply, as  indi-
       cated by the increasing numbers.

       The  third  subject  is not selected for reading, as indi-
       cated by the <>'s.  Note you can always  forcefully  visit
       an  unselected  article  with  'N'  and 'P' as well as the
       thread-navagation commands (which are  typically  macro'ed
       to the arrow keys on your keypad).

       When  there  is only one subject associated with a thread,
       all the nodes are marked with  the  number  1.   When  the
       first subject change arrives, it is marked with the number
       2, and so on.  If you were to look at this thread  in  the
       thread  selector,  the  three  subjects associated with it
       would be listed in the same order as the ascending digits.
       In those rare cases where more than 9 subjects are associ-
       ated with each thread, the nodes are marked with the  let-
       ters A-Z, and then by a-z.

       The  articles  that have already been read are enclosed in
       ()'s, Unread articles are displayed in []'s,  and  unread-
       but-unselected  articles  are displayed in <>'s.  The cur-
       rently displayed article has its entire  node  highlighted
       in the display.  The previously displayed article has only
       its number highlighted.  If the group has  not  been  com-
       pletely  threaded  yet,  some  articles will appear as (?)
       until trn can determine if the  referenced  article  truly
       exists  or not.  If you visit such an article and wait for
       trn to finish threading the group, the screen will refresh
       as  soon  as  the  presence  or  absence of the article is
       determined.

       OOppttiioonnss

       _T_r_n has a nice set of options to allow you to  tailor  the
       interaction  to your liking.  (You might like to know that
       the author swears by "-x6ms +e -mu  -S  -XX  -N  -B  -p".)
       These  options  may  be  set  on the command line, via the
       TRNINIT environment variable, via a file pointed to by the
       TRNINIT  variable,  or  from within _t_r_n via the & command.
       Options  may  generally  be  unset  by  typing  "+switch".
       Options include:

       --aa   causes  trn  to  always thread the unread articles on
            entry to a group.  Without this option trn may  enter
            a group in a partially-threaded state and process the
            unthreaded articles in the background.  The down side
            of  this is that the tree display may not be complete
            when it is first displayed and you may start  out  at
            an odd position in the first thread's article tree.

       --AA   tells  trn  to  attempt to create some default macros
            that will map your arrow keys to useful trn functions
            (this  is the default).  Use ++AA to turn this behavior



                              LOCAL                            24





TRN(1)                                                     TRN(1)


            off.

       --bb   will force trn to read each thread in a breadth-first
            order, rather than depth-first.

       --BB   will  turn on a spinner that twirls when trn is doing
            background article-processing.   A  gizmo  for  those
            interested in what's going on behind the scenes.

       --cc   checks  for  news without reading news.  If a list of
            newsgroups is given on the command line,  only  those
            newsgroups will be checked; otherwise all subscribed-
            to newsgroups are checked.  Whenever the --cc switch is
            specified, a non-zero exit status from _t_r_n means that
            there is unread news in  one  of  the  checked  news-
            groups.   The --cc switch does not disable the printing
            of newsgroups with unread news; this is controlled by
            the --ss switch.  (The --cc switch is not meaningful when
            given via the & command.)

       --CC<<nnuummbbeerr>>
            tells _t_r_n how often to  checkpoint  the  _._n_e_w_s_r_c,  in
            articles  read.   Actually,  this number says when to
            start thinking about doing a checkpoint if the situa-
            tion is right.  If a reasonable check-pointing situa-
            tion doesn't  arise  within  10  more  articles,  the
            _._n_e_w_s_r_c is check-pointed willy-nilly.

       --dd<<ddiirreeccttoorryy nnaammee>>
            sets  your  private news directory to something other
            than ~/News.  The directory name will be globbed (via
            csh)  if  necessary  (and if possible).  The value of
            SAVEDIR (where articles are saved) is  initially  set
            to  this  directory, but is often manipulated via the
            --// option or by manipulating SAVEDIR  directly  (per-
            haps via the memorized commands (the KILL file) for a
            group.  Any KILL files (see  the  K  command  in  the
            Article Selection section) also reside in this direc-
            tory and its subdirectories, by  default.   In  addi-
            tion, shell escapes leave you in this directory.

       --DD<<ffllaaggss>>
            enables debugging output.  See common.h for flag val-
            ues.  Warning: normally _t_r_n attempts to restore  your
            _._n_e_w_s_r_c  when  an unexpected signal or internal error
            occurs.  This is disabled when  any  debugging  flags
            are set.

       --ee   causes  each  page within an article to be started at
            the top of the screen, not just the first page.   (It
            is  similar  to the --cc switch of _m_o_r_e(1).)  You never
            have to read scrolling text with this  switch.   This
            is  helpful  especially at certain baud rates because
            you can start  reading  the  top  of  the  next  page



                              LOCAL                            25





TRN(1)                                                     TRN(1)


            without waiting for the whole page to be printed.  It
            works nicely in conjunction with the --mm switch, espe-
            cially  if  you use half-intensity for your highlight
            mode.  See also the --LL switch.

       --EE<<nnaammee>>==<<vvaall>>
            sets the environment variable  <name>  to  the  value
            specified.   Within  _t_r_n, "&-ESAVENAME=%t" is similar
            to "setenv SAVENAME '%t'" in _c_s_h, or  "SAVENAME='%t';
            export  SAVENAME"  in  _s_h.  Any environment variables
            set with --EE will be inherited by subprocesses of _t_r_n.

       --ff   will  make  trn  avoid  various  sleep  calls and the
            prompt after the processing of the memorized commands
            that are intended to allow you time to read a message
            before the screen clears.  This allows  the  advanced
            user  to  cruise along a little faster at the expense
            of readability.  The -t (terse) option turns on -f by
            default,  but  you can override this by specifying +f
            after the -t option.

       --FF<<ssttrriinngg>>
            sets the prefix string for the 'F' follow-up  command
            to  use in prefixing each line of the quoted article.
            For example, "-F<tab>" inserts a tab on the front  of
            each  line  (which  will  cause  long  lines  to wrap
            around, unfortunately), "-F>>>>"  inserts  ">>>>"  on
            every  line,  and "-F" by itself causes nothing to be
            inserted, in case you want to reformat the text,  for
            instance.  The initial default prefix is ">".

       --gg<<lliinnee>>
            tells _t_r_n which line of the screen you want searched-
            for strings to show up on when you  search  with  the
            'g'  command  within  an article.  The lines are num-
            bered starting with 1.  The initial default is "-g1",
            meaning  the  first  line of the screen.  Setting the
            line to less than 1 or more than the number of  lines
            on  the  screen  will  set it to the last line of the
            screen.

       --GG   selects the "fuzzy" processing on the go command when
            you  don't  type  in  a  valid group name.  With this
            option on trn will attempt  to  find  the  group  you
            probably  meant  to type, but it can be a little slow
            about it, so it's not on by default.

       --hh<<ssttrriinngg>>
            hides (disables the printing  of)  all  header  lines
            beginning  with  _s_t_r_i_n_g  that  trn  recognizes.   For
            instance, -hexp will  disable  the  printing  of  the
            "Expires:"  line.   Case  is  insignificant.  Headers
            unknown to trn cannot be disabled except  by  turning
            them  all  off  (-h without a string will disable all



                              LOCAL                            26





TRN(1)                                                     TRN(1)


            headers except the Subject)  and  then  using  ++hh  to
            select  those lines you want to see.  You may wish to
            use the baud-rate switch modifier below to hide  more
            lines at lower baud rates.

       --HH<<ssttrriinngg>>
            works just like --hh except that instead of setting the
            hiding flag for a header line, it sets the magic flag
            for  that  header  line.   Certain  header lines have
            magic behavior that can be controlled this  way.   At
            present, the following actions are caused by the flag
            for the particular line: the  Date  line  prints  the
            date in local time if the group is threaded; the From
            line will only print the  commented  portion  of  the
            user  name;  the Newsgroups line will only print when
            there are multiple newsgroups; the Subject line  will
            be  underlined  and (when threaded) the keyword 'Sub-
            ject:' is replaced by its subject number (e.g.  [1]);
            and  the  Expires  line  will always be suppressed if
            there is nothing  on  it.   In  fact,  all  of  these
            actions  are the default, and you must use ++HH to undo
            them.

       --ii==<<nnuummbbeerr>>
            specifies how long (in lines) to consider the initial
            page  of  an  article  -- normally this is determined
            automatically depending on baud rate.  (Note that  an
            entire  article header will always be printed regard-
            less of the specified initial page  length.   If  you
            are  working  at low baud rate and wish to reduce the
            size of the headers,  you  may  hide  certain  header
            lines with the hh switch.)

       --II   tells  trn  to append all new, unsubscribed groups to
            the end of the .newsrc.

       --jj   forces trn to leave control characters unmolested  in
            messages.

       --JJ{{<<nnuummbbeerr>>}}
            causes  trn  to  join  similar subjects into a common
            thread if they are the same up to the indicated  num-
            ber  of characters (the default is 30).  You can turn
            this on and off for specific groups  by  putting  the
            following lines into your kill file for the group(s):

            &-J30
            X&+J

       --kk   tells trn to ignore the  THRU  line  when  processing
            selection searches (i.e. searches with a command por-
            tion that starts with a '+' or a '.')  in  the  memo-
            rized  commands  (aka kill files).  This is turned on
            by default, so use ++kk if you want to turn it off.



                              LOCAL                            27





TRN(1)                                                     TRN(1)


       --KK   is used to keep a trn  from  checking  for  new  news
            while  you're in the group.  Use this when your kill-
            file processing is so slow that you  don't  want  the
            group  to  expand  while you're reading.  If you only
            want specific groups to be affected, put these  lines
            into your kill file for the group(s):

            &-K
            X&+K

       --ll   disables  the clearing of the screen at the beginning
            of each article, in case you have a bizarre terminal.

       --LL   tells  _t_r_n to leave information on the screen as long
            as possible by not blanking the screen between pages,
            and by using clear to end-of-line.  (The _m_o_r_e(1) pro-
            gram does this.)  This feature works only if you have
            the  requisite  termcap capabilities.  The switch has
            no effect unless the --ee switch is set.

       --mm==<<mmooddee>>
            enables the marking of the last line of the  previous
            page  printed, to help the user see where to continue
            reading.  This is most helpful when less than a  full
            page  is  going to be displayed.  It may also be used
            in conjunction with the --ee switch, in which case  the
            page is erased, and the first line (which is the last
            line of the previous page) is highlighted.   If  --mm==ss
            is  specified, the standout mode will be used, but if
            --mm==uu is specified, underlining will be used.  If nei-
            ther  ==ss or ==uu is specified, standout is the default.
            Use ++mm to disable highlighting.

       --MM   forces mailbox format in  creating  new  save  files.
            Ordinarily you are asked which format you want.

       --NN   forces  normal  (non-mailbox)  format in creating new
            save files.  Ordinarily you are  asked  which  format
            you want.

       --oo   will act like old versions of trn and not junk cross-
            referenced articles when  using  thread  commands  to
            junk  articles  in  the  current  group  (such as the
            selector's 'X' command).

       --OO<<mmooddee>>{{<<oorrddeerr>>}}
            specifies the selector's mode  and  (optionally)  the
            sort  order.   The modes are 'a'rticle, 's'ubject, or
            't'hread.   The   orders   are   'd'ate,   's'ubject,
            'a'uthor,  article  'c'ount  per group, 'n'umeric, or
            subject-date 'g'roups.  The order can be  capitalized
            to  reverse  the  indicated  order.   For example, to
            choose the article selector in subject order  specify
            "-Oas".



                              LOCAL                            28





TRN(1)                                                     TRN(1)


       --pp{{oopptt}}
            tells  trn  to  auto-select  your  postings and their
            replies as it encounters them in the  various  groups
            you  read.   The  optional parameter is either a '.',
            'p', or '+' (it  defaults  to  '.'  if  omitted)  and
            affects  what  command  trn  should  execute  when it
            encounters your postings.  The default is to  execute
            the command "T." on each of your postings which tells
            trn to memorize the auto-selection  of  this  article
            and  all its replies.  Using -pp tells trn to use the
            same command, but start the selection with the parent
            article,  so  that  you  see any other replies to the
            same article.  Using -p+  tells  trn  to  select  the
            whole thread that contains your reply.

       --qq   bypasses  the automatic check for new newsgroups when
            starting _t_r_n.

       --QQ<<sseett>>
            defines the set  of  available  charset  conversions.
            This  can be useful to restrict the available conver-
            sions to those your terminal  can  handle  and/or  to
            specify  an  alternate  default. The first element of
            this set is taken as default for each article.

       --rr   causes _t_r_n to restart in the last newsgroup read dur-
            ing a previous session with _t_r_n.  It is equivalent to
            starting up normally and then getting  to  the  news-
            group with a g command.

       --ss   with  no  argument  suppresses the initial listing of
            newsgroups with unread news, whether --cc is  specified
            or  not.  Thus --cc and --ss can be used together to test
            "silently" the status of news from within your _._l_o_g_i_n
            file.   If  --ss  is  followed by a number, the initial
            listing is suppressed after that many lines have been
            listed.   Presuming that you have your _._n_e_w_s_r_c sorted
            into order of interest, --ss55 will tell you the 5  most
            interesting  newsgroups  that have unread news.  This
            is also a nice feature to use in  your  _._l_o_g_i_n  file,
            since  it  not only tells you whether there is unread
            news, but also how  important  the  unread  news  is,
            without  having  to  wade  through the entire list of
            unread newsgroups.  If no --ss switch is given  --ss55  is
            assumed,  so  just  putting  "rn -c" into your .login
            file is fine.

       --SS<<nnuummbbeerr>>
            causes _t_r_n to enter subject search mode (^N) automat-
            ically whenever an unthreaded newsgroup is started up
            with <number> unread articles or more.  Additionally,
            it  causes any 'n' typed while in subject search mode
            to be interpreted as '^N' instead.  (To get back  out
            of  subject search mode, the best command is probably



                              LOCAL                            29





TRN(1)                                                     TRN(1)


            '^'.)  If <number> is omitted, 3 is assumed.

       --tt   puts _t_r_n into terse mode.  This is more  cryptic  but
            useful  for  low  baud rates.  (Note that your system
            administrator may have compiled _t_r_n with either  ver-
            bose or terse messages only to save memory.)  You may
            wish to use the baud-rate switch  modifier  below  to
            enable terse mode only at lower baud rates.

       --TT   allows you to type ahead of trn.  Ordinarily trn will
            eat typeahead to prevent your autorepeating space bar
            from doing a very frustrating thing when you acciden-
            tally hold it down.  If you don't  have  a  repeating
            space  bar,  or you are working at low baud rate, you
            can set this switch to prevent  this  behavior.   You
            may  wish  to use the baud-rate switch modifier below
            to disable typeahead only at lower baud rates.

       --uu   sets the unbroken-subject-line mode in the  selector,
            which  simply  truncates  subjects  that are too long
            instead of dumping the middle portion  prior  to  the
            last two words of the subject.

       --UU   tells  trn  to  not  write the .newsrc file out after
            visiting each group.  While this is "unsafe"  it  can
            be faster if you have a really huge .newsrc.

       --vv   sets  verification  mode for commands.  When set, the
            command being executed  is  displayed  to  give  some
            feedback  that the key has actually been typed.  Use-
            ful when the system is heavily loaded and you give  a
            command that takes a while to start up.

       --VV   will output trn's version number and quit.

       --xx{{<<nnuummbbeerr>>}}{{<<lliisstt>>}}
            Enable the extended (threaded) features of _t_r_n beyond
            the _r_n compatibility mode (this may be the default on
            your  system,  use  +x  if you yearn for the good ol'
            days).  The <number> is the maximum number  of  arti-
            cle-tree  lines  (from 0 to 11) you want displayed in
            your header.  Use the <list> to choose  which  thread
            selector  styles  you  like  ('s'hort,  'm'edium,  or
            'l'ong), and in what order they are selected with the
            'L' command.  For example, use --xxmmss to start with the
            medium display mode and only switch  between  it  and
            the  short  mode.  You can omit either or both of the
            parameters, in which case  a  default  of  --xx66llmmss  is
            assumed.

       --XX{{<<nnuummbbeerr>>}}{{<<ccoommmmaannddss>>}}
            If  you like using the selector, you'll probably want
            to use this option to make the selector  command  (+)
            the  default  when  a newsgroup is started up with at



                              LOCAL                            30





TRN(1)                                                     TRN(1)


            least <number> unread articles.  (Your installer  may
            have  chosen to make -X1 the default on your system.)
            It is also used to select which commands you want  to
            be the defaults while using the thread selector.  For
            example, --XX22XXDD will  make  the  thread  selector  the
            default  command  for  entering  a  newsgroup with at
            least 2 unread articles, and set the default  command
            for  the LAST page of the thread selector to be the XX
            command and the default command for all  other  pages
            to  be  the DD command.  Either or both parameters can
            be omitted, as well as  the  second  default  command
            (e.g.   --XXXX  would change the default newsgroup entry
            to use the selector and the default command  for  the
            last page of the selector to be 'X').  The default is
            --XX11ZZ>> if just --XX is specified.  To  set  the  default
            selector  commands  without having '+' be the default
            entry into a newsgroup, specify a high  number,  like
            9999.

       --zz   sets  the  minimum number of minutes that must elapse
            before the active file is refetched to look  for  new
            articles.  A value of 0 or using +z turns this off.

       --ZZ   is used to select what style of database you want trn
            to  access.   Use  -Zt  for  thread  files,  -Zo  for
            overview  files,  and  +Z  for  none.  The default is
            whatever your newsadmin compiled into trn, and can be
            -Zot to try to access either one.

       --//   sets  SAVEDIR  to "%p/%c" and SAVENAME to "%a", which
            means that by default articles are saved in a  subdi-
            rectory  of your private news directory corresponding
            to the name of the the current  newsgroup,  with  the
            filename  being  the article number.  ++// sets SAVEDIR
            to "%p" and SAVENAME to "%^C", which by default saves
            articles  directly  to  your  private news directory,
            with the filename being the name of the current news-
            group,  first  letter  capitalized.  (Either ++// or --//
            may be default on your system, depending on the feel-
            ings  of  your  news administrator when he, she or it
            installed _t_r_n.)  You may, of course,  explicitly  set
            SAVEDIR  and  SAVENAME to other values -- see discus-
            sion in the environment section.

       Any switch may be selectively  applied  according  to  the
       current  baud-rate.   Simply prefix the switch with +speed
       to apply the switch at that speed or greater,  and  -speed
       to  apply  the  switch  at  that speed or less.  Examples:
       -1200-hposted suppresses the Posted line at 1200  baud  or
       less;  +9600-m  enables marking at 9600 baud or more.  You
       can  apply  the  modifier  recursively  to  itself   also:
       +300-1200-t sets terse mode from 300 to 1200 baud.

       Similarly,  switches  may  be  selected  based on terminal



                              LOCAL                            31





TRN(1)                                                     TRN(1)


       type:

            -=vt100+T      set +T on vt100
            -=tvi920-ETERM=mytvi     get a special termcap entry
            -=tvi920-ERNMACRO=%./.rnmac.tvi
                           set up special key-mappings
            +=paper-v      set verify mode if not hardcopy

       Some switch arguments, such as environment  variable  val-
       ues,  may  require  spaces in them.  Such spaces should be
       quoted via ", ', or \ in the  conventional  fashion,  even
       when passed via TRNINIT or the & command.

       RReegguullaarr EExxpprreessssiioonnss

       The patterns used in article searching are regular expres-
       sions such as  those  used  by  _e_d(1).   In  addition,  \w
       matches   an   alphanumeric   character   and  \W  a  non-
       alphanumeric.  Word boundaries may be matched by  \b,  and
       non-boundaries  by \B.  The bracketing construct \( ... \)
       may also be used, and \digit  matches  the  digit'th  sub-
       string,  where  digit  can  range from 1 to 9.  \0 matches
       whatever the last bracket match matched.  Up to 10  alter-
       natives  may given in a pattern, separated by \|, with the
       caveat that \( ... \| ... \) is illegal.

       CChhaarraacctteerrsseett ccoonnvveerrssiioonnss

       _t_r_n can use  character  set  conversions  when  displaying
       articles.  This  helps users in non-English-speaking coun-
       tries to display special  characters  on  7-bit  displays.
       _t_r_n assumes that articles use the ISO-8859-1 character set
       and converts the special characters (e.g., "umlauts") to a
       string  of ASCII characters.  Currently the following con-
       versions are supported (see the _-_Q option):

       pp    Plain. No change. This is the default.

       aa    ISO->ASCII. Special characters are mapped  to  ASCII,
            e.g. the umlaut-o character becomes oe.

       mm    ISO->ASCII  monospaced. Special characters are mapped
            to exactly one similar-looking ASCII character,  e.g.
            umlaut-o  becomes  o.  Used  where correct spacing is
            more important than accuracy.

       tt    TeX->ISO.  Assuming  your  display  can  handle   the
            ISO-8859-1 charset, _t_r_n transforms umlauts in the TeX
            notation, which is commonly used in Germany, to  real
            ISO characters, e.g. "a becomes umlaut-a.

       The selected conversion, if different from pp, will be dis-
       played in the article level and pager prompt. The  conver-
       sion  is  also  used when including original articles in a



                              LOCAL                            32





TRN(1)                                                     TRN(1)


       reply or followup. It is not used when saving articles  to
       files.

       IInntteerrpprreettaattiioonn aanndd IInntteerrppoollaattiioonn

       Many of the strings that _t_r_n handles are subject to inter-
       pretations of several types.  Under filename expansion, an
       initial "~/" is translated to the name of your home direc-
       tory, and "~name" is translated to the login directory for
       the  user  specified.  Filename expansion will also expand
       an initial environment variable, and also does  the  back-
       slash, caret and percent expansion mentioned below.

       All  interpreted  strings  go through backslash, caret and
       percent interpretation.  The  backslash  escapes  are  the
       normal  ones  (such  as  \n,  \t,  \033, etc.).  The caret
       escapes indicate control codes (such as ^i, ^l, etc.).  If
       you wish to pass through a backslash or a caret it must be
       escaped with a backslash.  The special percent escapes are
       similar  to  printf percent escapes.  These cause the sub-
       stitution of various run-time values into the string.  The
       following are currently recognized:

       %a      Current article number.

       %A      Full name of current article (%P/%c/%a).

       %b      Destination of last save command, often a mailbox.

       %B      The byte offset to the beginning of  the  part  of
               the  article to be saved, set by the save command.
               The 's' and 'S' commands set it to 0, and the  'w'
               and  'W' commands set it to the byte offset of the
               body of the article.

       %c      Current newsgroup, directory form.

       %C      Current newsgroup, dot form.

       %d      Full name of newsgroup directory (%P/%c).

       %D      "Distribution:" line from the current article.

       %e      The last command executed to extract data from  an
               article.

       %E      The last directory where an extracted file went.

       %f      "From:"  line  from  the  current  article, or the
               "Reply-To:" line if there is  one.   This  differs
               from  %t  in that comments (such as the full name)
               are not stripped out with %f.





                              LOCAL                            33





TRN(1)                                                     TRN(1)


       %F      "Newsgroups:" line for a new article,  constructed
               from  "Newsgroups:"  and  "Followup-To:"  lines of
               current article.

       %h      Name of the header file to pass  to  the  mail  or
               news  poster,  containing all the information that
               the poster program needs in the form of a  message
               header.  It may also contain a copy of the current
               article.  The format of the header  file  is  con-
               trolled  by the MAILHEADER and NEWSHEADER environ-
               ment variables.

       %H      Host name (your machine's name).

       %i      "Message-I.D.:" line  from  the  current  article,
               with <> guaranteed.

       %I      The reference indication mark (see the --FF switch.)

       %l      The news administrator's login name, if any.

       %L      Login name (yours).

       %m      The current mode of _t_r_n_, for  use  in  conditional
               macros.

                    i    Initializing.
                    n    Newsgroup-selection level.
                    f    end (Finis) of newsgroup-selection level.
                    t    the Thread/subject/article selector.
                    a    Article level (What next?).
                    e    End of the article level.
                    p    Pager level (MORE prompt).
                    u    Set-unread prompt.
                    d    selector moDe prompt.
                    o    selector Order prompt.
                    m    Memorize thread command prompt.
                    r    memoRize subject command prompt.
                    k    processing memorized (KILL file) commands.
                    A    Add this newsgroup?
                    B    aBandon confirmation.
                    C    Catchup confirmation.
                    D    Delete bogus newsgroups?
                    F    Is follow-up a new topic?
                    M    Use mailbox format?
                    R    Resubscribe to this newsgroup?

               Note  that  yes/no  questions  are  all upper-case
               modes.  If, for example, you  wanted  to  disallow
               defaults on all yes/no questions, you could define
               the following macro:

               \040 %(%m=[A-Z]?h: )




                              LOCAL                            34





TRN(1)                                                     TRN(1)


       %M      The number of articles marked to  return  via  the
               'M' command.  If the same article is Marked multi-
               ple times, "%M" counts it multiple  times  in  the
               current implementation.

       %n      "Newsgroups:" line from the current article.

       %N      Full name (yours).

       %o      Organization (yours).

       %O      Original  working  directory  (where  you  ran trn
               from).

       %p      Your private news directory, normally ~/News.

       %P      Public    news    spool    directory,     normally
               /usr/spool/news on systems that don't use NNTP.

       %q      The  value  of the last "quoted" input string (see
               the %" interp).

       %r      Last reference on references line of current arti-
               cle (parent article id).

       %R      References  list  for  a  new article, constructed
               from the references and article ID of the  current
               article.

       %s      Subject, with all Re's and (nf)'s stripped off.

       %S      Subject, with one "Re:" stripped off.

       %t      "To:"  line  derived  from the "From:" and "Reply-
               To:" lines of the current  article.   This  always
               returns an Internet format address.

       %T      "To:"  line  derived  from the "Path:" line of the
               current article to produce a uucp path.

       %u      The number of unread articles in the current news-
               group.

       %U      The number of unread articles in the current news-
               group, not counting the the current article.  When
               threads  are  selected,  this  count reflects only
               selected articles.

       %v      The number of unselected  articles,  not  counting
               the current article if it is unselected.

       %w      The  directory where mthreads keeps its tmp files.





                              LOCAL                            35





TRN(1)                                                     TRN(1)


       %W      The directory where thread files are placed.

       %x      The news library directory.

       %X      The trn library directory.

       %z      The length of the current article in bytes.

       %Z      The number of selected threads.

       %~      Your home directory.

       %.      The directory containing your dot files, which  is
               your  home  directory unless the environment vari-
               able DOTDIR is defined when trn is invoked.

       %#      The current count for a multi-file save,  starting
               with 1.  This value is incremented by one for each
               file saved or extracted within a single command.

       %$      Current process number.

       %/      Last search string.

       %?      A space unless the current interp string is  >  79
               characters,  at  which  point it turns into a new-
               line.

       %%      A percent sign.

       %{name} or %{name-default}
               The environment variable "name".

       %[name] The value of header line "Name:" from the  current
               article.  The "Name: " is not included.  For exam-
               ple "%D"  and  "%[distribution]"  are  equivalent.
               The name must be spelled out in full.

       %`command`
               Inserts the output of the command, with any embed-
               ded newlines translated to space.

       %""prompt""
               Prints prompt on the  terminal,  then  inputs  one
               string, and inserts it.

       %(test_text=pattern?then_text:else_text)
               If   _t_e_s_t___t_e_x_t  matches  _p_a_t_t_e_r_n,  has  the  value
               _t_h_e_n___t_e_x_t, otherwise _e_l_s_e___t_e_x_t.  The  ":else_text"
               is  optional, and if absent, interpolates the null
               string.  The = may be replaced with !=  to  negate
               the  test.   To  quote  any of the meta-characters
               ('=', '?', ':', or ')'), precede with a backslash.




                              LOCAL                            36





TRN(1)                                                     TRN(1)


       %digit  The  digits  1  through  9  interpolate the string
               matched by the nth bracket  in  the  last  pattern
               match  that had brackets.  If the last pattern had
               alternatives, you may not know the number  of  the
               bracket  you  want  --  %0  will give you the last
               bracket matched.

       Modifiers: to capitalize the  first  letter,  insert  '^':
       "%^C"  produces something like "Rec.humor".  Inserting '_'
       causes the first letter following the last '/' to be capi-
       talized: "%_c" produces "rec/Humor".

       Inserting  '\'  will insert a backslash before any charac-
       ters that would be magic in a regular expression,  includ-
       ing '%': "%\C" produces "rec\.humor".

       Inserting  "'"  will insert a backslash before any single-
       quotes in the result, suitable for  enclosing  in  single-
       quotes  and  sending  to  a  shell:  "'%'s'" might produce
       "'I'\''m a subject'".

       Inserting "''" will insert a backslash before any  double-
       quotes  in  the  result, suitable for enclosing in double-
       quotes and sending to a shell.

       Inserting ">" will strip out just the address  portion  of
       an address string such as the From line.

       Inserting  ")" will strip out just the comment (real name)
       portion of an address string such as the From line.

       Inserting ":FMT" will format the result according  to  the
       printf-style  FMT  string:  "%:-50.50s" left-justifies the
       subject into a 50 character field.

EENNVVIIRROONNMMEENNTT
       The following environment variables are paid attention  to
       by  _t_r_n.   In general the default values assumed for these
       variables by _t_r_n are reasonable, so if you are  using  _t_r_n
       for  the  first  time, you can safely ignore this section.
       Note that the defaults below may not correspond  precisely
       to  the  defaults  on  your  system.   To  find the actual
       defaults you would need to look in config.h  and  common.h
       in  the trn source directory, and the file INIT in the trn
       library directory.

       Those variables marked (%) are subject to % interpolation,
       and  those  marked (~) are subject to both % interpolation
       and ~ interpretation.

       ATTRIBUTION (%)
               Gives the format of the attribution line in  front
               of the quoted article included by an F command.




                              LOCAL                            37





TRN(1)                                                     TRN(1)


               Default: In article %i,%?%)f <%>f> wrote:

       AUTOSUBSCRIBE
               When  _t_r_n is checking for new newsgroups and finds
               one matching one of the patterns in AUTOSUBSCRIBE,
               the new group is automatically added to the end of
               the .newsrc, subscribed.  Newsgroups not  matching
               this or AUTOUNSUBSCRIBE, below, are offered to the
               user.

               AUTOSUBSCRIBE is a comma separated list  of  news-
               group  patterns  ala  'o',  '/', etc.  It can also
               include  "but  not"  entries  preceded   by   '!'.
               "a,b,!c,d"  is read as "matching a or b, unless it
               also matches c; matching d  regardless".   Another
               way  to  look  at  it is "(((a or b) and not c) or
               d)".  To  automatically  subscribe  to  all  local
               groups  but  be choosy about non-local groups, one
               might say "*,!*.*".

               Default: (none)

       AUTOUNSUBSCRIBE
               AUTOUNSUBSCRIBE is very similar to  AUTOSUBSCRIBE,
               above, but new newsgroups matching it are automat-
               ically added to  the  end  of  the  .newsrc  file,
               unsubscribed.   If  a  newsgroup  matches AUTOSUB-
               SCRIBE, AUTOUNSUBSCRIBE is not consulted.

               Default: (none)

       CANCEL (~)
               The shell command used to cancel an article.

               Default: inews -h < %h

       CANCELHEADER (%)
               The format of the file to pass to the CANCEL  com-
               mand in order to cancel an article.

               Default:
               Newsgroups: %n
               Subject: cmsg cancel %i
               References: %R
               Reply-To: %L@%H (%N)
               Distribution: %D
               Organization: %o

               %i cancelled from trn.

       DOTDIR  Where  to  find  your dot files, if they aren't in
               your home directory.  Can  be  interpolated  using
               "%.".




                              LOCAL                            38





TRN(1)                                                     TRN(1)


               Default: $HOME

       EDITOR (~)
               The name of your editor, if VISUAL is undefined.

               Default: whatever your news administrator compiled
               in, usually vi.

       EXSAVER (%)
               The shell command to execute in order  to  extract
               data  to  either  /bin/sh or a user-specified com-
               mand.

               Default: tail +%Bc %A | %e

       FIRSTLINE (%)
               Controls the format of the line displayed  at  the
               top of an article.  Warning: this may go away.

               The default (ignoring the Marked to return display
               in unthreaded groups) is approximately:

               %C #%a%(%Z=^0$?%(%U!=^0$? (%U more\)):  (%U  +  %v
               more\))

       FORWARDHEADER (%)
               The  format of the header file for forwarding mes-
               sages.  See also FORWARDPOSTER.

               Default:

               To:
               Subject: %(%i=^$?:[subject] (fwd\\)
               %(%{REPLYTO}=^$?:Reply-To: %{REPLYTO}
               )Newsgroups: %n
               In-Reply-To: %i)
               %(%[references]=^$?:References: %[references]
               )Organization: %o
               Cc:
               Bcc: \n\n

       FORWARDPOSTER (~)
               The shell command to be used by the  forward  com-
               mand  (^F)  in  order  to  allow  you  to edit and
               deliver the file.  _t_r_n will not itself  call  upon
               an editor for replies -- this is a function of the
               program referenced  by  FORWARDPOSTER.   See  also
               FORWARDHEADER and MAILPOSTER.

               Default: QUOTECHARS=%I Rnmail -h %h

       HIDELINE
               If  defined,  contains  a regular expression which
               matches article lines to be hidden, in order,  for



                              LOCAL                            39





TRN(1)                                                     TRN(1)


               instance,  to  suppress quoted material.  A recom-
               mended string for this purpose is  "^>...",  which
               _d_o_e_s_n_'_t  hide  lines  with  only '>', to give some
               indication that quoted material is being  skipped.
               If you want to hide more than one pattern, you can
               use "|" to separate  the  alternatives.   You  can
               view  the  hidden  lines by restarting the article
               with the 'v' command.

               There is some overhead involved in  matching  each
               line  of the article against a regular expression.
               You might wish to  use  a  baud-rate  modifier  to
               enable this feature only at low baud rates.

               Default: undefined

       HOME    Your  home  directory.   Affects ~ interpretation,
               and the location of your dot files  if  DOTDIR  is
               not defined.

               Default: $LOGDIR

       KILLGLOBAL (~)
               Where  to  find  the  KILL  file to apply to every
               newsgroup.  See the '^K' command at the newsgroup-
               selection level.

               Default: %p/KILL

       KILLLOCAL (~)
               Where  to find the KILL file for the current news-
               group.  See the commands 'K' and '^K' at the arti-
               cle  selection level, and the search modifier 'K'.

               Default: %p/%c/KILL

       LOGDIR  Your home directory if HOME is undefined.  Affects
               ~  interpretation,  and  the  location of your dot
               files if DOTDIR is not defined.

               Default: none.

               Explanation:  you  must  have  either   $HOME   or
               $LOGDIR.

       LOGNAME Your  login  name,  if  USER is undefined.  May be
               interpolated using "%L".

               Default: value of getlogin().

       LOCALTIMEFMT
               The format used by strftime() to print  the  local
               time.   The  Date  line is only displayed in local
               time if the group is threaded (see the  -H  option



                              LOCAL                            40





TRN(1)                                                     TRN(1)


               for more information on Date).

               Default: %a %b %e %X %Z %Y

               which is the same format as the _d_a_t_e(1) command.

       MAILCALL (~)
               What to say when there is new mail.

               Default: (Mail)

       MAILFILE (~)
               Where to check for mail.

               Default: /usr/spool/mail/%L

       MAILHEADER (%)
               The  format  of  the header file for replies.  See
               also MAILPOSTER.

               Default:

               To: %t
               Subject: %(%i=^$?:Re: %S
               %(%{REPLYTO}=^$?:Reply-To: %{REPLYTO}
               )Newsgroups: %n
               In-Reply-To: %i)
               %(%[references]=^$?:References: %[references]
               )Organization: %o
               Cc:
               Bcc: \n\n

       MAILPOSTER (~)
               The shell command to be used by the reply commands
               (r  and  R)  in  order  to  allow you to enter and
               deliver the response.  _t_r_n will  not  itself  call
               upon  an  editor for replies -- this is a function
               of the program referenced by MAILPOSTER.  See also
               MAILHEADER.

               Default: QUOTECHARS=%I Rnmail -h %h

       MBOXSAVER (~)
               The  shell  command  to save an article in mailbox
               format.

               Default: %X/mbox.saver %A %P %c %a %B %C "%b" \
               "From %t %`date`"

               Explanation: the first  seven  arguments  are  the
               same as for NORMSAVER.  The eighth argument to the
               shell script is the new From line for the article,
               including   the   posting   date,  derived  either
               directly from the Posted: line, or not-so-directly



                              LOCAL                            41





TRN(1)                                                     TRN(1)


               from  the  Date:  line.   Header  munging  at  its
               finest.

       MODSTRING
               The string to insert in the  group  summary  line,
               which  heads  each article, for a moderated group.
               See also NOPOSTRING.

               Default: " (moderated)"

       NAME    Your full name.  May be interpolated using "%N".

               Default: name from /etc/passwd, or ~/.fullname.

       NEWSHEADER (%)
               The format of the header file for follow-ups.  See
               also NEWSPOSTER.

               Default:

               %(%[followup-to]=^$?:%(%[followup-to]=^%n$?:X-
               ORIGINAL-NEWSGROUPS: %n
               ))Newsgroups: %(%F=^$?%C:%F)
               Subject: %(%S=^$?%"\n\nSubject: ":Re: %S)
               Summary:
               Expires:
               %(%R=^$?:References: %R
               )Sender:
               Followup-To:
               %(%{REPLYTO}=^$?:Reply-To: %{REPLYTO}
               )Distribution: %(%i=^$?%"Distribution: ":%D)
               Organization: %o
               Keywords: %[keywords]
               Cc: \n\n

       NEWSORG Either the name of your organization, or the  name
               of  a  file  containing the name of your organiza-
               tion.  (For use at sites  where  the  ORGANIZATION
               environmental variable is already in use.  NEWSORG
               will override ORGANIZATION if both  are  present.)
               May be interpolated using "%o".

               Default: whatever your news administrator compiled
               in.

       NEWSPOSTER (~)
               The shell command to be used by the follow-up com-
               mands (f and F) in order to allow you to enter and
               post a  follow-up  news  article.   _t_r_n  will  not
               itself  call upon an editor for follow-ups -- this
               is a function of the program called by  _t_r_n.   See
               also NEWSHEADER.

               Default: QUOTECHARS=%I Pnews -h %h



                              LOCAL                            42





TRN(1)                                                     TRN(1)


       NNTPSERVER
               The  hostname  of your NNTPSERVER.  [This does not
               apply unless you are running the NNTP  version  of
               trn.]

               Default:  the  hostname listed in the server file,
               usually /usr/local/lib/rn/server.

       NOPOSTRING
               The string to insert in the  group  summary  line,
               which  heads  each  article,  for a group to which
               local posting is not allowed.  See also MODSTRING.

               Default: " (no posting)"

       NORMSAVER (~)
               The shell command to save an article in the normal
               (non-mailbox) format.

               Default: %X/norm.saver %A %P %c %a %B %C "%b"

       ORGANIZATION
               Either the name of your organization, or the  name
               of  a  file  containing the name of your organiza-
               tion.  (If NEWSORG is set, it will override  ORGA-
               NIZATION.)  May be interpolated using "%o".

               Default: whatever your news administrator compiled
               in.

       PAGESTOP
               If defined, contains a  regular  expression  which
               matches article lines to be treated as form-feeds.
               There are at least two things you might want to do
               with  this.  To cause page breaks between articles
               in a digest, you might define it  as  "^--------".
               To  force  a  page  break  before a signature, you
               could define it as "^-- $".  (Then, when  you  see
               "--"  at  the bottom of the page, you can skip the
               signature if you so desire by typing  'n'  instead
               of  space.)   To do both, you could use "^--".  If
               you want to break on more than  one  pattern,  you
               can use "|" to separate the alternatives.

               There  is  some overhead involved in matching each
               line of the article against a regular  expression.
               You  might  wish  to  use  a baud-rate modifier to
               enable this feature only at low baud rates.

               Default: undefined

       PIPESAVER (%)
               The shell command to execute in  order  to  accom-
               plish   a   save   to  a  pipe  ("s | command"  or



                              LOCAL                            43





TRN(1)                                                     TRN(1)


               "w | command").  The command typed by the user  is
               substituted in as %b.

               Default: %(%B=^0$?<%A:tail +%Bc %A |) %b

               Explanation:  if %B is 0, the command is "<%A %b",
               otherwise the command is "tail +%Bc %A | %b".

       REPLYTO The value of the "Reply-To:" header, if needed.


       RNINIT  This variable is used when initializing trn in rn-
               compatibility mode (see the -x switch) or when the
               TRNINIT variable isn't defined.  See  the  TRNINIT
               variable for a description.

       RNMACRO (~)
               The  name  of  the  file containing macros and key
               mappings when running trn as  rn.   See  also  the
               TRNMACRO variable and the CUSTOM MACROS section.

               Default: %./.rnmac

       SAVEDIR (~)
               The  name of the directory to save to, if the save
               command does not specify a directory name.

               Default:
                  If --// is set: %p/%c
                  If ++// is set: %p

       SAVENAME (%)
               The name of the file to save to, if the save  com-
               mand contains only a directory name.

               Default:
                  If --// is set: %a
                  If ++// is set: %^C

       SELECTCHARS
               The  characters  used  by  the  thread selector to
               select the associated thread of  discussion.   You
               can specify up to 64 visible characters, including
               upper- and lower-case letters, numbers,  and  many
               punctuation   characters.    Selection  characters
               override command characters in the  selector,  but
               are not excluded from macro expansion, so be care-
               ful.
               Default: abdefgijlorstuvwxyz1234567890BCFGHIKMVW
               (You'll notice various characters are  omitted  to
               allow  them  to be typed as commands in the selec-
               tor.)





                              LOCAL                            44





TRN(1)                                                     TRN(1)


       SHELL   The name of your preferred shell.  It will be used
               by the '!', 'S' and 'W' commands.

               Default: whatever your news administrator compiled
               in.

       SUBJLINE (%)
               Controls the format of the lines displayed by  the
               '=' command at the article selection level.

               Default: %s

       SUPERSEDEHEADER (%)
               The  format  of  the  header  file for a supersede
               article.

               Default:

               From: %L@%H (%N)
               Newsgroups: %n
               Subject: %S
               Distribution: %D
               Organization: %o
               Supersedes: %i

       TERM    Determines which  termcap  entry  to  use,  unless
               TERMCAP contains the entry.

       TERMCAP Holds  either  the name of your termcap file, or a
               termcap entry.

               Default: /etc/termcap, normally.

       TRNINIT Default values for switches may be passed  to  _t_r_n
               by placing them in the TRNINIT variable (or RNINIT
               if you're starting trn in rn-compatibility  mode).
               Any  switch  that  is set in this way may be over-
               ruled on the command line, or via the '&'  command
               from  within _t_r_n.  Binary-valued switches that are
               set with "-switch" may be unset using "+switch".

               If TRNINIT begins with a '/' it is assumed  to  be
               the  name  of a file containing switches.  You can
               put comments in this file by preceding them with a
               '#'  as  long  as this is the first character on a
               line or it follows some white-space (which  delim-
               its the switches in the file).  If you want to set
               many environment variables but don't want to  keep
               them all in your environment, or if the use of any
               of these variables conflicts with other  programs,
               you  can use this feature along with the --EE switch
               to set the environment variables upon startup.

               Default: " ".



                              LOCAL                            45





TRN(1)                                                     TRN(1)


       TRNMACRO (~)
               The name of the file  containing  macros  and  key
               mappings.   If  the file is not found, the RNMACRO
               variable is used to look for your rn macros.   For
               information on what to put into this file, see the
               CUSTOM MACROS section.

               Default: %./.trnmac

       UNSHAR (~)
               The shell command to execute in  order  to  accom-
               plish the unshar'ing of a shell archive.

               Default: /bin/sh

       USER    Your  login name.  May be interpolated using "%L".

               Default: $LOGNAME

       VISUAL (~)
               The name of your editor.

               Default: $EDITOR

       XTERMMOUSE
               If you set this variable to 'y'  (yes),  trn  will
               enable  the use of the xterm mouse in the selector
               if you are using an xterm.  If you set it  to  'a'
               (always), trn will assume you have an xterm.  Once
               enabled left-clicking on an item selects it  while
               middle-clicking  an  item  will move to that item.
               If you click the top (header) line of the selector
               it  moves  up  a  page.   If  you click the bottom
               (footer) line of  the  selector  it  executes  the
               default  command for the page (left click) or goes
               down a page (middle click).  You can also use  the
               right  mouse  button  to move up or down a page by
               clicking in the upper-half or  lower-half  of  the
               screen, respectively.

       YOUSAID (%)
               Gives  the format of the attribution line in front
               of the quoted article included by an R command.

               Default: In article %i you write:

AAUUTTOOMMAATTIICC MMAACCRROOSS
       On startup _t_r_n attempts to build a set of macros that  map
       your keypad arrow keys to useful functions.  These default
       actions are mentioned in the  prior  description  of  each
       level's  commands.  If you don't like this (or trn gets it
       wrong), you can disable the automatic macros by using  the
       --AA option.




                              LOCAL                            46





TRN(1)                                                     TRN(1)


CCUUSSTTOOMM MMAACCRROOSS
       When  _t_r_n  starts  up it looks for a file containing macro
       definitions  (see  environment  variables   TRNMACRO   and
       RNMACRO).   Any  sequence  of commands may be bound to any
       sequence of keys, so you could re-map your entire keyboard
       if  you  desire.  Blank lines or lines beginning with # in
       the macro file  are  considered  comments;  otherwise  _t_r_n
       looks  for two fields separated by white space.  The first
       field gives the sequence of keystrokes  that  trigger  the
       macro, and the second field gives the sequence of commands
       to execute.  Both fields are subject to  %  interpolation,
       which  will  also translate backslash and caret sequences.
       (The keystroke field is interpreted at startup  time,  but
       the  command  field is interpreted at macro execution time
       so that you may refer to % values in a macro.)  For  exam-
       ple,  if  you want to reverse the roles of carriage return
       and space in _t_r_n

       ^J   \040
       ^M   \040
       \040 ^J

       will do just that.  By default, all characters in the com-
       mand  field  are  interpreted as the canonical _t_r_n charac-
       ters, i.e. no macro  expansion  is  done.   Otherwise  the
       above  pair  of  macros  would cause an infinite loop.  To
       force macro expansion in the command  field,  enclose  the
       macro call with ^( ... ^) thusly:

       @s   |mysavescript
       @w   w^(@s^)

       You  can  use  the  %() conditional construct to construct
       macros  that  work  differently  under  different  circum-
       stances.   In  particular,  the  current  mode (%m) of _t_r_n
       could be used to make a command that only works at a  par-
       ticular  level.  This is particularly vital for the selec-
       tor which uses most of the lower-case  letters  to  select
       the associated item in its display.  For example,

       a    %(%m=t?a:s art.hold\n)

       will  return  the original letter (a) in the selector, and
       the command "s art.hold\n" everywhere else.

       %(%{TERM}=vt100?^[[O)    /^J

       will do the binding only if the terminal  type  is  vt100,
       though  if  you  have  many of these it would be better to
       have separate files for each terminal.

       If you want to bind a macro to a function key that puts  a
       common  garbage  character after the sequence (such as the
       carriage return on  the  end  of  Televideo  920  function



                              LOCAL                            47





TRN(1)                                                     TRN(1)


       sequences),  DO  NOT  put the carriage return into all the
       sequences or you  will  waste  a  CONSIDERABLE  amount  of
       internal  storage.  Instead of "^AF^M", put "^AF+1", which
       indicates to _t_r_n that it should gobble  up  one  character
       after the F.

WWHHAATT''SS NNEEWW
       Here's  a  quick  run-down  of _t_r_n's features and commands
       aimed at the knowledgeable _r_n or _t_r_n user.

       The addition of true reference-line threading  is  one  of
       the  biggest  improvements over rn.  This threading allows
       you to read a discussion in reply order with an  article's
       replies  being attached to the article that inspired them.
       Threads will encompass multiple subjects whenever a  reply
       to  an article in the thread arrives with a different sub-
       ject.  This is usually done to better indicate  the  topic
       in the reply when it diverges from the original subject.

       Another big improvement is the selector, which is bound to
       the '+' key.  The selector displays  a  list  of  threads,
       subjects,  or  individual  articles to allow you to select
       the topics that interest you by  typing  their  associated
       letter.  The difference between the thread and the subject
       selector is that the subject selector  displays  all  sub-
       jects  with  a  separate selection letter, even those tied
       together via their references.  This can be  quite  useful
       if  you  select  some  threads and desire to weed out some
       extraneous discussions: you could switch the selector into
       exclusive  mode ('E' shows only selected threads) and then
       into subject mode ('Ss')  to  separate  the  threads  into
       their component subjects and deselect or kill the subjects
       you don't care about.  You don't have to go  to  all  this
       trouble  using  the selector if you prefer to just hit the
       'k' key when you start reading a subject you're not inter-
       ested  in.   The  selector can also switch between showing
       unread articles and articles that have already been  read,
       allowing  you  to selectively re-read discussions (this is
       the 'U' command in the selector).

       Another threaded addition is the article-tree  display  in
       the upper-right corner of the header.  Looking at the tree
       gives you a feel for how  the  articles  you  are  reading
       relate to each other, allowing you to see at a glance when
       there are lots of replies and decide if you want  to  junk
       an uninteresting set of replies or perhaps tough it out.

       The  header  display  has also been modified to hide a few
       more lines by default (e.g. References), but,  as  always,
       you  can  override these with -h.  There is also some more
       "magic" in the header: the From header can be  trimmed  to
       be  just  the comment portion (if available), and the Date
       header is displayed in local time (by  default).   Use  -H
       and +H to turn header magic on and off.



                              LOCAL                            48





TRN(1)                                                     TRN(1)


       Once  you begin reading articles, use the regular movement
       commands (n, N, p, P, etc.) as you normally would.  You'll
       find  that  these  commands track the reply order shown in
       the tree display.  Then try using ^N and ^P, which  follow
       a subject in the order the articles were posted.  Finally,
       check out the [, ], (, ), {, and } commands to move around
       in  the  article tree a bit more directly.  The first four
       commands should also be bound to your keypad's arrow keys,
       making  them  easier  to  type.   For  example, typing '['
       (left) takes you to your parent article, even  if  it  was
       already  read,  which is very useful for tracking down the
       cited portion of the article in its original context.

       There are additional kill commands for the  entire  thread
       (J) and the current article and all its replies (,).

       The  KILL files have been extended and the commands inside
       them are now referred to memorized  commands,  since  they
       are  often used for selection rather than killing of arti-
       cles.  There are new, easier ways to  add  memorized  com-
       mands using the 'A'dd and 'T'hread commands.  The 'A' com-
       mand is subject-oriented, while the 'T' command  is  arti-
       cle-oriented  (meaning they affect a specific set of arti-
       cles rather than any article that happens to have a match-
       ing  subject).  They both prompt you for what kind of com-
       mand you want to add, making both auto-killing  and  auto-
       selecting just as easy.

       There is also an easy way to skip around among the various
       threads with the < and > commands.  Use them if  you  want
       to  skip  a  set of article and read them later instead of
       junking them.

       Note: your news administrator has the  option  of  turning
       thread  processing  off for individual groups, and thus it
       is possible for some groups to not have any  pre-processed
       thread information available for use.  When _t_r_n encounters
       such a group, it generates the thread information  on  the
       fly while entering the group.  For really large groups (or
       really slow systems), this can take an appreciable  amount
       of  time.   If you can't talk your news administrator into
       pre-threading the group, you can turn off the threading on
       a  group-by-group basis using the 't' command at the news-
       group-selection level.  Groups turned off in this way  are
       read in the _r_n style -- articles arranged in arrival order
       unless you specify the -S option, which reads the articles
       in date order by subject.

       Take note of the "e dir" command, which is used to extract
       a shell archive  or  uuencoded  file  into  the  specified
       directory.  It is even possible to extract other data for-
       mats if you specify the appropriate filter  command  (e.g.
       "e dir|cmd".




                              LOCAL                            49





TRN(1)                                                     TRN(1)


       Also,  if you plan to use macro definitions, it is good to
       keep in mind that the selector uses most of the lower-case
       letters  for  selection,  and  thus  it  is a good idea to
       explicitly set the mode(s) in which a macro applies.   For
       example,  if  you  want  to  press  'f'  from  the article
       pager/selector to forward the current article to the  user
       "smith", you could define:

            f    %(%m=[pa]?|mail smith\n:f)

       This  checks the current mode (%m) and if it is 'p' or 'a'
       it expands it to the string "|mail smith\n", otherwise  it
       returns  the  letter  'f'.   In some cases, you may simply
       wish to exclude the selector from a macro with the  condi-
       tional "%m!=t".

       Finally,  you'll  probably want to use the new options, --xx
       and --XX to ensure that all the newest features  are  avail-
       able  for  use.   These  options  might  be on by default,
       depending on how your  administrator  decided  to  install
       _t_r_n.

AAUUTTHHOORRSS
       Rn    was    created    by    Larry    Wall    <lwall@jpl-
       devvax.jpl.nasa.gov>
       and  is  now  under   the   direction   of   Stan   Barber
       <sob@bcm.tmc.edu>.
       Threaded version by Wayne Davison <davison@borland.com>
       (Mail all bug reports for trn to Wayne.)
       Regular  expression  routines  are borrowed from emacs, by
       James Gosling.
       Hashing routines are modified versions from Geoffrey  Col-
       lyer.

FFIILLEESS
        %./.newsrc  status of your news reading

        %./.oldnewsrc
                    backup  copy  of  your  _._n_e_w_s_r_c from start of
                    session

        %./.rnlock  lock file so you don't screw up your _._n_e_w_s_r_c

        %./.rnlast  info from last run of trn

        %./.rnsoft  soft pointers  into  /usr/lib/news/active  to
                    speed startup, synchronous with _._n_e_w_s_r_c

        %./.rnhead  temporary  header file to pass to a mailer or
                    news poster

        %./.[t]rnmac
                    macro and keymap definitions




                              LOCAL                            50





TRN(1)                                                     TRN(1)


        %p          your news save directory, usually ~/News

        %x/active   the  list  of  active   newsgroups,   usually
                    /usr/lib/news/active  on  systems  that don't
                    use NNTP

        %P          the  public  news  spool  directory,  usually
                    /usr/spool/news  on  systems  that  don't use
                    NNTP

        %X/INIT     system-wide default switches

SSEEEE AALLSSOO
       newsrc(5), more(1), readnews(1), Pnews(1), Rnmail(1)

DDIIAAGGNNOOSSTTIICCSS
       Generally self-documenting, as they say.

BBUUGGSS
       The --hh switch can only hide header lines  that  _t_r_n  knows
       about.

       The  '-'  command  doesn't cross newsgroup boundaries, and
       only undoes the last article selection.

       If you edit your _._n_e_w_s_r_c while _t_r_n is  running,  _t_r_n  will
       happily wipe out your changes when it decides to write out
       the _._n_e_w_s_r_c file.

       Marking of duplicate articles as read in  cross-referenced
       newsgroups   will  not  work  unless  the  Xref  patch  is
       installed in inews.

       If you get carried away with %  or  escape  substitutions,
       you can overflow buffers.






















                              LOCAL                            51


