/* splot.h */

#ifndef SPLOT_H
#define SPLOT_H

/* general defines */
#define OFF 0
#define ON 1
#define PI 3.141592654

/* define line styles */
#define SOLID 0
#define DASHED 1.0,0.5
#define DOTTED 0.2,0.2
#define DOTDASH 1.0,0.5,0.2,0.5

/* page size in cm */
#define XLENGTH 20.00
#define YLENGTH 26.00

/* define colours */
#define INVIS -1
#define BLACK 0 
#define BLUE 1
#define GREEN 2
#define CYAN 3
#define RED 4
#define MAGENTA 5
#define BROWN 6
#define WHITE 7

/* define the axes lables */
#define LOWER 0
#define BOTTOM 0
#define UPPER 2
#define TOP 2
#define LEFT 1
#define RIGHT 3
#define XAXES 4
#define YAXES 5
#define XYAXES 6

#define CENTER 4
#define XCENTER 1.7e308
#define YCENTER 1.7e308

/* define axes types */
#define LINEAR 0x11
#define LOGX 0x12
#define LOGY 0x21
#define LOGLOG 0x22
#define INVX 0x14
#define INVY 0x41
#define INVINV 0x44
#define INVXLOGY 0x24
#define LOGXINVY 0x42

/* define line cap styles */
#define BUTTCAP 0
#define ROUNDCAP 1
#define PROJCAP 2

/* define line join styles */
#define MITERJOIN 3
#define MITREJOIN 3
#define ROUNDJOIN 4
#define BEVELJOIN 5

/* define fill rules */
#define NONZWIND 0
#define EVENODD 1

/* define which vals for errorbars */
#define XVALS 0
#define YVALS 1

/* define ALL_Y for use with plodata */
#define ALL_Y -1

/* define default font info */
#define CELL_WIDTH        0.7       /* default font width */
#define CELL_ASPECT       2.0       /* default font height/width ratio */
#define CELL_SPACING      2.0

#define NFONTS        7             /* number of available fonts */
#define NORMALTEXT    0             /* for use with array of font pointers */
#define ROMAN_S       1
#define ROMAN_C       2
#define GREEK_S       3
#define GREEK_C       4
#define ITALIC_C      5
#define SYMBOL_S      6
#define SIMPLEX       0
#define COMPLEX       1

/* define symbol names */
#define OCIRCLE 0
#define OSQUARE 1
#define OTRIANGLE 2
#define ODIAMOND 3
#define OSTAR 4
#define OARROW 5
#define PLUS 6
#define CROSS 7
#define MULT 8
#define CIRCLE 9
#define SQUARE 10
#define TRIANGLE 11
#define DIAMOND 12
#define STAR 13
#define ARROW 14

/* define plot types */
#define LINES 0
#define SYMBOLS 1
#define SYM_LINES 2

/* define set options */
#define AXESCLIP        0 
#define AXESTYPE        1 
#define CURSYMBOL       2 
#define FILLRULE        3 
#define FLATNESS        4 
#define FONT            5 
#define FONTASPECT      6 
#define FONTDIR         7 
#define FONTMULT        8 
#define FONTSPACE       9 
#define FONTWIDTH       10
#define LABELMARG       11
#define LINECAP         12
#define LINECOLOUR      13
#define LINEJOIN        14
#define LINESTYLE       15
#define LINEWIDTH       16
#define MITERLIMIT      17
#define PAGEROT         18
#define PATTOFF         19
#define PLOTTYPE        20
#define SCALEALL        21
#define SCRIPTSCALE     22
#define SCRIPTSHIFT     23
#define SYMMULT         24
#define TICKLMARG       25
#define TICKLENGTH      26
#define XMULT           27
#define XRANGE          28
#define XSHIFT          29
#define YMULT           30
#define YRANGE          31
#define YSHIFT          32


#define LINECOLOR       13
#define MITRELIMIT      17
#define PAGE_ROT        18
#endif

/* splot.h */

