/*
 * GetImg.CMD
 *
 * Grabs *.JPG and *.AVI files from (removable) drive
 */

parse arg drive target;

if drive='' then drive = 'f';
if target='' then target = '.';

if SUBSTR(target,LENGTH(target),1)\='\' then
  target = target'\';
target = target''DATE('S');
"@MD "target;
target = target'\';

call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs';
call SysLoadFuncs;

tmpf = SysTempFileName('TMP?????.GET');

CALL getFiles 'JPG';
CALL getFiles 'AVI';
CALL getFiles 'THM';

"@DEL "tmpf;

exit;

GetFiles:
  parse arg suffix;

  pattern = drive':*.'suffix;
  rc = SysFileTree(pattern,'files','SF');
  if rc\=0 then
    say 'SysFileTree error:' rc;

  do i = 1 to files.0;
    parse var files.i . . . . filename;
    "@EXIFREAD "filename" | RXQUEUE";
    datetime = '';
    do while(QUEUED()>0);
      parse pull "Original Datetime:" dt;
      if dt\='' then datetime=STRIP(dt);
    end;
    if datetime\='' then do;
      parse var datetime yyyy":"mo":"dd hh":"mm":"ss;
      thistarget=yyyy''mo''dd;
      "@MD "thistarget" >"tmpf;
      thistarget=thistarget'\'
      fname = FILESPEC("name",filename);
      parse var fname .'.'suffix
      fname=yyyy''mo''dd'_'hh''mm''ss'.'suffix;
    end;
    else do;
      thistarget=target;
      fname = FILESPEC("name",filename);
    end;
    "COPY "filename" "thistarget""fname" >"tmpf;
  end;
  Say files.0 suffix 'files copied';
return;


