/* 
** WORKLab
** config.sys parser for LogoArt
** 1) prepends LIBPATH with logoart and kvec dirs
** 2) prepends PATH with logoart and kvec dirs
** 3) sets the LOGOART_HOME var
*/

call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

   parse arg target_path
   if target_path="" then call fatal "target path missing"

   /* query boot drive and open config.sys */
   BtDrv=filespec('drive',value('COMSPEC',,'OS2ENVIRONMENT'))

   config_sys = BtDrv||"\config.sys";
   res = stream(config_sys, C, 'QUERY EXISTS');
   if res = "" then call fatal "error opening "||config_sys;

   /* backup copy */
   parse var config_sys backup '.'
   backup = backup||".L$$"
   parse var config_sys backup_2 '.'
   backup_2= backup_2||".SAV"
   "@echo off"
   if stream(backup, C, 'QUERY EXISTS') \= "" then "del" backup
   "copy" config_sys backup_2 "> nul"

   /* process config.sys */
   do while lines(config_sys)

      line=linein(config_sys)
      /* LIBPATH?  */
      if(pos("LIBPATH", line) \= 0) then do
         /* libpath for logoart and kvec */
         line = substr(line, pos("=",line)+1)
         line = "LIBPATH="||target_path||";"||target_path||"\kvec;"||line
      end
      /* PATH ? */
      else if(pos(" PATH", line) \= 0) then do
         /* libpath for logoart and kvec */
         line = substr(line, pos("=",line)+1)
         line = "SET PATH="||target_path||";"||target_path||"\kvec;"||line
      end
      /* skip this one if there */
      else if(pos("LOGOART_HOME", line) \= 0) then iterate

      call lineout backup, line
   end

   /* and write home directory */
   call lineout backup, "SET LOGOART_HOME="||target_path

   /* OK, safe to replace config.sys now*/
   call lineout config_sys;
   call lineout backup;
   "copy" backup config_sys "> nul"
   "del" backup

exit

fatal:
   parse arg msg
   say "ERROR------"
   say msg
exit
