;Boot loader and serial loader
;Originally Written By Dwight K Elvey 1999
;Modified to boot on Z80 emulator and to allow JMP 0x0005 for BDOSE

Base	equ	0x0000

CCP	equ	Base+0x2900

BDOS	equ	CCP+0x900

STACK 	equ	0x0100


BDOSE	equ	BDOS+6

	jmp	start
	db	0	;iobyte
	db	0	;current drive
	jmp	BDOSE	;entry to bdos
COLD	mvi	a,3	;Force FDC to BOOT
	out	0x7c
start
	lxi	h,COLD		;patch jmp at 0 to point to COLD
	shld	1		; fall through to start
	LXI 	SP,STACK
	LXI 	H,CCP  		;CCP is target
	LXI 	D,0002h  	;Start at track 0 sector 2
				;d=track e=sector
BEGIN_READ_CPM
	CALL 	Read_Sec

	MVI 	A,80h		;increment DMA target
	ADD 	L
	MOV 	L,A
	MVI 	A,0h
	ADC 	H
	MOV 	H,A

	INR 	E		;increment sector
	MOV 	A,E
	CPI 	1Bh		;Last sector was read
	JNZ 	BEGIN_READ_CPM

	MVI 	A,04h		;FB for newer FDC
	OUT 	7Fh
	MVI 	A,06h		;F9 for newer FDC
	OUT 	7Fh
	MVI 	A,04h		;FB for newer FDC
	OUT 	7Fh

Wait_step			;wait for step to complete
	IN 	7Fh
	ANI 	02h
	JZ 	Wait_step

	MVI 	E,01h		;reset sector to 1
	INR 	D		;inc track
	MOV 	A,D
	CPI 	02h
	JNZ 	BEGIN_READ_CPM

	JMP 	CCP

Read_Sec
	DCX 	H		;save 3 bytes before DAM buffer
	MOV 	C,M
	DCX 	H
	MOV 	B,M
	PUSH 	B
	DCX 	H
	MOV 	C,M
	PUSH 	H

	MOV 	A,H  		;DMA hi
	NOP   			;needs CMA for newer FDC
	OUT 	7Eh		;Hi DMA
	MOV 	A,L		;DMA lo
	NOP   			;needs CMA for newer FDC
	OUT 	7Dh		;Low DMA

	MOV 	M,D	;Track
	INX 	H
	MOV 	M,E	;Sector
	INX 	H
	MVI 	A,0FBh
	MOV 	M,A
	MVI 	A,40h	;Read Command BF on newer FDC
	OUT 	7Fh
Wait_Sec3
	IN 	7Fh
	ANI 	08h
	JZ 	Wait_Sec3

	POP 	H	;restore 3 bytes before DMA
	MOV 	M,C
	INX 	H
	POP 	B
	MOV 	M,B
	INX 	H
	MOV 	M,C
	INX 	H
	RET

