;  RUNTIME LIBRARY FOR MI - C  V1.26
; PUBLIC CCOR,CCXOR,CCAND
; PUBLIC CCEQ,CCNE,CCGT,CCLE,CCGE,CCLT,CUGE,CULT,CUGT,CCLNOT
; PUBLIC CULE,CCASR,CUASR,CCASL,CCSUB,CCNEG,CCCOM,CCMULT,CCDIV
; PUBLIC CUDIV,CCSCOM,CCSNEG,CCSLNOT
; PUBLIC CUSDIV,CCSDIV,CCSASR,CUSASR,CCSASL,CCSSUB
; PUBLIC CC0DIV
;
;
; CC0DIV WIRD AUFGERUFEN, WENN EINE DIVISION DURCH 0 
; AUFTRITT. EINE ANDERE REAKTION KANN VOM BENUTZER 
; EINGEFUEGT WERDEN. 
;
CC0DIV:	
	PUSH	AF
	PUSH	BC
	PUSH	DE
	PUSH	HL
;
	LD	DE,CC0TEXT
	LD	C,9
	CALL	5	     ; BDOS AUFRUF TEXTAUSGABE KONSOLE
;
	POP	HL
	POP	DE
	POP	BC
	POP	AF
	JP	0
;
; ALTERNATIVES ENDE STATT JMP 0
;
;	RET
;
CC0TEXT:
	DEFB	0DH,0AH,'0 - DIVISION',0DH,0AH,'$'
;
;
CCOR:	LD	A,L
	OR	E
	LD	L,A
	LD	A,H
	OR	D
	LD	H,A
	OR	L
	RET	
;
CCXOR:	LD	A,L
	XOR	E
	LD	L,A
	LD	A,H
	XOR	D
	LD	H,A
	OR	L
	RET	
;
CCAND:	LD	A,L
	AND	E
	LD	L,A
	LD	A,H
	AND	D
	LD	H,A
	OR	L
	RET	
;
CCEQ:	
	AND	A
	SBC	HL,DE
	JP	NZ,CCEQ1
	INC	L
	RET	
CCEQ1:	
	XOR	A
	LD	H,A
	LD	L,A
	RET	
;
CCNE:	
	AND	A
	SBC	HL,DE
	RET	Z
	LD	HL,1
	RET	
;
CCLT:	
	EX	DE,HL
;
CCGT:	
	LD	A,D
	XOR	H
	JP	M,CCGT1
	SBC	HL,DE
	LD	HL,1
	RET	C
	DEC	L
	RET	
CCGT1:	
	AND	H
	LD	HL,1
	RET	M
	DEC	L
	RET	
;
CCGE:	
	LD	A,D
	XOR	H
	JP	M,CCGE1
	SBC	HL,DE
	LD	HL,1
	RET	C
	JR	Z,CCGE2
	DEC	L
	RET	
CCGE2:
	OR	L
	RET
CCGE1:	
	AND	H
	LD	HL,1
	RET	M
	DEC	L
	RET	

;
CCLE:	
	LD	A,D
	XOR	H
	JP	M,CCLE1
	SBC	HL,DE
	LD	HL,0
	INC	L
	RET	NC
	DEC	L
	RET	
CCLE1:	
	LD	HL,1
	AND	D
	RET	M
	DEC	L
	RET	
;
CULT:	
	EX	DE,HL
;
CUGT:	
	LD	A,L
	SUB	E
	LD	A,H
	SBC	A,D
	LD	HL,1
	RET	C
	DEC	L
	RET	
;
CUGE:	
	EX	DE,HL
;
CULE:	
	LD	A,L
	SUB	E
	LD	A,H
	SBC	A,D
	LD	HL,0
	INC	L
	RET	NC
	DEC	L
	RET	
;
CCASR:	
	EX	DE,HL
CCSASR:	
	LD	A,E
	AND	A
	RET	Z
	SRA	H
	RR	L
	DEC	E
	JP	NZ,CCASR+4
	RET	
;
CUASR:	
	EX	DE,HL
CUSASR:	
	LD	A,E
	AND	A
	RET	Z
	SRL	H
	RR	L
	DEC	E
	JP	NZ,CUASR+4
	RET	
;
CCASL:	
	EX	DE,HL
CCSASL:	
	LD	A,E
	AND	A
	RET	Z
	ADD	HL,HL
	DEC	E
	JP	NZ,CCASL+4
	RET	
;
CCSUB:
	EX	DE,HL
CCSSUB:
	AND	A
	SBC	HL,DE
	RET
;
CCNEG:	
	LD	A,H
	CPL	
	LD	H,A
	LD	A,L
	CPL	
	LD	L,A
	INC	HL
	RET	
;
CCSNEG:	
	LD	A,D
	CPL	
	LD	D,A
	LD	A,E
	CPL	
	LD	E,A
	INC	DE
	RET	
;
CCCOM:	
	LD	A,H
	CPL	
	LD	H,A
	LD	A,L
	CPL	
	LD	L,A
	RET	
;
CCSCOM:	LD	A,D
	CPL	
	LD	D,A
	LD	A,E
	CPL	
	LD	E,A
	RET	
;
CCLNOT:	LD	A,H
	OR	L
	LD	HL,1
	JP	Z,CCLN1
	DEC	L
	RET	
CCLN1:	
	OR	L
	RET	
;
CCSLNOT:
	LD	A,D
	OR	E
	LD	DE,1
	JP	Z,CCSL1
	DEC	E
	RET	
CCSL1:	
	OR	E
	RET	
;
CCMULT:	LD	B,H
	LD	C,L
	LD	HL,0
CCMUL1:	LD	A,C
	RRCA	
	JP	NC,CCMUL2
	ADD	HL,DE
CCMUL2:
	SRL	B
	RR	C
	LD	A,C
	OR	B
	RET	Z
	SLA	E
	RL	D
	LD	A,D
	OR	E
	RET	Z
	JP	CCMUL1
;
CUDIV:	
	EX	DE,HL
CUSDIV:	
	XOR	A
	PUSH	AF
	JP	CCDIV4
;
CCDIV:	
	EX	DE,HL
CCSDIV:	
	LD	A,D
	XOR	H
	PUSH	AF
	LD	A,D
	OR	A
	CALL	M,CCSNEG
	LD	A,H
	OR	A
	CALL	M,CCNEG
CCDIV4:	
	LD	B,D
	LD	C,E
	LD	A,B
	OR	C
	CALL	Z,CC0DIV
	LD	A,16
	PUSH	AF
	LD	DE,0
CCDIV1:	
	ADD	HL,HL
;
	RL	E
	RL	D
	LD	A,D
	OR	E
;
	JP	Z,CCDIV2
;
	LD	A,E
	SUB	C
	LD	A,D
	SBC	A,B
;
	JP	M,CCDIV2
	SET	0,L
;
	LD	A,E
	SUB	C
	LD	E,A
	LD	A,D
	SBC	A,B
	LD	D,A
CCDIV2:	
	POP	AF
	DEC	A
	JP	Z,CCDIV3
	PUSH	AF
	JP	CCDIV1
CCDIV3:	
	POP	AF
	RET	P
	CALL	CCSNEG
	JP	CCNEG
; 
