// drawwnd.cpp : implementation file
//

#include "stdafx.h"
#include "Saver.h"
#include "drawwnd.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

LPCTSTR CDrawWnd::m_lpszClassName = NULL;

/////////////////////////////////////////////////////////////////////////////
// CDrawWnd

CDrawWnd::CDrawWnd(BOOL bAutoDelete)
{
	int i, j;
	
	m_bAutoDelete = bAutoDelete;
	for (i = 0; i < 32; i++)
    	for (j = 0; j < 32; j++)
        	{
    		m_cell[i][j] = 0;
            }
}

CDrawWnd::~CDrawWnd()
{
}


BEGIN_MESSAGE_MAP(CDrawWnd, CWnd)
	//{{AFX_MSG_MAP(CDrawWnd)
	ON_WM_TIMER()
	ON_WM_PAINT()
	ON_WM_SIZE()
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



void CDrawWnd::Draw(CDC& dc) 
{
	CDC dcBmp;

	dcBmp.CreateCompatibleDC(&dc);
	CObject *pOb = dcBmp.SelectObject(&m_bmpScr);
	dc.StretchBlt(0, 0, m_rectWnd.Width(), m_rectWnd.Height(), &dcBmp, 0, 0, m_rectDesk.Width(), m_rectDesk.Height(), SRCCOPY);
	
	dcBmp.SelectObject(pOb);
}


void CDrawWnd::SetSpeed(int nSpeed)
{
	KillTimer(1);
	VERIFY(SetTimer(1, 50+500-nSpeed*5, NULL) != 0);
}


/////////////////////////////////////////////////////////////////////////////
// CDrawWnd message handlers

#define R1(x) ( x >= 1 && x <= 4)
#define R2(x) ( x >= 5 && x <= 8)

void CDrawWnd::OnTimer(UINT nIDEvent) 
{
	if (nIDEvent == 1)
	{
	int p,q;

	for (int i = 1; i < 31; i++)
    	for (int j = 1; j < 31; j++)
        {
        	// Animate cell
            if (m_cell[i][j] != 0)
            	{
                m_cell[i][j]++;
                if (m_cell[i][j] == 5) m_cell[i][j] = 1;
                if (m_cell[i][j] == 9) m_cell[i][j] = 5;
                }
            if (rand() % 100 < 2 && R1(m_cell[i][j]))
            	{
                m_cell[i][j] += 4;
            	}
            else if (rand() % 100 < 2 && R2(m_cell[i][j]))
            	{
                m_cell[i][j] -= 4;
            	}
        	// Check m_cell's neighbours
        	for (p = i-1; p <= i+1; p++)
            	for (q = j-1; q <= j+1; q++)
                	if ((i != p || j != q) && rand() % 100 < 10)	// Omit the m_cell itself
                        {
            			if ((!m_cell[i][j]) && m_cell[p][q])
                           	{
                            m_cell[i][j] = 1;
                            break;
                            }
            			else if (R1(m_cell[i][j]) && R2(m_cell[p][q]))
                           	{
                            m_cell[i][j] += 4;
                            break;
                            }
            			else if (R2(m_cell[i][j]) && R1(m_cell[p][q]))
                           	{
                            m_cell[i][j] -= 4;
                            break;
                            }

                        }
        }
		UpdateGraphics();
		CClientDC dc(this);
		Draw(dc);

	}
	else	
		CWnd::OnTimer(nIDEvent);
}

void CDrawWnd::OnPaint() 
{
	CPaintDC dc(this); // device context for painting

	Draw(dc);
	// Do not call CWnd::OnPaint() for painting messages
}

void CDrawWnd::OnSize(UINT nType, int cx, int cy) 
{
	CWnd::OnSize(nType, cx, cy);
	
	m_nScale = cx/29;
	m_nHeight = cy;

	GetWindowRect(&m_rectWnd);
}


int CDrawWnd::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	int i,j,w,h;

	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	int nSpeed = AfxGetApp()->GetProfileInt("Config", "Speed", 1);
	if (nSpeed < 0)
		nSpeed = 0;	
	SetSpeed(nSpeed);

// Initialise the "m_cell" array
    srand( (unsigned)time( NULL ) );

	for (i = 0; i < 32; i++)
    	for (j = 0; j < 32; j++)
        	{
    		m_cell[i][j] = 0;
            }

    i = rand() % 30 + 1;
    j = rand() % 30 + 1;

    m_cell[i][j] = 1;

// Initialise the background bitmap	
	
	CWnd *pWnd   = CWnd::GetDesktopWindow();
	CDC *pDC = GetDC();
	CDC *pDeskDC = pWnd->GetDC();
	pWnd->GetWindowRect(&m_rectDesk);

	CBitmap bmpChaos;
	bmpChaos.LoadBitmap(IDB_CHAOS);

	w = m_rectDesk.Width() / 30;
	h = m_rectDesk.Height() / 30;

	for (int n = 0; n < 8; n++)
		{
		CDC dcFrom, dcTo;
		CObject *pObFrom, *pObTo;

		dcFrom.CreateCompatibleDC(pDC);
		dcTo.  CreateCompatibleDC(pDC);
		m_bmpImage[n].CreateCompatibleBitmap(pDC, w, h);
		pObFrom = dcFrom.SelectObject(&bmpChaos);
		pObTo   = dcTo.SelectObject(&m_bmpImage[n]);
		dcTo.StretchBlt(0, 0, w, h, &dcFrom, (n*32), 0, 32, 32, SRCCOPY);

		dcFrom.SelectObject(pObFrom);
		dcTo.  SelectObject(pObTo);
		}
	GetWindowRect(&m_rectWnd);
	m_bmpScr.CreateCompatibleBitmap(pDC, m_rectDesk.Width(), m_rectDesk.Height());

	CDC dcBmp;
	dcBmp.CreateCompatibleDC(NULL);
	CObject *pObject = dcBmp.SelectObject(&m_bmpScr);
	dcBmp.BitBlt(0, 0, m_rectDesk.Width(), m_rectDesk.Height(), pDeskDC, 0, 0, SRCCOPY);
	dcBmp.SelectObject(pObject);

	pWnd->ReleaseDC(pDeskDC);
	ReleaseDC(pDC);
	return 0;
}

BOOL CDrawWnd::Create(DWORD dwExStyle, DWORD dwStyle, const RECT& rect, 
	CWnd* pParentWnd, UINT nID, CCreateContext* pContext) 
{
    // Register a class with no cursor
	if (m_lpszClassName == NULL)
	{
    	m_lpszClassName = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW,
			::LoadCursor(AfxGetResourceHandle(), 
			MAKEINTRESOURCE(IDC_NULLCURSOR)));
	}

	// TODO: Add your specialized code here and/or call the base class
	return CreateEx(dwExStyle, m_lpszClassName, _T(""), dwStyle, 
		rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, 
		pParentWnd->GetSafeHwnd(), NULL, NULL );
}

void CDrawWnd::PostNcDestroy() 
{
	if (m_bAutoDelete)
		delete this;
}


void CDrawWnd::UpdateGraphics()
	{
	int x,y,w,h,n,i,j;

	CObject *pOld[9];
	CDC dcImages[9];
	CDC *pDC = GetDC();
	CBrush brBlack(RGB(0,0,0));
	CBrush *brColour[8];

	for (n = 0; n < 8; n++) 
		{
		dcImages[n].CreateCompatibleDC(pDC);
		pOld[n] = dcImages[n].SelectObject(&m_bmpImage[n]);
		brColour[n] = new CBrush(RGB((n & 1) * 128, (n & 2) * 64, (n & 4) * 32));
		}

	dcImages[8].CreateCompatibleDC(pDC);
	pOld[9] = dcImages[8].SelectObject(&m_bmpScr);

	for (i = 1; i < 31; i++)
    	for (j = 1; j < 31; j++)
        	{
			x = (int)(((long)m_rectDesk.Width()  * ((long)(i - 1))) / 30L);
			y = (int)(((long)m_rectDesk.Height() * ((long)(j - 1)))	/ 30L);
			w = (int)((((long)m_rectDesk.Width()  * ((long)i))     / 30L) - x);
			h = (int)((((long)m_rectDesk.Height() * ((long)j))	 / 30L) - y);

            CRect r(x, y, x+w, y+h);

			if (m_cell[i][j] >= 1 && m_cell[i][j] <= 8)
				{
				dcImages[8].FillRect(&r, &brBlack);
				dcImages[8].BitBlt(x,y,w,h,&dcImages[m_cell[i][j] - 1],0,0,SRCCOPY); 
				}
			else if (m_cell[i][j]) dcImages[8].FillRect(&r, &brBlack);
        	}

	for (n = 0; n < 9; n++) dcImages[n].SelectObject(&pOld[n]);
	for (n = 0; n < 8; n++) delete brColour[n];
	ReleaseDC(pDC);
	}
