/*
 * Decompiled with CFR 0.152.
 */
package info.seasip.romfont;

import info.seasip.romfont.FileFormatException;
import info.seasip.romfont.Psf;

public class Psf2
implements Psf {
    private byte[] font;
    private int[] ucsDir;
    private int[] header = new int[8];

    final int version() {
        return this.header[1];
    }

    final int headerSize() {
        return this.header[2];
    }

    final int flags() {
        return this.header[3];
    }

    final int cellSize() {
        return this.header[5];
    }

    public Psf2(byte[] byArray) throws FileFormatException {
        this.font = byArray;
        int n = 0;
        while (n < 8) {
            this.header[n] = this.font[n * 4] & 0xFF;
            int n2 = n;
            this.header[n2] = this.header[n2] | (this.font[n * 4 + 1] & 0xFF) << 8;
            int n3 = n;
            this.header[n3] = this.header[n3] | (this.font[n * 4 + 2] & 0xFF) << 16;
            int n4 = n;
            this.header[n4] = this.header[n4] | (this.font[n * 4 + 3] & 0xFF) << 24;
            ++n;
        }
        if (this.isUnicode()) {
            int n5 = this.charCount() * this.cellSize() + this.headerSize();
            int n6 = this.decodeDir(null, n5);
            this.ucsDir = new int[n6];
            this.decodeDir(this.ucsDir, n5);
        }
    }

    private int decodeDir(int[] nArray, int n) throws FileFormatException {
        int n2 = n;
        int n3 = 0;
        int n4 = this.charCount();
        while (n4 > 0) {
            int n5;
            int n6;
            if (n2 >= this.font.length) break;
            if ((n6 = this.font[n2++] & 0xFF) == 255) {
                --n4;
                n5 = -1;
            } else if (n6 == 254) {
                n5 = -2;
            } else if (n6 < 128) {
                n5 = n6;
            } else {
                if (n6 < 192) {
                    throw new FileFormatException("Invalid UTF-8 sequence");
                }
                if (n6 < 224) {
                    n5 = (n6 & 0x1F) << 6;
                    if (n2 >= this.font.length) break;
                    if (((n6 = this.font[n2++] & 0xFF) & 0xC0) != 128) {
                        throw new FileFormatException("Invalid UTF-8 sequence");
                    }
                    n5 |= n6 & 0x3F;
                } else if (n6 < 240) {
                    n5 = (n6 & 0xF) << 12;
                    if (n2 >= this.font.length) break;
                    if (((n6 = this.font[n2++] & 0xFF) & 0xC0) != 128) {
                        throw new FileFormatException("Invalid UTF-8 sequence");
                    }
                    n5 |= (n6 & 0x3F) << 6;
                    if (n2 >= this.font.length) break;
                    if (((n6 = this.font[n2++] & 0xFF) & 0xC0) != 128) {
                        throw new FileFormatException("Invalid UTF-8 sequence");
                    }
                    n5 |= n6 & 0x3F;
                } else if (n6 < 245) {
                    n5 = (n6 & 7) << 18;
                    if (n2 >= this.font.length) break;
                    if (((n6 = this.font[n2++] & 0xFF) & 0xC0) != 128) {
                        throw new FileFormatException("Invalid UTF-8 sequence");
                    }
                    n5 |= (n6 & 0x3F) << 12;
                    if (n2 >= this.font.length) break;
                    if (((n6 = this.font[n2++] & 0xFF) & 0xC0) != 128) {
                        throw new FileFormatException("Invalid UTF-8 sequence");
                    }
                    n5 |= (n6 & 0x3F) << 6;
                    if (n2 >= this.font.length) break;
                    if (((n6 = this.font[n2++] & 0xFF) & 0xC0) != 128) {
                        throw new FileFormatException("Invalid UTF-8 sequence");
                    }
                    n5 |= n6 & 0x3F;
                } else {
                    throw new FileFormatException("Invalid UTF-8 sequence");
                }
            }
            if (nArray != null) {
                nArray[n3] = n5;
            }
            ++n3;
        }
        return n3;
    }

    public boolean isUnicode() {
        return (this.flags() & 1) != 0;
    }

    public int charCount() {
        return this.header[4];
    }

    public byte[] lookup(int n) {
        if (n > this.charCount()) {
            return null;
        }
        byte[] byArray = new byte[this.cellSize()];
        System.arraycopy(this.font, this.headerSize() + n * this.cellSize(), byArray, 0, this.cellSize());
        return byArray;
    }

    public byte[] lookupU(int n) {
        if (!this.isUnicode()) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        n2 = 0;
        n3 = 0;
        while (n3 < this.ucsDir.length) {
            if (this.ucsDir[n3] == -1) {
                ++n2;
            } else if (this.ucsDir[n3] == n) {
                return this.lookup(n2);
            }
            ++n3;
        }
        return null;
    }
}

