/*
 * Decompiled with CFR 0.152.
 */
package info.seasip.romfont;

import info.seasip.romfont.Psf;

public class Psf1
implements Psf {
    private byte[] font;
    private short[] ucsDir;

    public Psf1(byte[] byArray) {
        this.font = byArray;
        if (this.isUnicode()) {
            int n = this.charCount() * this.font[3] + 4;
            int n2 = (byArray.length - n) / 2;
            this.ucsDir = new short[n2];
            int n3 = 0;
            while (n3 < n2) {
                short s = this.font[n + 2 * n3];
                short s2 = this.font[n + 2 * n3 + 1];
                this.ucsDir[n3] = (short)(s & 0xFF | s2 << 8);
                ++n3;
            }
        }
    }

    public boolean isUnicode() {
        return (this.font[2] & 2) != 0;
    }

    public int charCount() {
        if ((this.font[2] & 1) != 0) {
            return 512;
        }
        return 256;
    }

    public byte[] lookup(int n) {
        if (n > this.charCount()) {
            return null;
        }
        byte[] byArray = new byte[this.font[3]];
        System.arraycopy(this.font, 4 + n * this.font[3], byArray, 0, this.font[3]);
        return byArray;
    }

    public byte[] lookupU(int n) {
        if (!this.isUnicode()) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        n2 = 0;
        n3 = 0;
        while (n3 < this.ucsDir.length) {
            if (this.ucsDir[n3] == -1) {
                ++n2;
            } else if ((this.ucsDir[n3] & 0xFFFF) == n) {
                return this.lookup(n2);
            }
            ++n3;
        }
        return null;
    }
}

