/*
 * Decompiled with CFR 0.152.
 */
package info.seasip.romfont;

import info.seasip.romfont.FileFormatException;
import info.seasip.romfont.FontRef;
import info.seasip.romfont.Psf;
import info.seasip.romfont.Psf1;
import info.seasip.romfont.Psf2;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class RomFile {
    private byte[] romBuf;
    Vector references;
    boolean dirty;
    final byte[] header;
    public static final int EXPORT_RAW = 0;
    public static final int EXPORT_PLUS3DOS = 1;
    public static final int EXPORT_PSF2 = 2;
    public static final int PSF2_MAGIC = -2041924238;

    public RomFile(String string) throws IOException, FileNotFoundException {
        byte[] byArray = new byte[11];
        byArray[0] = 80;
        byArray[1] = 76;
        byArray[2] = 85;
        byArray[3] = 83;
        byArray[4] = 51;
        byArray[5] = 68;
        byArray[6] = 79;
        byArray[7] = 83;
        byArray[8] = 26;
        byArray[9] = 1;
        this.header = byArray;
        this.romBuf = this.load(string);
        this.dirty = false;
        this.scan();
    }

    private void storeFont(byte[] byArray, FontRef fontRef, FontRef fontRef2) {
        int n = byArray.length - fontRef.offset;
        int n2 = fontRef2.length();
        if (fontRef.type == fontRef2.type && n >= n2) {
            System.arraycopy(byArray, fontRef.offset, this.romBuf, fontRef2.offset, n2);
            return;
        }
        int[] nArray = fontRef.unicodeMap();
        int[] nArray2 = fontRef2.unicodeMap();
        int n3 = 0;
        while (n3 < nArray2.length) {
            int n4 = 0;
            while (n4 < nArray.length) {
                if (nArray[n4] == nArray2[n3]) {
                    int n5 = fontRef.offset + n4 * 8;
                    int n6 = fontRef2.offset + n3 * 8;
                    if (n5 + 8 <= byArray.length && n6 + 8 <= this.romBuf.length) {
                        System.arraycopy(byArray, n5, this.romBuf, n6, 8);
                    }
                }
                ++n4;
            }
            ++n3;
        }
        this.dirty = true;
    }

    public byte[] getFont(FontRef fontRef) {
        byte[] byArray = new byte[fontRef.length()];
        System.arraycopy(this.romBuf, fontRef.offset, byArray, 0, byArray.length);
        return byArray;
    }

    public void save(String string) throws IOException, FileNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ((OutputStream)fileOutputStream).write(this.romBuf);
        ((OutputStream)fileOutputStream).close();
        this.dirty = false;
    }

    public void exportFont(String string, FontRef fontRef, int n) throws IOException, FileNotFoundException {
        switch (n) {
            case 0: {
                this.exportRaw(string, fontRef);
                return;
            }
            case 1: {
                this.exportPlus3dos(string, fontRef);
                return;
            }
            case 2: {
                this.exportPsf2(string, fontRef);
                return;
            }
        }
        throw new IOException("Unknown file format requested for export");
    }

    public void exportRaw(String string, FontRef fontRef) throws IOException, FileNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ((OutputStream)fileOutputStream).write(this.romBuf, fontRef.offset, fontRef.length());
        ((OutputStream)fileOutputStream).close();
    }

    public void exportPsf2(String string, FontRef fontRef) throws IOException, FileNotFoundException {
        byte[] byArray = new byte[fontRef.length() + 32];
        int[] nArray = new int[8];
        int[] nArray2 = fontRef.unicodeMap();
        nArray[0] = -2041924238;
        nArray[1] = 0;
        nArray[2] = 32;
        nArray[3] = 1;
        nArray[4] = nArray2.length;
        nArray[5] = 8;
        nArray[6] = 8;
        nArray[7] = 8;
        int n = 0;
        while (n < 8) {
            byArray[n * 4] = (byte)(nArray[n] & 0xFF);
            byArray[n * 4 + 1] = (byte)(nArray[n] >> 8 & 0xFF);
            byArray[n * 4 + 2] = (byte)(nArray[n] >> 16 & 0xFF);
            byArray[n * 4 + 3] = (byte)(nArray[n] >> 24 & 0xFF);
            ++n;
        }
        System.arraycopy(this.romBuf, fontRef.offset, byArray, 32, fontRef.length());
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ((OutputStream)fileOutputStream).write(byArray);
        n = 0;
        while (n < nArray2.length) {
            int n2 = nArray2[n];
            if (n2 < 128) {
                ((OutputStream)fileOutputStream).write(n2);
            } else if (n2 < 2048) {
                ((OutputStream)fileOutputStream).write(0xC0 | n2 >> 6 & 0x1F);
                ((OutputStream)fileOutputStream).write(0x80 | n2 & 0x3F);
            } else if (n2 < 65536) {
                ((OutputStream)fileOutputStream).write(0xE0 | n2 >> 12 & 0xF);
                ((OutputStream)fileOutputStream).write(0x80 | n2 >> 6 & 0x3F);
                ((OutputStream)fileOutputStream).write(0x80 | n2 & 0x3F);
            } else {
                ((OutputStream)fileOutputStream).write(0xF0 | n2 >> 18 & 7);
                ((OutputStream)fileOutputStream).write(0x80 | n2 >> 12 & 0x3F);
                ((OutputStream)fileOutputStream).write(0x80 | n2 >> 6 & 0x3F);
                ((OutputStream)fileOutputStream).write(0x80 | n2 & 0x3F);
            }
            ((OutputStream)fileOutputStream).write(255);
            ++n;
        }
        ((OutputStream)fileOutputStream).close();
    }

    public void exportPlus3dos(String string, FontRef fontRef) throws IOException, FileNotFoundException {
        byte[] byArray = new byte[fontRef.length() + 128];
        int n = 0;
        System.arraycopy(this.romBuf, fontRef.offset, byArray, 128, byArray.length - 128);
        System.arraycopy(this.header, 0, byArray, 0, this.header.length);
        byArray[11] = (byte)(byArray.length & 0xFF);
        byArray[12] = (byte)(byArray.length >> 8 & 0xFF);
        byArray[15] = 3;
        byArray[16] = (byte)(byArray.length - 128 & 0xFF);
        byArray[17] = (byte)(byArray.length - 128 >> 8 & 0xFF);
        byArray[18] = (byte)(fontRef.fontAddress() & 0xFF);
        byArray[19] = (byte)(fontRef.fontAddress() >> 8 & 0xFF);
        int n2 = 0;
        while (n2 < 127) {
            n = (short)(n + (byArray[n2] & 0xFF));
            ++n2;
        }
        byArray[127] = (byte)(n & 0xFF);
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ((OutputStream)fileOutputStream).write(byArray);
        ((OutputStream)fileOutputStream).close();
    }

    public boolean importPSF(Psf psf, FontRef fontRef) {
        int[] nArray = fontRef.unicodeMap();
        if (psf.isUnicode()) {
            int n = 0;
            while (n < nArray.length) {
                int n2;
                byte[] byArray = psf.lookupU(nArray[n]);
                if (byArray != null && (n2 = fontRef.offset + n * 8) + 8 <= this.romBuf.length) {
                    System.arraycopy(byArray, 0, this.romBuf, n2, 8);
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < nArray.length) {
                int n3;
                byte[] byArray;
                int n4 = nArray[n];
                if (n4 == 8593) {
                    n4 = 94;
                }
                if (n4 <= 256 && (byArray = psf.lookup(n4)) != null && (n3 = fontRef.offset + n * 8) + 8 <= this.romBuf.length) {
                    System.arraycopy(byArray, 0, this.romBuf, n3, 8);
                }
                ++n;
            }
        }
        this.dirty = true;
        return true;
    }

    public boolean import437(byte[] byArray, FontRef fontRef) {
        this.storeFont(byArray, new FontRef(0, 3), fontRef);
        return true;
    }

    public boolean importPlus3dos(byte[] byArray, FontRef fontRef) {
        int n = 0;
        FontRef fontRef2 = new FontRef(128, fontRef.type);
        if (byArray.length < 128) {
            return false;
        }
        int n2 = 0;
        while (n2 < 127) {
            n += byArray[n2] & 0xFF;
            ++n2;
        }
        if ((n & 0xFF) != (byArray[127] & 0xFF)) {
            return false;
        }
        int n3 = 0;
        while (n3 < this.header.length - 2) {
            if (this.header[n3] != byArray[n3]) {
                return false;
            }
            ++n3;
        }
        if (byArray[15] == 3 && byArray[16] == 0 && byArray[17] == 2 && byArray[18] == 0 && byArray[19] == 14) {
            fontRef2.type = 2;
        }
        if (byArray[15] == 3 && byArray[16] == 0 && byArray[17] == 2 && byArray[18] == 0 && byArray[19] == 30) {
            fontRef2.type = 1;
        }
        if (byArray[15] == 3 && byArray[16] == 0 && byArray[17] == 3 && byArray[18] == 0 && byArray[19] == 61) {
            fontRef2.type = 0;
        }
        this.storeFont(byArray, fontRef2, fontRef);
        return true;
    }

    public void importFont(String string, FontRef fontRef) throws IOException, FileNotFoundException, FileFormatException {
        Object object;
        byte[] byArray = this.load(string);
        if (byArray.length >= 4 && byArray[0] == 54 && byArray[1] == 4 && this.importPSF((Psf)(object = new Psf1(byArray)), fontRef)) {
            return;
        }
        if (byArray.length >= 32 && (byArray[0] & 0xFF) == 114 && (byArray[1] & 0xFF) == 181 && (byArray[2] & 0xFF) == 74 && (byArray[3] & 0xFF) == 134 && this.importPSF((Psf)(object = new Psf2(byArray)), fontRef)) {
            return;
        }
        if (byArray.length >= 128 && this.importPlus3dos(byArray, fontRef)) {
            return;
        }
        if (byArray.length >= 2048 && this.import437(byArray, fontRef)) {
            return;
        }
        object = new FontRef(0, fontRef.type);
        this.storeFont(byArray, (FontRef)object, fontRef);
    }

    public byte[] load(String string) throws IOException, FileNotFoundException {
        byte[] byArray = null;
        byte[] byArray2 = new byte[4096];
        FileInputStream fileInputStream = new FileInputStream(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = ((InputStream)fileInputStream).read(byArray2);
        while (n > 0) {
            byteArrayOutputStream.write(byArray2, 0, n);
            n = ((InputStream)fileInputStream).read(byArray2);
        }
        ((InputStream)fileInputStream).close();
        ((OutputStream)byteArrayOutputStream).close();
        byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    private void scan() {
        this.references = new Vector();
        byte[] byArray = new byte[16];
        byArray[9] = 16;
        byArray[10] = 16;
        byArray[11] = 16;
        byArray[12] = 16;
        byArray[14] = 16;
        byte[] byArray2 = byArray;
        byte[] byArray3 = new byte[6];
        byArray3[0] = 33;
        byArray3[2] = 60;
        byArray3[3] = 34;
        byArray3[4] = 54;
        byArray3[5] = 92;
        byte[] byArray4 = byArray3;
        byte[] byArray5 = new byte[16];
        byArray5[8] = -16;
        byArray5[9] = -16;
        byArray5[10] = -16;
        byArray5[11] = -16;
        byte[] byArray6 = byArray5;
        byte[] byArray7 = new byte[16];
        byArray7[0] = -1;
        byArray7[1] = -1;
        byArray7[2] = -1;
        byArray7[3] = -1;
        byArray7[4] = -16;
        byArray7[5] = -16;
        byArray7[6] = -16;
        byArray7[7] = -16;
        byArray7[12] = 15;
        byArray7[13] = 15;
        byArray7[14] = 15;
        byArray7[15] = 15;
        byte[] byArray8 = byArray7;
        this.seek(byArray2, 128, 15616, 15616, 0);
        this.seek(byArray4, 128, 4636, 15616, 0);
        this.seek(byArray6, 128, 7680, 7680, 1);
        this.seek(byArray8, 128, 3612, 3584, 2);
    }

    private void seek(byte[] byArray, int n, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < this.romBuf.length) {
            if (n5 + n2 + byArray.length <= this.romBuf.length) {
                boolean bl = true;
                int n6 = 0;
                while (n6 < byArray.length) {
                    if (byArray[n6] != this.romBuf[n5 + n2 + n6]) {
                        bl = false;
                        break;
                    }
                    ++n6;
                }
                if (bl) {
                    this.found(n5 + n3, n4);
                }
            }
            n5 += n;
        }
    }

    private void found(int n, int n2) {
        int n3 = this.references.size();
        int n4 = 0;
        while (n4 < n3) {
            FontRef fontRef = (FontRef)this.references.elementAt(n4);
            if (fontRef.offset == n && fontRef.type == n2) {
                return;
            }
            ++n4;
        }
        this.references.addElement(new FontRef(n, n2));
    }
}

