/*
 * Decompiled with CFR 0.152.
 */
package info.seasip.romfont;

import info.seasip.romfont.ImagePanel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

class QuestionDialog
extends Dialog
implements ActionListener {
    private String caption;
    private Image picture;
    private Button yes;
    private Button no;
    private Button cancel;
    public static final int YES = 1;
    public static final int NO = 2;
    public static final int CANCEL = 0;
    private int result = 0;

    public QuestionDialog(Frame frame, String string, String string2) {
        super(frame, string);
        this.caption = string2;
        this.setModal(true);
        this.picture = this.loadPicture("Query.gif");
    }

    public int getResult() {
        return this.result;
    }

    private Image loadPicture(String string) {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            if (inputStream == null) {
                return null;
            }
            byte[] byArray = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = inputStream.read(byArray);
            while (n > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
            inputStream.close();
            ((OutputStream)byteArrayOutputStream).close();
            return Toolkit.getDefaultToolkit().createImage(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void showModal() {
        Panel panel = new Panel();
        this.setLayout(new BorderLayout());
        panel.setLayout(new FlowLayout());
        if (this.picture != null) {
            this.add("West", new ImagePanel(this.picture));
        }
        this.add("Center", new Label(this.caption));
        this.add("South", panel);
        this.yes = new Button("Yes");
        this.no = new Button("No");
        this.cancel = new Button("Cancel");
        panel.add(this.yes);
        panel.add(this.no);
        panel.add(this.cancel);
        this.yes.addActionListener(this);
        this.no.addActionListener(this);
        this.cancel.addActionListener(this);
        this.addWindowListener(new 1());
        this.pack();
        super.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.yes) {
            this.result = 1;
        }
        if (actionEvent.getSource() == this.no) {
            this.result = 2;
        }
        if (actionEvent.getSource() == this.cancel) {
            this.result = 0;
        }
        this.dispose();
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            QuestionDialog.this.dispose();
        }

        /* synthetic */ 1() {
        }
    }
}

