/*
 * Decompiled with CFR 0.152.
 */
package info.seasip.romfont;

import info.seasip.romfont.AlertDialog;
import info.seasip.romfont.FileFormatException;
import info.seasip.romfont.FontRef;
import info.seasip.romfont.FontViewer;
import info.seasip.romfont.QuestionDialog;
import info.seasip.romfont.RomFile;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;

public class MainFrame
extends Frame
implements ActionListener,
ItemListener {
    private MenuBar menuBar = new MenuBar();
    private Menu menuFile = new Menu("File");
    private MenuItem miFileExit = new MenuItem("Exit", new MenuShortcut(81));
    private MenuItem miFileOpen = new MenuItem("Open", new MenuShortcut(79));
    private MenuItem miFileSave = new MenuItem("Save", new MenuShortcut(83));
    private MenuItem miFileSaveAs = new MenuItem("Save As...");
    private Menu menuFont = new Menu("Font");
    private MenuItem miFontView = new MenuItem("View");
    private MenuItem miFontImport = new MenuItem("Import");
    private MenuItem miFontExportRaw = new MenuItem("Export (raw)");
    private MenuItem miFontExportP3 = new MenuItem("Export (+3DOS)");
    private MenuItem miFontExportPsf = new MenuItem("Export (PSF2)");
    private Menu menuHelp = new Menu("Help");
    private MenuItem miHelpAbout = new MenuItem("About");
    private List itemList = new List();
    private RomFile document;
    private String docFilename;

    public MainFrame() {
        super("ROM font tool");
        this.addWindowListener(new 1());
        ((Component)this).setSize(400, 300);
        this.menuFile.add(this.miFileOpen);
        this.menuFile.add(this.miFileSave);
        this.menuFile.add(this.miFileSaveAs);
        this.menuFile.addSeparator();
        this.menuFile.add(this.miFileExit);
        this.menuBar.add(this.menuFile);
        this.menuFont.add(this.miFontView);
        this.menuFont.add(this.miFontImport);
        this.menuFont.add(this.miFontExportRaw);
        this.menuFont.add(this.miFontExportP3);
        this.menuFont.add(this.miFontExportPsf);
        this.menuBar.add(this.menuFont);
        this.menuHelp.add(this.miHelpAbout);
        this.menuBar.add(this.menuHelp);
        this.enableFontMenu(false);
        this.miFileSaveAs.setEnabled(false);
        this.miFileSave.setEnabled(false);
        this.setMenuBar(this.menuBar);
        this.miFileOpen.addActionListener(this);
        this.miFileSave.addActionListener(this);
        this.miFileSaveAs.addActionListener(this);
        this.miFileExit.addActionListener(this);
        this.miFontView.addActionListener(this);
        this.miFontExportRaw.addActionListener(this);
        this.miFontExportP3.addActionListener(this);
        this.miFontExportPsf.addActionListener(this);
        this.miFontImport.addActionListener(this);
        this.miHelpAbout.addActionListener(this);
        this.add((Component)this.itemList, "Center");
        this.itemList.addItemListener(this);
    }

    private void onFileOpen() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Open ROM image", 0);
        fileDialog.show();
        String string = this.getPath(fileDialog);
        if (string != null) {
            this.load(string);
        }
    }

    private void onFileSaveAs() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Save ROM image", 1);
        fileDialog.show();
        String string = this.getPath(fileDialog);
        if (string != null) {
            this.save(string);
            this.docFilename = string;
        }
    }

    private void onFileSave() {
        this.save(this.docFilename);
    }

    private void save(String string) {
        try {
            this.document.save(string);
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.alert("File not found: " + fileNotFoundException.getMessage());
            return;
        }
        catch (IOException iOException) {
            this.alert("I/O error reading file: " + iOException.getMessage());
            return;
        }
    }

    boolean checkSave() {
        if (this.document == null) {
            return true;
        }
        if (this.document.dirty) {
            QuestionDialog questionDialog = new QuestionDialog((Frame)this, "ROM Font Utility", "Save your changes to " + this.docFilename + "?");
            questionDialog.showModal();
            switch (questionDialog.getResult()) {
                case 1: {
                    this.onFileSave();
                    return true;
                }
                case 2: {
                    this.document.dirty = false;
                    return true;
                }
                case 0: {
                    return false;
                }
            }
        }
        return true;
    }

    void load(String string) {
        if (!this.checkSave()) {
            return;
        }
        try {
            RomFile romFile;
            this.document = romFile = new RomFile(string);
            this.docFilename = string;
            this.showDocument();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.alert("File not found: " + fileNotFoundException.getMessage());
            return;
        }
        catch (IOException iOException) {
            this.alert("I/O error reading file: " + iOException.getMessage());
            return;
        }
    }

    private void onFontView() {
        int n = this.itemList.getSelectedIndex();
        if (n < 0) {
            return;
        }
        FontRef fontRef = (FontRef)this.document.references.elementAt(n);
        byte[] byArray = this.document.getFont(fontRef);
        FontViewer fontViewer = new FontViewer((Frame)this, byArray);
        fontViewer.show();
    }

    private void onFontImport() {
        int n = this.itemList.getSelectedIndex();
        if (n < 0) {
            return;
        }
        FileDialog fileDialog = new FileDialog((Frame)this, "Import font", 0);
        fileDialog.show();
        String string = this.getPath(fileDialog);
        if (string != null) {
            FontRef fontRef = (FontRef)this.document.references.elementAt(this.itemList.getSelectedIndex());
            try {
                this.document.importFont(string, fontRef);
                return;
            }
            catch (FileFormatException fileFormatException) {
                this.alert("File format error loading " + string + ": " + fileFormatException.getMessage());
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.alert("File not found: " + fileNotFoundException.getMessage());
                return;
            }
            catch (IOException iOException) {
                this.alert("I/O error reading file: " + iOException.getMessage());
                return;
            }
        }
    }

    private void onFontExport(int n) {
        int n2 = this.itemList.getSelectedIndex();
        if (n2 < 0) {
            return;
        }
        FileDialog fileDialog = new FileDialog((Frame)this, "Export font", 1);
        fileDialog.show();
        String string = this.getPath(fileDialog);
        if (string != null) {
            FontRef fontRef = (FontRef)this.document.references.elementAt(this.itemList.getSelectedIndex());
            try {
                this.document.exportFont(string, fontRef, n);
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.alert("File not found: " + fileNotFoundException.getMessage());
                return;
            }
            catch (IOException iOException) {
                this.alert("I/O error writing file: " + iOException.getMessage());
                return;
            }
        }
    }

    private void onHelpAbout() {
        AlertDialog alertDialog = new AlertDialog((Frame)this, "ROM Font Utility", "ROM Font Utility v1.0\nCopyright 2007, John Elliott\n\nThis program is free software; you can redistribute it and/or modify\nit under the terms of the GNU General Public License as published by\nthe Free Software Foundation; either version 2 of the License, or\n(at your option) any later version.\n\nThis program is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\nGNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License\nalong with this program; if not, write to the Free Software\nFoundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.", "OK");
        alertDialog.showModal();
    }

    private void showDocument() {
        Vector vector = this.document.references;
        int n = vector.size();
        this.setTitle(String.valueOf(this.docFilename) + " - ROM font tool");
        this.itemList.removeAll();
        this.miFileSave.setEnabled(true);
        this.miFileSaveAs.setEnabled(true);
        this.enableFontMenu(false);
        int n2 = 0;
        while (n2 < n) {
            FontRef fontRef = (FontRef)vector.elementAt(n2);
            this.itemList.add(fontRef.toString());
            if (n2 == 0) {
                this.itemList.select(0);
                this.enableFontMenu(true);
            }
            ++n2;
        }
    }

    private void enableFontMenu(boolean bl) {
        this.miFontView.setEnabled(bl);
        this.miFontImport.setEnabled(bl);
        this.miFontExportRaw.setEnabled(bl);
        this.miFontExportP3.setEnabled(bl);
        this.miFontExportPsf.setEnabled(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.miFileExit) {
            if (!this.checkSave()) {
                return;
            }
            this.dispose();
        }
        if (object == this.miFileOpen) {
            if (!this.checkSave()) {
                return;
            }
            this.onFileOpen();
        }
        if (object == this.miFileSave) {
            this.onFileSave();
        }
        if (object == this.miFileSaveAs) {
            this.onFileSaveAs();
        }
        if (object == this.miFontImport) {
            this.onFontImport();
        }
        if (object == this.miFontExportRaw) {
            this.onFontExport(0);
        }
        if (object == this.miFontExportP3) {
            this.onFontExport(1);
        }
        if (object == this.miFontExportPsf) {
            this.onFontExport(2);
        }
        if (object == this.miFontView) {
            this.onFontView();
        }
        if (object == this.miHelpAbout) {
            this.onHelpAbout();
        }
    }

    protected void alert(String string) {
        AlertDialog alertDialog = new AlertDialog((Frame)this, "ROM Font Utility", string, "Cancel");
        alertDialog.showModal();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.enableFontMenu(true);
    }

    private String getPath(FileDialog fileDialog) {
        String string = fileDialog.getFile();
        if (string == null) {
            return string;
        }
        String string2 = fileDialog.getDirectory();
        if (string2 == null) {
            return string;
        }
        return String.valueOf(string2) + string;
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            if (!MainFrame.this.checkSave()) {
                return;
            }
            MainFrame.this.dispose();
        }

        public void windowClosed(WindowEvent windowEvent) {
            System.exit(0);
        }

        /* synthetic */ 1() {
        }
    }
}

