/*
    PCW image handlers
    Copyright (C) 2000  John Elliott <jce@seasip.demon.co.uk>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
// ============================================================================
// declarations
// ============================================================================

// ----------------------------------------------------------------------------
// headers
// ----------------------------------------------------------------------------
#ifdef __GNUG__
    #pragma implementation "image_logo.cpp"
    #pragma interface "image_logo.h"
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// for all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif
#include "wx/image.h"

// Our own header
#include "image_logo.h"
#include "image_utils.h"

LogoImageHandler::LogoImageHandler()
{
	m_name = "DR LOGO picture";
	m_extension = "pic";
	m_type = wxBITMAP_TYPE_LOGO;
	m_mime = "image/x-pcw-logo-picture";
}

LogoImageHandler::~LogoImageHandler()
{
}

#if wxUSE_STREAMS
bool LogoImageHandler::LoadFile( wxImage *image, wxInputStream& stream, bool verbose, int index )
{
	UNUSED(index);
	return LoadFile(image, stream, verbose);
}

bool LogoImageHandler::LoadFile( wxImage *image, wxInputStream& stream, bool verbose )
{
	int cx, cy, px, m, o;
	unsigned char *data, dbyte, pichdr[128];

	UNUSED(verbose);
	/* Empty the image */
	image->Destroy();
	stream.Read(pichdr, 128);

	if (memcmp(pichdr, "PICTURE\032", 8)) return FALSE;	

	image->Create(720, 256);
	data = image->GetData();
	if (!data)
        {
        	wxLogError( wxT("Cannot allocate memory to load LOGO picture.") );
		return FALSE;
	}

	memset(data, 0, 720*256*3);

	for (cy = 0; cy < 256; cy++)	/* 256 lines */
	{
		for (cx = 0; cx < 90; cx++)
		{
			stream.Read(&dbyte, 1);
			m = 0x80;
                        o = (cy * 720 + cx * 8) * 3;

			for (px = 0; px < 8; px++)
			{
				if (dbyte & m)
				{
					data[o  ] = 0xFF;
					data[o+1] = 0xFF;
					data[o+2] = 0xFF;
				}
				o += 3;
				m = m >> 1;
					
			}
		}
	}
	image->SetMask( FALSE );

	return TRUE;

}



bool LogoImageHandler::SaveFile( wxImage *image, wxOutputStream& stream, bool verbose )
{
	int x, y, w, h, px, mask;
	unsigned char *data, pichdr[128], picfile[23040];
	int offset, doffset;

	UNUSED(verbose);

	memset(pichdr, 0, sizeof(pichdr));
	strcpy((char *)pichdr, "PICTURE\032");

	w = image->GetWidth();
	h = image->GetHeight();

	data = image->GetData();

	if (!data) return FALSE;
	memset(picfile, 0, 23040);

	offset = 0;
	for (y = 0; y < h; y++)
	{
		if (y >= 256) break;
		for (x = 0; x < w; x++)
		{
			if (x >= 720) 
			{
				offset += 3; 
				continue; 
			}
			px = mono(x,y,data[offset], 
                                  data[offset+1],
                                  data[offset+2]);
			offset += 3;

			doffset = (y * 90) + (x / 8);

			mask = 0x80;
			if (x % 8) mask = mask >> (x % 8);
			if (px) picfile[doffset] |= mask;
		}
	}
	stream.Write(pichdr, 128);
	stream.Write(picfile, 23040);
	return TRUE;
}


bool LogoImageHandler::DoCanRead( wxInputStream& stream )
{
        char buf[128];
	char pichdr[128];

        stream.Read(&buf, 128);
        stream.SeekI(-128, wxFromCurrent);

	memset(pichdr, 0, sizeof(pichdr));
        strcpy(pichdr, "PICTURE\032");

	if (memcmp(buf, pichdr, 128)) return FALSE;
	return TRUE;
}


#endif


