

/* PCW Explorer - access Amstrad PCW discs on Linux or Windows
    Copyright (C) 2000  John Elliott

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
// ============================================================================
// declarations
// ============================================================================

// ----------------------------------------------------------------------------
// headers
// ----------------------------------------------------------------------------
#ifdef __GNUG__
    #pragma implementation "drvdlg.cpp"
    #pragma interface "drvdlg.h"
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// for all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif

// Our own header
#include "drvdlg.h"

BEGIN_EVENT_TABLE(PcwDriveDialog, wxDialog)
	EVT_TEXT(DRVLIST_ID, PcwDriveDialog::onSelchange) 
	EVT_COMBOBOX(DRVLIST_ID, PcwDriveDialog::onSelchange)
END_EVENT_TABLE()



PcwDriveDialog::PcwDriveDialog(wxWindow *parent, wxWindowID id, 
                       const wxPoint& pos, 
                       const wxSize& size, 
                       long style, 
                       const wxString& name)
	: wxDialog(parent, id, "Choose drive for PCW disc", pos, size, style, name)
{
	// Create all controls
	cbDriveList = new wxComboBox
                     (this, DRVLIST_ID, "", wxDefaultPosition, wxSize(300, -1));
	
	wxString message = "Choose the drive containing your PCW disc.";


#ifdef WIN32
    wxString message2 = "";
	cbDriveList->Append("Drive A: ", "A:");
	cbDriveList->Append("Drive B: ", "B:");
#else
	cbDriveList->Append("Drive A: ", (void *)"/dev/fd0H720");
	cbDriveList->Append("Drive B: ", (void *)"/dev/fd1H720");

    wxString message2 = "The standard choices assume you are using 720k \n"
                        "PCW discs and standard 1.4Mb 3.5\" drives. If \n"
                        "this is not the case, you will have to enter \n"
                        "the name of the correct disc device by hand. \n";
#endif
	// Add controls to the page
        wxBoxSizer *topsizer = new wxBoxSizer( wxVERTICAL );

        // text message
        topsizer->Add( CreateTextSizer( message ), 0, wxALL, 10 );

        // Combo box
        topsizer->Add( cbDriveList, 1, wxEXPAND | wxLEFT|wxRIGHT, 15 );

	// Second message
        topsizer->Add( CreateTextSizer( message2 ), 0, wxALL, 10 );

        // Buttons
        topsizer->Add( CreateButtonSizer( wxOK | wxCANCEL ), 0, wxCENTRE | wxALL, 10 );

    SetAutoLayout( TRUE );
    SetSizer( topsizer );

    topsizer->SetSizeHints( this );

    Centre(wxBOTH);
}


void PcwDriveDialog::onSelchange(wxEvent &e)
{
	int sel = cbDriveList->GetSelection();
	
	if (sel == -1) m_drvName = cbDriveList->GetValue();
	else 	       m_drvName = (char *)cbDriveList->GetClientData(sel);
}

