
/* 
 * Dos/PC Emulator
 * Copyright (C) 1991 Jim Hudgens
 * 
 * 
 * The file is part of GDE.
 * 
 * GDE is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 * 
 * GDE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GDE; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  
 *
 */

#ifndef SYSDEP_H
#define SYSDEP_H

static char sysdep_h_rcsid[]=
  "$Id: $";


/* $Log: $
 *
 */

#ifndef DEBUG
/* TESTED SPEEDUPS */
#define INLINE_DECODE_MODRM
#define QUICK_FETCH
#define QUICK_DECODE_RM
#define UNPACKED_FLAGS
#endif

#if defined(sun) && defined(sparc)
#include <sys/types.h>
#include <sys/param.h>
#include <unistd.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>
#include <strings.h>
#include <ctype.h>
#include <varargs.h>
#include <errno.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <fcntl.h>


/* which include  file? */
char  EXFUN(tolower,(char));
char  EXFUN(toupper,(char));  
void  EXFUN(perror,(const char *));

#define IS_VOLATILE  /* ARRGH */

extern int sys_nerr;     
extern char *sys_errlist[];

#define STRERROR(y)  ((y>0 && y<sys_nerr)?sys_errlist[y]:"")

#define WORDS_BIGENDIAN


typedef   char  int8;
typedef   long  int32;
typedef   short int16;   
typedef   unsigned long  u_int32;
typedef   unsigned short u_int16;
typedef   unsigned char  u_int8;
#endif




#if defined(ultrix) && defined(mips)
#include <sys/types.h>
#include <sys/param.h>
#include <ctype.h>
#include <unistd.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>
#include <strings.h>
#include <varargs.h>
#include <errno.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <fcntl.h>

void  EXFUN(perror,(const char *));

extern int sys_nerr;     
extern char *sys_errlist[];

#define STRERROR(y)  ((y>0 && y<sys_nerr)?sys_errlist[y]:"")

#undef WORDS_BIGENDIAN

typedef   char  int8;
typedef   long  int32;
typedef   short int16;   
typedef   unsigned long  u_int32;
typedef   unsigned short u_int16;
typedef   unsigned char  u_int8;
#endif



#if defined(_AIX)
#include <sys/types.h>
#include <sys/param.h>
#include <ctype.h>
#include <unistd.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>
#include <strings.h>
#include <varargs.h>
#include <errno.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <fcntl.h>

void  EXFUN(perror,(const char *));

extern int sys_nerr;     
extern char *sys_errlist[];

#define STRERROR(y)  ((y>0 && y<sys_nerr)?sys_errlist[y]:"")

#define   WORDS_BIGENDIAN

typedef   signed char    int8;
typedef   short          int16;   
typedef   long           int32;
typedef   unsigned char  u_int8;
typedef   unsigned short u_int16;
typedef   unsigned long  u_int32;
#endif

/* [JCE] Added a stanza for Linux */
#if defined(LINUX)
#include <sys/types.h>
#include <sys/param.h>
#include <ctype.h>
#include <unistd.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>
#include <strings.h>
#include <stdarg.h>
#include <errno.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <fcntl.h>

void  EXFUN(perror,(const char *));

extern int sys_nerr;     

#define STRERROR(y)  strerror(y)

#undef WORDS_BIGENDIAN
#define IS_VOLATILE volatile

typedef   signed char    int8;
typedef   short          int16;   
typedef   long           int32;
typedef   unsigned char  u_int8;
typedef   unsigned short u_int16;
typedef   unsigned long  u_int32;
#endif

#ifndef NULL
#define NULL  0
#endif

#endif
