
/* 
 * Dos/PC Emulator
 * Copyright (C) 1991 Jim Hudgens
 * 
 * 
 * The file is part of GDE.
 * 
 * GDE is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 * 
 * GDE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GDE; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  
 *
 */

static char rcsid[]=
  "$Id: $";

/* $Log:  $
 * Revision 0.02  1991/07/30  02:09:56  hudgens
 * added copyright.
 *
 * Revision 0.01  1991/07/20  04:10:56  hudgens
 * Initial revision
 *
 */



#include "gde.h"


/** 
 **  do the following:
 **   allocate all the memory to be used.  Currently 1M.
 **   set up interrupt table.
 **
 */
   
void DEFUN(initialize_sys,(m), PC_ENV *m)
 {
    int i;

    /* start up the debugging stuff */
    /* needs to be done *always* whether DEBUG defined or not */
    debug_init(m);

	  

    /* initialize system memory.  Here, we go for a hardwired
       1M of memory.  
     */

    m->mem_base = (u_int8 *) malloc(m->mem_size);

    if (! m->mem_base) 
	{
	  sys_fatal(errno,
		    "malloc of system memory sized %d failed",m->mem_size);
	}

    /* fill in the int table...
       Note that the segments are all set to BIOS_SEG, and the OFFSETS
       are all set to the interrupt number shifted left 8.
       THis is in case a program intercepts the interrupt, and then
       does something like:
              pushf
	      call far [saved_int_cs_ip]
       then, with the proper check in the call opcode, we can determine
       that it was an interrupt faked, *AND* which interrupt it was. 
       Since we are faking all of that, this is important.
     */

    for (i=0; i < 256; i++)
	{
	   *(u_int8 *)(m->mem_base + i*4) = BIOS_SEG & 0xff;
	   *(u_int8 *)(m->mem_base + i*4 + 1) = BIOS_SEG >> 8;
	   *(u_int8 *)(m->mem_base + i*4 + 2) = 0;
	   *(u_int8 *)(m->mem_base + i*4 + 3) = i;
	}
    /* [JCE] Now make INT 30 emulate CP/M (it's a far call, not a vector) 
     * This is a quick-and-dirty fix; true DOS does it more politely. */
    m->mem_base[0xC0] = 0x8A;	/* MOV AH, CL */
    m->mem_base[0xC1] = 0xE1;
    m->mem_base[0xC2] = 0xCD;	/* INT 21 */
    m->mem_base[0xC3] = 0x21;
    m->mem_base[0xC4] = 0x5E;	/* POP SI */
    m->mem_base[0xC5] = 0x5F;	/* POP DI */
    m->mem_base[0xC6] = 0x5E;	/* POP SI */
    m->mem_base[0xC7] = 0x57;	/* PUSH DI */
    m->mem_base[0xC8] = 0x56;	/* PUSH SI */
    m->mem_base[0xC9] = 0xCB;	/* RETF */
    bios_init(m);

    /* initialize the memory allocation system. */
    doss_memalloc_init(m);

    /* initialize the drives configured into the system. */
    doss_fs_init(m);
    

    /* initialize the system file table */
    doss_filetab_init(m);
  
    /* XXX */
    m->doss_curr_drive = 0;
    
    doss_proc_init(m);

 }



void DEFUN(bios_init,(m),PC_ENV *m)
 {
    /* currently the only task here is to initialize the 
       system timer.  More will happen as more system 
       functions become available.*/
    init_bios_timer();
 }
    

void	sys_fatal(int error, char *fmt, ...)
{
  va_list	p;
	
  va_start(p, fmt);
  fprintf(stderr, "Fatal error: ");
  if (error != 0)
      {
	fprintf(stderr, "<%d>",error);
	fprintf(stderr,"%s",STRERROR(error));
      }

  vfprintf(stderr, fmt, p);
  va_end(p);
  fprintf(stderr, "\nExiting...\n");
  exit(1);
}

void	sys_warn(char *fmt, ...)
{
  va_list	p;
	
  va_start(p, fmt);
  fprintf(stderr, "Warning: ");
  vfprintf(stderr, fmt, p);
  va_end(p);
}





  
