
/* 
 * Dos/PC Emulator
 * Copyright (C) 1991 Jim Hudgens
 * 
 * 
 * The file is part of GDE.
 * 
 * GDE is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 * 
 * GDE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GDE; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  
 *
 */


static char rcsid[]=
  "$Id: $";


/* $Log: $
 *
 */


#include "gde.h"

/* system console routines. */

static void DEFUN(syscons_wrchar,(c,clr), u_int8 c AND char clr)
{
  if (c >= ' ' && c < '\177')
    putchar(c);
  else if (c >= '\177')
      {
	switch(c)
	    {
	      /* line drawing characters, replaced by nearest
		 ascii equivalent */
	    case 0xb4: case 0xb5: case 0xb6: case 0xb7:
	    case 0xb8: case 0xb9:            case 0xbb: 
	    case 0xbc: case 0xbd: case 0xbe: case 0xbf:
	    case 0xc0: case 0xc1: case 0xc2: case 0xc3:
	    case 0xc5: case 0xc6: case 0xc7:
	    case 0xc8: case 0xc9: case 0xca: case 0xcb:
	    case 0xcc:            case 0xce: case 0xcf:
	    case 0xd0: case 0xd1: case 0xd2: case 0xd3:
	    case 0xd4: case 0xd5: case 0xd6: case 0xd7:
	    case 0xd8: case 0xd9: case 0xda:
	      putchar('+');
	      break;
	    case 0xb3:
	    case 0xba:
	      putchar('|');
	      break;
	    case 0xc4:
	    case 0xcd:
	      putchar('-');
	      break;
	    default:
	      putchar('.');
	      break;
	    }
      }
  else  
      {
	switch(c)
	    {
	    case '\r':
	      break;
	    case '\0':
	      putchar(' ');
	      break;
	    case '\007':
	      putchar(c);
	      break;
	    case '\t':
	    case '\b':
	    case '\n':
	      putchar(c);
	      break;
	    default:
	      fprintf(stdout,"(0x%x)",c);
	      break;
	    }
      }
}


void DEFUN(syscons_init,(m),PC_ENV *m)
{
  
}

