
/* 
 * Dos/PC Emulator
 * Copyright (C) 1991 Jim Hudgens
 * 
 * 
 * The file is part of GDE.
 * 
 * GDE is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 * 
 * GDE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GDE; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  
 *
 */

static char rcsid[]=
  "$Id: $";

/* $Log: $
 * Revision 0.02  1991/07/30  02:07:09  hudgens
 * added copyright
 *
 * Revision 0.01  1991/07/20  04:10:44  hudgens
 * Initial revision
 *
 */



#include "gde.h"


char *Fname;
PC_ENV  Sys;

int ihandle()
 {
    printf("handled\n");
    exit(0);
 }
    

main(argc,argv)
    char ** argv;
 {
    int i;
    int alen;
    char fbuf[MAXPATHLEN + 10];    /* [JCE] +10 for "/.gderc" */
    char *home;	/* [JCE] home directory */
 
    char *p;
    signal(1, ihandle);
    signal(2, ihandle);
    signal(3, ihandle);

    if (argc == 2)
	{
	   Fname = argv[1];
	}
    else if (argc > 2)
	{
	   i = 1;

	   Fname = argv[i];
	   i++;
	   p = (char*)&Sys.Ctail.cmd[0];
	   Sys.Ctail.len = 0;
	   while ( i < argc )
	       {
		  alen = strlen (argv[i]);
		  sprintf(p," %s", argv[i]);
		  p += alen + 1;   /* count the space, too. */
		  Sys.Ctail.len += alen + 1;
		  i += 1;
	       }
	   *p = 0x0d;
	}
    else
	{
	   printf("usage: %s dos-exe [dos-exe-args]\n",argv[0]);
	   exit(1);
	}
    
	
    /* Configure GDE. Look first for a .gderc in the current 
       directory, then in the user's HOME dir.  If either of these
       fail, fall back to minimalist defaults. */

    /* [JCE] On Linux, sprintf() returns int rather than char*. Recast this
     * bit to use strncpy() and avoid a possible buffer overflow. */

    if ((home = getenv("HOME")))
    {
	strncpy(fbuf, home, MAXPATHLEN - 1); 
	fbuf[MAXPATHLEN] = 0;
	strcat(fbuf, "/.gderc");
    } 

    if ( access(".gderc",R_OK) == 0)
      sys_config(".gderc",&Sys);
    else if (home != NULL && access(fbuf,R_OK) == 0)
      sys_config(fbuf,&Sys);
    else
      sys_config_def(&Sys);


    initialize_sys(&Sys);

    /* XXX
       fix the use of Sys.curr_proc->env_seg before this really hoses
       something up... This points to the "root process's environment
       segment".  
     */

    if (doss_exec(&Sys, Fname, Sys.doss_curr_proc->env_seg,
		  &Sys.Ctail)	== SYSCALL_SUCCESS)
      {
	 i86_exec(&Sys);
      }
    else
	{
	   printf("something hosed\n\nquitting\n");
	   exit(1);
	}
    
 }
    

    

