
/* 
 * Dos/PC Emulator
 * Copyright (C) 1991 Jim Hudgens
 * 
 * 
 * The file is part of GDE.
 * 
 * GDE is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 * 
 * GDE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GDE; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  
 *
 */

#ifndef GDE_H
#define GDE_H

static char gde_h_rcsid[]=
  "$Id: $";


/* $Log: $
 *
 */

#include "ansidecl.h"
#include "sysdep.h"

#include <stdio.h>

#define FETCH_BYTE(to,from,offset) to = from[offset];
#define FETCH_WORD(to,from,offset) to=from[offset]&0xff; \
  to|=(from[offset+1]<<8); 
#define STORE_BYTE(to,offset,from)   to[offset] = (from);
#define STORE_WORD(to,offset,from)   to[offset] = (from)&0xff;\
    to[offset+1] = ((from)>>8)&0xff;


/* 8086 support structs and definitions */
#include "i86.h"
/* 8087 support structs and definitions. */
#include "i87.h"
#include "bios.h"
#include "doss.h"
#include "kbd.h"



typedef struct gde PC_ENV;

struct  gde
{
   /*	The registers!!		*/
   struct i386_general_regs  Gn_regs;
   struct i386_special_regs  Sp_regs;
   struct i386_segment_regs  Sg_regs;
   /* our flags structrure.  This contains information on
           REPE prefix           2 bits  repe,repne
           SEGMENT overrides     5 bits  normal,DS,SS,CS,ES
           Delayed flag set      3 bits  (zero, signed, parity)
	   reserved              6 bits
           interrupt #           8 bits  instruction raised interrupt
	   BIOS video segregs    4 bits  
	   Interrupt Pending     1 bits  
           Extern interrupt      1 bits
	   Halted                1 bits
    */
	   
   
   long   sysmode;
   u_int8 intno;

   /* system memory information */
   u_int8 *	mem_base;
   int32    mem_size;
   int16    cpage_active;
   int16    cpage_system;

#ifdef BIOS_SUPPORT 

/*   video bios subfunctions */
/*   stored as a pointer, since we definitely want 
 *   to support more than one type of display functionality 
 */


   int  vbios_flags;   /* how capable is our equipment??? */
   int  vbios_textx, vbios_texty;
   int  vbios_resx, vbios_resy;
   int  vbios_mode;
   
/* INTERRUPT 0x10 bios calls*/
#define NVBIOS   0x1c

   struct
     {
#ifdef __STDC__
       void (*vbios[NVBIOS])(PC_ENV *m);
       void (*scr_wrchar)(char c, char attr);
#else
       void (*vbios[NVBIOS])();
       void (*scr_wrchar)();
#endif
    } vid_ops;
  
   KBD_OPS *kbd_ops; 

/* printer structure.  Array of three elements 
   defining LPT1 through LPT3. 

  includes
    timestamp on last access
    timeout value for this printer.
    stream handle for this printer.
    name of the printer.

*/

   struct 
       {
	  time_t lpd_fd_last_access;
	  time_t lpd_fd_timeout;
	  FILE  *lpd_fd_stream;
	  char  *lpd_fd_name;
       } printer_desc[BIOS_NPRINTERS];


#endif

#ifdef DOSS_SUPPORT
    /* memory allocation information */
   int      mem_alloc_strategy;
   struct   doss_mcb *mcb_root;

    /* proc info */
   struct   doss_proc   *doss_curr_proc;
    
    /* system drive information */
   struct   doss_drive  *doss_drives;
   int  doss_ndrives;
   int  doss_lastdrive;
   int  doss_curr_drive;

   /* system file table */
   struct   doss_file_handle  *doss_files;
   u_int32  doss_nfiles;

   /*	Old system wide globals which have been brought inside	*/
   struct doss_ctail    Ctail;

   /* configuration stuff */
   char **doss_envp;

#endif
	
#ifdef DEBUG
   int			debug;
   int			check;
   u_int16		saved_ip;
   u_int16		saved_cs;
   int                  enc_pos;
   int                  enc_str_pos;
   char                 decode_buf[32];      /* encoded byte stream  */
   char                 decoded_buf[256];   /* disassembled strings */
#endif
   /* needs to be defined always. */
   FILE                 *dbg_stream;

};

/* GLOBAL */
IS_VOLATILE int intr;

#include "i86_externs.h"
#include "i87_externs.h"
#include "bios_externs.h"
#include "doss_externs.h"
#include "sys_debug.h"
void EXFUN(initialize_sys,(PC_ENV *m));
/* VARARGS subroutines */
void	sys_fatal(int err, char *fmt, ...);
void    sys_warn(char *fmt, ...);


     
#endif

