

/* 
 * Dos/PC Emulator
 * Copyright (C) 1991 Jim Hudgens
 * 
 * 
 * The file is part of GDE.
 * 
 * GDE is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 * 
 * GDE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GDE; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  
 *
 */

#ifdef DOSS_SUPPORT
static char rcsid[]=
  "$Id: doss_time.c,v 1.2 1991/07/30 01:58:10 hudgens Exp hudgens $";

/* $Log: doss_time.c,v $
 * Revision 1.2  1991/07/30  01:58:10  hudgens
 * added copyright.
 *
 * Revision 1.1  1991/07/20  04:08:26  hudgens
 * Initial revision
 *
 *
 */


#include "gde.h"


#define TICKSPERSEC 18.2


/*

 not much here, just code to convert to/from scaled seconds
since midnight (biosticks=seconds*18.2) to hour,min,second,centisec.
   We simply do the conversion, and then call the equivalent 
bios routines.  Two dos functions explicitly deal with time.
First retrieves the time, and the second sets it.

*/


/***********************************************************************/

/* 
  doss_get_clock:

  get the current clock.  This corresponds  to doss interrupt 
  0x21, function 0x2c.  It is passed 4 pointers to unsigned char,
  and returns a success/fail value.  It fills the 4 pointers with
  the hour, minute, second, and centisecond.
*/

int DEFUN(doss_get_clock,(oh,om,os,ocs),
	  u_int8  *oh AND 
	  u_int8  *om AND
	  u_int8  *os AND
	  u_int8  *ocs)
 {
    u_int32 bt;
    double  ft;
    int cs,s,m,h;
/*    int slt=43210;       usecs  --- unused? */
    u_int16 hi,lo;
    u_int8  ov;
    

    /* lazy.  Get the value from the corresponding bios routine */
    intr_0x1a_getclock(&hi,&lo,&ov);
    /* convert to a 32 bit integer. */
    bt = lo | (hi<<16);
    /* convert to floating point */
    ft = bt / TICKSPERSEC;
    /* truncate into seconds.  */
    s = (int) ft;
    /* recover the fractional portion (scaled by 100) into cs */
    cs = (int)((ft-s)*100);    
    /* get the current hour by dividing by 3600. */
    h = s/3600;
    /* get the "fractional" hour (scaled as seconds) back into s */
    s = s - h*3600;
    /* now allow for rollover of hours */
    if (h > 23) h=h%24;  /* just in case it rolls over */
    /* get minutes. */
    m = s/60;
    /* now get the seconds */
    s = s%60;
    /* prepare for return */
    *oh = h;
    *om = m;
    *os = s;
    *ocs = cs;
    /* always success */
    return 0;
 }




/* 
  doss_set_clock:

  set the clock.  This corresponds  to doss interrupt 
  0x21, function 0x2d.  It is passed unsigned chars, 
  and returns a success/fail value. 
 
  If the values are sensible, it uses them to initialize the 
  system clock.
*/

int DEFUN(doss_set_clock,(h,m,s,cs),
	  int  h AND
	  int  m AND 
	  int  s AND
	  int  cs)
 {
    u_int32 bt;
    double  ft;
    u_int16 hi,lo;

    
    if (h < 23 && m < 60 && s < 60 && cs < 100)
	{
	   ft = h*3600 + m*60 + s + (cs/100.0);
	   ft = ft * TICKSPERSEC;
	   bt = (int) ft;
	   lo = bt&0xffff;
	   hi = (bt>>16)&0xffff;
    
	   /* lazy.  Get the value from the corresponding bios routine */
	   intr_0x1a_setclock(hi,lo);
	   return 0;
	}
    else
	{
	   return 1;  /* fail */
	}
 }
    
    



#ifdef TEST
#undef TEST
#include "bios_time.c"
#include "test/t_doss_time.c"
#endif
#endif
