
/* 
 * Dos/PC Emulator
 * Copyright (C) 1991 Jim Hudgens
 * 
 * 
 * The file is part of GDE.
 * 
 * GDE is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 * 
 * GDE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GDE; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  
 *
 */

static char rcsid[]=
  "$Id: $";

/* $Log: $
 * Revision 0.02  1991/07/30  01:49:27  hudgens
 * added copyright.
 *
 * Revision 0.01  1991/07/20  04:05:29  hudgens
 * Initial revision
 *
 *
 */

/* these routines are mostly wrapper routines, and localized to 
   to keep the various grunges associated with the console IO out of 
   doss_file.c 


 */


#include "gde.h"

#ifdef DOSS_SUPPORT 

int DEFUN(doss_conio_is_conin,(m,fh),
	  PC_ENV *m AND int fh)
 {
    int sfh;

    sfh = doss_ufh_to_sfh(m,fh);

    /* check that we are passed a valid handle */
    if ( (m->doss_files[sfh].flags & DOSS_FH_VALID)== 0)
	{
	   return SYSCALL_FAILURE;
	}
    else if ((m->doss_files[sfh].flags & DOSS_FH_ISCHAR) &&
	      (m->doss_files[sfh].flags & DOSS_FH_ISCONIN) )
	{
	   return SYSCALL_SUCCESS;
	}
 }


int DEFUN(doss_conio_is_conout,(m,fh),
	  PC_ENV *m AND int fh)
 {
    int sfh;
    
    sfh = doss_ufh_to_sfh(m,fh);

    /* check that we are passed a valid handle */
    if ( (m->doss_files[sfh].flags & DOSS_FH_VALID)== 0)
	{
	   return SYSCALL_FAILURE;
	}
    else if ((m->doss_files[sfh].flags & DOSS_FH_ISCHAR) &&
	      (m->doss_files[sfh].flags & DOSS_FH_ISCONIN) )
	{
	   return SYSCALL_SUCCESS;
	}
 }

void DEFUN(doss_conio_out_chr,(m,c,ioflg),
	   PC_ENV *m AND
	   u_int8 c  AND
	   u_int8 ioflg)
 {
 /*    (*m->vid_ops.scr_wrchar)(c,0); */
    putchar (c);
 }

int  DEFUN(doss_conio_in_chr,(m,chr,ioflg),
	   PC_ENV *m AND u_int8 *chr AND u_int8 ioflg)
 {
    
 }  

#endif
