
/* 
 * Dos/PC Emulator
 * Copyright (C) 1991 Jim Hudgens
 * 
 * 
 * The file is part of GDE.
 * 
 * GDE is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 * 
 * GDE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GDE; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  
 *
 */

#ifdef BIOS_SUPPORT

static char rcsid[]=
  "$Id: $";

/* $Log: $
 *
 * Revision 0.04  1992/04/13  00:03:39  hudgens
 * Major change to eliminate 99% of the routines in this file.
 * Only the table, and the unique routines remain.
 * Prototypes added, based on GCHUNT's work.
 *
 * Revision 0.03  1991/07/30  01:45:50  hudgens
 * added copyright
 *
 * Revision 0.02  1991/07/20  18:36:07  hudgens
 * added support for interrupts 11 and 12.
 *
 * Revision 0.01  1991/07/20  04:04:07  hudgens
 * Initial revision
 *
 */

#include "gde.h"

/* note large portions of this file were (obviously) generated.
   This corresponds to the initial interrupt table that the 
   bios generates.  Each entry here corresponds to an interrupt 
   vector number, and upon "power up", all the vectors are defined
   as follows.  Most (98%) are left undefined throughout execution
   of the programs.  Some are redefined by the "loaded system".  
   The current method is to initialize the interrupt table to 
   0xfff0:0x00nn, so that if 1) an interrupt ocurrs and the 
   loaded vector has segment=0xfff0, then we exit the emulation
   of instructions and begin a "free form" emulation of the function
   called.  Likewise, any FAR JUMPS (CALLS?) must check to see 
   if the called segment is ==0xfff0, so that the the bios can 
   correctly be emulated if someone intercepts the interrupt
   by changing the table.
 */

/* catch all... */


static void DEFUN(undef_intr,(i,m),int i AND PC_ENV *m)
 {
    /*I'm not quite sure how to handle this now that we have fake code, 
      guess we just return to the program as if there really wasn't anything
      that happened.	-GSH
      */
    debug_printf(m, "SYSTEM CALL #%02x\n",i);
 }
    

static void DEFUN(intr_tab_10,(i,m),int i AND PC_ENV *m)
{
  if (m->R_AH > 0 && m->R_AH < NVBIOS &&
      (*m->vid_ops.vbios[m->R_AH] != NULL))
    (*m->vid_ops.vbios[m->R_AH])(m);
}


static void DEFUN(intr_tab_11,(i,m),int i AND PC_ENV *m)
 {

   /* EQUIPMENT CHECK */
   m->R_AX = 0x1;                /* bit 0:  one or more disk drives. */
                                 /* bit 1: unused? Math coproc? */
                                 /* bit 2,3:  ?  (set to zero)       */
   m->R_AX |=  (0x3 << 4);        /* bits 4,5 --- video=80x25 mono */
                                 /* bits 6,7 --- count of drives */ 
   if (m->doss_ndrives > 4) 
     m->R_AX |= (0x3 << 6 );
   else
     m->R_AX |= (m->doss_ndrives << 6);
                                 /* bit 8, set to zero */
                                 /* bits 9-11: #com ports: set to zero */
                                 /* bit 12  === 0 */
                                 /* bit 13: unused, set to zero */
                                 /* bit 14,15: #printers: set to zero */
 }

    
static void DEFUN(intr_tab_12,(i,m),int i AND PC_ENV *m)
 {
    if (m->mem_size > 640*1024)
      m->R_AX = 640;
    else
      m->R_AX = m->mem_size>>10;
 }
    
static void DEFUN(intr_tab_1a,(i,m),int i AND PC_ENV *m)
 {
    u_int16 h,l;
    u_int8  ov;
    
    
    switch(m->R_AH)
	{
	   
	 case 0:
	   
	   intr_0x1a_getclock(&h,&l,&ov);
	   m->R_CX = h;
	   m->R_DX = l;
	   m->R_AL = ov;
#ifdef DEBUG
	   if (DEBUG_SYSINT(m))
	       {
		  debug_printf(m, "INTR 1A  GET CLOCK\n");
		  debug_printf(m, "clock=%x\n",
			       (h<<16)|l);
	       }
#endif	      
	   break;
	   
	 case 1:
	   h = m->R_CX;
	   l = m->R_DX;
	   intr_0x1a_setclock(h,l);	
#ifdef DEBUG
	   if (DEBUG_SYSINT(m))
	       {
		  debug_printf(m, "INTR 1A  SET CLOCK\n");
		  debug_printf(m, "clock=%x\n",
			       (h<<16)|l);
	       }
#endif	      
	   break;
	   
	}
 }
    
static void DEFUN(intr_tab_16,(i,m),int i AND PC_ENV *m)
 {
#ifdef DEBUG
    if (DEBUG_KEYBOARD(m))
    {
	decode_printf2(m, "\n---\nKEYBOARD SVC 0x%02x\n", m->R_AH);
    }
#endif 
    switch (m->R_AH)
	{
	 case 0x0:
	 case 0x10:
	   /* read keyboard, blocking. */
	  (*m->kbd_ops->kbd_rdchar_blk)(&m->R_AL, &m->R_AH);
	  break;
	  
	 case 0x01:
	 case 0x11:
	  /* read keyboard, non-blocking.  Call sets ZF */
	  if ((*m->kbd_ops->kbd_rdchar_nblk)(&m->R_AL, &m->R_AH) != 0)
	      {
		SET_FLAG(m, F_ZF);
	      }
	  else
	      {
		CLEAR_FLAG(m,F_ZF);
	      }
	  break;
	  
	case 0x02:
	case 0x12:
	  /* read keyboard status, non-blocking.  Call sets ZF */
	  m->R_AL = (*m->kbd_ops->kbd_rdstatus)();
	  break;
	  
	 default:
	   m->R_AH = m->R_AH - 2;  /* XXX  */
	   return;
	}
 }
 


/* XXXX

   things to check here.  
   1) make sure that the timeout is checked periodically.
   2) check the "DX out of range 0..2" return error codes
   correctly.  PHOENIX bios manual not really clear on this.

   Simple printer tests under an AMI bios, that a typical
   sequence for a good printer might be:
  
   get printer status -> 0x90 === NBUSY | SEL
   initialize printer -> 0x8  === IOERROR  ???
   get printer status -> 0x8  === IOERROR  ???
   print byte         -> 0x10 === SEL

*/
  

static void DEFUN(intr_tab_17,(i,m),int i AND PC_ENV *m)
 {
    int n;
    struct timeval ts;
    
    switch (m->R_AH)
	{
	 case 0x0:
	   /* write char in AL to printer given by DX. */
	   if (m->R_DX < 3 &&
	       m->printer_desc[m->R_DX].lpd_fd_stream != (FILE  *) NULL)
	       {
		  n = fwrite(&(m->R_AL), 1, 1, 
			     m->printer_desc[m->R_DX].lpd_fd_stream);

		  if (n > 0)
		      {
			 /* write successfull.  See note on return 
			    values above. */
			 m->R_AH = BIOS_LPD_SEL ; /* printer selected */
		      }
		  else
		    {
		       /* write failed, fall out of subroutine */
		       m->R_AH = BIOS_LPD_IOERR;
		       return;
		       /* NOTREACHED */
		    }
		  /* on success, update timestamp and return */
		  gettimeofday(&ts,(struct timezone *)NULL);
		  m->printer_desc[m->R_DX].lpd_fd_last_access 
		    = ts.tv_sec;
		  return;
		  /* NOTREACHED */
	       }
	   /* here, outside the if statement,
	      one of the two conditions failed.  
	      PHOENIX BIOS book says AX unchanged.  So....
	      Just return. */
	   return;
	   /* NOTREACHED */

	 case 0x01:
	   /* initialize printer */
	   if (m->R_DX < 3)
	       {
		  /* first, see if already open, and a pipe. */
		  if ( m->printer_desc[m->R_DX].lpd_fd_stream 
		          == (FILE  *) NULL &&
		      m->printer_desc[m->R_DX].lpd_fd_name[0] == '|')
		      {
			 pclose(m->printer_desc[m->R_DX].lpd_fd_stream);
		      }
		  
		  if ( m->printer_desc[m->R_DX].lpd_fd_name[0] == '|')
		      {
			 m->printer_desc[m->R_DX].lpd_fd_stream = 
			   popen(&m->printer_desc[m->R_DX].lpd_fd_name[1],
				 "w");
		      }
		  
		  else
		      {
/* [JCE] Removed redundant & from filename */
			 m->printer_desc[m->R_DX].lpd_fd_stream = 
			   fopen(m->printer_desc[m->R_DX].lpd_fd_name,
				 "w");
		      }
			 
		  if (m->printer_desc[m->R_DX].lpd_fd_stream != 
		      (FILE*) NULL)
		      {
			 /* open was successfull.  Ignore the
			  tests, just indicate printer ready 
			  as simply as possible. */
			 m->R_AH = BIOS_LPD_SEL;
			 gettimeofday(&ts,(struct timezone *)NULL);
			 m->printer_desc[m->R_DX].lpd_fd_last_access 
			   = ts.tv_sec;
		      }
		  else	
		    {
		       /* open failed */
		       m->R_AH = BIOS_LPD_IOERR;
		    }
	       }
	   /* apparently, no error, printer(DX) out of range.  */
	   return;
	 case 0x2:
	   /* printer status */
	   if (m->R_DX < 3)
	       {
		  /* see if open, return success. */
		  if (m->printer_desc[m->R_DX].lpd_fd_stream != 
		      (FILE *) NULL) 
		      {
			 
			 m->R_AH = BIOS_LPD_SEL;
			 return;
		      }
		  else  /* closed, indicate SEL|NBUSY */
		      {
			 
			 m->R_AH = BIOS_LPD_SEL |
			   BIOS_LPD_NBUSY;	 
		      }
	       }
	   /* return with no change to AX. */
	   return;
	   
	 default:
	   m->R_AH = m->R_AH - 2;  /* Lordy.  PHOENIX BIOS GUIDE.  p423*/
	   return;
	}

 }


static void DEFUN(intr_tab_20,(i,m),int i AND PC_ENV *m)
 {
#ifdef DEBUG
    if (DEBUG_SYSINT(m))
      debug_printf(m, "\n---\nDOS INT 0x20: EXIT\n");    
#endif
    doss_exit(m,0);
 }
   
static void DEFUN(intr_tab_21,(i,m),int i AND PC_ENV *m)
    {
       u_int16 svc;
       
       svc = m->R_AH;
       /* INVOKE MSDOS */
       (*doss_svc[svc])(m);
    }
    

#ifdef __STDC__
    void (*intr_tab[256])(int i AND PC_ENV *m) =
#else
    void (*intr_tab[256])() =
#endif
 {
    /* 00 - 0f */	
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,     undef_intr,	undef_intr,
    /* 10 - 1f */
    intr_tab_10,
    intr_tab_11, /* partial--hardcoded */
    intr_tab_12, /* partial--hardcoded */
    undef_intr,
    undef_intr,	undef_intr,	
    intr_tab_16, /* kbd support     */	
    intr_tab_17, /* printer support */
    undef_intr,	undef_intr,
    intr_tab_1a,  /* time services */
    undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    /* 20 - 2f */
    intr_tab_20,  /* exit process. */              
    intr_tab_21,  /* DOSS services. */
    undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    /* nada from here on... */
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,     undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr, undef_intr, 	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
    undef_intr,	undef_intr,	undef_intr,	undef_intr,
   };
    
#endif
