/* VTEST: GEM video driver tester
   Copyright 2007, 2012 John Elliott <jce@seasip.demon.co.uk>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/


/*

Page*/
/*------------------------------*/
/*	includes		*/
/*------------------------------*/
/* #include "deskacc.h"				 #define DESKACC x	*/

//#include "portab.h"				/* portable coding conv	*/
//#include "machine.h"				/* machine depndnt conv	*/
//#include "obdefs.h"				/* object definitions	*/
//#include "gembind.h"				/* gem binding structs	*/

#include "ppdgem.h"
#include <dos.h>				// for FP_OFF and FP_SEG macros
#include <string.h>				// for memset
#include <ctype.h>				// for toupper
#include "vtest.h"

/*------------------------------*/
/*	defines			*/
/*------------------------------*/

#define	ARROW		0
#define	HOUR_GLASS	2			

#define	DESK		0

#define END_UPDATE	0
#define	BEG_UPDATE	1

/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Data Structures			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


/*------------------------------*/
/*	Global			*/
/*------------------------------*/

extern WORD vdi_handle;
extern GRECT work_area;

extern void grect_to_array(GRECT *area, WORD *array);

/* Tests of General Drawing Primitives. 
 *
 * These are mostly variations on the familiar box fill test.
 * GDP 10 (justified text) is not covered, because the Text 6 and Text 7
 * tests exercise it.
 * 
 * Rounded rectangles */
void draw_gdp1(void)
{
	WORD	pxy[4];
	WORD	qxy[4];
	WORD 	w0, h0;
	WORD	w1, h1;
	int m, n;

	grect_to_array(&work_area, pxy);
	w0 = (pxy[2] - pxy[0]) / 2;
	h0 = (pxy[3] - pxy[1]) / 2;
	w1 = w0 / 8;
	h1 = h0 / 8;

	vsf_interior(vdi_handle, 3);
	vsf_style(vdi_handle, 3);
	for (m = 0; m < 4; m++)
	{
		vswr_mode(vdi_handle, 1 + m);
		for (n = 0; n < 4; n++)
		{
			vsl_color(vdi_handle, n);
			qxy[0] = pxy[0] + (w1 / 2) + (n * 2 * w1);
			qxy[1] = pxy[1] + (h1 / 2) + (m * 2 * h1);
			qxy[2] = qxy[0] + w1;
			qxy[3] = qxy[1] + w1;
			v_rbox(vdi_handle, qxy);
			qxy[0] += w0; qxy[2] += w0;
			v_rbox(vdi_handle, qxy);
			qxy[1] += h0; qxy[3] += h0;
			v_rbox(vdi_handle, qxy);
			qxy[0] -= w0; qxy[2] -= w0;
			v_rbox(vdi_handle, qxy);
		}
	}
	vswr_mode(vdi_handle, 1);	
}


/* Filled rounded rectangles */
void draw_gdp2(void)
{
	WORD	pxy[4];
	WORD	qxy[4];
	WORD 	w0, h0;
	WORD	w1, h1;
	int m, n;

	grect_to_array(&work_area, pxy);
	w0 = (pxy[2] - pxy[0]) / 2;
	h0 = (pxy[3] - pxy[1]) / 2;
	w1 = w0 / 8;
	h1 = h0 / 8;

	vsf_interior(vdi_handle, 3);
	vsf_style(vdi_handle, 3);
	for (m = 0; m < 4; m++)
	{
		vswr_mode(vdi_handle, 1 + m);
		for (n = 0; n < 4; n++)
		{
			vsf_color(vdi_handle, n);
			qxy[0] = pxy[0] + (w1 / 2) + (n * 2 * w1);
			qxy[1] = pxy[1] + (h1 / 2) + (m * 2 * h1);
			qxy[2] = qxy[0] + w1;
			qxy[3] = qxy[1] + w1;
			v_rfbox(vdi_handle, qxy);
			qxy[0] += w0; qxy[2] += w0;
			v_rfbox(vdi_handle, qxy);
			qxy[1] += h0; qxy[3] += h0;
			v_rfbox(vdi_handle, qxy);
			qxy[0] -= w0; qxy[2] -= w0;
			v_rfbox(vdi_handle, qxy);
		}
	}
	vswr_mode(vdi_handle, 1);	
}



/* Pie slices and elliptical pie slices */
void draw_gdp3(void)
{
	WORD	pxy[4];
	WORD	qxy[4];
	WORD 	w0, h0;
	WORD	w1, h1;
	int m, n;

	grect_to_array(&work_area, pxy);
	w0 = (pxy[2] - pxy[0]) / 2;
	h0 = (pxy[3] - pxy[1]) / 2;

	if (w0 == h0) h0 = w0 / 2;

	w1 = w0 / 8;
	h1 = h0 / 8;

	vsf_interior(vdi_handle, 3);
	vsf_style(vdi_handle, 3);
	for (m = 0; m < 4; m++)
	{
		vswr_mode(vdi_handle, 1 + m);
		for (n = 0; n < 4; n++)
		{
			vsf_color(vdi_handle, n);
			qxy[0] = pxy[0] + (w1 / 2) + (n * 2 * w1);
			qxy[1] = pxy[1] + (h1 / 2) + (m * 2 * h1);
			qxy[2] = w1;
			qxy[3] = h1;
			if (n < 2)
			{
				v_ellpie(vdi_handle, qxy[0], qxy[1], qxy[2], qxy[3], 2700, 0);
				qxy[0] += w0; 
				v_ellpie(vdi_handle, qxy[0], qxy[1], qxy[2], qxy[3], 2700, 0);
				qxy[1] += h0; 
				v_ellpie(vdi_handle, qxy[0], qxy[1], qxy[2], qxy[3], 2700, 0);
				qxy[0] -= w0; 
				v_ellpie(vdi_handle, qxy[0], qxy[1], qxy[2], qxy[3], 2700, 0);
			}
			else
			{
				v_pieslice(vdi_handle, qxy[0], qxy[1], qxy[2], 2700, 0);
				qxy[0] += w0; 
				v_pieslice(vdi_handle, qxy[0], qxy[1], qxy[2], 2700, 0);
				qxy[1] += h0; 
				v_pieslice(vdi_handle, qxy[0], qxy[1], qxy[2], 2700, 0);
				qxy[0] -= w0; 
				v_pieslice(vdi_handle, qxy[0], qxy[1], qxy[2], 2700, 0);
			}
		}
	}
	vswr_mode(vdi_handle, 1);	
}


/* Arcs and elliptical arcs */
void draw_gdp4(void)
{
	WORD	pxy[4];
	WORD	qxy[4];
	WORD 	w0, h0;
	WORD	w1, h1;
	int m, n;

	grect_to_array(&work_area, pxy);
	w0 = (pxy[2] - pxy[0]) / 2;
	h0 = (pxy[3] - pxy[1]) / 2;
	if (w0 == h0) h0 = w0 / 2;
	w1 = w0 / 8;
	h1 = h0 / 8;

	vsf_interior(vdi_handle, 3);
	vsf_style(vdi_handle, 3);
	for (m = 0; m < 4; m++)
	{
		vswr_mode(vdi_handle, 1 + m);
		for (n = 0; n < 4; n++)
		{
			vsl_color(vdi_handle, n);
			qxy[0] = pxy[0] + (w1 / 2) + (n * 2 * w1);
			qxy[1] = pxy[1] + (h1 / 2) + (m * 2 * h1);
			qxy[2] = w1;
			qxy[3] = h1;
			if (n < 2)
			{
				v_ellarc(vdi_handle, qxy[0], qxy[1], qxy[2], qxy[3], 2700, 0);
				qxy[0] += w0; 
				v_ellarc(vdi_handle, qxy[0], qxy[1], qxy[2], qxy[3], 2700, 0);
				qxy[1] += h0; 
				v_ellarc(vdi_handle, qxy[0], qxy[1], qxy[2], qxy[3], 2700, 0);
				qxy[0] -= w0; 
				v_ellarc(vdi_handle, qxy[0], qxy[1], qxy[2], qxy[3], 2700, 0);
			}
			else
			{
				v_arc(vdi_handle, qxy[0], qxy[1], qxy[2], 2700, 0);
				qxy[0] += w0; 
				v_arc(vdi_handle, qxy[0], qxy[1], qxy[2], 2700, 0);
				qxy[1] += h0; 
				v_arc(vdi_handle, qxy[0], qxy[1], qxy[2], 2700, 0);
				qxy[0] -= w0; 
				v_arc(vdi_handle, qxy[0], qxy[1], qxy[2], 2700, 0);
			}
		}
	}
	vswr_mode(vdi_handle, 1);
}

/* Ellipses and circles */
void draw_gdp5(void)
{
	WORD	pxy[4];
	WORD	qxy[4];
	WORD 	w0, h0;
	WORD	w1, h1;
	int m, n;

	grect_to_array(&work_area, pxy);
	w0 = (pxy[2] - pxy[0]) / 2;
	h0 = (pxy[3] - pxy[1]) / 2;

	if (w0 == h0) h0 = w0 / 2;

	w1 = w0 / 8;
	h1 = h0 / 8;

	vsf_interior(vdi_handle, 3);
	vsf_style(vdi_handle, 3);
	for (m = 0; m < 4; m++)
	{
		vswr_mode(vdi_handle, 1 + m);
		for (n = 0; n < 4; n++)
		{
			vsf_color(vdi_handle, n);
			qxy[0] = pxy[0] + w1 + (n * 2 * w1);
			qxy[1] = pxy[1] + h1 + (m * 2 * h1);
			qxy[2] = w1 / 2;
			qxy[3] = h1 / 2;
			if (n < 2) 
			{
				v_ellipse(vdi_handle, qxy[0], qxy[1], qxy[2], qxy[3]);
				qxy[0] += w0; 
				v_ellipse(vdi_handle, qxy[0], qxy[1], qxy[2], qxy[3]);
				qxy[1] += h0; 
				v_ellipse(vdi_handle, qxy[0], qxy[1], qxy[2], qxy[3]);
				qxy[0] -= w0; 
				v_ellipse(vdi_handle, qxy[0], qxy[1], qxy[2], qxy[3]);
			}
			else
			{
				v_circle(vdi_handle, qxy[0], qxy[1], qxy[2]);
				qxy[0] += w0; 
				v_circle(vdi_handle, qxy[0], qxy[1], qxy[2]);
				qxy[1] += h0; 
				v_circle(vdi_handle, qxy[0], qxy[1], qxy[2]);
				qxy[0] -= w0; 
				v_circle(vdi_handle, qxy[0], qxy[1], qxy[2]);
			}
		}
	}
	vswr_mode(vdi_handle, 1);	
}

/* GDP bar (basically, a synonym for filled rectangle) */
void draw_gdp6(void)
{
	WORD	pxy[4];
	WORD	qxy[4];
	WORD 	w0, h0;
	WORD	w1, h1;
	int m, n;

	grect_to_array(&work_area, pxy);
	w0 = (pxy[2] - pxy[0]) / 2;
	h0 = (pxy[3] - pxy[1]) / 2;
	w1 = w0 / 8;
	h1 = h0 / 8;

	vsf_interior(vdi_handle, 3);
	vsf_style(vdi_handle, 3);
	for (m = 0; m < 4; m++)
	{
		vswr_mode(vdi_handle, 1 + m);
		for (n = 0; n < 4; n++)
		{
			vsf_color(vdi_handle, n);
			vsl_color(vdi_handle, (n + 5) % 8);
			qxy[0] = pxy[0] + (w1 / 2) + (n * 2 * w1);
			qxy[1] = pxy[1] + (h1 / 2) + (m * 2 * h1);
			qxy[2] = qxy[0] + w1;
			qxy[3] = qxy[1] + w1;
			v_bar(vdi_handle, qxy);
			qxy[0] += w0; qxy[2] += w0;
			v_bar(vdi_handle, qxy);
			qxy[1] += h0; qxy[3] += h0;
			v_bar(vdi_handle, qxy);
			qxy[0] -= w0; qxy[2] -= w0;
			v_bar(vdi_handle, qxy);
		}
	}
	vswr_mode(vdi_handle, 1);	
}

