/* VTEST: GEM video driver tester
   Copyright 2007, 2012 John Elliott <jce@seasip.demon.co.uk>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "ppdgem.h"
#include <dos.h>				// for FP_OFF and FP_SEG macros
#include <string.h>				// for memset
#include <stdio.h>				// for sprintf
#include "vtest.h"

#define ARROW 0
#define HOUR_GLASS 2

extern VOID objc_xywh(LPTREE tree, WORD obj, GRECT *p);
extern LPTREE gl_menu;
extern WORD vdi_handle;
extern LPVOID old_timer;
extern LPVOID new_timer;
extern LPBYTE ad_rmsg;

/* Tests for the timer and keyboard.
 *
 * The timer test installs a custom timer handler, that counts ticks. This 
 * has to be written in assembly.
 *
 */
WORD st_ticks;
#asm

	.psect	data,class=DATA
_old_timer:
	.blkb	4
_new_timer:
	.word	_time_vector
	.word	seg _time_vector

	.psect	_TEXT,class=CODE
	.globl	_time_vector
	.signat	_time_vector, 24
_time_vector:
	push	ax
	push	ds
	mov	ax, #seg _st_ticks
	mov	ds, ax
	mov	ax, _st_ticks
	inc	ax
	mov	_st_ticks, ax
;;;	pushf			;Simulate interrupt
;;;	callf	[_old_timer]
	pop	ds
	pop	ax
	iret
#endasm

/* The timer test waits for scale*10 ticks (where scale is the value returned
 * by vex_timv()) and compares that to elapsed clock time. 
 */
void test_timer(void)
{
	WORD scale, cscale;
	union REGS rg;
	long tstart, tend;
	char buf[200];

// Get clock.

	graf_mouse(HOUR_GLASS, 0x0L);

	rg.x.ax = 0x2c00;
	intdos(&rg, &rg);
	tstart = 3600L * rg.h.ch + 60L * rg.h.cl + rg.h.dh;

// Hook timer interrupt.
	vex_timv(vdi_handle, new_timer, &old_timer, &scale);

	st_ticks = 0;
	tend = tstart;
	do
	{
/* Guard against the timer not firing at all. Continue reading the clock 
 * until the first tick is received; and if it's more than 10 seconds later,
 * break out of the loop. */
		if (!st_ticks)
		{
			rg.x.ax = 0x2c00;
			intdos(&rg, &rg);
			tend = 3600L * rg.h.ch + 60L * rg.h.cl + rg.h.dh;
			// Have we gone over midnight?
			if (tend < tstart) tend += 86400L;

			if (tend - tstart > 10) break;
		}
	}
	while (st_ticks < scale * 10);
	rg.x.ax = 0x2c00;
	intdos(&rg, &rg);
	tend = 3600L * rg.h.ch + 60L * rg.h.cl + rg.h.dh;
	if (tend < tstart) tend += 86400L;
// Restore timer vector
	vex_timv(vdi_handle, old_timer, &old_timer, &scale);

	cscale = 0;
	if (st_ticks) cscale = ((tend - tstart) * 1000) / st_ticks;
	sprintf(buf, "[0][Timer scale:      %d |"
		         "Ticks received:   %d |"
		         "In clock time:    %ld sec |"
			 "Calculated scale: %d ][  OK  ]",
				scale, st_ticks, tend - tstart,
				cscale);	
	graf_mouse(ARROW, 0x0L);
	form_alert(0, buf);
}

/* Keyboard test: display incoming keycodes until a mouse button click.
 */
void keytest_main(LPTREE tree)
{
	BOOLEAN	done;
	UWORD mousex, mousey, bstate, kstate, kreturn, bclicks;
	UWORD ev_which;
	GRECT rc;

	static char buffer[200];

	objc_xywh(tree, MAINRECT, &rc);
	done = FALSE;
	while( !done )
	{
/* Wait for keyboard or button events */
		ev_which = evnt_multi(MU_KEYBD | MU_BUTTON,
			0, 0, 0,
			0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,
			ad_rmsg, 0, 0,
			&mousex, &mousey, &bstate, &kstate,
			&kreturn, &bclicks);
		wind_update(BEG_UPDATE);	/* begin window update	*/
		if (ev_which & MU_KEYBD)
		{
/* Display incoming keycodes */
			sprintf(buffer, "kstate=0x%04x kreturn=0x%04x",
				kstate, kreturn);
			tree[RESULTS].ob_spec = ADDR(buffer);
			objc_draw(tree, MAINRECT, 1, rc.g_x, rc.g_y, rc.g_w,
				rc.g_h);
		}
		if (ev_which & MU_BUTTON)
		{
/* And button clicks end the loop */
			if (bstate & 1)
			{
				done = TRUE;	/* handle event message	*/
			}
		}
		wind_update(END_UPDATE);	/* end window update	*/
	}

}


/* Keyboard test opens the keyboard-test window, runs the modal loop, closes
 * it. */
void test_keyboard(void)
{
	LPTREE	tree;
	WORD	xdial, ydial, wdial, hdial;

	GRECT	box;

	objc_xywh(gl_menu, OTHEMENU, &box);
	rsrc_gaddr(R_TREE, KEYBTEST, (LPVOID *)&tree);
	
	tree[RESULTS].ob_spec = ADDR("Waiting for key(s)");
	form_center(tree, &xdial, &ydial, &wdial, &hdial);  /* returns 	*/
	/**/				/* screen center x,y,w,h	*/
	
	form_dial(0, box.g_x, box.g_y, box.g_w, box.g_h, 
				xdial, ydial, wdial, hdial);/* reserves*/
	/**/				/* screen space for dialog box	*/

	form_dial(1, box.g_x, box.g_y, box.g_w, box.g_h, 
				xdial, ydial, wdial, hdial);/*  draws 	*/
	/**/				/* expanding box		*/
	
	objc_draw(tree, ROOT, MAX_DEPTH, xdial, ydial, wdial, hdial);

	keytest_main(tree);	

//	exitobj = form_do(tree, 0) & 0x7FFF;
//	tree[exitobj].ob_state &= ~SELECTED; /* deselect OK button	*/

	form_dial(2, box.g_x, box.g_y, box.g_w, box.g_h, 
				xdial, ydial, wdial, hdial);/* draws a	*/
	/**/				/* shrinking box 		*/
  
	form_dial(3, box.g_x, box.g_y, box.g_w, box.g_h, 
				xdial, ydial, wdial, hdial);/* free 	*/
	/**/				/* screen space, causes redraw	*/

}
