/* VTEST: GEM video driver tester
   Copyright 2007, 2012 John Elliott <jce@seasip.demon.co.uk>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/* Based on the GEM 'Hello World' sample, extensively modified */

#include "ppdgem.h"
#include <dos.h>				// for FP_OFF and FP_SEG macros
#include <conio.h>				// for getch
#include <stdio.h>				// for cprintf
#include <string.h>				// for memset
#include <ctype.h>				// for toupper
#include "vtest.h"

/*------------------------------*/
/*	defines			*/
/*------------------------------*/

#define	ARROW		0
#define	HOUR_GLASS	2			

#define	DESK		0

#define END_UPDATE	0
#define	BEG_UPDATE	1


/*------------------------------*/
/*	Local data		*/
/*------------------------------*/

WORD	gl_wchar;			/* character width		*/
WORD	gl_hchar;			/* character height		*/
WORD	gl_wbox;			/* box (cell) width		*/
WORD	gl_hbox;			/* box (cell) height		*/
WORD	gem_handle;			/* GEM vdi handle		*/
WORD	vdi_handle;			/* vtest vdi handle		*/
WORD	work_out[57];			/* open virt workstation values	*/
WORD	ext_work_out[57];		/* extended enquire values	*/
GRECT	work_area;			/* current window work area	*/
WORD	gl_apid;			/* application ID		*/
WORD	gl_rmsg[8];			/* message buffer		*/
LPBYTE	ad_rmsg;			/* LONG pointer to message bfr	*/
WORD	gl_itemvtest = 0;		/* vtest menu item		*/
WORD	gl_xfull;			/* full window 'x'		*/
WORD	gl_yfull;			/* full window 'y'		*/
WORD	gl_wfull;			/* full window 'w' width	*/
WORD	gl_hfull;			/* full window 'h' height	*/
WORD	ev_which;			/* event message returned value	*/
WORD	vtest_whndl = 0;		/* vtest window handle		*/
WORD	type_size;			/* system font cell size	*/
BYTE	*wdw_title = " Graphics Tests ";/* window title		        */
LPTREE	gl_menu;			/* Menu bar                     */
WORD	gl_curdisplay = TESTBOX;	/* Selected display pattern     */
WORD	gl_nplanes;			/* Colour depth of screen       */
LPBIT   gl_bitmap;			/* "GEM" bitmap from resources  */
MFDB    fdbScreen;
WORD 	last_clip[4];			/* Clip rectangle passed by GEM 
					 * when repainting. */

/* Tests in vtest2.c and vtest3.c */
void test_timer(void);
void test_keyboard(void);
void draw_gdp1(void);
void draw_gdp2(void);
void draw_gdp3(void);
void draw_gdp4(void);
void draw_gdp5(void);
void draw_gdp6(void);

/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Local Procedures			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


/*------------------------------*/
/*	min			*/
/*------------------------------*/
WORD
min(a, b)			/* return min of two values	*/
WORD		a, b;
{
	return( (a < b) ? a : b );
}


/*------------------------------*/
/*	max			*/
/*------------------------------*/
WORD
max(a, b)			/* return max of two values	*/
WORD		a, b;
{
	return( (a > b) ? a : b );
}

VOID objc_xywh(LPTREE tree, WORD obj, GRECT *p)         /* get x,y,w,h for specified object     */
{       
	objc_offset(tree, obj, &(p->g_x), &(p->g_y));
	p->g_w = tree[obj].ob_width;    //LWGET(OB_WIDTH(obj));
	p->g_h = tree[obj].ob_height;   //LWGET(OB_HEIGHT(obj));
}


VOID do_about(VOID)
{
	LPTREE	tree;
	WORD	xdial, ydial, wdial, hdial, exitobj;

	GRECT	box;

	objc_xywh(gl_menu, DESKMENU, &box);
	rsrc_gaddr(R_TREE, ABOUTBOX, (LPVOID *)&tree);
	
	form_center(tree, &xdial, &ydial, &wdial, &hdial);  /* returns 	*/
	/**/				/* screen center x,y,w,h	*/
	
	form_dial(0, box.g_x, box.g_y, box.g_w, box.g_h, 
				xdial, ydial, wdial, hdial);/* reserves*/
	/**/				/* screen space for dialog box	*/

	form_dial(1, box.g_x, box.g_y, box.g_w, box.g_h, 
				xdial, ydial, wdial, hdial);/*  draws 	*/
	/**/				/* expanding box		*/
	
	objc_draw(tree, ROOT, MAX_DEPTH, xdial, ydial, wdial, hdial);

	exitobj = form_do(tree, 0) & 0x7FFF;
	tree[exitobj].ob_state &= ~SELECTED; /* deselect OK button	*/

	form_dial(2, box.g_x, box.g_y, box.g_w, box.g_h, 
				xdial, ydial, wdial, hdial);/* draws a	*/
	/**/				/* shrinking box 		*/
  
	form_dial(3, box.g_x, box.g_y, box.g_w, box.g_h, 
				xdial, ydial, wdial, hdial);/* free 	*/
	/**/				/* screen space, causes redraw	*/

}

/*------------------------------*/
/*	grect_to_array		*/
/*------------------------------*/
VOID grect_to_array(GRECT *area, WORD *array)
/* convert x,y,w,h to upr lt x,y and	*/
/*		      lwr rt x,y	*/
{
	*array++ = area->g_x;
	*array++ = area->g_y;
	*array++ = area->g_x + area->g_w - 1;
	*array = area->g_y + area->g_h - 1;
}

/*------------------------------*/
/*	do_open			*/
/*------------------------------*/
WORD
do_open(wh, org_x, org_y, x, y, w, h)	/* grow and open specified wdw	*/
WORD	wh;
WORD	org_x, org_y;
WORD	x, y, w, h;
{
	WORD	ret_code;

	graf_mouse(2,0x0L);
	graf_growbox(org_x, org_y, 21, 21, x, y, w, h);
	ret_code = wind_open(wh, x, y, w, h);
	graf_mouse(ARROW,0x0L);
	return(ret_code);
}


/*------------------------------*/
/*	do_close		*/
/*------------------------------*/
VOID
do_close(wh, org_x, org_y)	/* close and shrink specified window	*/
WORD	wh;
WORD	org_x, org_y;
{
	WORD	x, y, w, h;

	graf_mouse(2,0x0L);
	wind_get(wh, WF_CXYWH, &x, &y, &w, &h);
	wind_close(wh);
	graf_shrinkbox(org_x, org_y, 21, 21, x, y, w, h);
	graf_mouse(ARROW,0x0L);
}


/*------------------------------*/
/*	set_clip		*/
/*------------------------------*/
VOID
set_clip(clip_flag, s_area)	/* set clip to specified area		*/
WORD	clip_flag;
GRECT	*s_area;
{
	grect_to_array(s_area, last_clip);
	vs_clip(vdi_handle, clip_flag, last_clip);
}

/*------------------------------*/
/*	align_x			*/
/*------------------------------*/
WORD
align_x(x)		/* forces word alignment for column positon,	*/
WORD	x;		/*   rounding to nearest word			*/
{
	return((x & 0xfff0) + ((x & 0x000c) ? 0x0010 : 0));
}	

/*------------------------------*/
/*	wdw_size		*/
/*------------------------------*/
VOID
wdw_size(box, w, h)	/* compute window size for given w * h chars	*/
GRECT	*box;
WORD	w, h;
{
	vst_height(vdi_handle, type_size,
	&gl_wchar,&gl_hchar,&gl_wbox,&gl_hbox);

/*
 * wind_calc(WC_BORDER, 0x000B, gl_xfull + gl_wfull/2-w/2, gl_yfull + gl_hfull/2-h/2, w, h, &box->g_x, &box->g_y, &box->g_w, &box->g_h);
	box->g_x = align_x(box->g_x) - 1;
*/
	box->g_x = gl_xfull;
	box->g_y = gl_yfull;
	box->g_w = gl_wfull;
	box->g_h = gl_hfull;
}

/* The backgrounds for the test pages: Plain white */
VOID white_background(WORD *pxy)
{
	vswr_mode(vdi_handle, 1);
	vsf_interior(vdi_handle, 1);
	vsf_color(vdi_handle, WHITE);
	vr_recfl(vdi_handle, pxy);
}


/* The backgrounds for the test pages: Plain green (or black in mono GEM) */
VOID solid_background(WORD *pxy)
{
	vswr_mode(vdi_handle, 1);
	vsf_interior(vdi_handle, 1);
	vsf_color(vdi_handle, GREEN);
	vr_recfl(vdi_handle, pxy);
}



/* The backgrounds for the test pages: blue/white stipple */
VOID stipple_background(WORD *pxy)
{
	vswr_mode(vdi_handle, 1);
	vsf_interior(vdi_handle, 2);
	vsf_style(vdi_handle, 4);
	vsf_color(vdi_handle, BLUE);
	vr_recfl(vdi_handle, pxy);
}

/* The backgrounds for the test pages: four quadrants in colours white/black/
 * red/green */
VOID draw_background(WORD *pxy)
{
	WORD qxy[4];
	WORD w = (pxy[2] - pxy[0]) / 2;
	WORD h = (pxy[3] - pxy[1]) / 2;

	vswr_mode(vdi_handle, 1);
	vsf_interior(vdi_handle, 1);
	vsf_color(vdi_handle, WHITE);
	qxy[0] = pxy[0]; qxy[1] = pxy[1]; 
	qxy[2] = qxy[0] + w; qxy[3] = qxy[1] + h;
	vr_recfl(vdi_handle, qxy);
	
	vsf_color(vdi_handle, BLACK);
	qxy[0] = qxy[2]; qxy[2] = pxy[2];
	vr_recfl(vdi_handle, qxy);
	
	vsf_color(vdi_handle, GREEN);
	qxy[1] = qxy[3]; qxy[3] = pxy[3];
	vr_recfl(vdi_handle, qxy);
	
	vsf_color(vdi_handle, RED);
	qxy[0] = pxy[0]; qxy[2] = pxy[0] + w;
	vr_recfl(vdi_handle, qxy);
}

/********************************* The test pages **************************/

/* draw_boxes() is the ur-test page, on which an awful lot of the others are
 * based. */
VOID draw_boxes()
{
	WORD	pxy[4];
	WORD	qxy[4];
	WORD 	w0, h0;
	WORD	w1, h1;
	int m, n;

	grect_to_array(&work_area, pxy);	/* pxy: Size of window */
	w0 = (pxy[2] - pxy[0]) / 2;		/* w0, h0: Size of quadrant */
	h0 = (pxy[3] - pxy[1]) / 2;
	w1 = w0 / 8;				/* w1, h1: Size of one */
	h1 = h0 / 8;				/*         test rectangle */

	vsf_interior(vdi_handle, 3);
	vsf_style(vdi_handle, 3);
	for (m = 0; m < 4; m++)		/* Test in 4 modes... */
	{
		vswr_mode(vdi_handle, 1 + m);
		for (n = 0; n < 4; n++)	/* ... and 4 colours */
		{
			vsf_color(vdi_handle, n);
			qxy[0] = pxy[0] + (w1 / 2) + (n * 2 * w1);
			qxy[1] = pxy[1] + (h1 / 2) + (m * 2 * h1);
			qxy[2] = qxy[0] + w1;
			qxy[3] = qxy[1] + w1;
			vr_recfl(vdi_handle, qxy);
			qxy[0] += w0; qxy[2] += w0;
			vr_recfl(vdi_handle, qxy);
			qxy[1] += h0; qxy[3] += h0;
			vr_recfl(vdi_handle, qxy);
			qxy[0] -= w0; qxy[2] -= w0;
			vr_recfl(vdi_handle, qxy);
		}
	}
	vswr_mode(vdi_handle, 1);	
}


/* Boxes test 2: Test various fill styles */
VOID draw_boxes2()
{
	WORD	pxy[4];
	WORD	qxy[4];
	WORD 	w0, h0;
	WORD	w1, h1;
	int m, n;

	grect_to_array(&work_area, pxy);
	w0 = (pxy[2] - pxy[0]) / 2;
	h0 = (pxy[3] - pxy[1]) / 2;
	w1 = w0 / 8;
	h1 = h0 / 8;

	vswr_mode(vdi_handle, 1);
	vsf_color(vdi_handle, BLUE);
	for (m = 0; m < 4; m++)
	{
		vsf_interior(vdi_handle, 1 + m);
		for (n = 0; n < 4; n++)
		{
			vsf_style(vdi_handle, 1 + n);
			qxy[0] = pxy[0] + (w1 / 2) + (n * 2 * w1);
			qxy[1] = pxy[1] + (h1 / 2) + (m * 2 * h1);
			qxy[2] = qxy[0] + w1;
			qxy[3] = qxy[1] + w1;
			vr_recfl(vdi_handle, qxy);
			qxy[0] += w0; qxy[2] += w0;
			vr_recfl(vdi_handle, qxy);
			qxy[1] += h0; qxy[3] += h0;
			vr_recfl(vdi_handle, qxy);
			qxy[0] -= w0; qxy[2] -= w0;
			vr_recfl(vdi_handle, qxy);
		}
	}
	vswr_mode(vdi_handle, 1);	
}

/* Boxes test 3: Test solid fill in various colours */
VOID draw_boxes3()
{
	WORD	pxy[4];
	WORD	qxy[4];
	WORD 	w0, h0;
	WORD	w1, h1;
	int m, n;

	grect_to_array(&work_area, pxy);
	w0 = (pxy[2] - pxy[0]) / 2;
	h0 = (pxy[3] - pxy[1]) / 2;
	w1 = w0 / 8;
	h1 = h0 / 8;

	vsf_interior(vdi_handle, 1);
	vsf_style(vdi_handle, 1);
	for (m = 0; m < 4; m++)
	{
		vswr_mode(vdi_handle, 1 + m);
		for (n = 0; n < 4; n++)
		{
			vsf_color(vdi_handle, n);
			qxy[0] = pxy[0] + (w1 / 2) + (n * 2 * w1);
			qxy[1] = pxy[1] + (h1 / 2) + (m * 2 * h1);
			qxy[2] = qxy[0] + w1;
			qxy[3] = qxy[1] + w1;
			vr_recfl(vdi_handle, qxy);
			qxy[0] += w0; qxy[2] += w0;
			vr_recfl(vdi_handle, qxy);
			qxy[1] += h0; qxy[3] += h0;
			vr_recfl(vdi_handle, qxy);
			qxy[0] -= w0; qxy[2] -= w0;
			vr_recfl(vdi_handle, qxy);
		}
	}
	vswr_mode(vdi_handle, 1);	
}


/* Boxes test 3: Test empty fill in various colours */
VOID draw_boxes4()
{
	WORD	pxy[4];
	WORD	qxy[4];
	WORD 	w0, h0;
	WORD	w1, h1;
	int m, n;

	grect_to_array(&work_area, pxy);
	w0 = (pxy[2] - pxy[0]) / 2;
	h0 = (pxy[3] - pxy[1]) / 2;
	w1 = w0 / 8;
	h1 = h0 / 8;

	vsf_interior(vdi_handle, 0);
	vsf_style(vdi_handle, 0);
	for (m = 0; m < 4; m++)
	{
		vswr_mode(vdi_handle, 1 + m);
		for (n = 0; n < 4; n++)
		{
			vsf_color(vdi_handle, n);
			qxy[0] = pxy[0] + (w1 / 2) + (n * 2 * w1);
			qxy[1] = pxy[1] + (h1 / 2) + (m * 2 * h1);
			qxy[2] = qxy[0] + w1;
			qxy[3] = qxy[1] + w1;
			vr_recfl(vdi_handle, qxy);
			qxy[0] += w0; qxy[2] += w0;
			vr_recfl(vdi_handle, qxy);
			qxy[1] += h0; qxy[3] += h0;
			vr_recfl(vdi_handle, qxy);
			qxy[0] -= w0; qxy[2] -= w0;
			vr_recfl(vdi_handle, qxy);
		}
	}
	vswr_mode(vdi_handle, 1);	
}





/* Test box drawing with a clip rectangle */
VOID draw_rclip()
{
	WORD	pxy[4];
	WORD	cxy[4];
	WORD	qxy[4];
	WORD 	w0, h0;
	WORD	w1, h1;
	int m, n;

	grect_to_array(&work_area, pxy);
	w0 = (pxy[2] - pxy[0]) / 2;
	h0 = (pxy[3] - pxy[1]) / 2;
	w1 = w0 / 8;
	h1 = h0 / 8;

	vswr_mode(vdi_handle, 1);
	vsf_color(vdi_handle, BLUE);
	for (m = 0; m < 4; m++)
	{
		for (n = 0; n < 4; n++)
		{
			vs_clip(vdi_handle, 1, last_clip);
			vsf_style(vdi_handle, 1 + n);
			qxy[0] = pxy[0] + (w1 / 2) + (n * 2 * w1);
			qxy[1] = pxy[1] + (h1 / 2) + (m * 2 * h1);
			qxy[2] = qxy[0] + w1;
			qxy[3] = qxy[1] + w1;

/* Draw the clip rectangles */
			vswr_mode(vdi_handle, 3);
			vsf_interior(vdi_handle, 0);
			v_bar(vdi_handle, qxy);
			qxy[0] += w0; qxy[2] += w0;
			v_bar(vdi_handle, qxy);
			qxy[1] += h0; qxy[3] += h0;
			v_bar(vdi_handle, qxy);
			qxy[0] -= w0; qxy[2] -= w0;
			v_bar(vdi_handle, qxy);
			qxy[1] -= h0; qxy[3] -= h0;
			vswr_mode(vdi_handle, 1);
			vsf_interior(vdi_handle, 1 + m);
/* Now set clipping so the rectangle is confined inside the clip area */
			cxy[0] = qxy[0] + 2;
			cxy[1] = qxy[1] + 2;
			cxy[2] = qxy[2] - 2;
			cxy[3] = qxy[3] - 2;
			if (cxy[3] > last_clip[3]) cxy[3] = last_clip[3];
			vs_clip(vdi_handle, 1, cxy);
			vr_recfl(vdi_handle, qxy);
			qxy[0] += w0; qxy[2] += w0;
			cxy[0] += w0; cxy[2] += w0;
			if (cxy[3] > last_clip[3]) cxy[3] = last_clip[3];
			vs_clip(vdi_handle, 1, cxy);
			vr_recfl(vdi_handle, qxy);
			qxy[1] += h0; qxy[3] += h0;
			cxy[1] += h0; cxy[3] += h0;
			if (cxy[3] > last_clip[3]) cxy[3] = last_clip[3];
			vs_clip(vdi_handle, 1, cxy);
			vr_recfl(vdi_handle, qxy);
			qxy[0] -= w0; qxy[2] -= w0;
			cxy[0] -= w0; cxy[2] -= w0;
			if (cxy[3] > last_clip[3]) cxy[3] = last_clip[3];
			vs_clip(vdi_handle, 1, cxy);
			vr_recfl(vdi_handle, qxy);
		}
	}
	vswr_mode(vdi_handle, 1);	
/* And restore the original clipping on exit */
	vs_clip(vdi_handle, 1, last_clip);
}






/* Draw the 'star' shape used by the lines test */

static int xedge[] = { 0, 1, 2, 3, 3, 3, 3, 2, 1, 0, 0, 0 };
static int yedge[] = { 0, 0, 0, 0, 1, 2, 3, 3, 3, 3, 2, 1 };

VOID line_shape(WORD *qxy)
{
	WORD pxy[4];
	WORD dx, dy;
	WORD n;

	pxy[0] = (qxy[0] + qxy[2]) / 2;	/* Centre X */
	pxy[1] = (qxy[1] + qxy[3]) / 2;	/* Centre Y */
	dx = (qxy[2] - qxy[0]) / 3;
	dy = (qxy[3] - qxy[1]) / 3;

	for (n = 0; n < 12; n++)
	{
		pxy[2] = qxy[0] + dx * xedge[n];
		pxy[3] = qxy[1] + dy * yedge[n];
		v_pline(vdi_handle, 2, pxy);
	}
}


/* As line_shape, but draws markers at the line endpoints */
VOID mark_shape(WORD *qxy)
{
	WORD pxy[4];
	WORD dx, dy;
	WORD n;

	pxy[0] = (qxy[0] + qxy[2]) / 2;	/* Centre X */
	pxy[1] = (qxy[1] + qxy[3]) / 2;	/* Centre Y */
	dx = (qxy[2] - qxy[0]) / 3;
	dy = (qxy[3] - qxy[1]) / 3;

	for (n = 0; n < 12; n++)
	{
		vsm_type(vdi_handle, 1 + n);
		pxy[2] = qxy[0] + dx * xedge[n];
		pxy[3] = qxy[1] + dy * yedge[n];
		v_pmarker(vdi_handle, 2, pxy);
	}
}


/* Draw the 'lines' test */
VOID draw_lines()
{
	WORD	pxy[4];
	WORD	qxy[4];
	WORD 	w0, h0;
	WORD	w1, h1;
	int m, n;

	grect_to_array(&work_area, pxy);
	w0 = (pxy[2] - pxy[0]) / 2;
	h0 = (pxy[3] - pxy[1]) / 2;
	w1 = w0 / 8;
	h1 = h0 / 8;

	vsl_type(vdi_handle, 3);
	for (m = 0; m < 4; m++)
	{
		vswr_mode(vdi_handle, 1 + m);
		for (n = 0; n < 4; n++)
		{
			vsl_color(vdi_handle, n);
			qxy[0] = pxy[0] + (w1 / 2) + (n * 2 * w1);
			qxy[1] = pxy[1] + (h1 / 2) + (m * 2 * h1);
			qxy[2] = qxy[0] + w1;
			qxy[3] = qxy[1] + w1;
			line_shape(qxy);
			qxy[0] += w0; qxy[2] += w0;
			line_shape(qxy);
			qxy[1] += h0; qxy[3] += h0;
			line_shape(qxy);
			qxy[0] -= w0; qxy[2] -= w0;
			line_shape(qxy);
		}
	}

}


/* Draw the 'line thickness' test */
VOID draw_lines2()
{
	WORD	pxy[4];
	WORD	qxy[4];
	WORD 	w0, h0;
	WORD	w1, h1;
	int m, n;

	grect_to_array(&work_area, pxy);
	w0 = (pxy[2] - pxy[0]) / 2;
	h0 = (pxy[3] - pxy[1]) / 2;
	w1 = w0 / 8;
	h1 = h0 / 8;

	vswr_mode(vdi_handle, 3);
	for (m = 0; m < 4; m++)
	{
		for (n = 0; n < 4; n++)
		{
			vsl_type(vdi_handle, m + 1);
			vsl_width(vdi_handle, n + 1);
			qxy[0] = pxy[0] + (w1 / 2) + (n * 2 * w1);
			qxy[1] = pxy[1] + (h1 / 2) + (m * 2 * h1);
			qxy[2] = qxy[0] + w1;
			qxy[3] = qxy[1] + w1;
			line_shape(qxy);
			qxy[0] += w0; qxy[2] += w0;
			vsl_type(vdi_handle, m + 5);
			line_shape(qxy);
			vsl_type(vdi_handle, m + 1);
			vsl_width(vdi_handle, n + 5);
			qxy[1] += h0; qxy[3] += h0;
			line_shape(qxy);
			vsl_type(vdi_handle, m + 5);
			qxy[0] -= w0; qxy[2] -= w0;
			line_shape(qxy);
		}
	}
	vsl_width(vdi_handle, 1);
	vsl_type(vdi_handle, 1);
}


/* Draw the polymarkers test */
VOID draw_markers()
{
	WORD	pxy[4];
	WORD	qxy[4];
	WORD 	w0, h0;
	WORD	w1, h1;
	int m, n;

	grect_to_array(&work_area, pxy);
	w0 = (pxy[2] - pxy[0]) / 2;
	h0 = (pxy[3] - pxy[1]) / 2;
	w1 = w0 / 8;
	h1 = h0 / 8;

	for (m = 0; m < 4; m++)
	{
		vswr_mode(vdi_handle, 1 + m);
		for (n = 0; n < 4; n++)
		{
			vsm_color(vdi_handle, n);
			qxy[0] = pxy[0] + (w1 / 2) + (n * 2 * w1);
			qxy[1] = pxy[1] + (h1 / 2) + (m * 2 * h1);
			qxy[2] = qxy[0] + w1;
			qxy[3] = qxy[1] + w1;
			mark_shape(qxy);
			qxy[0] += w0; qxy[2] += w0;
			mark_shape(qxy);
			qxy[1] += h0; qxy[3] += h0;
			mark_shape(qxy);
			qxy[0] -= w0; qxy[2] -= w0;
			mark_shape(qxy);
		}
	}

}



/* Test v_get_pixel(). DRI's drivers don't support this */
VOID draw_getp()
{
	WORD	pxy[4];
	WORD	qxy[4];
	WORD 	w0, h0;
	WORD	w1, h1;
	WORD	pel, idx;
	int m;
	char buf[200];

	grect_to_array(&work_area, pxy);
	w0 = (pxy[2] - pxy[0]) / 2;
	h0 = (pxy[3] - pxy[1]) / 2;
	w1 = w0 / 8;
	h1 = h0 / 8;

	vst_point(vdi_handle, 12, &gl_wchar, &gl_hchar, &gl_wbox, &gl_hbox);
	vsf_interior(vdi_handle, 1);
	vsf_style(vdi_handle, 1);
	vswr_mode(vdi_handle, 1);
	vst_color(vdi_handle, BLACK);
/* Test 16 colours, using a logarithmic scale so we get meaningful results
 * on a truecolour display */
	for (m = 0; m < 16; m++)
	{
		vsf_color(vdi_handle, 1 << m);
		qxy[0] = pxy[0] + (w1 / 2) + (m / 8) * w0;
		qxy[1] = pxy[1] + (h1 / 2) + ((m % 8) * 2 * h1);
		qxy[2] = qxy[0] + w1;
		qxy[3] = qxy[1] + w1;
		/* Draw a rectangle */
		vr_recfl(vdi_handle, qxy);
		/* Attempt to read its colour */
		v_get_pixel(vdi_handle, qxy[0] + 1, qxy[1] + 1,
				&pel, &idx);

		vsf_color(vdi_handle, idx);
		/* And draw a second rectangle in that colour */
		qxy[0] = qxy[2] + 2;
		qxy[2] = qxy[0] + w1;
		vr_recfl(vdi_handle, qxy);

		/* Also draw the results as text */	
		sprintf(buf, "Ink=%04x Pel=%04x Idx=%04x",
			1 << m, pel, idx);
		v_gtext(vdi_handle, qxy[2] + 1, qxy[3], buf);
	}
}




/* Draw a 4x4 cell array. DRI's drivers don't support this. */
VOID draw_cell1()
{
	WORD	pxy[4];
	WORD	qxy[4];
	WORD 	w0, h0;
	WORD	w1, h1;
	int m, n;
	static const WORD colours[] = { 0, 1, 2, 3, 4, 
					5, 6, 7, 8, 9, 
				        10,11,12,13,14,
					15,16,17,18,19 };

	grect_to_array(&work_area, pxy);
	w0 = (pxy[2] - pxy[0]) / 2;
	h0 = (pxy[3] - pxy[1]) / 2;
	w1 = w0 / 8;
	h1 = h0 / 8;

	for (m = 0; m < 4; m++)
	{
		for (n = 0; n < 4; n++)
		{
			qxy[0] = pxy[0] + (w1 / 2) + (n * 2 * w1);
			qxy[1] = pxy[1] + (h1 / 2) + (m * 2 * h1);
			qxy[2] = qxy[0] + w1;
			qxy[3] = qxy[1] + w1;
			v_cellarray(vdi_handle, qxy, (n & 1)+4, 4, 4, m + 1,
				(WORD *)((n & 2) ? &colours[1] :colours));
			qxy[0] += w0; qxy[2] += w0;
			v_cellarray(vdi_handle, qxy, (n & 1)+4, 4, 4, m + 1,
				(WORD *)((n & 2) ? &colours[1] :colours));
			qxy[1] += h0; qxy[3] += h0;
			v_cellarray(vdi_handle, qxy, (n & 1)+4, 4, 4, m + 1,
				(WORD *)((n & 2) ? &colours[1] :colours));
			qxy[0] -= w0; qxy[2] -= w0;
			v_cellarray(vdi_handle, qxy, (n & 1)+4, 4, 4, m + 1,
				(WORD *)((n & 2) ? &colours[1] :colours));
		}
	}

}


/* Read a cell array, then draw it at double size. Repeat until the whole 
 * window is filled. 
 *
 * Again, DRI's drivers don't support cell arrays.
 */
VOID draw_cell2()
{
	WORD	pxy[4];
	WORD	qxy[4];
	WORD	rxy[4];
	WORD	buffer[32];
	int y, y1, x, x1;
	WORD el_used;
	WORD rows_used;
	WORD stat;

	grect_to_array(&work_area, pxy);

	qxy[0] = 0;
	qxy[2] = 31;

	y = 0;
	for (y1 = pxy[1]; y1 <= pxy[3] ; y1 += 2)
	{
		x = 0;
		for (x1 = pxy[0]; x1 <= pxy[2]; x1 += 64)
		{
			qxy[0] = x;
			qxy[1] = y;
			qxy[2] = x + 31;
			qxy[3] = y;
			rxy[0] = x1;
			rxy[1] = y1;
			rxy[2] = x1 + 63;
			rxy[3] = y1 + 1;
			vq_cellarray(vdi_handle, qxy, 32, 1, &el_used, 
				&rows_used, &stat, buffer);
			v_cellarray(vdi_handle, rxy, 32, 32, 1, 1, buffer);
			x += 32;
		}
		++y;
	}
}






/* TEXT1 tests text positioning */
VOID draw_text1()
{
	WORD	pxy[4];
	WORD	qxy[4];
	WORD 	w0, h0;
	WORD	w1, h1;
	int m, n;

	grect_to_array(&work_area, pxy);
	w0 = (pxy[2] - pxy[0]) / 2;
	h0 = (pxy[3] - pxy[1]) / 2;
	w1 = w0 / 8;
	h1 = h0 / 8;

	vst_color(vdi_handle, 2);
	vst_point(vdi_handle, 12, &gl_wchar, &gl_hchar, &gl_wbox, &gl_hbox);
	for (m = 0; m < 4; m++)
	{
		vswr_mode(vdi_handle, 1 + m);
		for (n = 0; n < 16; n++)
		{
			qxy[0] = pxy[0] + n + 5*m*gl_wbox;
			qxy[1] = pxy[1] + (n+1) * gl_hbox;
			/* If text is going outside the box, stop
			 * (except in 'replace' mode) */
			if ((n+1)*gl_hbox > h0) break;

			v_gtext(vdi_handle, qxy[0], qxy[1], "Text");
			qxy[0] += w0;
			v_gtext(vdi_handle, qxy[0], qxy[1], "Text");
			qxy[1] += h0;
			v_gtext(vdi_handle, qxy[0], qxy[1], "Text");
			qxy[0] -= w0;
			v_gtext(vdi_handle, qxy[0], qxy[1], "Text");
			
		}
	}

}

/* TEXT2 tests text sizes */
VOID draw_text2()
{
	WORD	pxy[4];
	WORD	qxy[4];
	WORD 	w0, h0;
	WORD	w1, h1;
	int m, n, spacing;

	grect_to_array(&work_area, pxy);
	w0 = (pxy[2] - pxy[0]) / 2;
	h0 = (pxy[3] - pxy[1]) / 2;
	w1 = w0 / 8;
	h1 = h0 / 8;
	
	vst_point(vdi_handle, 40, &gl_wchar, &gl_hchar, &gl_wbox, &gl_hbox);
	spacing = gl_hbox;
	vst_color(vdi_handle, 2);
	for (m = 0; m < 4; m++)
	{
		vswr_mode(vdi_handle, 1 + m);
		for (n = 8; n < 48; n += 4)
		{
			vst_point(vdi_handle, n, &gl_wchar, &gl_hchar, &gl_wbox, &gl_hbox);
			qxy[0] = pxy[0] + 5*m*gl_wbox;
			qxy[1] = pxy[1] + spacing * ((n-4)/4);
			v_gtext(vdi_handle, qxy[0], qxy[1], "Text");
			
		}
	}
	vswr_mode(vdi_handle, 1);
}

/* TEXT3 tests text effects */
VOID draw_text3()
{
	WORD	pxy[4];
	WORD	qxy[4];
	WORD 	w0, h0;
	WORD	w1, h1;
	int n;

	grect_to_array(&work_area, pxy);
	w0 = (pxy[2] - pxy[0]) / 2;
	h0 = (pxy[3] - pxy[1]) / 2;
	w1 = w0 / 8;
	h1 = h0 / 16;

	vst_color(vdi_handle, 2);
	vst_point(vdi_handle, 12, &gl_wchar, &gl_hchar, &gl_wbox, &gl_hbox);
	for (n = 0; n < 32; n++)
	{
		vst_effects(vdi_handle, n);
		qxy[0] = pxy[0] + (w1 / 2) + ((n%4) * 2 * w1);
		qxy[1] = pxy[1] + (h1 / 2) + ((n/4) * 2 * h1);
		vswr_mode(vdi_handle, 1);
		v_gtext(vdi_handle, qxy[0], qxy[1], "Text");
		qxy[0] += w0;
		vswr_mode(vdi_handle, 2);
		v_gtext(vdi_handle, qxy[0], qxy[1], "Text");
		qxy[1] += h0;
		vswr_mode(vdi_handle, 3);
		v_gtext(vdi_handle, qxy[0], qxy[1], "Text");
		qxy[0] -= w0;
		vswr_mode(vdi_handle, 4);
		v_gtext(vdi_handle, qxy[0], qxy[1], "Text");
	}
	vst_effects(vdi_handle, 0);
	vswr_mode(vdi_handle, 1);
}

/* TEXT4 tests text rotation */
VOID draw_text4()
{
	WORD	pxy[4];
	WORD	qxy[4];
	WORD 	w0, h0;
	WORD	w1, h1;
	int m, n;

	grect_to_array(&work_area, pxy);
	w0 = (pxy[2] - pxy[0]) / 2;
	h0 = (pxy[3] - pxy[1]) / 2;
	w1 = w0 / 8;
	h1 = h0 / 8;

	vst_color(vdi_handle, 2);
	vst_point(vdi_handle, 12, &gl_wchar, &gl_hchar, &gl_wbox, &gl_hbox);
	for (m = 0; m < 4; m++)
	{
		vswr_mode(vdi_handle, 1 + m);
		for (n = 0; n < 4; n++)
		{
			qxy[0] = pxy[0] + (w0 / 4) + ((n&1) * w0);
			qxy[1] = pxy[1] + (h0 / 4) + (((n/2)&1) * h0);

			qxy[0] += (m&1) * 4 * w1;
			qxy[1] += ((m/2)&1) * 4 * h1;

			v_gtext(vdi_handle, qxy[0], qxy[1], "Text");
			vst_rotation(vdi_handle, 900);
			v_gtext(vdi_handle, qxy[0], qxy[1], "Text");
			vst_rotation(vdi_handle, 1800);
			v_gtext(vdi_handle, qxy[0], qxy[1], "Text");
			vst_rotation(vdi_handle, 2700);
			v_gtext(vdi_handle, qxy[0], qxy[1], "Text");
			vst_rotation(vdi_handle, 0);
		}
	}
	vswr_mode(vdi_handle, 1);
}


/* TEXT5 tests text clipping */
VOID draw_text5()
{
	WORD	pxy[4];
	WORD	qxy[4];
	WORD 	w0, h0;
	WORD	w1, h1;
	int m, n;
	WORD	rxy[10];

	grect_to_array(&work_area, pxy);
	w0 = (pxy[2] - pxy[0]) / 2;
	h0 = (pxy[3] - pxy[1]) / 2;
	w1 = w0 / 8;
	h1 = h0 / 8;

	vst_color(vdi_handle, 2);
	vst_point(vdi_handle, 12, &gl_wchar, &gl_hchar, &gl_wbox, &gl_hbox);
	for (m = 0; m < 4; m++)
	{
		for (n = 0; n < 4; n++)
		{
			qxy[0] = pxy[0] + (w0 / 4) + ((n&1) * w0);
			qxy[1] = pxy[1] + (h0 / 4) + (((n/2)&1) * h0);

			qxy[0] += (m&1) * 4 * w1;
			qxy[1] += ((m/2)&1) * 4 * h1;

			vswr_mode(vdi_handle, 3);
			vsl_color(vdi_handle, BLACK);
			rxy[0] = qxy[0] - 20;
			rxy[1] = qxy[1] - 20;
			rxy[2] = rxy[0] + 40; rxy[3] = rxy[1];
			rxy[4] = rxy[2];      rxy[5] = rxy[3] + 40;
			rxy[6] = rxy[4] - 40; rxy[7] = rxy[5];
			rxy[8] = rxy[6];      rxy[9] = rxy[7] - 40;
			v_pline(vdi_handle, 5, rxy);	
			rxy[0] = qxy[0] - 19;
			rxy[1] = qxy[1] - 19;
			rxy[2] = qxy[0] + 19;
			rxy[3] = qxy[1] + 19;
			if (rxy[3] > last_clip[3]) rxy[3] = last_clip[3];
			vs_clip(vdi_handle, 1, rxy);

			vswr_mode(vdi_handle, 1 + m);
			v_gtext(vdi_handle, qxy[0], qxy[1], "Text");
			vst_rotation(vdi_handle, 900);
			v_gtext(vdi_handle, qxy[0], qxy[1], "Text");
			vst_rotation(vdi_handle, 1800);
			v_gtext(vdi_handle, qxy[0], qxy[1], "Text");
			vst_rotation(vdi_handle, 2700);
			v_gtext(vdi_handle, qxy[0], qxy[1], "Text");
			vst_rotation(vdi_handle, 0);
			vs_clip(vdi_handle, 1, last_clip);
		}
	}
	vswr_mode(vdi_handle, 1);
}


/* TEXT6 tests text justification */
VOID draw_text6()
{
	WORD	pxy[4];
	WORD	qxy[4];
	WORD 	w0, h0;
	WORD	w1, h1;
	int m, n;

	grect_to_array(&work_area, pxy);
	w0 = (pxy[2] - pxy[0]) / 2;
	h0 = (pxy[3] - pxy[1]) / 2;
	w1 = w0 / 8;
	h1 = h0 / 8;

	vst_color(vdi_handle, 2);
	vst_point(vdi_handle, 12, &gl_wchar, &gl_hchar, &gl_wbox, &gl_hbox);
	vswr_mode(vdi_handle, 1);
	for (m = 0; m < 4; m++)
	{
		for (n = 0; n < 4; n++)
		{
			char *str = (n & 1) ? "Te xt" : "Text";

			qxy[0] = pxy[0] + (w0 / 4) + ((n&1) * w0);
			qxy[1] = pxy[1] + (h0 / 4) + (((n/2)&1) * h0);

			qxy[0] += (m&1) * 4 * w1;
			qxy[1] += ((m/2)&1) * 4 * h1;

			v_justified(vdi_handle, qxy[0], qxy[1], str, 35+3*m,
					n & 1, (n & 2) >> 1);
			vst_rotation(vdi_handle, 900);
			v_justified(vdi_handle, qxy[0], qxy[1], str, 35+3*m,
					n & 1, (n & 2) >> 1);
			vst_rotation(vdi_handle, 1800);
			v_justified(vdi_handle, qxy[0], qxy[1], str, 35+3*m,
					n & 1, (n & 2) >> 1);
			vst_rotation(vdi_handle, 2700);
			v_justified(vdi_handle, qxy[0], qxy[1], str, 35+3*m,
					n & 1, (n & 2) >> 1);
			vst_rotation(vdi_handle, 0);
		}
	}
	vswr_mode(vdi_handle, 1);
}

/* In GEM/3, v_justified() can be made to populate intout with the adjusted
 * width of each character. Since the C binding does not expose this, we need
 * to access intout directly. */ 
extern WORD intout[];

/* Test of justified text. GEM supports two methods of getting the character
 * dimensions back: v_justified() with the top bit of INTIN[0] set, or 
 * vqt_justified(). For whatever reason, they don't produce anything like
 * the same results, and getting them to match what v_justified() actually
 * draws appears to be a forlorn hope, too! */
VOID draw_text7()
{
	WORD	pxy[4];
	WORD	rxy[4];
	WORD	qxy[40];
	WORD 	w0, h0;
	WORD	w1, h1;
	WORD y;
	UWORD	j1, j2;
	int m, n, spacing;

	grect_to_array(&work_area, pxy);
	w0 = (pxy[2] - pxy[0]);
	h0 = (pxy[3] - pxy[1]);
	w1 = w0 / 8;
	h1 = h0 / 16;
	
	vst_point(vdi_handle, 12, &gl_wchar, &gl_hchar, &gl_wbox, &gl_hbox);
	spacing = gl_hbox;
	vst_color(vdi_handle, 1);
	for (n = 0; n < 12; n++)
	{
		vswr_mode(vdi_handle, 1);
		y = pxy[1] + gl_hchar + (h1 * n);
/* Draw some text with v_justified() */
		v_justified(vdi_handle, pxy[0] + gl_wchar, y,
				"Justified text", (12 + n) * (gl_wbox+1), 
				(n & 1) ? 0 : 1, (n & 2) ? 0 : 1);

		memset(qxy, 0, sizeof(qxy));	
/* Now use vqt_justified() to get where the letters go */
		vqt_justified(vdi_handle, pxy[0] + gl_wchar, y,
				"Justified text", (12 + n) * (gl_wbox+1),
				(n & 1) ? 0 : 1, (n & 2) ? 0 : 1, qxy);	

		vswr_mode(vdi_handle, 3);
		vsf_interior(vdi_handle, 0);
/* And draw a rectangle where each letter is supposed to be */
		for (m = 0; m < 14; m++)
		{
			rxy[0] = qxy[m*2  ];
			rxy[1] = y + 2;
			rxy[2] = rxy[0] + gl_wbox;
			rxy[3] = rxy[1] + 2;
			v_bar(vdi_handle, rxy);	
		} 
/* Now use v_justified() to see where the letters go, and repeat. */
		memset(intout, 0, 20 * sizeof(WORD));
		j1 = (n & 1) ? 0x8000: 0x8001;
		j2 = (n & 2) ? 0x8000: 0x8001;
		v_justified(vdi_handle, pxy[0] + gl_wchar + (w0 / 2), y,
				"Justified text", (12 + n) * (gl_wbox+1),
				(WORD)j1, (WORD)j2);

		vswr_mode(vdi_handle, 3);
		vsf_interior(vdi_handle, 0);
		rxy[0] = pxy[0];
		for (m = 0; m < 14; m++)
		{
			rxy[1] = y + 6;
			rxy[2] = rxy[0] + gl_wbox - 1;
			rxy[3] = rxy[1] + 2;
			v_bar(vdi_handle, rxy);	
			rxy[0] += intout[m];
		}



	}
}





/* Draw a standard test pattern for blitting (used to check that the blit
 * picks up all points inside a rectangle, and none outside it. Pattern is
 * 'Test' in red, on a white background, with a black border. */
VOID blit_testpat(WORD x, WORD y, WORD *bxy)
{
	WORD qxy[4], n;

	qxy[0] = x;
	qxy[1] = y;
	qxy[2] = qxy[0] + 4 * gl_wbox + 6;
	qxy[3] = qxy[1] +     gl_hbox + 5;
	vswr_mode(vdi_handle, 1);
	vsf_interior(vdi_handle, 1);
	vsf_color(vdi_handle, BLACK);
	vr_recfl(vdi_handle, qxy);
	qxy[0]++; qxy[1]++; qxy[2]--; qxy[3]--;
	vsf_color(vdi_handle, WHITE);
	vr_recfl(vdi_handle, qxy);
	qxy[0]++; qxy[1]++; qxy[2]--; qxy[3]--;
	for (n = 0; n < 4; n++)
	{
		bxy[n] = qxy[n];
	}
	vsf_color(vdi_handle, BLACK);
	vr_recfl(vdi_handle, qxy);
	qxy[0]++; qxy[1]++; qxy[2]--; qxy[3]--;
	vsf_color(vdi_handle, WHITE);
	vr_recfl(vdi_handle, qxy);
	vst_color(vdi_handle, RED);
	qxy[0]++; qxy[1]++; qxy[2]--; qxy[3]--;
	v_gtext(vdi_handle, qxy[0], qxy[3], "Test");
}


/* Draw a thin test pattern (7 pixels wide) for blitting (used to check that 
 * the blit can handle a pattern that's narrower than a byte) */
VOID blit_testthin(WORD x, WORD y, WORD *bxy)
{
	WORD qxy[4], n;

	qxy[0] = x;
	qxy[1] = y;
	qxy[2] = qxy[0] + 7;
	qxy[3] = qxy[1] + 15;
	vswr_mode(vdi_handle, 1);
	vsf_interior(vdi_handle, 1);
	vsf_color(vdi_handle, BLACK);
	vr_recfl(vdi_handle, qxy);
	qxy[0]++; qxy[1]++; qxy[2]--; qxy[3]--;
	vsf_color(vdi_handle, WHITE);
	vr_recfl(vdi_handle, qxy);
	qxy[0]++; qxy[1]++; qxy[2]--; qxy[3]--;
	for (n = 0; n < 4; n++)
	{
		bxy[n] = qxy[n];
	}
	vsf_color(vdi_handle, BLACK);
	vr_recfl(vdi_handle, qxy);
	qxy[0]++; qxy[1]++; qxy[2]--; qxy[3]--;
	vsf_color(vdi_handle, WHITE);
	vr_recfl(vdi_handle, qxy);
}



/* The first blit test copies the standard test pattern 16 times, 
 * incrementing the X-coordinate by 1 each time. This should exercise the
 * various code paths in the blitting engine that deal with shifts and 
 * rotations. */
VOID draw_blit1(void)
{
	WORD n, m, w, h;
	/* Start by drawing a test pattern */
	WORD pxy[4];
	WORD bxy[8];
	WORD xspace;
	MFDB src, dest;

	vst_point(vdi_handle, 8, &gl_wchar, &gl_hchar, &gl_wbox, &gl_hbox);
	grect_to_array(&work_area, pxy);

	xspace = (work_area.g_w) / 7;
	memset(&src, 0, sizeof(src));
	memset(&dest, 0, sizeof(dest));
	blit_testpat(pxy[0] + 4, pxy[1] + 4, bxy);

	/* Test pattern generated */
	w = bxy[2] - bxy[0];
	h = bxy[3] - bxy[1];
	for (n = 0; n < 20; n++)
	{
		for (m = 0; m < 6; m++)
		{
			bxy[4] = bxy[0] + (m+1) * xspace + n;
			bxy[5] = bxy[1] + (gl_hbox + 5) * n;
			bxy[6] = bxy[4] + w;
			bxy[7] = bxy[5] + h;
			vro_cpyfm(vdi_handle, m, bxy, &src, &dest);
		}
	}
}


/* The second blit test deals with overlapping blits, since the blit engine
 * has to detect these and do them backwards if necessary. */
VOID draw_blit2(void)
{
	WORD n, m, w, h, dx, dy;
	WORD pxy[4];
	WORD bxy[8];
	MFDB src, dest;

	vst_point(vdi_handle, 8, &gl_wchar, &gl_hchar, &gl_wbox, &gl_hbox);
	grect_to_array(&work_area, pxy);

	memset(&src, 0, sizeof(src));
	memset(&dest, 0, sizeof(dest));

	for (n = 0; n < 8; n++)
	//for (n = 1; n < 2; n++)
	{
		blit_testpat((pxy[0] + pxy[2]) / 2, 
			     (pxy[1] + pxy[3]) / 2, bxy);
		w = bxy[2] - bxy[0];
		h = bxy[3] - bxy[1];
		switch(n)
		{
			case 0: case 1: case 2: dy = -(gl_hbox-2); break;
			case 3: case 4:		dy = 0; break;
			case 5: case 6: case 7: dy = (gl_hbox-2); break;
		}
		switch(n)
		{
			case 0: case 3: case 5: dx = -(w / 2); break;
			case 1: case 6:         dx = 0; break;
			case 2: case 4: case 7: dx = (w / 2); break;
		}

		for (m = 1; m < 8; m++)
		//for (m = 1; m < 2; m++)
		{
			bxy[4] = bxy[0] + m*dx;
			bxy[5] = bxy[1] + m*dy;
			bxy[6] = bxy[4] + w;
			bxy[7] = bxy[5] + h;
			vro_cpyfm(vdi_handle, 3, bxy, &src, &dest);
		}
	}
}

/* This tests blits where the area being copied is small enough to fit in a 
 * byte: to exercise code where the value being blitted gets clipped on the
 * left and the right. */
VOID draw_blit3(void)
{
	WORD n;
	WORD pxy[4];
	WORD bxy[8];
	MFDB src, dest;
	int cx, cy, w, h;

	vst_point(vdi_handle, 8, &gl_wchar, &gl_hchar, &gl_wbox, &gl_hbox);
	grect_to_array(&work_area, pxy);

	memset(&src, 0, sizeof(src));
	memset(&dest, 0, sizeof(dest));

	cx = (pxy[0] + pxy[2]) / 2;
	cy = (pxy[1] + pxy[3]) / 2;


	for (n = 0; n < 16; n++)
	{
		blit_testthin(cx, cy, bxy);	
		w = bxy[2] - bxy[0];
		h = bxy[3] - bxy[1];
		bxy[4] = pxy[0] + 8 + 9*n;
		bxy[5] = pxy[1] + 8 + 9*n;
		bxy[6] = pxy[0] + w + 8 + 9*n;
		bxy[7] = pxy[1] + h + 8 + 9*n;
		vro_cpyfm(vdi_handle, 3, bxy, &src, &dest);
	}
}


/* This tests blitting a mono bitmap image using the 'transparent' blit.
 * As usual, tests with four colours and four modes. 
 */ 
VOID draw_blit4()
{
	WORD	pxy[4];
	WORD	qxy[8];
	WORD 	w0, h0;
	WORD	w1, h1;
	WORD 	fgbg[2];
	int m, n;
	MFDB	fdbMem;

/* Set up a MFDB based on the first bitmap in the resource file */
	memset(&fdbMem, 0, sizeof(fdbMem));
	fdbMem.mp  = gl_bitmap->bi_pdata;
	fdbMem.fww = gl_bitmap->bi_wb / 2;
	fdbMem.fh  = gl_bitmap->bi_hl;
	fdbMem.fwp = gl_bitmap->bi_wb * 8;
	fdbMem.ff  = 0;
	fdbMem.np  = 1;
	qxy[0] = 0; 
	qxy[1] = 0;
	qxy[2] = fdbMem.fwp - 4;
	qxy[3] = fdbMem.fh - 2;

	grect_to_array(&work_area, pxy);
	w0 = (pxy[2] - pxy[0]) / 2;
	h0 = (pxy[3] - pxy[1]) / 2;
	w1 = w0 / 8;
	h1 = h0 / 8;

	vsf_interior(vdi_handle, 3);
	vsf_style(vdi_handle, 3);
	for (m = 0; m < 4; m++)
	{
		vswr_mode(vdi_handle, 1 + m);
		for (n = 0; n < 4; n++)
		{
			fgbg[0] = n;
			fgbg[1] = 0;
			vsf_color(vdi_handle, n);
			qxy[4] = pxy[0] + (w1 / 2) + (n * 2 * w1);
			qxy[5] = pxy[1] + (h1 / 2) + (m * 2 * h1);
			qxy[6] = qxy[4] + qxy[2];
			qxy[7] = qxy[5] + qxy[3];
			vrt_cpyfm(vdi_handle, m+1, qxy, &fdbMem, &fdbScreen, fgbg);		
			qxy[4] += w0; qxy[6] += w0;
			vrt_cpyfm(vdi_handle, m+1, qxy, &fdbMem, &fdbScreen, fgbg);		
			qxy[5] += h0; qxy[7] += h0;
			vrt_cpyfm(vdi_handle, m+1, qxy, &fdbMem, &fdbScreen, fgbg);		
			qxy[4] -= w0; qxy[6] -= w0;
			vrt_cpyfm(vdi_handle, m+1, qxy, &fdbMem, &fdbScreen, fgbg);		
		}
	}
	vswr_mode(vdi_handle, 1);	
}

/* This tests blitting mono -> colour as above, but at 8 different pixel 
 * offsets; to test shift/rotation code. */
VOID draw_blit5()
{
	WORD	pxy[4];
	WORD	qxy[8];
	WORD 	w0, h0;
	WORD 	fgbg[2];
	int m, n, o;
	MFDB	fdbMem;

	memset(&fdbMem, 0, sizeof(fdbMem));
	fdbMem.mp  = gl_bitmap->bi_pdata;
	fdbMem.fww = gl_bitmap->bi_wb / 2;
	fdbMem.fh  = gl_bitmap->bi_hl;
	fdbMem.fwp = gl_bitmap->bi_wb * 8;
	fdbMem.ff  = 0;
	fdbMem.np  = 1;
	qxy[0] = 0; 
	qxy[1] = 0;
	qxy[2] = fdbMem.fwp - 4;
	qxy[3] = fdbMem.fh - 2;

	grect_to_array(&work_area, pxy);
	w0 = (pxy[2] - pxy[0]) / 8;
	h0 = (pxy[3] - pxy[1]) / 8;

	vsf_interior(vdi_handle, 3);
	vsf_style(vdi_handle, 3);
	for (m = 0; m < 4; m++)
	{
		vswr_mode(vdi_handle, 1 + m);
		for (n = 0; n < 2; n++)
		{
			fgbg[0] = n;
			fgbg[1] = 0;
			vsf_color(vdi_handle, n);
			for (o = 0; o < 8; o++)
			{
				qxy[4] = pxy[0] + ((n*4+m) * w0) + o;
				qxy[5] = pxy[1] + (o * (2+qxy[3]));
				qxy[6] = qxy[4] + qxy[2];
				qxy[7] = qxy[5] + qxy[3];
				vrt_cpyfm(vdi_handle, m+1, qxy, &fdbMem, &fdbScreen, fgbg);
			}
		}
	}
	vswr_mode(vdi_handle, 1);	
}


/* This tests screen -> memory -> screen blits, and all 16 modes supported by
 * vro_cpyfm(). */
VOID draw_blit6(void)
{
	WORD n, m, w, h, y;
	WORD pxy[4];
	WORD bxy[8];
	WORD mxy[8];
	WORD xspace;
	MFDB src, dest, mem;

	vst_point(vdi_handle, 8, &gl_wchar, &gl_hchar, &gl_wbox, &gl_hbox);
	grect_to_array(&work_area, pxy);

	xspace = (work_area.g_w) / 7;
	memset(&src, 0, sizeof(src));
	memset(&dest, 0, sizeof(dest));
	blit_testpat(pxy[0] + 4, pxy[1] + 4, bxy);

	/* Test pattern generated */
	w = bxy[2] - bxy[0];
	h = bxy[3] - bxy[1];
	/* Draw 3 columns of the test pattern */
	for (n = 0; n < 3; n++)
	{
		for (m = 0; m < 16; m++)
		{
			bxy[4] = bxy[0] + (n+1) * xspace + m;
			bxy[5] = bxy[1] + (gl_hbox + 5) * m;
			bxy[6] = bxy[4] + w;
			bxy[7] = bxy[5] + h;
			vro_cpyfm(vdi_handle, m, bxy, &src, &dest);
		}
	}
/* Test Screen -> Memory -> Screen blit */
	memset(&mem, 0, sizeof(mem));
	mem.fwp = w + 1;
	mem.fh  = h + 1;
	mem.fww = (w + 16) / 16;
	mem.ff  = 1;
	mem.np  = ext_work_out[4];
/* Allocate memory for the temporary bitmap */
	mem.mp  = dos_alloc(mem.fww * mem.fh * mem.np * 2);

	if (mem.mp)
	{
/* Start: Screen -> Memory */
		mxy[0] = bxy[4] = 0;
		mxy[1] = bxy[5] = 0;
		mxy[2] = bxy[6] = w;
		mxy[3] = bxy[7] = h;
		vro_cpyfm(vdi_handle, 3, bxy, &src, &mem);

		n = 4;
/* Now Memory -> Screen in all 16 modes */
		for (m = 0; m < 16; m++)
		{
			mxy[4] = bxy[0] + (n+1) * xspace + m;
			mxy[5] = bxy[1] + (gl_hbox + 5) * m;
			mxy[6] = mxy[4] + w;
			mxy[7] = mxy[5] + h;
			vro_cpyfm(vdi_handle, m, mxy, &mem, &dest);
		}
/* And, to prove we're going via memory, manipulate the memory bitmap */
		for (n = 0; n < mem.np; n++)
		{	
			unsigned wb = mem.fww * 2;
			LPBYTE ptr1;
			LPBYTE ptr2;
 			ptr1 = mem.mp;
 			ptr1 += (wb * mem.fh * n); /* Start of plane */
			ptr2 = ptr1;
			ptr2 += (wb * (mem.fh - 1)); /* End of plane*/
			for (y = 0; y < (mem.fh / 2); y++)
			{
				for (m = 0; m < wb; m++)
				{
					unsigned char c = ptr1[m];
					ptr1[m] = ptr2[m];
					ptr2[m] = c;
				}
				ptr1 += wb;
				ptr2 -= wb;
			}
		}
/* And draw the manipulated version */
		n = 5;
		for (m = 0; m < 16; m++)
		{
			mxy[4] = bxy[0] + (n+1) * xspace + m;
			mxy[5] = bxy[1] + (gl_hbox + 5) * m;
			mxy[6] = mxy[4] + w;
			mxy[7] = mxy[5] + h;
			vro_cpyfm(vdi_handle, m, mxy, &mem, &dest);
		}

		dos_free(mem.mp);
	}

}


/* Test blit clipping: Replicate blit test 2, but inside a clipping 
 * rectangle. */
VOID draw_blit7()
{
	WORD	pxy[4];
	WORD	qxy[4];
	WORD	bxy[8];
	WORD	dx, dy;
	WORD 	w0, h0;
	WORD	w1, h1;
	WORD	w, h;
	int 	p, q, n, m;
	WORD	rxy[10];
	MFDB src, dest;

	vst_point(vdi_handle, 8, &gl_wchar, &gl_hchar, &gl_wbox, &gl_hbox);
	grect_to_array(&work_area, pxy);

	memset(&src, 0, sizeof(src));
	memset(&dest, 0, sizeof(dest));


	grect_to_array(&work_area, pxy);
	w0 = (pxy[2] - pxy[0]) / 2;
	h0 = (pxy[3] - pxy[1]) / 2;
	w1 = w0 / 8;
	h1 = h0 / 8;

	for (p = 0; p < 4; p++)
	{
		for (q = 0; q < 4; q++)
		{
			qxy[0] = pxy[0] + (w0 / 4) + ((q&1) * w0);
			qxy[1] = pxy[1] + (h0 / 4) + (((q/2)&1) * h0);

			qxy[0] += (p&1) * 4 * w1;
			qxy[1] += ((p/2)&1) * 4 * h1;

			vswr_mode(vdi_handle, 3);
			vsl_color(vdi_handle, BLACK);
			rxy[0] = qxy[0] - 30;
			rxy[1] = qxy[1] - 30;
			rxy[2] = rxy[0] + 60; rxy[3] = rxy[1];
			rxy[4] = rxy[2];      rxy[5] = rxy[3] + 60;
			rxy[6] = rxy[4] - 60; rxy[7] = rxy[5];
			rxy[8] = rxy[6];      rxy[9] = rxy[7] - 60;
			v_pline(vdi_handle, 5, rxy);	
			rxy[0] = qxy[0] - 29;
			rxy[1] = qxy[1] - 29;
			rxy[2] = qxy[0] + 29;
			rxy[3] = qxy[1] + 29;
			if (rxy[3] > last_clip[3]) rxy[3] = last_clip[3];
			vs_clip(vdi_handle, 1, rxy);
			for (n = 0; n < 8; n++)
			{
				blit_testpat(qxy[0] - 2 * gl_wbox - 2, 
					     qxy[1] - (gl_hbox / 2) - 2, bxy);
				w = bxy[2] - bxy[0];
				h = bxy[3] - bxy[1];
				switch(n)
				{
					case 0: case 1: case 2: dy = -(gl_hbox-2); break;
					case 3: case 4:		dy = 0; break;
					case 5: case 6: case 7: dy = (gl_hbox-2); break;
				}
				switch(n)
				{
					case 0: case 3: case 5: dx = -(w / 2); break;
					case 1: case 6:         dx = 0; break;
					case 2: case 4: case 7: dx = (w / 2); break;
				}

				for (m = 1; m < 8; m++)
				{
					bxy[4] = bxy[0] + m*dx;
					bxy[5] = bxy[1] + m*dy;
					bxy[6] = bxy[4] + w;
					bxy[7] = bxy[5] + h;
					vro_cpyfm(vdi_handle, 3, bxy, &src, &dest);
				}
			}
			vs_clip(vdi_handle, 1, last_clip);
		}
	}
	vswr_mode(vdi_handle, 1);
}




/* The 'palette' test draws two areas. The upper one is intended to display
 * all the colours in the palette, up to a maximum of whatever will fit on
 * the screen. 
 *
 * The lower half tests truecolour drawing. On a truecolour display, 
 * changing the RGB mapping of a pen does not affect pixels on the screen.
 * The test therefore repeatedly draws vertical lines with the same pen, 
 * mapping it to a new colour with each line. On a paletted display, the
 * bottom half will end up as solid colour.
 */
VOID draw_pal(void)
{
	WORD n;
	WORD pxy[4];
	WORD lxy[4];
	WORD dr;
	WORD rgb[3];

	grect_to_array(&work_area, pxy);

	lxy[1] = pxy[1];
	lxy[3] = pxy[1] + ((pxy[3] - pxy[1]) / 2);
	for (n = pxy[0]; n < pxy[2]; n++)
	{
		lxy[0] = lxy[2] = n;
		vsl_color(vdi_handle, n);
		v_pline(vdi_handle, 2, lxy);
	}
	lxy[1] = pxy[1] + ((pxy[3] - pxy[1]) / 2);
	lxy[3] = pxy[3];

	dr = 1000 / (pxy[2] - pxy[0]);

	rgb[0] = 0; rgb[1] = 0; rgb[2] = 500;
	for (n = pxy[0]; n < pxy[2]; n++)
	{
		lxy[0] = lxy[2] = n;
		vs_color(vdi_handle, 17, rgb);
		vsl_color(vdi_handle, 17);
		v_pline(vdi_handle, 2, lxy);
		rgb[0] += dr;
	}
}


/* Filled area test: a five-pointed star, where the lines cross over, so the
 * five tips are filled and the central pentagon remains empty. */
VOID draw_fill(void)
{
	WORD	pxy[4];
	WORD	qxy[10];
	WORD 	w0, h0;
	WORD	w1, h1;
	int m, n, q;

	grect_to_array(&work_area, pxy);
	w0 = (pxy[2] - pxy[0]) / 2;
	h0 = (pxy[3] - pxy[1]) / 2;
	w1 = w0 / 8;
	h1 = h0 / 8;

	vsf_interior(vdi_handle, 3);
	vsf_style(vdi_handle, 3);
	for (m = 0; m < 4; m++)
	{
		vswr_mode(vdi_handle, 1 + m);
		for (n = 0; n < 4; n++)
		{
			vsf_color(vdi_handle, n);

			qxy[0] = pxy[0] + (w1 / 2) + (n * 2 * w1);
			qxy[1] = pxy[1] + (h1 / 2) + (m * 2 * h1);
			qxy[2] = qxy[0] + w1;
			qxy[3] = qxy[1];
			qxy[4] = qxy[0] + (w1 / 4);
			qxy[5] = qxy[1] + 2 * (w1 / 3);	
			qxy[6] = qxy[0] + (w1 / 2);
			qxy[7] = qxy[1] - (w1 / 4);
			qxy[8] = qxy[0] + 3 * (w1 / 4);
			qxy[9] = qxy[1] + 2 * (w1 / 3);	

			v_fillarea(vdi_handle, 5, qxy);
			for (q = 0; q < 10; q += 2) qxy[q] += w0;
			v_fillarea(vdi_handle, 5, qxy);
			for (q = 1; q < 10; q += 2) qxy[q] += h0;
			v_fillarea(vdi_handle, 5, qxy);
			for (q = 0; q < 10; q += 2) qxy[q] -= w0;
			v_fillarea(vdi_handle, 5, qxy);
		}
	}
	vswr_mode(vdi_handle, 1);	

}


/* Contour fill test. DRI's drivers don't support a contour fill operation,
 * so on stock GEM this will just draw the hollow contours. 
 *
 *         +-+     +-+
 *        /|P \   /  |\
 *  	 + |   +-+   | +
 *	 | |         | |
 *	 + |   +-+   | +
 *        \|  /   \  |/
 *         +-+     +-+
 *
 * The test is to fill the shape, starting at the point marked P. 
 * The shape outline is drawn in blue, the vertical lines within in cyan.
 * If a positive number is passed in for the border colour, the fill will
 * go to lines of that colour:
 *
 *         +-+     +-+
 *        /===\   /===\
 *  	 +==== +-+=====+
 *	 |=============|
 *	 +==== +-+ ====+
 *        \===/   \===/
 *         +-+     +-+
 *
 * If a negative number is passed in, the fill goes up to any colour not 
 * matching the pixel at P:
 *
 *         +-+     +-+
 *        /|==\   /==|\
 *  	 + |===+-+===| +
 *	 | |=========| |
 *	 + |===+-+===| +
 *        \|==/   \==|/
 *         +-+     +-+

 */
VOID draw_cfill(void)
{
	WORD	pxy[4];
	WORD	qxy[48];
	WORD 	w0, h0;
	WORD	w1, h1;
	int m, n, q;

	grect_to_array(&work_area, pxy);
	w0 = (pxy[2] - pxy[0]) / 2;
	h0 = (pxy[3] - pxy[1]) / 2;
	w1 = w0 / 8;
	h1 = h0 / 8;

	vsf_interior(vdi_handle, 3);
	vsf_style(vdi_handle, 3);
	for (m = 0; m < 4; m++)
	{
		for (n = 0; n < 4; n++)
		{
			int xstep = w1 / 8;
			int ystep = h1 / 4;

			vswr_mode(vdi_handle, 1);
			qxy[ 0] = pxy[ 0] + (n * 2 * w1) + xstep;
			qxy[ 1] = pxy[ 1] + (m * 2 * h1);
			qxy[ 2] = qxy[ 0] + xstep;
			qxy[ 3] = qxy[ 1];
			qxy[ 4] = qxy[ 2] + xstep;
			qxy[ 5] = qxy[ 1] + ystep;
			qxy[ 6] = qxy[ 4] + xstep;
			qxy[ 7] = qxy[ 5];
			qxy[ 8] = qxy[ 6] + xstep;
			qxy[ 9] = qxy[ 1];
			qxy[10] = qxy[ 8] + xstep;
			qxy[11] = qxy[ 1];
			qxy[12] = qxy[10] + xstep;
			qxy[13] = qxy[ 5];
			qxy[14] = qxy[12];
			qxy[15] = qxy[13] + 2 * ystep;
			qxy[16] = qxy[14] - xstep;
			qxy[17] = qxy[15] + ystep;
			qxy[18] = qxy[16] - xstep;
			qxy[19] = qxy[17]; 
			qxy[20] = qxy[18] - xstep;
			qxy[21] = qxy[19] - ystep;
			qxy[22] = qxy[20] - xstep;
			qxy[23] = qxy[21];
			qxy[24] = qxy[22] - xstep;
			qxy[25] = qxy[17];
			qxy[26] = qxy[24] - xstep;
			qxy[27] = qxy[25];
			qxy[28] = qxy[26] - xstep;
			qxy[29] = qxy[27] - ystep;
			qxy[30] = qxy[28];
			qxy[31] = qxy[29] - 2 * ystep;
			qxy[32] = qxy[0];
			qxy[33] = qxy[1];

			qxy[34] = qxy[0];
			qxy[35] = qxy[1] + 1;
			qxy[36] = qxy[0];
			qxy[37] = qxy[27] - 1;

			qxy[38] = qxy[34] + 5 * xstep;
			qxy[39] = qxy[35];
			qxy[40] = qxy[34] + 5 * xstep;
			qxy[41] = qxy[37];
/* Shape:

	0 1 2 3 4 5 6 7
          +-+     +-+
         /|  \   /  |\
	+ |   +-+   | +
	| |         | |
	+ |   +-+   | +
         \|  /   \  |/
          +-+     +-+

*/
			vsl_color(vdi_handle, 5);
			v_pline(vdi_handle, 2, &qxy[34]);
			v_pline(vdi_handle, 2, &qxy[38]);
			vsl_color(vdi_handle, 4);
			v_pline(vdi_handle, 17, qxy);

			vsf_color(vdi_handle, n);
			vswr_mode(vdi_handle, m + 1);
			v_contourfill(vdi_handle, qxy[0] + 2, qxy[1] + 4, 4);
			vswr_mode(vdi_handle, 1);

			for (q = 0; q < 42; q += 2) qxy[q] += w0;
			vsl_color(vdi_handle, 5);
			v_pline(vdi_handle, 2, &qxy[34]);
			v_pline(vdi_handle, 2, &qxy[38]);
			vsl_color(vdi_handle, 4);
			v_pline(vdi_handle, 17, qxy);
			vsf_color(vdi_handle, n);
			vswr_mode(vdi_handle, m + 1);
			v_contourfill(vdi_handle, qxy[0] + 2, qxy[1] + 4, 4);
			vswr_mode(vdi_handle, 1);

			for (q = 1; q < 42; q += 2) qxy[q] += h0;
			vsl_color(vdi_handle, 5);
			v_pline(vdi_handle, 2, &qxy[34]);
			v_pline(vdi_handle, 2, &qxy[38]);
			vsl_color(vdi_handle, 4);
			v_pline(vdi_handle, 17, qxy);
			vsf_color(vdi_handle, n);
			vswr_mode(vdi_handle, m + 1);
			v_contourfill(vdi_handle, qxy[0] + 2, qxy[1] + 4, -4);
			vswr_mode(vdi_handle, 1);

			for (q = 0; q < 42; q += 2) qxy[q] -= w0;
			vsl_color(vdi_handle, 5);
			v_pline(vdi_handle, 2, &qxy[34]);
			v_pline(vdi_handle, 2, &qxy[38]);
			vsl_color(vdi_handle, 4);
			v_pline(vdi_handle, 17, qxy);
			vsf_color(vdi_handle, n);
			vswr_mode(vdi_handle, m + 1);
			v_contourfill(vdi_handle, qxy[0] + 2, qxy[1] + 4, -4);
			vswr_mode(vdi_handle, 1);

		}
	}
	vswr_mode(vdi_handle, 1);	

}





static UWORD st_udpat[16*16];
/*
 * Test user-defined pattern, supporting up to 16 planes.
 */
VOID draw_udpat()
{
	WORD	pxy[4];
	WORD	qxy[4];
	WORD 	w0, h0;
	WORD	w1, h1;
	int m, n, mask;

	mask = 2;
	/* Fill the pattern with horizontal stripes in different colours */
	for (n = 0; n < 16; n++)
	{
		for (m = 0; m < 16; m++)
		{
			st_udpat[16*n+m] = (m & mask) ? 0xFFFF : 0;
		}
		mask = mask << 1;
	}

	grect_to_array(&work_area, pxy);
	w0 = (pxy[2] - pxy[0]) / 2;
	h0 = (pxy[3] - pxy[1]) / 2;
	w1 = w0 / 8;
	h1 = h0 / 8;

/* And then draw the patterns */
	vsf_udpat(vdi_handle, (WORD *)st_udpat, gl_nplanes);
	vsf_interior(vdi_handle, 4);
	for (m = 0; m < 4; m++)
	{
		vswr_mode(vdi_handle, 1 + m);
		for (n = 0; n < 4; n++)
		{
			vsf_color(vdi_handle, n);
			qxy[0] = pxy[0] + (w1 / 2) + (n * 2 * w1);
			qxy[1] = pxy[1] + (h1 / 2) + (m * 2 * h1);
			qxy[2] = qxy[0] + w1;
			qxy[3] = qxy[1] + w1;
			vr_recfl(vdi_handle, qxy);
			qxy[0] += w0; qxy[2] += w0;
			vr_recfl(vdi_handle, qxy);
			qxy[1] += h0; qxy[3] += h0;
			vr_recfl(vdi_handle, qxy);
			qxy[0] -= w0; qxy[2] -= w0;
			vr_recfl(vdi_handle, qxy);
		}
	}
	vswr_mode(vdi_handle, 1);	
}


/* Display the active page */
VOID draw_display(VOID)
{
	switch(gl_curdisplay)
	{
		case TESTBOX:  draw_boxes(); break;
		case TESTBOX2: draw_boxes2(); break;
		case TESTBOX3: draw_boxes3(); break;
		case TESTBOX4: draw_boxes4(); break;
		case TSTRCLIP: draw_rclip(); break;
		case TESTLINE: draw_lines(); break;
		case TSTLINE2: draw_lines2(); break;
		case TESTMARK: draw_markers(); break;
		case TESTTXT1: draw_text1(); break;
		case TESTTXT2: draw_text2(); break;
		case TESTTXT3: draw_text3(); break;
		case TESTTXT4: draw_text4(); break;
		case TESTTXT5: draw_text5(); break;
		case TESTTXT6: draw_text6(); break;
		case TESTTXT7: draw_text7(); break;
		case TSTBLIT1: draw_blit1(); break;
		case TSTBLIT2: draw_blit2(); break;
		case TSTBLIT3: draw_blit3(); break;
		case TSTBLIT4: draw_blit4(); break;
		case TSTBLIT5: draw_blit5(); break;
		case TSTBLIT6: draw_blit6(); break;
		case TSTBLIT7: draw_blit7(); break;
		case TESTGDP1: draw_gdp1(); break;
		case TESTGDP2: draw_gdp2(); break;
		case TESTGDP3: draw_gdp3(); break;
		case TESTGDP4: draw_gdp4(); break;
		case TESTGDP5: draw_gdp5(); break;
		case TESTGDP6: draw_gdp6(); break;
		case TESTFILL: draw_fill(); break;
		case TESTUDPT: draw_udpat(); break;
		case TESTPAL:  draw_pal(); break;
		case TESTGETP: draw_getp(); break;
		case TSTCELL1: draw_cell1(); break;
		case TSTCELL2: draw_cell2(); break;
		case TSTCFILL: draw_cfill(); break;
		default:
		{
			WORD	pxy[4];

			grect_to_array(&work_area, pxy);
			graf_mouse(M_OFF, 0x0L);
			stipple_background(pxy); 
			graf_mouse(M_ON, 0x0L);
		}
		break;
	}
}


/*------------------------------*/
/*	disp_message		*/
/*------------------------------*/
VOID
disp_mesag(clip_area)	/* display message applying input clip	*/
GRECT	*clip_area;
{
	WORD	pxy[4];

	set_clip(TRUE, clip_area);
	grect_to_array(&work_area, pxy);
	graf_mouse(M_OFF, 0x0L);
	switch(gl_curdisplay)
	{
		case TESTGETP: white_background(pxy); break;
		case TSTLINE2:
		case TESTTXT2:	
		case TESTTXT3:
		case TESTTXT7:
		case TSTBLIT5: 
		case TESTTXT6: solid_background(pxy); break;
		case TSTBLIT1:	
		case TSTBLIT2: 
		case TSTBLIT3:
		case TSTBLIT6: stipple_background(pxy); break;
		default: draw_background(pxy); break;
	}
	vsl_color(vdi_handle,BLACK);
	vswr_mode(vdi_handle,MD_REPLACE);
	vsl_type (vdi_handle,FIS_SOLID);
	vswr_mode(vdi_handle, 1);
	draw_display();
	graf_mouse(M_ON, 0x0L);
	vswr_mode(vdi_handle, 1);
	set_clip(FALSE, clip_area);
}


/* Test the text mode support. Most GEM drivers only allow you to switch in
 * and out of text mode, and don't supply the GSX escape functions to do 
 * text mode drawing. But in case a driver does, this will test it. */
VOID test_curmode(void)
{
	int n;
	WORD w, h, x, y;
	char buf[50];

	/* Switch to text mode */
	v_enter_cur(vdi_handle);
	/* Write this using the BIOS rather than GEM, since we don't know 
	 * if the GEM driver supports v_curtext() */
	cputs("If textmode is supported, output will appear below\n");

	vq_chcells(vdi_handle, &h, &w);
	sprintf(buf, "Screen dimensions: rows=%d cols=%d", h, w);

	x = y = 0;
	/* Move to (10, 10) and see if we're there */
	vs_curaddress(vdi_handle, 10, 10);
	vq_curaddress(vdi_handle, &x, &y);

	if (x != 10 && y != 10)
	{
		cputs("Cursor positioning test failed.\n");
	}


	/* Test the cursor movement and text colouring escapes */
	v_curtext(vdi_handle, buf);
	vs_curaddress(vdi_handle, 14, 14);
	v_curtext(vdi_handle, "->");
	v_curup(vdi_handle);
	v_curtext(vdi_handle, "Up");
	v_curdown(vdi_handle);
	v_curtext(vdi_handle, "Down");
	v_curright(vdi_handle);
	v_curtext(vdi_handle, "Right");
	v_curleft(vdi_handle);
	v_curtext(vdi_handle, "Left");
	v_rvon(vdi_handle);
	v_curtext(vdi_handle, " Inverse");
	v_rvoff(vdi_handle);
	v_curtext(vdi_handle, " Normal");

	/* See if text wraps at the edge of the screen */
	vs_curaddress(vdi_handle, 15, w - 2);
	v_curtext(vdi_handle, "Wrap");

	for (n = 16; n < 22; n++)
	{
		vs_curaddress(vdi_handle, n, 16);
		v_curtext(vdi_handle, "**********");
	}
	/* Test 'delete to end of line' and 'delete to end of screen' */
	vs_curaddress(vdi_handle, 17, 20); v_eeol(vdi_handle);
	vs_curaddress(vdi_handle, 19, 20); v_eeos(vdi_handle);

	/* Use the BIOS to wait for a keypress */
	getch();
	/* Switch back to graphics mode */
	v_exit_cur(vdi_handle);
}



/*------------------------------*/
/*	do_redraw		*/
/*------------------------------*/
VOID
do_redraw(wh, area)		/* redraw message applying area clip	*/
WORD	wh;
GRECT	*area;
{
	GRECT	box;

	graf_mouse(M_OFF, 0x0L);
	wind_get(wh, WF_FIRSTXYWH, &box.g_x, &box.g_y, &box.g_w, &box.g_h);
	while ( box.g_w && box.g_h )
	{
		if (rc_intersect(area, &box))
		{
			if (wh == vtest_whndl)
			{
				disp_mesag(&box);
			}
		}
		wind_get(wh, WF_NEXTXYWH, &box.g_x, &box.g_y, &box.g_w, &box.g_h);
	}
	graf_mouse(M_ON, 0x0L);
}



/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Message Handling			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


BOOLEAN hndl_menu(WORD menu, WORD option)
{
	switch(menu)
	{
		case FILEMENU:
			if (option == FILEQUIT)
				return TRUE;
			break;

		case OTHEMENU:
			switch(option)
			{
				case TESTTIME:
					test_timer();
					break;
				case TESTKEYB:
					test_keyboard();
					break;
			}
			break;

		case VIDMENU:
			if (option == TSTCURMD)
			{
				test_curmode();
			}
			else
			{
				gl_curdisplay = option;
				disp_mesag(&work_area);
			}
			break;
		case DESKMENU:
			if (option == APPABOUT)
			{
				do_about();
			}
			break;
	}
	return FALSE;
}

/* Map keyboard shortcut keys */
BOOLEAN hndl_keybd(WORD key)
{
	WORD kcode = (key & 0xFF);

	if (islower(kcode)) kcode = toupper(kcode);

	switch(kcode)
	{
		case 'Q' - '@': return hndl_menu(FILEMENU, FILEQUIT);
		case '1':	return hndl_menu(VIDMENU, TESTBOX);
		case '2':	return hndl_menu(VIDMENU, TESTLINE);
		case '3':	return hndl_menu(VIDMENU, TESTTXT1);
		case '4':	return hndl_menu(VIDMENU, TESTTXT2);
		case '5':	return hndl_menu(VIDMENU, TESTTXT3);
		case '6':	return hndl_menu(VIDMENU, TESTTXT4);
		case '7':	return hndl_menu(VIDMENU, TESTTXT5);
		case '8':	return hndl_menu(VIDMENU, TESTTXT6);
		case '9':	return hndl_menu(VIDMENU, TESTTXT7);
		case '0':	return hndl_menu(VIDMENU, TSTBLIT1);
		case 'A':	return hndl_menu(VIDMENU, TSTBLIT2);
		case 'B':	return hndl_menu(VIDMENU, TSTBLIT3);
		case 'C':	return hndl_menu(VIDMENU, TSTBLIT4);
		case 'D':	return hndl_menu(VIDMENU, TSTBLIT5);
		case 'E':	return hndl_menu(VIDMENU, TSTBLIT6);
		case 'F':	return hndl_menu(VIDMENU, TSTBLIT7);
		case 'G':	return hndl_menu(VIDMENU, TESTGDP1);
		case 'H':	return hndl_menu(VIDMENU, TESTGDP2);
		case 'I':	return hndl_menu(VIDMENU, TESTGDP3);
		case 'J':	return hndl_menu(VIDMENU, TESTGDP4);
		case 'K':	return hndl_menu(VIDMENU, TESTGDP5);
		case 'L':	return hndl_menu(VIDMENU, TESTGDP6);
		case 'M':	return hndl_menu(VIDMENU, TESTMARK);
		case 'N':	return hndl_menu(VIDMENU, TSTLINE2);
		case 'O':	return hndl_menu(VIDMENU, TSTCFILL);
		case 'P':	return hndl_menu(VIDMENU, TESTPAL);
		case 'Q':	return hndl_menu(VIDMENU, TESTBOX2);
		case 'R':	return hndl_menu(VIDMENU, TSTRCLIP);
		case 'S':	return hndl_menu(VIDMENU, TESTFILL);
		case 'T':	return hndl_menu(VIDMENU, TSTCURMD);
		case 'U':	return hndl_menu(VIDMENU, TESTUDPT);
		case 'V':	return hndl_menu(VIDMENU, TESTBOX3);
		case 'W':	return hndl_menu(VIDMENU, TESTBOX4);
		case 'X':	return hndl_menu(VIDMENU, TESTGETP);
		case 'Y':	return hndl_menu(VIDMENU, TSTCELL1);
		case 'Z':	return hndl_menu(VIDMENU, TSTCELL2);
	}
	return FALSE;
}

/*------------------------------*/
/*	hndl_mesag		*/
/*------------------------------*/
BOOLEAN	hndl_mesag()
{
	GRECT	box;
	BOOLEAN	done; 
	WORD	wdw_hndl;

	done = FALSE;
	wdw_hndl = gl_rmsg[3];			/* wdw handle of mesag	*/
	switch( gl_rmsg[0] )			/* switch on type of msg*/
	{
	case AC_OPEN:				/* do accessory open	*/
		if ( (gl_rmsg[4] == gl_itemvtest) && 
		    (!vtest_whndl) )		/* unless already open	*/
		{
			graf_mouse(HOUR_GLASS, 0x0L);
			/* 0x0B = NAME | CLOSER | MOVER	*/
			vtest_whndl = wind_create(0x000B, align_x(gl_xfull)-1, gl_yfull, gl_wfull, gl_hfull);
			if (vtest_whndl == -1)
			{ 
				graf_mouse(ARROW, 0x0L);
				form_alert(1,
				ADDR("[3][Fatal Error !|Window not available|for VTEST.][ Abort ]"));
				vtest_whndl = 0;
				return(TRUE); 
			}

			wind_set(vtest_whndl, WF_NAME, FP_OFF(wdw_title), FP_SEG(wdw_title), 0, 0);
			wdw_size(&box, gl_wfull, gl_hfull - gl_yfull);
#if	DESKACC					/* open from menu area	*/
			do_open(vtest_whndl, gl_wbox*4, gl_hbox/2, box.g_x, box.g_y, box.g_w, box.g_h);
#else						/* open from screen cntr*/
			do_open(vtest_whndl, gl_wfull/2, gl_hfull/2, box.g_x, box.g_y, box.g_w, box.g_h);
#endif
			wind_get(vtest_whndl, WF_WXYWH,	&work_area.g_x, &work_area.g_y, &work_area.g_w, &work_area.g_h);
			disp_mesag(&work_area);
			graf_mouse(ARROW,0x0L);
		}
		else   
		{
			graf_mouse(ARROW, 0x0L);
			wind_set(vtest_whndl, WF_TOP, 0, 0, 0, 0); 
		}
		break;

	case AC_CLOSE:				/* do accessory close	*/
		if ( (gl_rmsg[3] == gl_itemvtest) &&
		    (vtest_whndl) )
		{
			vtest_whndl = 0;	/* reset window handle	*/
		}
		break;

	case WM_REDRAW:				/* do redraw wdw contnts*/
		do_redraw(wdw_hndl, (GRECT *) &gl_rmsg[4]);
		break;

	case WM_TOPPED:				/* do window topped	*/
		wind_set(wdw_hndl, WF_TOP, 0, 0, 0, 0);
		break;

	case WM_CLOSED:				/* do window closed	*/
#if	DESKACC					/* close to menu bar	*/
		do_close(vtest_whndl, gl_wbox*4, gl_hbox/2);
#else						/* close to screen cntr	*/
		do_close(vtest_whndl, gl_wfull/2, gl_hfull/2);
#endif
		wind_delete(vtest_whndl);
		vtest_whndl = 0;
		done = TRUE;
		break;

	case WM_MOVED:				/* do window move	*/
		wind_set(wdw_hndl, WF_CXYWH, align_x(gl_rmsg[4])-1, gl_rmsg[5], gl_rmsg[6], gl_rmsg[7]);
		wind_get(vtest_whndl, WF_WXYWH,	&work_area.g_x, &work_area.g_y, &work_area.g_w, &work_area.g_h);
		break;

	case MN_SELECTED:
		done = hndl_menu(gl_rmsg[3], gl_rmsg[4]);
		if (done)
		{
#if	DESKACC					/* close to menu bar	*/
			do_close(vtest_whndl, gl_wbox*4, gl_hbox/2);
#else						/* close to screen cntr	*/
			do_close(vtest_whndl, gl_wfull/2, gl_hfull/2);
#endif
			wind_delete(vtest_whndl);
			vtest_whndl = 0;
		}
		break;

	default:
		break;
	} /* switch */
	return(done);
} /* hndl_mesag */



/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    VTEST Event Handler			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


/*------------------------------*/
/*	vtest			*/
/*------------------------------*/
vtest()
{
	BOOLEAN	done;
	UWORD mousex, mousey, bstate, kstate, kreturn, bclicks;

	/**/					/* loop handling user	*/
	/**/					/*   input until done	*/
	done = FALSE;				/*   -or- if DESKACC	*/
	while( !done )				/*   then forever	*/
	{
		ev_which = evnt_multi(MU_KEYBD | MU_MESAG,
			0, 0, 0,
			0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,
			ad_rmsg, 0, 0,
			&mousex, &mousey, &bstate, &kstate,
			&kreturn, &bclicks);	/* wait for message	*/
		wind_update(BEG_UPDATE);	/* begin window update	*/
		if (ev_which & MU_KEYBD)
			done = hndl_keybd(kreturn);
		if (ev_which & MU_MESAG)
			done = hndl_mesag();	/* handle event message	*/
		wind_update(END_UPDATE);	/* end window update	*/
#if	DESKACC
		done = FALSE;	/* never exit loop for desk accessory	*/
#endif
	}
}


/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Termination				     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


/*------------------------------*/
/*	vtest_term		*/
/*------------------------------*/  
vtest_term(int deinit) 
{
#if	DESKACC
	return(FALSE);			/* Desk Accessory never ends	*/
#else
	switch(deinit)
	{
		case 0:
		case 3:
			menu_bar(0, FALSE);
		case 2:
			v_clsvwk( vdi_handle );	
		case 1:
	//		wind_update(END_UPDATE);
			appl_exit();
		case 4:
			break;
	}
#endif
}

/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Initialization			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/

VOID vdi_fix(LPMFDB pfd, LPVOID theaddr, WORD wb, WORD h)
{
        pfd->fww = wb >> 1;             /* # of bytes to words          */
        pfd->fwp = wb << 3;             /* # of bytes to to pixels      */
        pfd->fh = h;                    /* height in scan lines         */
        pfd->np = 1;                    /* number of planes             */
        pfd->mp = theaddr;              /* memory pointer               */
}


/* Convert a bitmap into screen native format - which usually means 
 * swapping high/low bytes */
WORD vdi_trans(LPVOID saddr, UWORD swb, LPVOID daddr, UWORD dwb, UWORD h)
{
        MFDB            src, dst;       /* local MFDB                   */

        memset(&src, 0, sizeof(MFDB));
        memset(&dst, 0, sizeof(MFDB));

        vdi_fix(&src, saddr, swb, h);
        src.ff = TRUE;                  /* standard format              */

        vdi_fix(&dst, daddr, dwb, h);
        dst.ff = FALSE;                 /* transform to device          */
        /**/                            /*  specific format             */

        vr_trnfm(vdi_handle, &src, &dst );
}




/*------------------------------*/
/*	vtest_init		*/
/*------------------------------*/
WORD
vtest_init()
{
	WORD	i;
	WORD	work_in[11];
	WORD	attributes[10];
	LPTREE	tree;

	gl_apid = appl_init(NULL);			/* initialize libraries	*/
	wind_update(BEG_UPDATE);
	graf_mouse(HOUR_GLASS, 0L);
	if (!rsrc_load("vtest.rsc"))
	{
		graf_mouse(ARROW, 0);
		form_alert(1, "[3][Fatal Error!|VTEST.RSC|File Not Found][ Abort ]");
		return 1;
	}
	for (i=0; i<10; i++)
	{
		work_in[i]=1;
	}
	work_in[10]=2;
	gem_handle = graf_handle(&gl_wchar,&gl_hchar,&gl_wbox,&gl_hbox);
	vdi_handle = gem_handle;
	v_opnvwk(work_in,&vdi_handle,work_out);	/* open virtual work stn*/

	/* Work out how many planes there are, by taking the base2 log
	 * of the number of colours. */
	gl_nplanes = 0;
	i = work_out[13];	/* Number of colours */
	while (i != 1)
	{
		++gl_nplanes;
		i >>= 1;
	}
	fdbScreen.mp = 0;
	fdbScreen.fwp = work_out[0];
	fdbScreen.fh  = work_out[1];
	fdbScreen.fww = work_out[0] / 16;
	fdbScreen.ff  = 0;

	/* ViewMAX does not support vqt_attributes, so bail out rather than
 	 * risk programming error. */
	
	if (!vqt_attributes(vdi_handle, attributes))	/* get text attributes	*/
	{
		form_alert(1, "[3][VTEST cannot load.|"
                      "This version of GEM does not|"
                      "support the vqt__attributes call.][ OK ]");
#ifdef DESKACC	/* DAs can't terminate. Instead, just don't register our */
                /* menu option, so the drawing code will never be called. */
		type_size = 0;
#else
		return FALSE;
#endif
	}
	type_size = attributes[7];		/* get system font hbox	*/
	
#if	DESKACC					/* enter vtest in menu	*/
	if (type_size)	/* Only if vqt_attributes() worked */
		gl_itemvtest = menu_register(gl_apid, ADDR("  VTEST") );
#else
	if (vdi_handle == 0)
		return 1;
#endif

	/* Convert the app icon in the about box */
	rsrc_gaddr(R_TREE, ABOUTBOX, (LPVOID *)&tree);
	trans_gimage(vdi_handle, tree, APPICON); 

	/* And convert the bitmap used for blit testing */
	rsrc_gaddr(R_IMAGEDATA, BITMAP1, (LPVOID *)&gl_bitmap);
	vdi_trans(gl_bitmap->bi_pdata, gl_bitmap->bi_wb, 
		  gl_bitmap->bi_pdata, gl_bitmap->bi_wb,
		gl_bitmap->bi_hl);

						/* init. message address*/
/*#ifdef  LARGE					
	ad_rmsg = (LONG) ADDR((BYTE *) &gl_rmsg[0]);
#else
*/
	ad_rmsg = ADDR((BYTE *) &gl_rmsg[0]);
/*#endif	*/
	vq_extnd(vdi_handle, 1, ext_work_out);
	wind_get(DESK, WF_WXYWH, &gl_xfull, &gl_yfull, &gl_wfull, &gl_hfull);

	rsrc_gaddr(R_TREE, APPMENU, (LPVOID *)&gl_menu);
	menu_bar(gl_menu, TRUE);
	graf_mouse(ARROW, 0);
	wind_update(END_UPDATE);
	return 0;
}

/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Main Program			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


/*------------------------------*/
/*	GEMAIN			*/
/*------------------------------*/
WORD GEMAIN(WORD argc, BYTE *ARGV[])
{
	int res = vtest_init();

	if (res == 0)			/* initialization	*/
	{
#if	DESKACC
		vtest();
#else						/* simulate AC_OPEN	*/
		gl_rmsg[0] = AC_OPEN;
		gl_rmsg[4] = gl_itemvtest;
		hndl_mesag();

		vtest();
#endif
	}
	vtest_term(res);	
	return 0;
}

