/************************************************************************

    UITEST - program to demonstrate ViewMAX/3 UI features

    Copyright (C) 1999  John Elliott <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*************************************************************************/

/* Standard includes */

#include <stdio.h>
#include "ppdgem.h"



/* Non-prototyped library function */

GLOBAL VOID trans_gimage(WORD vdi_handle, LPTREE tree, WORD obj);

/* ICOLOAD.C */

int load_ico(FILE *fp, MFDB *icon, MFDB *mask);
int load_bmp(FILE *fp, MFDB *bmp);







/* If CHEAT is defined, images will be loaded in VGA16 device-dependent
 * format instead of device-independent. This saves time and memory
 * because vdi_trans() isn't necessary to convert them from 
 * device-independent format. However, it makes the program unportable 
 */

#define CHEAT 1


/* If DEBUG is 1, then trace messages are written to DEBUGFILE 
 * and memory allocation and deallocation is monitored. This is rather
 * important in 16-bit programs what with GEM taking a fair amount of
 * memory as well.
 */

#define DEBUG 1
#define DEBUGFILE "D:/GEMAPP.LOG"


/* Traced allocate/free operations. These record every memory
 * allocate and free. 
 *
 * llalloc() and llfree() take three arguments, the second two being
 * the line and file from which they are used. 
 * 
 * The macros lalloc() and lfree() automatically generate these parameters.
 *
 * memcheck() will list unallocated blocks.
 *
 * TRACE writes messages to the debug log. Since macros can't take 
 * variable numbers of arguments in Pacific, you need to pass everything
 * in double brackets:
 *
 *  TRACE(("File %s", str)); 
 *
 */
	
#if DEBUG
	LPVOID llalloc(long t, int line, char *file);
	VOID llfree(LPVOID t, int line, char *file);
	VOID memcheck(VOID);
	void TRACE1(char *s, ...);
	#define TRACE(x) TRACE1 x
	#define lalloc(x) llalloc(x, __LINE__, __FILE__)
	#define lfree(x)  llfree(x, __LINE__, __FILE__)

#else

	#define lalloc dos_alloc
	#define lfree dos_free
	#define memcheck()
	#define TRACE(x)

#endif

