/************************************************************************

    UITEST - test new user-interface features in FreeGEM

    Copyright (C) 1999  John Elliott <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*************************************************************************/


#include "ppdgem.h"
#include <dos.h>				// for FP_OFF and FP_SEG macros
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "uidemo.h"				// resources
#include "oblib.h"
#include "uitest.h"
#include "popmenu.h"

/*------------------------------*/
/*	defines			*/
/*------------------------------*/

#define	ARROW		0
#define	HOUR_GLASS	2			

#define	DESK		0

#define END_UPDATE	0
#define	BEG_UPDATE	1


#if DEBUG

#define TRACE(x) TRACE1 x

void TRACE1(char *s, ...);
#else
#define TRACE(x)
#endif

/* The Pacific libc functions malloc() and free() are not used here,
 * because malloc() can't allocate >64k. lalloc() and lfree() are
 * used instead.
 */


/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Data Structures			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


/*------------------------------*/
/*	Global			*/
/*------------------------------*/

X_BUF_V2 gl_xbuf;
LPTREE   gl_menu;

/* No scrollbars. No resize */
#define WDW_STYLE	(NAME | CLOSER | MOVER)

/*------------------------------*/
/*	Local			*/
/*------------------------------*/

WORD	gl_wchar;			/* character width		*/
WORD	gl_hchar;			/* character height		*/
WORD	gl_wbox;			/* box (cell) width		*/
WORD	gl_hbox;			/* box (cell) height		*/
WORD	gem_handle;			/* GEM vdi handle		*/
WORD	vdi_handle;			/* app vdi handle		*/
WORD	work_out[57];			/* open virt workstation values	*/
GRECT	work_area;			/* current window work area	*/
GRECT   bar_area;			/* Work area for the "taskbar" window */
GRECT   butn_area;			/* Work area for the "start" button */
WORD    gl_evset = MU_MESAG;/* What event set to use */
WORD	gl_apid;			/* application ID		*/
WORD	gl_rmsg[8];			/* message buffer		*/
LPBYTE	ad_rmsg;			/* LONG pointer to message bfr	*/
WORD	gl_xfull;			/* full window 'x'		*/
WORD	gl_yfull;			/* full window 'y'		*/
WORD	gl_wfull;			/* full window 'w' width	*/
WORD	gl_hfull;			/* full window 'h' height	*/
WORD	ev_which;			/* event message returned value	*/
WORD	skel_whndl = 0;		/* skel window handle		*/
WORD	bar_whndl  = 0;		/* Taskbar window handle */
BYTE	*wdw_title = " UI test ";		/* blank window title		*/
BYTE	*info_line = "info line";
WORD	gl_itemskel = 0;	/* Menu item (cf Hello) */
WORD	skel_wnd_w, skel_wnd_h;
MFDB	gl_mfimage;			/* MFDB for icon image */
MFDB	gl_mfmask;			/* Mask for icon image */
MFDB	gl_mfbitmap;		/* MFDB for bitmap image */
UWORD	m_out = FALSE;		/* mouse over "start" button? */
/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Local Procedures			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/

MLOCAL VOID vdi_trans(WORD vdi_handle, LPVOID saddr, WORD swb, 
                                       LPVOID daddr, WORD dwb, WORD h);



/*******************************************************
 * If this were C++, I would be writing an MFDB class. *
 * As it is, I'm faking one.                           *
 *******************************************************/


/* "Construct" an empty MFDB */
VOID new_mfdb(MFDB *new)
{
	new->mp = NULL;
}

/* "Construct" an MFDB with a size */
MLOCAL BOOLEAN create_mfdb(MFDB *new, WORD fww, WORD fh, WORD np)
{
	new->fww = fww;
	new->fh  = fh;
	new->np  = np;

	new->mp  = lalloc(2L * fww * fh * np);

	if (new->mp) return TRUE;
	return FALSE;
}


MLOCAL VOID delete_mfdb(MFDB *del)
{
	if (del->mp) lfree(del->mp);
	del->mp = 0;
}
 

/* Make a "deep" copy of an MFDB */
MLOCAL BOOLEAN copy_mfdb(MFDB *src, MFDB *dst)
{
	long count = 2L * src->np * src->fh * src->fww;
	
	delete_mfdb(dst);
	memcpy(dst, src, sizeof(MFDB));
	dst->mp = lalloc(count);

	if (!dst->mp) return FALSE;
	
	for (count--; count >= 0; count--)
		((LPBYTE)dst->mp)[count] = ((LPBYTE)src->mp)[count];
	return TRUE;
}

                                       

/* Make a copy of an MFDB, and ensure it's in device-independent format */
                                   
BOOLEAN make_dib(MFDB *src, MFDB *dst)
{
	if (!copy_mfdb(src, dst)) return FALSE;
	
	if (src->ff == 1) return TRUE;

	dst->ff = 1;
	
    vr_trnfm(vdi_handle, src, dst ); 
	return TRUE;
}

/* Make a copy of an MFDB, and ensure it's in device-dependent format */
                                       
BOOLEAN make_ddb(MFDB *src, MFDB *dst)
{
	if (!copy_mfdb(src, dst)) return FALSE;
	
	if (src->ff == 0) return TRUE;

	dst->ff = 0;
	
    vr_trnfm(vdi_handle, src, dst ); 
	return TRUE;
}

/*******************************************************
 * End of MFDB class                                   *
 *******************************************************/


/* Utilities from the Professional GEM articles */


VOID send_redraw(WORD wh, GRECT *p)
	{
	WORD	msg[8];

	msg[0] = WM_REDRAW;		/* Defined in GEMBIND.H	    */
	msg[1] = gl_apid;		/* As returned by appl_init */
	msg[2] = 0;
	msg[3] = wh;			/* Handle of window to redraw */
	msg[4] = p->g_x;
	msg[5] = p->g_y;
	msg[6] = p->g_w;
	msg[7] = p->g_h;
	appl_write(gl_apid, 16, ADDR(msg));	/* Use ADDR(msg) for portability */
	}

VOID get_path(BYTE *tmp_path, BYTE *spec)	/* get directory path name		*/
{
	WORD	cur_drv;

	cur_drv     = dos_gdrv();
	tmp_path[0] = cur_drv + 'A';
	tmp_path[1] = ':';
	tmp_path[2] = '\\';
	dos_gdir(cur_drv+1, ADDR(&tmp_path[3]));
	if (strlen(tmp_path) > 3) strcat(tmp_path, "\\");
	else                      tmp_path[2] = '\0';

	strcat(tmp_path, spec);
}


VOID add_file_name(BYTE *dname, BYTE *fname)
{
	BYTE	c;
	WORD	ii;

	ii = strlen(dname);
	while (ii && (((c = dname[ii-1])  != '\\') && (c != ':')))
		ii--;
	dname[ii] = '\0';
	strcat(dname, fname);
}




FILE *get_file(BOOLEAN loop, BYTE *file_name, BYTE *mask)		
{
	WORD	fs_iexbutton;
	BYTE	fs_iinsel[13];
	FILE	*fp;
	
	while (TRUE)
	{
		get_path(file_name, mask);
		fs_iinsel[0] = '\0'; 

		fsel_input(ADDR(file_name), ADDR(fs_iinsel), &fs_iexbutton);
		if (fs_iexbutton)
		{
			add_file_name(file_name, fs_iinsel);
			fp = fopen(file_name, "r+b");
			if (!loop || (loop && fp != NULL))
				return(fp);
		}
		else   
		{
			return((FILE *)NULL);   
		}
	}
	return ((FILE *)NULL);
} /* get_file */



/*------------------------------*/
/*	do_open			*/
/*------------------------------*/
WORD do_open(WORD wh, WORD org_x, WORD org_y, 
             WORD x,  WORD y, WORD w, WORD h)	/* grow and open specified wdw	*/
{
	WORD	ret_code;

	graf_mouse(2,0x0L);
	graf_growbox(org_x, org_y, 21, 21, x, y, w, h);
	ret_code = wind_open(wh, x, y, w, h);
	graf_mouse(ARROW,0x0L);
	return(ret_code);
}


/*------------------------------*/
/*	do_close		*/
/*------------------------------*/
VOID do_close(WORD wh, WORD org_x, WORD org_y)	/* close and shrink specified window	*/
{
	WORD	x, y, w, h;

	graf_mouse(2,0x0L);
	wind_get(wh, WF_CXYWH, &x, &y, &w, &h);
	wind_close(wh);
	graf_shrinkbox(org_x, org_y, 21, 21, x, y, w, h);
	graf_mouse(ARROW,0x0L);
}

/*------------------------------*/
/*	set_clip		*/
/*------------------------------*/
VOID set_clip(WORD clip_flag, GRECT *s_area)	/* set clip to specified area		*/
{
	WORD	pxy[4];

	rc_grect_to_array(s_area, pxy);
	vs_clip(vdi_handle, clip_flag, pxy);
}

/*------------------------------*/
/*	align_x			*/
/*------------------------------*/
WORD align_x(WORD x)		/* forces word alignment for column positon,	*/
							/*   rounding to nearest word			*/
{
	return((x & 0xfff0) + ((x & 0x000c) ? 0x0010 : 0));
}	

/*------------------------------*/
/*	wdw_size		*/
/*------------------------------*/
VOID wdw_size(GRECT *box)	/* compute window size for given skel size	*/
{
	WORD	pw = skel_wnd_w, ph = skel_wnd_h;

	wind_calc(WC_BORDER, WDW_STYLE, gl_wfull/2-pw/2, gl_hfull/2-ph/2, pw, ph, &box->g_x, &box->g_y, &box->g_w, &box->g_h);
	box->g_x = align_x(box->g_x) - 1;	/* byte-align */
	if (box->g_y < gl_yfull) box->g_y = gl_yfull;
}


/*------------------------------*/
/*	disp_message		*/
/*------------------------------*/
VOID paint_bmp(GRECT *clip_area)	
{
/* Draw the currently loaded bitmap in the window */
	
	WORD	pxy[8];
	MFDB	scrMFDB;
	MLOCAL WORD fgbg[] = {WHITE, BLACK};
	
	scrMFDB.mp  = 0;
	scrMFDB.fwp = work_out[0];
	scrMFDB.fh  = work_out[1];
	scrMFDB.fww = work_out[0] / 16;
	scrMFDB.ff  = 0;
	
	set_clip(TRUE, clip_area);
	vsf_interior(vdi_handle, 1);
	vsf_color(vdi_handle, BLACK);
	rc_grect_to_array(&work_area, pxy);
	graf_mouse(M_OFF, 0x0L);
	vr_recfl(vdi_handle, pxy);
	
	if (gl_mfbitmap.mp)
	{
		pxy[0] = pxy[1] = 0;
		pxy[2] = gl_mfbitmap.fwp - 1;
		pxy[3] = gl_mfbitmap.fh  - 1;
	
		pxy[4] = work_area.g_x + pxy[0] + 10;
		pxy[5] = work_area.g_y + pxy[1] + 10;
		pxy[6] = work_area.g_x + pxy[2] + 10;
		pxy[7] = work_area.g_y + pxy[3] + 10;
		if (gl_mfbitmap.np == 1)
		     vrt_cpyfm(vdi_handle, 3, pxy, &gl_mfbitmap, &scrMFDB, fgbg);
		else vro_cpyfm(vdi_handle, 3, pxy, &gl_mfbitmap, &scrMFDB);
	}
	else if (gl_mfimage.mp)
	{
		pxy[0] = pxy[1] = 0;
		pxy[2] = gl_mfimage.fwp - 1;
		pxy[3] = gl_mfimage.fh  - 1;
	
		pxy[4] = work_area.g_x + pxy[0] + 10;
		pxy[5] = work_area.g_y + pxy[1] + 10;
		pxy[6] = work_area.g_x + pxy[2] + 10;
		pxy[7] = work_area.g_y + pxy[3] + 10;
		if (gl_mfimage.np == 1)
			 vrt_cpyfm(vdi_handle, 3, pxy, &gl_mfimage, &scrMFDB, fgbg);
		else vro_cpyfm(vdi_handle, 3, pxy, &gl_mfimage, &scrMFDB);

	}
	graf_mouse(M_ON, 0x0L);
	set_clip(FALSE, clip_area);
}


WORD paint_bar(GRECT *clip_area)
{
	LPTREE	tree;
	WORD	pxy[8];

	rsrc_gaddr( R_TREE, TASKBAR, (LPVOID *)&tree) ;
	
	set_clip(TRUE, clip_area);
	vsf_interior(vdi_handle, 1);
	vsf_color(vdi_handle, BLACK);
	rc_grect_to_array(clip_area, pxy);
	graf_mouse(M_OFF, 0x0L);

	vsf_interior(vdi_handle, 1);
	vsf_color(vdi_handle, RED);
	vr_recfl(vdi_handle, pxy);

	
	tree->ob_x = 0;
	tree->ob_width = gl_wfull;

	tree->ob_y = gl_yfull + gl_hfull - tree->ob_height;

	objc_draw(tree, ROOT, MAX_DEPTH, clip_area->g_x, clip_area->g_y,
						  clip_area->g_w, clip_area->g_h);
	
	graf_mouse(M_ON, 0x0L);
	set_clip(FALSE, clip_area);


}






/*------------------------------*/
/*	do_redraw		*/
/*------------------------------*/
VOID
do_redraw(wh, area)		/* redraw message applying area clip	*/
WORD	wh;
GRECT	*area;
{
	GRECT	box;

	graf_mouse(M_OFF, 0x0L);
	wind_get(wh, WF_FIRSTXYWH, &box.g_x, &box.g_y, &box.g_w, &box.g_h);
	while ( box.g_w && box.g_h )
	{
		if (rc_intersect(area, &box))
		{
			if (wh == skel_whndl)
			{
				paint_bmp(&box);
			}
			if (wh == bar_whndl)
			{
				paint_bar(&box);
			}
		}
		wind_get(wh, WF_NEXTXYWH, &box.g_x, &box.g_y, &box.g_w, &box.g_h);
	}
	graf_mouse(M_ON, 0x0L);
}


WORD
hndl_dial(tree, def, x, y, w, h)	/* general purpose dialog 	*/
LPTREE	tree; 				/*  handler. Provides for 	*/
WORD	def;				/*  extended object type 	*/
WORD	x, y, w, h; 			/*  checking and 'local'	*/
{  					/*  processing of extended 	*/
					/*  type objects		*/

	WORD	xdial, ydial, wdial, hdial, exitobj;
	WORD 	indial = 1;
	
	form_center(tree, &xdial, &ydial, &wdial, &hdial);  /* returns 	*/
	/**/				/* screen center x,y,w,h	*/
	
	form_dial(0, x, y, w, h, xdial, ydial, wdial, hdial);/* reserves*/
	/**/				/* screen space for dialog box	*/

	form_dial(1, x, y, w, h, xdial, ydial, wdial, hdial);/*  draws 	*/
	/**/				/* expanding box		*/
	
	objc_draw(tree, ROOT, MAX_DEPTH, xdial, ydial, wdial, hdial);

	while (indial)
	{
		exitobj = form_do(tree, def) & 0x7FFF;

		switch(exitobj)
		{
			case BTNSEL:
			tree[ICON1].ob_state ^= SELECTED;
			objc_draw(tree, ICON1, 0, xdial, ydial, wdial, hdial);
			break;
			
			case BTND3D:
			tree[ICON1].ob_state ^= DRAW3D;
			objc_draw(tree, ICON1, 0, xdial, ydial, wdial, hdial);
			break;

			case BTNCRS:
			tree[ICON1].ob_state ^= CROSSED;
			objc_draw(tree, ICON1, 0, xdial, ydial, wdial, hdial);
			break;
			case BTNWBG:
			tree[ICON1].ob_state ^= WHITEBAK;
			objc_draw(tree, ICON1, 0, xdial, ydial, wdial, hdial);
			break;
			case BTNDIS:
			tree[ICON1].ob_state ^= DISABLED;
			objc_draw(tree, ICON1, 0, xdial, ydial, wdial, hdial);
			break;
			case BTNCHK:
			tree[ICON1].ob_state ^= CHECKED;
			objc_draw(tree, ICON1, 0, xdial, ydial, wdial, hdial);
			break;
			case BTNOUT:
			tree[ICON1].ob_state ^= OUTLINED;
			objc_draw(tree, ICON1, 0, xdial, ydial, wdial, hdial);
			break;
			case BTNSHAD:
			tree[ICON1].ob_state ^= SHADOWED;
			objc_draw(tree, ICON1, 0, xdial, ydial, wdial, hdial);
			break;

			default: 
			indial = 0;
			break;		
		}
	}

	form_dial(2, x, y, w, h, xdial, ydial, wdial, hdial);/* draws a	*/
	/**/				/* shrinking box 		*/
  
	form_dial(3, x, y, w, h, xdial, ydial, wdial, hdial);/* free 	*/
	/**/				/* screen space, causes redraw	*/

	return (exitobj);
}


VOID
objc_xywh(tree, obj, p)		/* get x,y,w,h for specified object	*/
LPTREE	tree;
WORD	obj;
GRECT	*p;
{
	objc_offset(tree, obj, &p->g_x, &p->g_y);
	p->g_w = tree[obj].ob_width;	//LWGET(OB_WIDTH(obj));
	p->g_h = tree[obj].ob_height;	//LWGET(OB_HEIGHT(obj));
}



WORD dial_clricon ()
{		    
	LPTREE	tree;
	GRECT	box;
	LPICON  ib;
	
	objc_xywh(gl_menu, CLRICN, &box);
	rsrc_gaddr( R_TREE, DLGCICN, (LPVOID *)&tree) ;

	ib = (LPICON)tree[ICON1].ob_spec;
	
	tree[ICON1].ob_type = G_CLRICN;
	ib->ib_pdata = ADDR(&gl_mfimage);
	ib->ib_pmask = ADDR(&gl_mfmask);
	ib->ib_ytext = 40;
	
	hndl_dial(tree, DLGCICN, box.g_x, box.g_y, box.g_w, box.g_h);

	tree[BTNCLOSE].ob_state &= (~SELECTED);
}





WORD hndl_menu(WORD menu, WORD item)
{
	MFDB ticon, tmask;
	LPTREE tree;
	FILE *fp;
	int r;
	char	filename[160];
	
	
	switch(menu)
	{
		case FILEMENU:
			if (item == ITEMQUIT) return 1;
			break;

		case TBARMENU:
			switch(item)
			{
				case MKTBAR:

				if (bar_whndl) break;
				bar_whndl = wind_create(0, align_x(gl_xfull)-1, gl_yfull, gl_wfull, gl_hfull);
				if (bar_whndl == -1) 
				{
					form_alert(1, "[3][GEM does not have|"
					           "any windows left.][ Cancel ]");
					break;
				}

				rsrc_gaddr( R_TREE, TASKBAR, (LPVOID *)&tree) ;
				tree->ob_y = gl_yfull + gl_hfull - tree->ob_height;
				tree->ob_width = gl_wfull;
				wind_open(bar_whndl, 0, tree->ob_y,
				                                gl_wfull, tree->ob_height);

				bar_area.g_x = 0;
				bar_area.g_y = tree->ob_y;
				bar_area.g_w = gl_wfull;
				bar_area.g_h = tree->ob_height;
				gl_evset |= MU_BUTTON | MU_M1;

				/* Work out the area occupied by the "Start" button */
				objc_xywh(tree, BTNSTART, &butn_area);
				
				send_redraw(bar_whndl, &bar_area);
				break;

				case BITBTN:

				rsrc_gaddr( R_TREE, TASKBAR, (LPVOID *)&tree) ;
				tree[BTNSTART].ob_flags ^= BITBUTTON;
				send_redraw(bar_whndl, &bar_area);
				menu_icheck(gl_menu, BITBTN, tree[BTNSTART].ob_flags & BITBUTTON);
				break;
				
				
				
			}
			break;
			
		case TESTMENU: 
			switch(item)
			{
				case DESKTILE:

					gl_mfbitmap.r1 = 2;
					xgrf_dtimage(&gl_mfbitmap);
					break;
					
				case DESKCNTR:
					gl_mfbitmap.r1 = 1;
					xgrf_dtimage(&gl_mfbitmap);
					break;
				case CLRICN:
					dial_clricon();
					break;
				case LOADICO:
					fp = get_file(TRUE, filename, "*.ICO");
					if (!fp) break;
					
					if (r = load_ico(fp, &ticon, &tmask))
					{
						sprintf(filename, "[3][Failed to load file|"
						                  "error = %d][ Cancel ]", r);
						form_alert(1, filename);
						fclose(fp);
						break;
					}
					fclose(fp);

#if CHEAT
					/* Cheating: The MFDBs are currently in device-specific
					 * format. Use them as-is. */

					delete_mfdb(&gl_mfimage);
					delete_mfdb(&gl_mfmask);
					memcpy(&gl_mfimage, &ticon, sizeof(MFDB));
					memcpy(&gl_mfmask,  &tmask, sizeof(MFDB));
#else
					
					
					/* These MFDBs are currently in device-independent 
					 * format. Transform them. */

					if (!make_ddb(&ticon, &gl_mfimage) ||
					    !make_ddb(&tmask, &gl_mfmask))
					    {
						form_alert(1,"[3][Not enough memory to load image][Abandon]");
						break;
					    }
					delete_mfdb(&ticon);
					delete_mfdb(&tmask);

					if (!copy_mfdb(&gl_mfimage, &gl_mfbitmap))
					{
						form_alert(1,"[3][Not enough memory to load image][Abandon]");
					}
#endif


					send_redraw(skel_whndl, &work_area);
					break;
					
				case LOADBMP:
					TRACE(("Entering LOADBMP\n"));
					fp = get_file(TRUE, filename, "*.BMP");
					if (!fp) break;
					
					TRACE(("File chosen\n"));
					if (r = load_bmp(fp, &ticon))
					{
						sprintf(filename, "[3][Failed to load file|"
						                  "error = %d][ Cancel ]", r);
						form_alert(1, filename);
						fclose(fp);
						break;
					}
					fclose(fp);
					xgrf_dtimage(NULL);
#if CHEAT
					/* Cheating: The MFDBs is currently in device-specific
					 * format. Use it as-is. */

					delete_mfdb(&gl_mfbitmap);
					memcpy(&gl_mfbitmap, &ticon, sizeof(MFDB));

#else					
					/* The MFDB is in device-independent 
					 * format. Transform it. */

					if (!make_ddb(&ticon, &gl_mfbitmap))
					    {
						form_alert(1,"[3][Not enough memory to load image][Abandon]");
						delete_mfdb(&ticon);
						copy_mfdb(&gl_mfimage,&gl_mfbitmap);
						break;
					    }
					delete_mfdb(&ticon);
#endif
					send_redraw(skel_whndl, &work_area);
					break;
			}
		case DESKMENU:
			if (item == ITEMABOU)
			{
				form_alert(1, "[2][This program tests ViewMAX/3|"
				                  "features in the GEM AES][ OK ]");
			}
			break;
	}
	return 0;
}


/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Message Handling			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


/*------------------------------*/
/*	hndl_mesag		*/
/*------------------------------*/
BOOLEAN	hndl_mesag()
{
	GRECT	box;
	BOOLEAN	done; 
	WORD	wdw_hndl;

	done = FALSE;
	wdw_hndl = gl_rmsg[3];			/* wdw handle of mesag	*/
	switch( gl_rmsg[0] )			/* switch on type of msg*/
	{
	case MN_SELECTED:
		done = hndl_menu(wdw_hndl, gl_rmsg[4]);/* Title, Item	*/
		break;
		
	case AC_OPEN:				/* do accessory open	*/
		if ( (gl_rmsg[4] == gl_itemskel) && 
		    (!skel_whndl) )		/* unless already open	*/
		{
			graf_mouse(HOUR_GLASS, 0x0L);
			skel_whndl = wind_create(WDW_STYLE, align_x(gl_xfull)-1, gl_yfull, gl_wfull, gl_hfull);
			if (skel_whndl == -1)
			skel_whndl = wind_create(WDW_STYLE, align_x(gl_xfull)-1, gl_yfull, gl_wfull, gl_hfull);
			if (skel_whndl == -1)
			{ 
				graf_mouse(ARROW, 0x0L);
				form_alert(1,
				ADDR("[3][Fatal Error !|Window not available|for this program.][ Abort ]"));
				skel_whndl = 0;
				return(TRUE); 
			}

			wind_set(skel_whndl, WF_NAME, FP_OFF(wdw_title), FP_SEG(wdw_title), 0, 0);
			wind_set(skel_whndl, WF_INFO, FP_OFF(info_line), FP_SEG(info_line), 0, 0);
			wdw_size(&box);
						/* open from screen cntr*/
			do_open(skel_whndl, gl_wfull/2, gl_hfull/2, box.g_x, box.g_y, box.g_w, box.g_h);

			wind_get(skel_whndl, WF_WXYWH,	&work_area.g_x, &work_area.g_y, &work_area.g_w, &work_area.g_h);
			paint_bmp(&work_area);
			graf_mouse(ARROW,0x0L);
		}
		else   
		{
			graf_mouse(ARROW, 0x0L);
			wind_set(skel_whndl, WF_TOP, 0, 0, 0, 0); 
		}
		break;

	case AC_CLOSE:				/* do accessory close	*/
		if ( (gl_rmsg[3] == gl_itemskel) &&
		    (skel_whndl) )
		{
			skel_whndl = 0;	/* reset window handle	*/
		}
		break;

	case WM_REDRAW:				/* do redraw wdw contnts*/
		do_redraw(wdw_hndl, (GRECT *) &gl_rmsg[4]);
		break;

	case WM_TOPPED:				/* do window topped	*/
		wind_set(wdw_hndl, WF_TOP, 0, 0, 0, 0);
		break;

	case WM_CLOSED:				/* do window closed	*/
		do_close(skel_whndl, gl_wfull/2, gl_hfull/2);
		wind_delete(skel_whndl);
		skel_whndl = 0;
		done = TRUE;
		break;

	case WM_MOVED:				/* do window move	*/

		gl_rmsg[4] = align_x(gl_rmsg[4]) - 1;

		wind_set(wdw_hndl, WF_CXYWH, align_x(gl_rmsg[4])-1, gl_rmsg[5], gl_rmsg[6], gl_rmsg[7]);
		wind_get(skel_whndl, WF_WXYWH,	&work_area.g_x, &work_area.g_y, &work_area.g_w, &work_area.g_h);
		break;

	default:
		break;
	} /* switch */
	return(done);
} /* hndl_mesag */




/*------------------------------*/
/*          vdi_fix()           */
/* set up MFDB for transform    */
/*------------------------------*/

MLOCAL VOID vdi_fix(pfd, theaddr, wb, h)

MFDB FAR *pfd;
VOID FAR *theaddr;
WORD wb, h;
{
   pfd->fww = wb >> 1;             /* # of bytes to words          */
   pfd->fwp = wb << 3;             /* # of bytes to to pixels      */
   pfd->fh = h;                    /* height in scan lines         */
   pfd->np = 1;                    /* number of planes             */
   pfd->mp = theaddr;              /* memory pointer               */
}


/*------------------------------*/
/*        vdi_trans()           */
/*   'on the fly' transform     */
/*------------------------------*/
MLOCAL VOID vdi_trans(vdi_handle, saddr, swb, daddr, dwb, h)

WORD vdi_handle;
VOID FAR *saddr;
WORD swb;
VOID FAR *daddr;
WORD dwb;
WORD h;
{
   MFDB src, dst;                    /* local MFDB                   */

   vdi_fix(&src, saddr, swb, h);
   src.ff = TRUE;                    /* standard format              */

   vdi_fix(&dst, daddr, dwb, h);
   dst.ff = FALSE;                   /* transform to device          */
                                     /* specific format              */   
   vr_trnfm(vdi_handle, &src, &dst ); 
}








VOID init_icons(void)
{
	int n, p, pl;
	static int icons[] = {IMAGER, IMAGEG, IMAGEB, IMAGEI, STARTBMP};

	LPBIT imdata;
	LPBYTE clrdata, maskdata;
	
	/* The resources start out in device-independent mono form */

	rsrc_gaddr(R_BITBLK, IMAGER, (LPVOID *)&imdata);

	create_mfdb(&gl_mfimage, (imdata->bi_wb + 1)/2, imdata->bi_hl, 4);
	create_mfdb(&gl_mfmask, (imdata->bi_wb + 1)/2, imdata->bi_hl, 1);
	new_mfdb(&gl_mfbitmap);
	
	clrdata  = (LPBYTE)gl_mfimage.mp;
	maskdata = (LPBYTE)gl_mfmask.mp;
	
	gl_mfimage.fwp = 32;
	gl_mfimage.ff  = 0;
	gl_mfmask .fwp = 32;
	gl_mfmask .ff  = 0; 

	pl = gl_mfimage.fww * gl_mfimage.fh * 2;	/* Plane length */

	/* Transform the four mono images into one four-plane image */
	
	for (n = 0; n < 4; n++)
	{
		rsrc_gaddr(R_BITBLK, icons[n], (LPVOID *)&imdata);

		vdi_trans(vdi_handle, imdata->bi_pdata, 
		                      imdata->bi_wb, 
		                      clrdata + (n * pl),
		                      imdata->bi_wb, 
		                      imdata->bi_hl);
	}
	/* Transform the mask into a mono image */
	
	rsrc_gaddr(R_BITBLK, MASKBM, (LPVOID *)&imdata);

	vdi_trans(vdi_handle, 
	          imdata->bi_pdata, 
	          imdata->bi_wb,
	          maskdata,
	          imdata->bi_wb,
	          imdata->bi_hl);

	copy_mfdb(&gl_mfimage, &gl_mfbitmap);

	/* Invert the mask. Windows masks are inverted compared to the masks
	 * in the RSC file */
	
	for (p = 0; p < pl; p++) maskdata[p] = ~maskdata[p];
	 
	/* Apply the mask to the image. This is necessary because a GEM
	 * colour icon works like a Windows colour icon; the mask is XORed
	 * with the image. Therefore transparent bits have to be "cut out"
	 * of both images.
	 * 
	 */
	
	for (n = 0; n < 4; n++)
	{
		for (p = 0; p < pl; p++)
		{
			clrdata[n * pl + p] |= maskdata[p];
		}
	}	
}


/*

Page*/
/************************************************************************/
/************************************************************************/
/****															     ****/
/****			    			Event Handler					     ****/
/****								     							 ****/
/************************************************************************/
/************************************************************************/

/*------------------------------*/
/*	hndl_mouse		*/
/*------------------------------*/
WORD
hndl_mouse() 			/* change mouse form depending on 	*/
{ 				/* whether it's in or out of window 	*/
	BOOLEAN	done;
	
	if (m_out)
		graf_mouse(ARROW, 0x0L);
	else
		graf_mouse(POINT_HAND, 0x0L);

	m_out = !m_out; 	/* change MU_M1 entry/exit flag 	*/
	done = FALSE;
	return(done); 
}

WORD hndl_click(WORD mx, WORD my)
{
	/* Make the menu pop up in the right place. 
	 */

	mx = butn_area.g_x;					/* Left of menu   = left of Start */
	my = butn_area.g_y - 3*gl_hchar;	/* Bottom of menu = top of Start */

	switch (menu_popup_strings(mx, my, 3, "  Programs  ", 
	                                      "  Documents  ",
	                                      "  Settings  "))
		{
		case -2: form_alert(1,"[3][Popup menu out of memory][ OK ]");    break;
		case -1: form_alert(1,"[1][Popup menu cancelled][ OK ]");        break;
		case  1: form_alert(1,"[0][\"Programs\" item selected][ OK ]");  break;
		case  2: form_alert(1,"[0][\"Documents\" item selected][ OK ]"); break;
		case  3: form_alert(1,"[0][\"Settings\" item selected][ OK ]");  break;
		default: form_alert(1,"[3][You should never see this][ OK ]");   break;

		}

	return 0;
}


/*--------------------------*/
/*	Main event loop			*/
/*--------------------------*/
skel()
{
	BOOLEAN	done;
	UWORD	mousex, mousey, bstate, kstate, kreturn, bclicks;
	
	/**/					/* loop handling user	*/
	/**/					/*   input until done	*/
	done = FALSE;				/*   -or- if DESKACC	*/
	while( !done )				/*   then forever	*/
	{
		ev_which = evnt_multi(gl_evset,
		0x01, 0x01, 0x01, /* 1 click, 1 button, button down */
		m_out,  /* entry , work_area x,y,w,h */ 
		(UWORD) butn_area.g_x, (UWORD) butn_area.g_y,
		(UWORD) butn_area.g_w, (UWORD) butn_area.g_h, 
		/* mouse rect 2 flags , x,y,w,h */
		0, 0, 0, 0, 0, 
		/* Message buffer, timer low count , high count 	*/
		ad_rmsg, 0, 0,  
		/* mouse posit ,  btn state, r & lshift, Ctrl, Alt 	*/
		&mousex, &mousey, &bstate, &kstate, 
		/* keybd key,# btn clicks */
		&kreturn, &bclicks);

		wind_update(BEG_UPDATE);	/* begin window update	*/
		if (ev_which & MU_MESAG) done = hndl_mesag();		/* handle event message	*/
		if (ev_which & MU_M1)    done = hndl_mouse();
		if (ev_which & MU_BUTTON)done = hndl_click(mousex, mousey);
		wind_update(END_UPDATE);	/* end window update	*/
	}
}


/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Termination				     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


/*------------------------------*/
/*	skel_term		*/
/*------------------------------*/  
skel_term() 
{
	xgrf_dtimage(NULL);
	delete_mfdb(&gl_mfbitmap);
	delete_mfdb(&gl_mfimage);
	delete_mfdb(&gl_mfmask);

	
	if (skel_whndl) 
	{
		do_close(skel_whndl, gl_wfull/2, gl_hfull/2);
		wind_delete(skel_whndl);
	}
	if (bar_whndl)  
	{
		wind_close(bar_whndl);
		wind_delete(bar_whndl);
	}
	
	v_clsvwk( vdi_handle );		/* close virtual work station	*/
	appl_exit();			/* application exit		*/ 
}

/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Initialization			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/

/*------------------------------*/
/*	skel_init		*/
/*------------------------------*/
WORD
skel_init()
{
	WORD	i;
	WORD	work_in[11];
	
	memset(&gl_xbuf, 0, sizeof(gl_xbuf));
	gl_xbuf.buf_len = sizeof(gl_xbuf);
	
	gl_apid = appl_init(&gl_xbuf);			/* initialize libraries	*/
	for (i = 0; i < 10; i++)
	{
		work_in[i]=1;
	}
	work_in[10] = 2;
	gem_handle  = graf_handle(&gl_wchar, &gl_hchar, &gl_wbox, &gl_hbox);
	vdi_handle  = gem_handle;
	v_opnvwk(work_in, &vdi_handle, work_out);	/* open virtual work stn*/

	/* Work out how big the window should be */
	skel_wnd_w = 480;  
	skel_wnd_h = 320;

	
	if (vdi_handle == 0)
		return(FALSE);

	wind_update(BEG_UPDATE);
	graf_mouse(HOUR_GLASS, 0x0L);
	if (!rsrc_load( ADDR("UIDEMO.RSC") ))
	{    	
		/* No Resource File  */
		graf_mouse(ARROW, 0x0L);
		form_alert(1,"[3][Fatal Error !|UIDEMO.RSC|File Not Found][ Abort ]");
		v_clsvwk( vdi_handle );		/* close virtual work station	*/
		appl_exit();			/* application exit		*/ 
		return FALSE;
	}
	/* initialize menu    */
	rsrc_gaddr(R_TREE, MENUTREE, (LPVOID *)&gl_menu);

	/* At some point the resource tree got damaged, and these are 
	 * necessary to undo the damage */
	gl_menu->ob_x = 0;
	gl_menu->ob_y = 0;
	
	/* show menu	      */
	menu_bar(gl_menu, TRUE);

	init_icons();	
	
	ad_rmsg = ADDR((BYTE *) &gl_rmsg[0]);
	wind_get(DESK, WF_WXYWH, &gl_xfull, &gl_yfull, &gl_wfull, &gl_hfull);
	graf_mouse(HOUR_GLASS, 0x0L);
	wind_update(END_UPDATE);
	return(TRUE);
}

/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Main Program			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


/*------------------------------*/
/*	GEMAIN			*/
/*------------------------------*/
WORD GEMAIN(WORD argc, BYTE *ARGV[])
{
	if (skel_init())			/* initialization	*/
	{
		gl_rmsg[0] = AC_OPEN;
		gl_rmsg[4] = gl_itemskel;
		hndl_mesag();

		skel();
	
		skel_term();			/* termination		*/
	}
	memcheck();
	return 0;
}

