/************************************************************************

    DBGALLOC - trace memory allocation 

    Copyright (C) 1999  John Elliott <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*************************************************************************/

#include "uitest.h"

#include <stdarg.h>	/* Used by TRACE1() */


#if DEBUG

#define NUM_TRACES 50	/* No. of mallocs we can track */

static LPVOID memlist[NUM_TRACES];

LPVOID llalloc(long t, int line, char *file)
{				
	int i;			
	LPVOID p = dos_alloc(t);
							
	TRACE(("%s:%d alloc(0x%lx) returns 0x%lx\n", file, line, t, p)); 

	if (!p) return p;

	for (i = 0; i < NUM_TRACES; i++) 
	{
		if (!memlist[i]) 
		{
			memlist[i] = p;
			TRACE(("%s:%d: block number %d\n", file, line, i));
			break;
		}
	}
	
	return p;
}


VOID llfree(LPVOID t, int line, char *file)
{
	int i;
	
	if (!t)
	{
		TRACE(("%s:%d ERROR freeing a null pointer\n", file, line)); 
		return;
	}
	
	dos_free(t);
	TRACE(("%s:%d free 0x%lx\n", file, line, t)); 

	for (i = 0; i < NUM_TRACES; i++) 
	{
		if (memlist[i] == t) 
		{
			memlist[i] = 0;
			TRACE(("%s:%d: block number %d freed\n", file, line, i));
			break;
		}
	}

}

VOID memcheck(void)
{
	int i;
	
	for (i = 0; i < NUM_TRACES; i++) 
	{
		if (memlist[i]) 
		{
			TRACE(("Block number %d allocated to 0x%lx\n", i, memlist[i]));
		}
	}

}


void TRACE1(char *s, ...)
{
	FILE *fp;
	va_list ap;

	va_start(ap, s);
	fp = fopen(DEBUGFILE, "a");


	vfprintf(fp, s, ap);
	va_end(ap);
	fclose(fp);
}



#endif
