
/* Flags in the top two bits of a tile ID */

#define BORDER 0x8000	/* This flag is set on all tiles round the edge */
#define MERGED 0x4000	/* This flag is set on any tiles created in the */
			/* most recent turn */

typedef struct
{
	unsigned short tile[6][6];
	long score;
} GAMEBOARD;

void gb_init(GAMEBOARD *g);
void gb_newtile(GAMEBOARD *g);
void gb_clearmerge(GAMEBOARD *g); 
int gb_canmove(GAMEBOARD *g);
int gb_move(GAMEBOARD *g, int dx, int dy);
