
#include <stdlib.h>
#include <string.h>
#include "2048game.h"



void gb_init(GAMEBOARD *g)
{
	int r, c;

	for (r = 0; r < 6; r++) for (c = 0; c < 6; c++)
	{
		if (r == 0 || c == 0 || r == 5 || c == 5)
			g->tile[r][c] = BORDER;
		else	g->tile[r][c] = 0;
	}
	g->score = 0L;

}


void gb_newtile(GAMEBOARD *g)
{
	while (1)
	{
		int r = 1 + (rand() % 4);
		int c = 1 + (rand() % 4);
	
		if (g->tile[r][c] == 0)
		{
			g->tile[r][c] = (rand() % 3) ? 1 : 2;

			return;
		}
	}
}

static void gb_movelr(GAMEBOARD *g, int row, int dx)
{
	int col, c2;

	for (col = (dx < 0) ? 1 : 4; 
		g->tile[row][col] != BORDER;
		col -= dx)
	{
		c2 = col;
		if (g->tile[row][c2] == 0) continue;
		/* Slide tile left as far as it will go */
		while (g->tile[row][c2 + dx] == 0)
		{
			g->tile[row][c2 + dx] = g->tile[row][c2];
			g->tile[row][c2] = 0;
			c2 += dx;
		}
		/* Has it hit another of the same type? */
		if (g->tile[row][c2 + dx] == g->tile[row][c2])
		{
			g->score += 2 * g->tile[row][c2];
			g->tile[row][c2 + dx] *= 2;
			/* Set a 'newly merged' flag so that nothing can be
			 * merged with this tile. */
			g->tile[row][c2 + dx] |= MERGED;
			g->tile[row][c2] = 0;
		}
	}
}



static void gb_moveud(GAMEBOARD *g, int col, int dy) 
{
	int row, r2;

	for (row = (dy < 0) ? 1 : 4; 
		g->tile[row][col] != BORDER;
		row -= dy)
	{
		r2 = row;
		if (g->tile[r2][col] == 0) continue;
		/* Slide tile up as far as it will go */
		while (g->tile[r2 + dy][col] == 0)
		{
			g->tile[r2 + dy][col] = g->tile[r2][col];
			g->tile[r2][col] = 0;
			r2 += dy;
		}
		/* Has it hit another of the same type? */
		if (g->tile[r2 + dy][col] == g->tile[r2][col])
		{
			g->score += 2 * g->tile[r2][col];
			g->tile[r2 + dy][col] *= 2;
			/* Set a 'newly merged' flag so that nothing can be
			 * merged with this tile. */
			g->tile[r2 + dy][col] |= MERGED;
			g->tile[r2][col] = 0;
		}
	}
}






int gb_move(GAMEBOARD *g, int dx, int dy)
{
	int row, col;
	GAMEBOARD g2;

	gb_clearmerge(g);	/* Clear any 'new tile' flags from previous 
				 * move */
	memcpy(&g2, g, sizeof(g2));
	if (dy == 0)
	{
		for (row = 1; row <= 4; row++)
		{
			gb_movelr(g, row, dx);
		}

	}
	else
	{
		for (row = 1; row <= 4; row++)
		{
			gb_moveud(g, row, dy);
		}

	}
	if (!memcmp(&g2, g, sizeof(g2)))
	{
		return 0;	/* No tile moved */
	}
	for (row = 1; row <= 4; row++) for (col = 1; col <= 4; col++)
	{
		if (g->tile[row][col] == 4096) return 2;
	}
	return 1;
}

void gb_clearmerge(GAMEBOARD *g)
{
	int row, col;

	for (row = 1; row <= 4; row++) for (col = 1; col <= 4; col++)
	{
		g->tile[row][col] &= ~MERGED;
	}
}


int gb_canmove(GAMEBOARD *g)
{
	GAMEBOARD g2;

/* Brute-force approach: Try all four of the user's possible moves and see if
 * any of them changed the board state. If gb_move() returned zero the board
 * was unchanged, so we don't need to restore it before each attempt. */
	memcpy(&g2, g, sizeof(g2));
	gb_clearmerge(&g2);

	if (gb_move(&g2, -1,  0) ||
	    gb_move(&g2,  1,  0) ||
	    gb_move(&g2,  0, -1) ||
            gb_move(&g2,  0,  1) )
	{
		return 1;
	}
	return 0;
}

