/************************************************************************

    CPPREP v1.00 - Replacement for MODE CON CP PREPARE supporting various
                  file formats.

    Copyright (C) 2006  John Elliott <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*************************************************************************/

/* Load a font from a raw file (ie, just the character glyphs) */

#include "cpprep.h"

void load_raw(char *filename, FILE *fp, int page, int *haveFonts)
{
	long fsize;
	int chsize, n;
	unsigned char far *bits;

	fseek(fp, 0, SEEK_END);
	fsize = ftell(fp);
	fseek(fp, 0, SEEK_SET);

	/* To avoid arithmetic overflow, we reject files bigger than 32k
	 * before even trying to guess the character size */
	if (fsize > 32767L)
	{
		fprintf(stderr, "%s:Character size guessed as 8x%ld --\n"
				"   unsupported size on this device.\n", 
				filename, fsize / 256L);
	
		return;	
	}

	chsize = ((unsigned)fsize / 256);
	
	bits = fontbits(page, chsize);
	if (!bits)
	{
		fprintf(stderr, "%s:Character size guessed as 8x%d --\n"
				"   unsupported size on this device.\n", 
				filename, chsize);
		return; 
	}
	if (verbose)
	{
		printf("%s: Loading codepage %d", filename, get_pageno(page));
		printf(" from raw file, size guessed as 8x%d\n", chsize);
	}
	for (n = 0; n < 256*chsize; n++)
	{
		bits[n] = fgetc(fp);
	}
	switch(chsize)
	{
		case  8: *haveFonts |= 1; break;
		case 14: *haveFonts |= 2; break;
		case 16: *haveFonts |= 4; break;
	}
}

