/************************************************************************

    CPPREP v1.00 - Replacement for MODE CON CP PREPARE supporting various
                  file formats.

    Copyright (C) 2006  John Elliott <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*************************************************************************/

/* This file a does the business of getting the generated codepage sent to 
 * DISPLAY.SYS */

#include "cpprep.h"
#ifdef __MSDOS__
#include <dos.h>

/* I have no idea how big to make this array. It needs to be at least 4 bytes
 * but the maximum size could be anything. */
static BYTE cpi_info[520];
static WORD curcp;
static int pcdos   = 0;
static int freedos = 0;

/* Open the console device. Be particularly nitpicky and open /dev/con just
 * in case someone's running on DOS 2 with AVAILDEV set to mandatory. */
static int open_con(void)
{
	union REGS rg;
	struct SREGS sg;
	static char far *condev = "/dev/con";

	rg.x.ax = 0x3D02;
	rg.x.dx = FP_OFF(condev);
	rg.x.cx = 0;
	sg.ds = FP_SEG(condev);
	intdosx(&rg, &rg, &sg);
	if (rg.x.cflag) 
	{
		fprintf(stderr, "Failed to open /dev/con\n");
		return -1;
	}
	curcp = PEEK2(cpi_info + 2);
	return rg.x.ax;
}

/* Close /dev/con */
static void close_con(int fd)
{
	union REGS rg;

	rg.x.ax = 0x3E00;
	rg.x.bx = fd;
	intdos(&rg, &rg);
}


/* See if PCDOS DISPLAY.SYS is loaded */
static int init_hw_pcdos(void)
{
	int fd;
	union REGS rg;
	struct SREGS sg;
	int havecpi = 0;

/* Open /dev/con */
	fd = open_con();
	if (fd == -1) return 0;
/* Query it for current codepage 
 */
	rg.x.ax = 0x440C;
	rg.x.bx = fd;
	rg.x.cx = 0x036A;
	rg.x.dx = FP_OFF(cpi_info);
	sg.ds   = FP_SEG(cpi_info);
	intdosx(&rg, &rg, &sg);
/* Error 5 (access denied) is returned if DISPLAY.SYS is present but no 
 * current codepage is loaded. If DISPLAY.SYS isn't there you get error 1
 * (function number invalid). */
	havecpi = (rg.x.cflag == 0 || rg.x.ax == 5);
/*
 * if (!havecpi)
	{
		fprintf(stderr, "Could not get current codepage: Error=%d\n",
				rg.x.ax);
	}
	*/
/* Close /dev/con again */
	close_con(fd);

	return havecpi;
}

/* At the time of writing, FreeDOS DISPLAY.SYS has its own API rather than
 * using the PCDOS streaming system. Detect it. */
static int init_hw_freedos(void)
{
	union REGS rg;

	rg.x.ax = 0xAD00;
	int86(0x2F, &rg, &rg);
	return (rg.h.al == 0xFF && rg.x.bx >= 12 && rg.x.bx < 256);
}


/* See if we have any sort of DISPLAY.SYS loaded */
int init_hardware(void)
{
	pcdos   = init_hw_pcdos(); if (pcdos) return 1;
	freedos = init_hw_freedos(); if (freedos) return 1;
	return 0;
}


/* Transmit the codepage to the PCDOS DISPLAY.SYS */
static void install_pcdos(int cpcount)
{
	int fd;
	int n;
	struct SREGS sg;
	union REGS rg;

	fd = open_con();
	if (fd == -1) return;

/* Generate the info header for codepage preparation */
	POKE2(cpi_info    , 0);			/* Flags */
	POKE2(cpi_info + 2, 2 * (cpcount+1));	/* Length of data */
	POKE2(cpi_info + 4, cpcount);		/* Codepage count */
	for (n = 0; n < cpcount; n++)		/* Codepage IDs */
	{
		POKE2(cpi_info + 6 + 2*n, get_pageno(n));
	}
/* Start to prepare codepages */
	rg.x.ax = 0x440C;
	rg.x.bx = fd;
	rg.x.cx = 0x034C;
	rg.x.dx = FP_OFF(cpi_info);
	sg.ds   = FP_SEG(cpi_info);
	intdosx(&rg, &rg, &sg);
	if (rg.x.cflag)
	{
		fprintf(stderr, "Code page prepare failed: Error %04x\n",
				rg.x.ax);
		close_con(fd);
		return;
	}
/* Send data */
	rg.x.ax = 0x4403;
	rg.x.bx = fd;
	rg.x.cx = get_cpi_len();
	rg.x.dx = FP_OFF(get_cpi_base());
	sg.ds   = FP_SEG(get_cpi_base());
	intdosx(&rg, &rg, &sg);
	if (rg.x.cflag)
	{
		fprintf(stderr, "Error writing CPI data into codepage: "
				"Error %04x\n", rg.x.ax);
		close_con(fd);
		return;
	}
/* Finish preparation */
	POKE2(cpi_info, 2);
	POKE2(cpi_info+2, curcp);
	rg.x.ax = 0x440C;
	rg.x.bx = fd;
	rg.x.cx = 0x034D;
	rg.x.dx = FP_OFF(cpi_info);
	sg.ds   = FP_SEG(cpi_info);
	intdosx(&rg, &rg, &sg);
	if (rg.x.cflag)
	{
		fprintf(stderr, "Code page end prepare failed: Error %04x\n",
				rg.x.ax);
	}
	close_con(fd);
}

/* Transmit the codepage to the FreeDOS DISPLAY.SYS */
void install_freedos(int cpcount)
{
	int n;
	struct SREGS sg;
	union REGS rg;

/* Generate the info header for codepage preparation */
	POKE2(cpi_info    , 0);			/* Flags */
	POKE2(cpi_info + 2, 2 * (cpcount+1));	/* Length of data */
	POKE2(cpi_info + 4, cpcount);		/* Codepage count */
	for (n = 0; n < cpcount; n++)		/* Codepage IDs */
	{
		POKE2(cpi_info + 6 + 2*n, get_pageno(n));
	}
/* Start to prepare codepages */
	rg.x.ax = 0xAD0E;
	rg.x.bx = 0x0C;
	rg.x.cx = 0x034C;
	rg.x.dx = FP_OFF(cpi_info);
	sg.ds   = FP_SEG(cpi_info);
	int86x(0x2F, &rg, &rg, &sg);
	if (rg.x.cflag)
	{
		fprintf(stderr, "Code page prepare failed: Error %04x\n",
				rg.x.ax);
		return;
	}
/* Send data */
	rg.x.ax = 0xAD0E;
	rg.x.bx = 3;
	rg.x.cx = get_cpi_len();
	rg.x.dx = FP_OFF(get_cpi_base());
	sg.ds   = FP_SEG(get_cpi_base());
	int86x(0x2F, &rg, &rg, &sg);
	if (rg.x.cflag)
	{
		fprintf(stderr, "Error writing CPI data into codepage: "
				"Error %04x\n", rg.x.ax);
		return;
	}
/* Finish preparation */
	rg.x.ax = 0xAD0E;
	rg.x.bx = 0x0C;
	rg.x.cx = 0x034D;
	int86x(0x2F, &rg, &rg, &sg);
	if (rg.x.cflag)
	{
		fprintf(stderr, "Code page end prepare failed: Error %04x\n",
				rg.x.ax);
	}
}


void install_font(int cpcount)
{
	if (pcdos)
	{
		install_pcdos(cpcount);
	}
	else if (freedos)
	{
		install_freedos(cpcount);
	}
}
#endif /* def __MSDOS__ */
