;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;Get parameters to USERF call into registers - and vice versa
;
getpars:
	ld	hl,usepb	;Get the USERF parameters from the block
	ex	de,hl		;at DE (in the BIOS) to the local block
	ld	bc,10
	ldir	
        ld      hl,(useaf)	;and thence into the registers.
        push    hl
        pop     af
        ld      bc,(usebc)
        ld      de,(usede)
        ld      hl,(usehl)
	ret
;
userf1:	ld	hl,usret
	push	hl	;Return after calling named function
	call	getpars
	push	hl
	ld	hl,(usepb)
	ld	(ujmp+1),hl
	pop	hl
ujmp:	jp	quit
;
;Store current registers in the USERF parameter block.
;
usret:	ld	(usehl),hl	;Save the registers in the parameter block.
	ld	(usede),de
	ld	(usebc),bc
	push	af
	pop	hl
	ld	(useaf),hl
	ld	hl,usepb	;Copy from local PB to the one in BIOS.
	ld	de,(usepp)
	ld	bc,10
	ldir
	ret
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;Parameter block: Local copy
;
usepp:  defw    0       ;Pointer to the BIOS's parameter block
usepb:  defw    0       ;Function
useaf:  defw    0
usebc:  defw    0
usede:  defw    0
usehl:  defw    0
;
