;
;General debugging code. "yes-i-live()" displays the byte in A and 8
;words from the stack.
;
ysp:	defw	0
;
yes_i_live:
	ld	(ysp),sp
	push	af		;Save registers so they can be
	push	bc		;output a bit later
	push	de
	push	hl

	ld	de,yila
	call	hexa		;Render A as ASCII
	ld	hl,0	
	add	hl,sp		;HL -> saved HL DE BC
	ld	de,yilhl
	call	hexm
	ld	de,yilde
	call	hexm
	ld	de,yilbc	;BC DE and HL as ASCII
	call	hexm
	push	ix
	pop	bc
	ld	de,yilix
	call	hexbc
	push	iy
	pop	bc
	ld	de,yiliy	;IX and IY as ASCII
	call	hexbc	


	ld	hl,(ysp)	;Stack trace
	ld	de,yils
	ld	b,8
yil1:	ld	c,(hl)		;as ASCII - 8 levels
	inc	hl
	ld	a,(hl)
	inc	hl
	call	hexa
	ld	a,c
	call	hexa
	inc	de
	djnz	yil1

	ld	hl,yildlg	;Print all the data
	ld	de,yile-yildlg
	call	alert
	or	a
	jp	nz,QUIT
popa:	pop	hl		;And continue.
	pop	de
	pop	bc	
	pop	af
	ret
;
dmemde:	ex	de,hl		;Dump 8 bytes of memory at DE.
	call	dmem
	ex	de,hl
	ret
;
dmem:	push	af	;Dump 8 bytes of memory at HL.
	push	bc
	push	de
	push	hl

	ld	de,dmemv
	ld	b,8
dmem11:	ld	a,(hl)	;Convert each byte to ASCII
	inc	hl
	call	hexa
	inc	de
	djnz	dmem11

	ld	hl,dmemdlg
	ld	de,dmeme-dmemdlg
	call	alert	;Show bytes
	jp	popa
;
;Some Hex output code..
;
chexb:	defb	0,0	;Space to expand hex byte to ASCII chars.
chexa:	push	af	;Output hex byte in A to the ANNECRT terminal emulator
	push	bc
	push	de
	push	hl
	ld	de,chexb
	call	hexa
	ld	a,(chexb)
	ld	e,a
	call	opchar
	ld	a,(chexb+1)
	ld	e,a
	call	opchar
	jp	popa
;
yildlg:
	defb	'A='
yila:	defb	'00 BC='
yilbc:	defb	'0000 DE='
yilde:	defb	'0000 HL='
yilhl:	defb	'0000 IX='
yilix:	defb	'0000 IY='
yiliy:	defb	'0000',0
	defb	'Stack trace: '
yils:	defb	'0000 0000 0000 0000 0000 0000 0000 0000',0,0
        defb    2                       ;35 2 buttons.
        defb    0FBh, 80h               ;36 Tick
        defb     0Dh, 80h               ;38 CR
        defb    'o',  80h               ;40 S
        defb    ' ',  80h               ;42 SPACE
        defb    ' ',1Fh,'OK ',0A5h,' ',0;44-51 "OK"
        defb    0FCh, 80h
        defb    's',80h
        defb    's',80h
        defb    's',80h
        defb    ' ',1Fh,'Stop ',0A4h,' ',0
yile:

dmemdlg:
dmemv:	defb	'00 00 00 00 00 00 00 00',0,0
        defb    1                       ;35 1 button.
        defb    0FBh, 80h               ;36 Tick
        defb     0Dh, 80h               ;38 CR
        defb    'o',  80h               ;40 S
        defb    ' ',  80h               ;42 SPACE
        defb    ' ',1Fh,'OK ',0A5h,' ',0;44-51 "OK"
dmeme:
