;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;cpm2anne converts a CP/M address (C=bank HL=offset) to Anne format 
;(C=block HL=offset)
;
cpm2anne:
	push	af
	push	de
	ld	a,h
	and	0C0h
	cp	0C0h	;In the top quarter => bank 7
	jr	z,cpm2cmn

	ld	a,c
	or	a
	ld	de,memlist	;X0
	jr	z,cpm2an0	;Bank 0
	dec	a
	ld	de,memlist+5	;X4
	jr	z,cpm2an1	;Bank 1
	ld	de,memlist+2	;X2
	dec	a
	jr	z,cpm2an0	;Bank 2	
	ld	de,memlist+8	;Bank 3
;
;It's in bank 2.
;
cpm2an0:
	ld	a,h
	and	0C0h
	jr	z,ret80
cpm2an1:
	ld	a,h
	rlca
	rlca
	and	3	;A = 0, 1 or 2
	add	a,e
	ld	e,a
	jr	nc,cpm2an2
	inc	d	;DE = address of bank var
cpm2an2:
	ld	a,(de)
	ld	c,a	;C = bank
	jr	cpm2anr
;
ret80:	ld	c,80h
	jr	cpm2anr
;
cpm2cmn:
	ld	a,(memlist+8)	;X7
	ld	c,a
cpm2anr:
	pop	de
	pop	af
	ret
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
