;
;WARNING: ONLY EDIT BIOS.H, NOT BIOS.ZSM. BIOS.ZSM IS A TEMPORARY FILE.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;             CP/M for the PCW16 - the official "BIOS" module                 ;
;                                                                             ;
;   Copyright (C) 1998-1999, John Elliott <jce@seasip.demon.co.uk>            ;
;                                                                             ;
;    This program is free software; you can redistribute it and/or modify     ;
;    it under the terms of the GNU Library General Public License as          ;
;    published by the Free Software Foundation; either version 2 of the       ;
;    License, or(at your option) any later version.                           ;
;                                                                             ;
;    This program is distributed in the hope that it will be useful,          ;
;    but WITHOUT ANY WARRANTY; without even the implied warranty of           ;
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            ;
;    GNU Library General Public License for more details.                     ;
;                                                                             ;
;    You should have received a copy of the GNU Library General Public        ;
;    License along with this program; if not, write to the Free Software      ;
;    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                ;
;                                                                             ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;/* Note: Despite its name of .h, this is a Z80 source file. I've called it
;   "bios.h" so that the GNU C preprocessor will expand macros in it. 
;   Likewise the C-style comments you see here and there are to hide '
;   characters from the preprocessor. I've tried not to comment out 
;   actual code like this; although "gcc -E -C" leaves the comments in, other
;   preprocessors might not. 
;
;CP/M 3: I am doing my own memory allocation, rather than letting GENCPM do
;       it for me; this is because FIDs require dynamic memory allocation at
;       load time rather than static allocation at GENCPM time. Therefore 
;       you won't see the value FFFEh in the DRVTBL, DPHs etc.
;
;Please, always ensure that SP is above the base of BIOS when calling LDRFUNC.
;Otherwise the BIOS will probably crash.
;
;Do NOT allow EI or DI to be executed (except that DI can be used within the
;interrupt service routine, in case some foolish program like SID does an EI).
;
;Interface between the BIOS and other programs in the system is defined by
;an extension to the BIOS jumpblock (after RESERV2):
;
;	JP	BCTL		;BIOS control
;	JP	LDR_CBK		;Loader callback
;	DB	'ANNE1',1Ah	;Magic number
;
;BCTL takes a function number in A:
;
;0:   Initialise memory paging. HL -> memory list. Called at cold boot by 
;     loader.
;1:   Return HL = address of memory list.
;             E = memory bank to use for disc I/O functions
;             D = memory bank to use for device I/O functions
;2:   Return HL = address of LOWSP (stack pointer for Rosanne memory)
;3:   Return HL = base of dynamically allocated area
;            DE = address of 128-byte buffer (used for disc I/O in 
;                 CP/M 2; not currently used in CP/M 3).
;
;40h: Switch address used for disc callbacks. Enter with L = 0 to use 
;     LDR_CBK, or 2 to use 4000h in bank 2.
;41h: As 40h, for device I/O functions. 
;
;LDR_CBK takes a function number in A, and passes parameters through BC 
;        and DE:
;
;  1 : Read keyboard character into E (no echo)
;  2 : Print character in E
;  3 : AUXIN character into E
;  4 : AUXOUT character in E
;  5 : LIST character in E
;  6 : Initialise device in E
;  7 : AUXIN ready status into E
;  8 : AUXOUT ready status into E
;  9 : LIST ready status into E
; 0Ah: CONOUT ready status into E
; 0Bh: CONIN ready status into E
;
; 7Fh: First load of CCP (cold boot)
; 80h: Reload CCP
;
; 81h: Read disc sector, DE->parameter block, C=0 for OK else error
; 82h: Write disc sector, DE & C as above.
; 83h: Log in a disc (C=new drive, DE->parameter block) C as above.
; 84h: Flush buffers
;
;0C0h: USERF. DE-> USERF parameter block.
;
; */
	include annecpm.inc

#ifdef CPM2		/* Assemble a CP/M 2 compatible BIOS */
	 org	BIOS
#else
 #ifdef ORG0		/* Assemble a CP/M 3 compatible BIOS */
	 org	0
 #else			/* (it assembles it twice, at different origins, */
	 org	0100h
 #endif			/*  to generate the .SPR file). */
#endif

CDISK	EQU	4	;[CP/M 2] Address of current disc byte
IOBYTE	EQU	3	;[CP/M 2] Address of IOBYTE
;
;The BIOS jump block.
;
BBASE:
	jp	CBOOT
WBOOT0:	jp	WBOOT
	jp	CONST
	jp	CONIN
	jp	CONOUT
	jp	LIST
	jp	PUNCH
	jp	READER
	jp	HOME
	jp	SELDSK
	jp	SETTRK
	jp	SETSEC
	jp	SETDMA
	jp	READ
	jp	WRITE
	jp	LISTST
	jp	SECTRAN
;
;For CP/M 3 only...
;
	jp	CONOST
	jp	AUXIST
	jp	AUXOST
	jp	DEVTBL
	jp	DEVINI
	jp	DRVTBL
	jp	MULTIO
	jp	FLUSH
	jp	MOVE
	jp	TIME
	jp	SELMEM
	jp	SETBNK
	jp	XMOVE
	jp	USERF			;FA5A
	jp	0	;RESERV1	;FA5D
	jp	0	;RESERV2	;FA60
;
; Extensions for PCW16 CP/M.
;
	jp	bctl	;Bios control	;FA63
ldr_cbk:
	jp	0	;Loader callback. This points to ANNELDR in bank 0.
	defb	'ANNE1',1Ah	;Magic no.	;FA69
;
	defw	DPBLK		;FA6F: New in v0.09: Let the boot loader 
				;manipulate the default DPB
;
;/* Dummy calls. Note: I'm making them the same size to help with memory 
; * alignment. This is easily done by moving the RET from the end to the
; * beginning of the code.
; */

#ifdef CPM2
DEVTBL:	ld	hl,0ffffh	;No DEVTBL
	ret

TIME:	ret			;No SCB, therefore no TIME
	call	USERF
	defw	00F2h

SETBNK:	ret			;In CP/M 2, disc I/O is always to the TPA.
	ld	(dmabank),a

MULTIO:	ret			;Not necessary in CP/Ms 2 or 3


#else	/* def CPM2 */

;WARNING: Other parts of the BIOS will assume DEVTBL preserves all
;        registers except HL.
;
DEVTBL:	ld	hl,devices	;Return DEVTBL address
	ret
;
TIME:	call	USERF		;Get time into SCB
	defw	00F2h
	ret
;
SETBNK:	ld	(dmabank),a	;Set DMA bank
	ret
;
MULTIO:	ret			;Not necessary.
#endif
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;XMOVE and MOVE are very useful functions, even in CP/M 2.
;
xmv:	defb	0	;XMOVE in use?
xmvbc:	defw	0	;XMOVE: C=source B=destination

XMOVE:	ld	a,1
	ld	(xmv),a	;Next copy will be between banks.
	ld	(xmvbc),bc
	ret
;
MOVE:	ld	a,(xmv)
	or	a	;Copy between banks?
	jr	z,move1
	xor	a
	ld	(xmv),a
	push	ix	;Yes. Call down to ANNELDR to do the move.
	ld	ix,(xmvbc)
	call	USERF
	defw	00F5h
	pop	ix
	ret
;
move1:	ex	de,hl	;Copying in the same bank.
	ldir
	ex	de,hl
	ret
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;WARNING: Other parts of the BIOS will assume DRVTBL preserves all 
;        registers except HL.
;
DRVTBL:	ld	hl,drives	;Return pointer to drive table.
	ret
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Calls to the BIOS from ANNELDR (or from CP/M utilities).
;
bctl:	or	a		;0 => initialise memory paging.
	jp	z,initmem
	cp	1		;1 => memory list addr.
	jp	z,mladdr
	cp	2		;2 => stack pointer addr.
	jp	z,spaddr
	cp	3		;3 => dynamic area addr.
	jp	z,sbaddr
	cp	40h		;40h => Switch disc FIDs on or off
	jr	z,discvec
	cp	41h		;41h => Switch tty FIDs on or off
	jr	z,ttyvec
	ld	hl,0
	ret			;Others are ignored, HL returns 0
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;Switch FIDS on/off. A=0 for off, 2 for on.
;
discvec:
	ld	a,l
	ld	(dskbank),a
	ret
;
ttyvec:	ld	a,l
	ld	(ttybank),a
	ret
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;Set up MEMLIST (list of available memory banks).
;
initmem:
	ld	de,memlist
	ld	bc,10		;Copy from HL to our own memlist.
	ldir
	ret
;
mladdr:	ld	hl,memlist	;Return pointer to MEMLIST
	ld	de,(dskbank)	;(and D, E = FID on/off status)
	ret
;
spaddr:	ld	hl,bios_stk	;Return address of stack pointer to use
	ret			;for Rosanne calls.
;
sbaddr:	ld	de,dirbf	;Return base of dynamically allocated common
	ld	hl,SBRK_0	;memory.
	ret
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;Warm boot.
;
WBOOT:	ld      sp,bios_stk	;Switch to stack in common memory
	xor	a
	call	SELMEM		;Bank 0
	ld	a,80h
	call	LDRFUNC		;Get CCP
CMNBOOT:
	ld	a,1		;TPA
	call	SELMEM
	ld	a,0C3h		;Create the jumps at 0 and 5.
	ld	(0),a
	ld	(5),a
tcd:	ld	hl,WBOOT0
	ld	(1),hl
#ifdef CPM2
	 ld	hl,BDOS+6	;Under CP/M 2, BDOS entry is at a fixed point
#else
	 ld	hl,(BIOS-2)	;Under CP/M 3, BDOS entry is stored in the SCB
#endif
	ld	(6),hl
	ld	hl,80h		;/* Initialise BIOS's DMA address */
	ld	(dmabuf),hl
	ld	a,(CDISK)	;Pass current disc to CCP (CP/M 2 only)
	ld	c,a	
#ifdef CPM3
	ld	sp,bios_stk-40h	;Default stack
	jp	0100h		;CCP loads at 100h
#else
	ld	sp,80h		;Under CP/M 2, CCP uses a stack at 80h
	jp	CCP		;CCP loads at top of memory
#endif
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;Output a string to the glass TTY (used when signing on)
;
print:	ld	a,(de)
	cp	'$'
	ret	z
	push	de
	ld	e,a
	ld	a,2
	call	TTYFUNC
	pop	de
	inc	de
	jr	print
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;Character device functions. These all map to calls to LDR_CBK or the
;FID manager.
;
DEVINI:	ld	a,6		;A = function...
	jr	ttyio

AUXIST:	ld	a,7
	jr	ttyio
;
AUXOST:	ld	a,8
	jr	ttyio
;	
LISTST:	ld	a,9
	jr	ttyio
;
CONOST: ld	a,10
	jr	ttyio
;
CONST:	ld	a,11
	jr	ttyio
;
CONIN:	ld	a,1
	jr	ttyio
;
CONOUT:	ld	a,2
	jr	ttyio
;
READER:	ld	a,3
	jr	ttyio
;
PUNCH:	ld	a,4
	jr	ttyio
;
LIST:	ld	a,5
ttyio:	ld	(callersp),sp
	ld	sp,bios_stk	;Switch to stack in common memory
	ld	e,c
	push	ix		;The ZPM3 BDOS requires IX and IY to survive
	push	iy		;BIOS calls. So do some programs.
	call	TTYFUNC
	pop	iy
	pop	ix
	ld	sp,(callersp)	;/* Back to caller's stack */
	ld	a,e
	ret
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
memlist:
	defs	10	;Memory blocks that can be used.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;USERF parameter block
;
usepb:	defw	0	;Function
useaf:	defw	0	;AF
usebc:	defw	0	;BC
usede:	defw	0	;DE
usehl:	defw	0	;HL

USERF:	ld	(usehl),hl
	ld	(usede),de
	ld	(usebc),bc
	push	af
	pop	hl		;Store registers in parameter block
	ld	(useaf),hl
	pop	hl		;Return address	
	ld	e,(hl)
	inc	hl		;Get inline word parameter
	ld	d,(hl)
	inc	hl
	push	hl
	ld	(callersp),sp	;Switch to stack in common memory
	ld	sp,bios_stk
	ld	(usepb),de	;Function no.
	ld	de,usepb
	ld	a,0C0h		;Make the call
	call	LDRFUNC
	ld	hl,(useaf)
	push	hl		;Registers returned in the parameter block
	pop	af
	ld	bc,(usebc)
	ld	de,(usede)
	ld	hl,(usehl)
	ld	sp,(callersp)
	ret
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;These calls perform the switch to bank 0 or bank 2 (depending 
;on the setting of DSKBANK and TTYBANK), call an ANNELDR function, and
;restore the previous banking arrangements.
;
TTYFUNC:
	ld	(func),a	;Check TTYBANK, and call bank 2 or bank 0
	ld	a,(ttybank)	;depending.
	jr	ttyfn1
;	
DSKFUNC:
	push	ix		;ZPM3 requires IX and IY not to be damaged
	push	iy		;by the BIOS
	call	dfun1
	pop	iy
	pop	ix
	ret

dfun1:	ld	(func),a		;Check DSKBANK for bank to use
	ld	a,(dskbank)		; - 0 to use built-in
ttyfn1:	or	a			;disc drivers, 2 for FIDs
	ld	a,(func)
	jr	z,LDRFUNC
;
;B2FUNC: Call 4000h in bank 2.
;
B2FUNC: call	LDRCHEK			;Make a call to bank 2 as if to
	ld	(func),a		;LDRFUNC.
	ld	a,(curbank)
	push	af			;Save current bank
	ld	a,2
	call	SELMEM			;Switch to bank 2
	ld	(highsp),sp
	ld	sp,(lowsp)		;Switch to Rosanne stack
	ld	a,(func)	
	call	4000h			;Call the function
	jr	ldrend
;
;LDRFUNC: Call LDR_CBK in bank 0.
;
LDRFUNC:
	call	LDRCHEK			;Check that the stack is in the BIOS.
;
ldrfun1:
	ld	(func),a		;Function no.
	ld	a,(curbank)
	push	af			;Save current bank
	xor	a
	call	SELMEM			;Switch to bank 0
	ld	(highsp),sp
	ld	sp,(lowsp)		;Switch to Rosanne stack
	ld	a,(func)
	call	ldr_cbk			;Call the function
ldrend:	ld	sp,(highsp)		;Back to BIOS stack
	ld	(funcret),a
	pop	af			;Bank to previous bank
	call	SELMEM
	ld	a,(funcret)		;Return A
	ret	
;
func:	defb	0			;Function being passed in
funcret:
	defb	0			;Value being returned
;
;Verify that the stack is above the base of the BIOS. Returns only if
;successful.
;
LDRCHEK:
        push    hl
        push    af
        ld      hl,0
        add     hl,sp		;HL := SP
        ld      a,h
        cp      0FAh		;If H > 0FAh, OK.
        jr      c,BADLDR
        pop     af
        pop     hl
	ret
;
BADLDR:	call	USERF		;Force CP/M to stop with an error.
	defw	1		;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Bank 3 (coldboot) is 80,X8,X1,X7
; Bank 2 (CCP)      is 80,X2,X3,X7
; Bank 1 (TPA)      is X4,X5,X6,X7
; Bank 0 (System)   is 80,X0,X1,X7
; Bank S (Screen)   is 81,82,83,X7 /* the BIOS doesn't use it like this */
;
; Bank S is accessed by CALL USERF ! DW 00E9h
;
;memlist itself is:
;+0 +1 +2 +3 +4 +5 +6 +7 +8 +9
;80 X0 X1 X2 X3 X4 X5 X6 X7 X8
;
SELMEM:	ld	(curbank),a
selm1:	or	a		;Select without changing stored status
	jr	z,bank0
	cp	2
	jr	z,bank2
	cp	3
	jr	z,bank3
	ld	a,(memlist+5)	;X4-X5-X6-X7
	out	(0F0h),a
	ld	a,(memlist+6)
	out	(0F1h),a
	ld	a,(memlist+7)
	out	(0F2h),a
	ret
;
bank2:	ld	a,(memlist+3)	;80-X2-X3-X7
	out	(0F1h),a
	ld	a,(memlist+4)
	out	(0F2h),a
	jr	bank00
	ret
;
bank0:	ld	a,(memlist+1)	;80-X0-X1-X7
	out	(0F1h),a
bank01:	ld	a,(memlist+2)
	out	(0F2h),a
bank00:	ld	a,(memlist)
	out	(0F0h),a
	ret
;
bank3:	ld	a,(memlist+9)	
	out	(0F1h),a
	jr	bank01
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;/*
; * This should never get called, because the PCW16's interrupts must be 
; * disabled before BIOS is entered. It'll only be called if a COM file
; * has executed EI; in which case, disable them again, pronto.
; */
tpaint:	di	
;;	push	af		;For debugging, switch to reverse video.
;;	ld	a,0C0h		;This shows that someone enabled interrupts,
;;	out	(0F7h),a	;which would normally only happen in a 
;;	pop	af		;crash.
	ret
;/*
; * The other RST nn's come to here: a debug breakpoint. This simply returns 
; * to the A> prompt.
; */
;
tbreak:	ld	(callersp),sp
	jp	WBOOT
;
;  The code below is the interrupt routine I wrote for when I tried to have
; interrupts enabled (an interrupt in the TPA would cause a switch to bank 0,
; then execution of the bank 0 interrupt). 
;
/*
;;;	di			;Called if there's an interrupt from the TPA
;;;	ld	(highspi),sp	;Save caller's SP
;;;	ld	sp,tpaint
;;;	push	af		;Save caller's AF
;;;	in	a,(0F0h)
;;;	push	af		;SP is now == isp1

;;;	ld	a,0C0h		;(debugging code) if there's a crash in an ISR,
;;;	out	(0F7h),a	;the screen will be reverse video.

;;;	ld	a,80h		;Switch Anne's bank 0 in where it wants it.
;;;	out	(0F0h),a
;;;	ld	sp,(lowsp)	;Put Anne's stack where it wants it.

;;;	rst	38h		;Call Anne's interrupt code.

;;;	di	
;;;	ld	a,40h		;Screen to normal video.
;;;	out	(0F7h),a

;;;	ld	sp,isp1
;;;	pop	af		;Restore bottom memory bank
;;;	out	(0F0h),a
;;;	pop	af		;Restore caller's AF
;;;	ld	sp,(highspi)	;Caller's SP
;;;	ei	
;;;	ret
;
;*/
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;Disc I/O code
;
FLUSH:	ld	(callersp),sp
	ld	sp,bios_stk
	ld	a,84h		;Flush buffers
	call	DSKFUNC
	ld	sp,(callersp)
	ret
;
HOME:	call	FLUSH		;Flush buffers, then go to track 0
	xor	a
	ld	bc,0
SETTRK:	ld	(track),bc	;Set track
	ret
;
SETSEC:	ld	(sector),bc	;Set sector
	ret
;
SETDMA:	ld	(dmabuf),bc	;Set transfer address
	ret
;
SELDSK:	ld	(callersp),sp
	ld	sp,bios_stk
	ld	b,e	;B=option (bit 0 set not to access the disc)
	push	bc	;C=drive
	ld	l,c
	ld	h,0
	add	hl,hl	;Find DPH for the drive in C.
	ld	de,drives
	add	hl,de
	ld	e,(hl)
	inc	hl
	ld	d,(hl)	;DE->DPH
	ld	a,d
	or	e	
	jr	z,nodrv
	ex	de,hl
	push	hl	;DPH
	ld	de,track
	ld	a,83h	;C = drive at this point; B has bit 0 set not to access
	call	DSKFUNC	;Call login function - either the basic one in 
	ld	a,c	;the loader, or a better replacement.
	pop	hl	;DPH
	or	a	;A = 0 if OK, else error.
	jr	nz,nodrv	
	pop	bc	;Drive
	ld	a,c	;Store current drive for later calls
	ld	(drive),a
	ld	(pdph),hl
	xor	a	;OK
	ld	sp,(callersp)
	ret
;
nodrv:	ld	hl,0	;No DPH	
	ld	sp,(callersp)
	ret
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;READ and WRITE
;
READ:	ld	a,1
	ld	(deblk),a	;Deblocking type
	ld	(callersp),sp
	ld	sp,bios_stk
	ld	de,track	;/* Call ANNELDR's disc I/O */
	ld	a,81h
read0:	call	DSKFUNC
	ld	sp,(callersp)
	ld	a,c
	ret
;
WRITE:	ld	a,c		;Deblocking type
	ld	(deblk),a
	ld	(callersp),sp
	ld	sp,bios_stk
	ld	de,track
	ld	a,82h
	jr	read0
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;SECTRAN
;
SECTRAN:
	ld	h,b	;No sector translation, the controller handles it.
	ld	l,c
	ret
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;Disc data
;
pdph:	defw	DPH_A	;Current DPH
track:	defw	0	;These 9 bytes form a parameter block for the Loader.
sector:	defw	0	;Current sector
dmabuf:	defw	0	;Transfer address
dmabank:
	defb	1	;Always bank 1 in CP/M 2
drive:	defb	0	;Current drive
deblk:	defb	0	;Deblocking factor
;
;The DRVTBL
;
drives:	defw	DPH_A, 0, 0, 0, 0, 0, 0, 0
	defw	    0, 0, 0, 0, 0, 0, 0, 0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;Stack code, and buffers. The code here is only used in a cold boot, and is
;overwritten by buffers under CP/M 2, or by SCR RUN ROUTINE under CP/M 3.
;
dirbf:	ret		;Stub for SCR RUN ROUTINE
;
sign$:	

;The different sign-on messages for CP/M 2 and 3.
;

#ifdef	CPM3
	defb	13,10,'CP/M 3.1 for the PCW16',13,10,10		;1Ah butes
;
;I'm omitting the TPA size for the moment, because it's printed by the 
;sign-on message in CPM3.SYS.
;
;;;        defb    'BIOS x.xx, 61k TPA, 1 disc drive',13,10,'$'    ;22h bytes
        defb    'BIOS '

	include	version.inc

	defb	', 1 disc drive',13,10,'$$$$$$$$$$'    ;22h bytes

#else
	defb	13,10,'CP/M 2.2 for the PCW16',13,10,10		;1Ah bytes
        defb    'BIOS '

	include	version.inc

	defb	', 56k TPA, 1 disc drive',13,10,'$'    ;22h bytes
#endif
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;Cold boot. Entered from the loader with memory in bank 0; can be 
;          overwritten once the BDOS has been started.
;
CBOOT:  ld      (lowsp),sp	;4 Save Rosanne stack pointer
        ld      sp,bios_stk	;3 Switch to BIOS stack
        ld      de,sign$	;3 Sign on.
        call    print		;3
#ifdef CPM3
	ld	de,0C000h	;3 Sign-on string in the SYS file. 
	call	print		;3
#endif
        ld      a,1		;2 Switch to TPA
        call    SELMEM		;3
        call    intsetup	;3
        ld      hl,081h		;3 IOBYTE = 81h (LST=LPT CON=CRT AUX=TTY)
        ld      (3),hl  	;3 Set current drive & IOBYTE
;
;Fill the memory with RST8 instructions. We go right up to the base of BIOS;
;this is then overlaid with the BDOS and CCP. The aim of this was to
;help with debugging - code jumping to the wrong place would hopefully
;be caught by an RST8.
;
        ld      hl,100h		;3 Base of TPA
        ld      de,101h		;3
#ifdef CPM3
	ld	bc,(BIOS-2)	;4 Under CP/M 3, go up only to the top of the
	dec	b		;1 top of the TPA, since the BDOS is not
	dec	b		;1 reloaded by a warm boot.
	ld	c,0FFh		;2 Limit to page, then subtract 101h
#else		
        ld      bc,BIOS-101h	;3 Under CP/M 2, go up to the base of BIOS.
#endif
        ld      (hl),0CFh       ;2 RST 8
        ldir			;2 
        xor     a		;1  Switch to bank 0
        call    SELMEM		;3 
        ld      a,7Fh		;2  Get the (BIOS and) CCP
        call    LDRFUNC		;3 

	ld	hl,WBOOT	;3   In case some maniac tries to call CBOOT
	ld	(BIOS+1),hl	;3   after it has been overwritten, point
        jp	CMNBOOT		;3   the vector at WBOOT.
;
;Set up interrupt vectors
;
intsetup:
        ld      a,1		;2 TPA
        call    SELMEM		;3
        ld      de,tbreak       ;3 Set RST8 - RST30 to TBREAK.
        ld      bc,06C3h        ;3 Set RST38 to interrupt disabler.
        ld      hl,8            ;2 RST 8 vector
iset1:  ld      (hl),c		;1 
        inc     hl		;1 C = C3h (JP)
        ld      (hl),e		;1 
        inc     hl		;1 DE = vector
        ld      (hl),d		;1 
        ld      a,l		;1 
        add     a,6		;2 Go to next vector
        ld      l,a		;1 
        djnz    iset1		;2 
        ld      de,tpaint	;3 Set RST38 to TPAINT.
        ld      (hl),c		;2 
        inc     hl		;1 
        ld      (hl),e		;1
        inc     hl		;1
        ld      (hl),d		;1
        ret			;1

	defs	102	;The stack. We have at least 128 bytes for the stack
			;and 128 bytes at dirbuf:
bios_stk:
lowsp:	defw	0	;Stack pointer used when calling Rosanne
highsp:	defw	0	;Saved stack pointer when calling Rosanne
highspi:
	defw	0	;Saved stack pointer used in interrupts
callersp:
	defw	0	;/* Caller's stack pointer while stack is in BIOS */
;
curbank:
	defb	0	;Memory bank currently selected
dskbank:
	defb	0	;Memory bank for disc code
ttybank:
	defb	0	;Memory bank for teletype code

#ifdef	CPM3		/* The DEVTBL */
devices:
	defb	'DUMB  ',3,0		;Device 0: Dumb terminal
	defb	0,0,0,0,0,0,0,0		;1
	defb	0,0,0,0,0,0,0,0		;2
        defb    0,0,0,0,0,0,0,0		;3
        defb    0,0,0,0,0,0,0,0		;4
        defb    0,0,0,0,0,0,0,0		;5
        defb    0,0,0,0,0,0,0,0		;6
        defb    0,0,0,0,0,0,0,0		;7
        defb    0,0,0,0,0,0,0,0		;8
        defb    0,0,0,0,0,0,0,0		;9
        defb    0,0,0,0,0,0,0,0		;10
	defb	0,0,0,0,0,0,0,0		;11
	defb	0,0,0,0,0,0,0,0		;12
	defb	0			;End of table
#endif

;
;From this point on, memory is allocated using a simple dynamic algorithm.
;
SBRK_0:
;
;The "default" DPB is at the end of the dynamic area, so that if there
;is trouble loading FIDs, it stands a better chance of survival (FIDLDR
;allocates memory from SBRK_0 up)
;
#ifdef CPM3

	DEFS	BBASE + 5C9h - $
;
;CP/M 3 DPH for A:
;	
DPH_A:	DEFW	0			;XLT
	DEFB	0,0,0,0,0,0,0,0,0	;-0-
	DEFB	0			;MF
	DEFW	DPBLK			;DPB
	DEFW	8400h			;CSV		;Addresses in bank 0
	DEFW	8500h			;ALV
	DEFW	40F8h			;DIRBCB		;See anneldr.zsm
	DEFW	40FAh			;DTABCB
	DEFW	0FFFFh			;HASH
	DEFB	0			;HBANK
#else
	DEFS	0FF55h - $

DPH_A:  DEFW    0000H,0000H	;CP/M 2 DPH for A:
        DEFW    0000H,0000H
        DEFW    DIRBF,DPBLK
        DEFW    CHK00,ALL00
#endif
;
;XDPB for a 720k CP/M floppy
;
DPBLK:  DEFW    36      ;SPT
        DEFB    4       ;BSH
        DEFB    15      ;BLM
        DEFB    0       ;EXM
        DEFW    352     ;DSM
        DEFW    255     ;DRM
        DEFB    0F0h    ;AL0
        DEFB    0       ;AL1
        DEFW    64      ;CKS
        DEFW    1       ;OFF
        DEFB    0       ;PSH	- ANNELDR uses 128-byte sectors
        DEFB    0       ;PHM
;
;XDPB data
;
	DEFB	81h	;Sidedness
	DEFB	80	;Cylinders
	DEFB	9	;Sectors
	DEFB	1	;1st physical sector
	DEFW	512	;512 bytes / real sector
	DEFB	2Ah	;FDC r/w gap
	DEFB	52h	;FDC format gap
	DEFB	60h	;MFM mode
	DEFB	0	;Freeze flag
;
#ifndef CPM3
CHK00:  DEFS    64      ;Checksum vector, drive 0
ALL00:  DEFS    63      ;Single-bit allocation vector, drive 0
#endif
ENDBIO:
	

	end
