/* #define PROGNAM "myutils"    /* Library */
/* #define AUTHOR  "F.T.Gowen"             */
/* #define VERSION "0.01"                  */
/* #define LASTMOD "15/07/1996"            */

#define TRUE        1
#define FALSE       0

#define CR     0x0d
#define FF     0x0c
#define LF     0x0a

#ifdef GCC

#define NUL    '\0'

char cmpext(char * a, char * b);

int fetch(char a[], FILE * b);

void fcrlf(FILE * a);
void makename(char * a, char * b, char * c);
void parsefn(char * a, char * b, char * c);

int fetch(char line[],
	  FILE * rfn)
/* FETCH a LINE, returning its LENGTH and removing trailing blanks */
{
  char d;
  int length;
  length = 0;
  do
    {
      line[length] = getc(rfn);
      if (line[length] == CR) line[length] = getc(rfn);
      if (line[length] == LF) break;
      if (line[length] == EOF) break;
      length++;
    }
  while ((!feof(rfn)) & (line[length-1] != NUL));
  line[length] = NUL;
  if (length == 0) return(length);
/* Remove trailing blanks */
  length--;
  while (line[length] == ' ')
    {
      line[length] = NUL;
      length--;
    }
  length++;
  return(length);
}

char cmpext(char * ext1,
	    char * ext2)
/* CoMPare EXTentions (tags) - as in FILENAME.EXT (or .TAG) */
{
  char flag,*p1,*p2;
  p1 = ext1;
  p2 = ext2;
  if ((*p1!=NUL) & (*p2!=NUL))
    {
      flag = TRUE;
      while (*p1!=NUL)
	{
	  if (*p1!=*p2)
	    {
	      flag = FALSE;
	      break;
	    }
	  else
	    {
	      p1++;
	      p2++;
	    }   
	}
    }
  else flag = FALSE;
  return(flag);
}

void fcrlf(FILE * ch)
{
   putc(CR, ch);
   putc(LF, ch);
}

void makename(char * newname,
	      char * ext,
	      char * oldname)
/* MAKE NEW fileNAME from OLD fileNAME and EXTention - form OLDNAME.EXT */
{
  char *p1,*p2;
  p1 = oldname;
  p2 = newname;
  while ((*p1!=NUL) & (*p1!='.')) *p2++ = *p1++;
  p1 = ext;
  *p2++ = '.';
  while (*p1!=NUL) *p2++ = *p1++;
  *p2 = NUL;
}

void parsefn(char * filename,
	     char * name,
	     char * ext)
/* PARSE FileName into (file)NAME and EXTention */
{
  char *p1,*p2;
  p1 = filename;
  p2 = name;
  while ((*p1!=NUL) & (*p1!='.')) *p2++ = *p1++;
  *p2 = NUL;
  p2 = ext;
  if (*p1 != NUL) p1++;
  while (*p1!=NUL) *p2++ = *p1++;
  *p2 = NUL;
}

#else

char cmpext();

int fetch();

void fcrlf();
void makename();
void parsefn();

int fetch(line, rfn)
/* FETCH a LINE, returning its LENGTH and removing trailing blanks */
  char line[];
  FILE *rfn;
{
  char d;
  int length;
  length = 0;
  do
    {
      line[length] = getc(rfn);
      if (line[length] == CR) line[length] = getc(rfn);
      if (line[length] == LF) break;
      if (line[length] == EOF) break;
      length++;
    }
  while ((!feof(rfn)) & (line[length-1] != NULL));
  line[length] = NULL;
  if (length == 0) return(length);
/* Remove trailing blanks */
  length--;
  while (line[length] == ' ')
    {
      line[length] = NULL;
      length--;
    }
  length++;
  return(length);
}

char cmpext(ext1, ext2)
  char ext1[],ext2[];
/* CoMPare EXTentions (tags) - as in FILENAME.EXT (or .TAG) */
{
  char flag,*p1,*p2;
  p1 = ext1;
  p2 = ext2;
  if ((*p1!=NULL) & (*p2!=NULL))
    {
      flag = TRUE;
      while (*p1!=NULL)
	{
	  if (*p1!=*p2)
	    {
	      flag = FALSE;
	      break;
	    }
	  else
	    {
	      p1++;
	      p2++;
	    }   
	}
    }
  else flag = FALSE;
  return(flag);
}

void fcrlf(ch)
  FILE *ch;
{
   putc(CR, ch);
   putc(LF, ch);
}

void makename(newname, ext, oldname)
/* MAKE NEW fileNAME from OLD fileNAME and EXTention - form OLDNAME.EXT */
  char newname[],ext[],oldname[];
{
  char *p1,*p2;
  p1 = oldname;
  p2 = newname;
  while ((*p1!=NULL) & (*p1!='.')) *p2++ = *p1++;
  p1 = ext;
  *p2++ = '.';
  while (*p1!=NULL) *p2++ = *p1++;
  *p2 = NULL;
}

void parsefn(filename, name, ext)
/* PARSE FileName into (file)NAME and EXTention */
  char filename[],name[],ext[];
{
  char *p1,*p2;
  p1 = filename;
  p2 = name;
  while ((*p1!=NULL) & (*p1!='.')) *p2++ = *p1++;
  *p2 = NULL;
  p2 = ext;
  if (*p1 != NULL) p1++;
  while (*p1!=NULL) *p2++ = *p1++;
  *p2 = NULL;
}

#endif
