;File:	RCP.ASM
;Edit date:	86/12/12.
;Revision level 1.6.
;Serial number 12
;
;	RCP - Resident Console Processor.
;
;	Copyright (c) 1983 by microMethods.
;                             P.O. Box G
;                             Warrenton, Oregon  97146
;
;	Reserved locations.
;
RDSK	EQU	0004H	;4/user number, 4/current disk
RDOS	EQU	0005H	;RDOS vector
RFCB	EQU	005CH	;Resident file control block
RBUF	EQU	0080H	;Resident record buffer
RTPA	EQU	0100H	;FWA for all user programs
;
;	RDOS functions.
;
FCCI	EQU	 1	;console input
FCCO	EQU	 2	;console output
FCBI	EQU	10	;read console buffer
FCST	EQU	11	;get console status
FRST	EQU	13	;reset disk system
FSEL	EQU	14	;select disk
FOPN	EQU	15	;open file
FCLO	EQU	16	;close file
FSFF	EQU	17	;search for first occurence
FSFN	EQU	18	;search for next occurence
FDEL	EQU	19	;delete file
FRDS	EQU	20	;read sequential
FWRS	EQU	21	;write sequential
FCNF	EQU	22	;create new file
FREN	EQU	23	;rename file
FRCD	EQU	25	;return current disk
FDMA	EQU	26	;set DMA
FUSR	EQU	32	;set or get user number
FPAG	EQU	38	;set display page size
;
;	Assembly constants.
;
VERN	EQU	2	;RCP revision level
RECSIZ	EQU	80H	;record size
MEMSIZ	EQU	64	;memory size in k bytes
MEMPAG	EQU	MEMSIZ*4	;memory size in pages
BIOSIZ	EQU	3+12		;CBIOS size in pages
RDOSIZ	EQU	14		;RDOS size in pages
RCPSIZ	EQU	8		;RCP size in pages
;
FALSE	EQU	0
TRUE	EQU	NOT FALSE
;
;	Assembly options.
;
USRPRM	EQU	TRUE	;add user number to prompt
XDRFS	EQU	TRUE	;across-drive file search
;
;	Assembler calculated memory map.
;
BIOFWA	EQU	(MEMPAG-BIOSIZ)*100H	;CBIOS fwa
RDOFWA	EQU	BIOFWA-(RDOSIZ*100H)	;RDOS fwa
RCPFWA	EQU	RDOFWA-(RCPSIZ*100H)	;RCP fwa
;
;	Locations in RDOS.
;
FCC	EQU	RDOFWA	;filter control codes
AWT	EQU	FCC+3	;access word table
;
	ORG	RCPFWA
;
	JMP	RCP1	;coldboot entry
	JMP	RCP	;warmboot entry
;
;	Load command buffer.
;	Entry	HL = command string fwa
;
	JMP	PNC1
	JMP	LDR5	;restart without disk reinit
;
;	Command buffer area.
;
CBUFL:	DB	127	;buffer size
CBUFC:	DB	0	;character count
CBUFF:	EQU	$
	DB	'Copyright (c) 1983 by microMethods.',0
	DB	'P.O. Box G   Warrenton, Oregon  97146',0
	DB	'1.6'
;
;	System configuration address table.
;
	DW	VERN	;serial number
	DW	GSFA	;.submit flag
	DW	PDISK	;loader .path disk
	DW	USRA	;.user number mask
	DW	LDRL	;loader .tpa
	DS	128-($-CBUFF)
CNEXT:	DW	CBUFF	;next char loc
CADDR:	DW	0	;fwa of argument
CDISK:	DB	0	;current disk
NDISK:	DB	0	;next disk
PDISK:	DB	01	;path disk (see LDR)
;
;	M3B - Move 3 bytes.
;	MMB - Move memory bytes.
;	Entry	HL = source fwa
;		DE = destination fwa
;
M3B:	MVI	B,3
;
;	Entry	 B = byte count
;
MMB:	MOV	A,M
	STAX	D
	INX	D
	INX	H
	DCR	B
	JNZ	MMB
	RET
;
;	DDN - Display disk name.
;	Entry	 A = disk number
;
DDN:	ADI	'A'
	CALL	CCO
	MVI	A,':'
;
;	CCO - Console character out.
;	Entry	 A = char
;
CCO:	MOV	E,A
	MVI	C,FCCO
	JMP	RDOS
;
CCO1:	MVI	A,' '	;display one space
CCO2:	PUSH	B	;CCO with save BC
	CALL	CCO
	POP	B
	RET
;
;	EOL - End of line.
;	cr, lf to console
;
EOL:	MVI A,0DH ! CALL CCO2
	MVI A,0AH ! JMP CCO2
;
;	MSG - Display console message.
;	Entry	BC = fwa of message ending in 00
;
MSG:	PUSH	B
	CALL	EOL	;cr,lf
	POP	H
;
MSG1:	MOV	A,M
	ORA	A
	RZ		;If end of message
;
	INX H ! PUSH H
	CALL	CCO
	POP H ! JMP MSG1
;
;	RPS - Reset page size.
;
RPS:	MVI	E,0
;
;	SPS - Set page size.
;	Entry	 E = lines/display page
;
SPS:	MVI	C,FPAG
	JMP	RDOS
;
;	DSI - Disk system initialize.
;
DSI:	MVI	C,FRST
	JMP	RDOS
;
;	BRK - Console break.
;	Exit	 Z = true if no break
;
BRK:	MVI	C,FCST	;get console status
	CALL	RDOS
	ORA	A
	RZ		;If no key pressed
;
	MVI	C,FCCI	;read the char
	CALL	RDOS
	ORA	A
	RET
;
;	GCD - Get current disk.
;	Exit	 A = disk
GCD:	MVI	C,FRCD
	JMP	RDOS
;
;	SDA - Set DMA=resident buffer.
;
SDA:	LXI	D,RBUF
;
;	Entry	DE = disk memory address
;
SDA1:	MVI	C,FDMA
	JMP	RDOS
;
;	CLC - Conditional login CDISK.
;	Called only at reboot entry time.
;	Entry	 Z = true, if "A" is current disk
;
CLC:	RZ		;If CDISK is logged in
;
;	Drive other than "A" is current drive, CDISK.
;	Login CDISK and save the local submit flag.
;
	CALL	SEL
	STA	SUBF
	RET
	NOP ! NOP
;
;	GSF - Get submit flag.
;	High bit of submit flag is an error flag.
;	Exit	HL = .submit flag
;		 A = submit flag=disk number
;		 Z = true, if no batch file
;
GSF:	LXI	H,SUBF
GSFA	EQU	$-2
	MOV	A,M
	ANI	7FH
	RET
;
;	ESF - Erase batch command file.
;
ESF:	CALL	GSF	;check submit flag
	RZ		;If no $a$.SUB file
;
	MVI	M,0	;clear submit flag
	DCR	A	;select submit disk
	CALL	SEL
	LXI	D,BCFCB	;drop $a$.SUB
	CALL	DEL
;
;	SCD - Select CDISK.
;
SCD:	LDA	CDISK	;current disk
;
;	SEL - Select disk.
;	Entry	 A = drive number
;
SEL:	MOV	E,A
	MVI	C,FSEL
	JMP	RDOS
;
;	OCF - Open COM file.
;	Provide search path.
;
OCF:	CALL	ONF	;search PDISK first
	RNZ		;If file found
;
;	Search the current disk.
;
	CALL	SDC
;
;	ONF - Open named file.
;
ONF:	XRA	A	;clear next record
	STA	SFFNR
ONF1:	LXI	D,SFFCB
;
;	OPN - Open file.
;	Entry	DE = fcb fwa
;	Exit	 Z = true if file not found
;
OPN:	MVI	C,FOPN
OPN1:	CALL	RDOS
	INR	A
	RET
;
;	CLO - Close file.
;	Entry	DE = fcb fwa
;
CLO:	MVI C,FCLO ! JMP OPN1
;
;	FNF - Find named file.
;
FNF:	LXI	D,SFFCB
;
;	FFO - Find first occurence.
;	Entry	DE = fcb fwa
;
FFO:	MVI C,FSFF ! JMP OPN1
;
;	FNO - Find next occurence.
;
FNO:	MVI C,FSFN ! JMP OPN1
;
;	DEL - Delete file.
;	Entry	DE = fcb fwa
;
DEL:	MVI C,FDEL ! JMP RDOS
;
;	RDF - Read disk file.
;
RDF:	LXI	D,SFFCB
;
;	RDR - Read disk record.
;	Entry	DE = fcb fwa
;
RDR:	MVI	C,FRDS	;read sequential
RDR1:	CALL	RDOS
	ORA	A
	RET
;
;	WDR - Write disk record.
;	Entry	DE = fcb fwa
;
WDR:	MVI	C,FWRS	;write sequential
	JMP	RDR1
;
;	CNF - Create new file.
;	Entry	DE = fcb fwa
;
CNF:	MVI C,FCNF ! JMP OPN1
;
;	RNF - Rename file.
;	Entry	DE = fcb fwa
;
RNF:	MVI C,FREN ! JMP OPN1
;
;	PUN - Process user number.
;
PUN:	MVI	E,0FFH	;get user
;
;	Entry	E = user number to set user
;
PUN1:	MVI C,FUSR ! JMP RDOS
;
;	SUD - Set user number and disk number in 0004.
;
SUD:	CALL	PUN	;get A=user number
	ADD A ! ADD A ! ADD A ! ADD A
	LXI	H,CDISK
	ORA	M
	STA	RDSK
	RET
;
;	GCC - Get character.
;	Entry	 A = character index
;		 C = ordinal
;	Exit	 A = char from RBUF(A+C)
;
GCC:	LXI	H,RBUF
	ADD	C
	CALL	HLA	;HL=HL+A
	MOV	A,M
	RET
;
;	CAS - Clear autoselect.
;	Exit	 A = NDISK
;		HL = .NDISK
;		 Z = true, if d: not stated
;
CAS:	XRA	A	;clear auto select
	STA	SFFCB
	LXI	H,NDISK	;d:
	MOV	A,M
	ORA	A
	RET
;
;	SDP - Select PDISK.
;	Select first disk to search for COM file.
;
SDP:	CALL	CAS	;clear autoselect
	JNZ	SDN1	;If d: stated, start there
;
;	Select search path starting at PDISK.
;
	INX H ! MOV A,M	;set ndisk=pdisk
	DCX H ! MOV M,A
;
;	SDN - Select NDISK.
;
SDN:	CALL	CAS	;clear autoselect
	RZ		;If no d: selection made
;
SDN1:	DCR	A
	LXI	H,CDISK
	CMP	M
	RZ		;If we are already there
;
	JMP	SEL	;go select NDISK
;
;	SDC - Return to CDISK.
;
SDC:	LDA	NDISK
	ORA	A
	RZ		;If we never left CDISK
;
	DCR	A
	LXI	H,CDISK
	CMP	M
	RZ		;If we are already there
;
	MOV	A,M
	JMP	SEL	;go select CDISK
;
;	CFC - Case fold character.
;	Entry	 A = char
;
CFC:	CPI 'a' ! RC	;If < "a"
	CPI 'z'+1 ! RNC	;If > "z"
	ANI	5FH
	RET
;
;	PNC - Get next command.
;
PNC:	CALL	GSF	;check batch processing
	JZ	PNC3	;If not processing "submit"
;
;	A batch command file is being processed.
;
	DCR	A	;select submit disk
	CALL	SEL
	MVI	A,'?'	;restore afn
	STA	BCFCB+2
	LXI	D,BCFCB	;open $a$.SUB
	CALL	OPN
	JZ	PNC2	;If file not found
;
;	Read a command string from the last record.
;
	LDA	BCFRC	;set next record=record count-1
	DCR	A
	STA	BCFNR
	LXI	D,BCFCB	;read last record
	PUSH	D
	CALL	RDR
	POP	D
	JNZ	PNC2	;If read error
;
	LXI	H,BCFRC	;advance record count
	DCR	M
	DCX	H	;mark file written
	MOV	M,A
	CALL	CLO	;close truncated file
;
	CALL	SCD	;select CDISK
;
;	Move string into command buffer.
;
	LXI	H,RBUF
PNC1:	LXI	D,CBUFF-1
	MVI	B,128	;byte count
	CALL	MMB
	LXI	H,CBUFF	;display command string
	CALL	MSG1
	CALL	BRK	;check console break
	JZ	PNC4	;If no key pressed
	CALL	ESF	;drop $a$.SUB
	JMP	RCP2	;go issue prompt
;
;	Resume console command processing.
;
PNC2:	CALL	ESF	;drop any $a$.SUB file
PNC3:	CALL	SUD	;set user & disk in 4
;
;	Get a command string from the console.
;
	MVI	C,FCBI
	LXI	D,CBUFL
	CALL	RDOS
PNC4:	CALL	CTU	;convert to upper case
	MOV	M,A	;set 00 to mark string end
	LXI	H,CBUFF	;reset char index
	SHLD	CNEXT
	RET
;
;	CTU - Convert command string to upper case.
;	Exit	HL = string lwa + 1
;
CTU:	LXI	H,CBUFF-1	;char count
	MOV	B,M
CTU1:	INX	H
	MOV	A,B
	ORA	A
	RZ		;If end of string
;
	MOV	A,M
	CALL	CFC	;case fold char
	MOV	M,A
	DCR	B
	JMP	CTU1	;loop to end of string
;
;	PCE - Process command error.
;	Entry	CADDR = current scan location
;
PCE:	LHLD	CADDR
	MOV C,L ! MOV B,H
	CALL	MSG	;echo command with ?
	MVI	A,'?'
	CALL	CCO
	CALL	EOL	;cr,lf
	CALL	ESF	;drop any existing "submit" file
	JMP	RCP2	;go issue console prompt
;
;	CSC - Check separator character.
;	Entry	DE = char index
;	Exit	 Z = true if valid separator
;		 A = character
;
CSC:	LDAX D ! ORA A ! RZ	;If terminator, 00
	CPI ' ' ! JC PCE	;If control code
	RZ			;If space
	CPI '=' ! RZ		;If equal sign
	CPI '_' ! RZ		;If underline
	CPI '.' ! RZ		;If period
	CPI ':' ! RZ		;If colon
	CPI ';' ! RZ		;If semicolon
	CPI '<' ! RZ		;If less than
	CPI '>' ! RET		;If greater than
;
;	ILS - Ignore leading spaces.
;	Entry	DE = current scan index
;	Exit	DE = index advanced to first nonblank char
;		 A = char
;
ILS:	LDAX D ! ORA A ! RZ	;If at terminator
	CPI ' ' ! RNZ		;If nonblank found
	INX D ! JMP ILS
;
;	HLA - Set HL = HL + A.
;
HLA:	ADD L ! MOV L,A ! RNC	;If no carry
	INR H ! RET
;
;	CFN - Check filename stated.
;	Exit	HL = .SFNT
;		 A = f1
;		 Z = true, if no filename
;
CFN:	LXI	H,SFFNT
	MOV	A,M
	CPI	' '
	RET
;
;	PFN - Parse filename.
;	Entry	CNEXT = current scan location
;	Exit	CNEXT = next scan location
;		    Z = true if unambiguous filename
;		    A = count of '?'
;
PFN:	MVI	A,0
;
;	Entry	 A = assembly location ordinal
;	Exit	Filename in fcb format at SFFCB+A.
;
PFN1:	LXI	H,SFFCB	;assemble base address
	CALL	HLA	;HL = pack location
	PUSH H ! PUSH H
	XRA	A	;preset no-select
	STA	NDISK
	LHLD	CNEXT	;DE=current scan loc
	XCHG
	CALL	ILS	;get next nonblank char
	XCHG
	SHLD	CADDR	;save start of argument
	XCHG
	POP	H	;pack location
	JZ	PFN2	;If end of command string
;
	SBI	'A'-1
	MOV	B,A	;may be drive code d:
	INX	D	;get next character
	LDAX	D
	CPI	':'
	JZ	PFN3	;If disk select d: stated
;
;	No disk selection is stated.
;
	DCX	D
PFN2:	MVI	M,0	;fcb(0)=0
	JMP	PFN4
;
;	Disk selection d: stated.
;
PFN3:	MOV	A,B
	STA	NDISK
	MOV	M,A	;fcb(0)=d:
	INX	D	;advance scan index
PFN4:	MVI	B,8	;file name char count
PFN5:	CALL	CSC	;get next char
	JZ	PFN9	;If end of filename
;
	INX	H	;advance pack loc
	CPI	'*'
	JNZ	PFN6	;If unambiguous
;
;	Process ambiguous filename.
;
	MVI	M,'?'	;pack fcb with "?"
	JMP	PFN7	;omit advance
;
;	Process unambiguous filename.
;
PFN6:	MOV	M,A	;pack fcb
	INX	D	;advance scan index
PFN7:	DCR	B	;advance char count
	JNZ	PFN5	;loop for 8 characters
;
;	Scan to next separator.
;	Truncate file name to 8 characters.
;
PFN8:	CALL	CSC
	JZ	PFN10	;If separator found
	INX	D	;advance scan index
	JMP	PFN8
;
;	Blank fill file name shorter than 8 characters.
;
PFN9:	INX	H	;advance fcb index
	MVI	M,' '
	DCR	B
	JNZ	PFN9	;loop for remainder of 8 char
;
;	Check filetype prefix (.) present.
;
PFN10:	MVI	B,3	;char count
	CPI	'.'
	JNZ	PFN15	;If type not stated
	INX	D	;advance scan index
;
;	Process filetype.
;
PFN11:	CALL	CSC	;get next character
	JZ	PFN15	;If separator
	INX	H	;advance fcb index
	CPI	'*'
	JNZ	PFN12	;If unambiguous filetype
;
;	Process ambiguous filetype.
;
	MVI	M,'?'	;pack type with "?"
	JMP	PFN13	;omit advance
;
;	Process unambiguous filetype.
;
PFN12:	MOV	M,A
	INX	D	;advance scan index
PFN13:	DCR	B
	JNZ	PFN11	;loop for 3 characters
;
;	Find next separator.
;	Truncate filetype to 3 characters.
;
PFN14:	CALL	CSC
	JZ	PFN16	;If separator
	INX	D	;advance scan index
	JMP	PFN14
;
;	Blank fill filetype shorter than 3 characters.
;
PFN15:	INX	H	;advance fcb
	MVI	M,' '
	DCR	B
	JNZ	PFN15	;loop for remainder of 3 char
;
;	Clear extent, spare byte, and s2.
;
PFN16:	MVI	B,3
PFN17:	INX	H	;advance fcb
	MVI	M,0
	DCR	B
	JNZ	PFN17	;loop for 3 bytes
;
;	Save current scan index.
;
	XCHG
	SHLD	CNEXT
;
;	Set Z false if ambiguous filename or filetype packed.
;
	POP	H	;fcb fwa
	LXI	B,11	;B=0 C=11
PFN18:	INX	H	;advance fcb index
	MOV	A,M
	CPI	'?'
	JNZ	PFN19	;If not ambiguous
	INR	B
PFN19:	DCR	C
	JNZ	PFN18	;loop over filename and filetype
;
	MOV	A,B	;count of "?"
	ORA	A
	RET
;
;	PDV - Process numeric value argument.
;	Assemble decimal or hexidecimal value.
;	Exit	HL = value
;		 A = low order byte, L
;
;	Examples:
;		save 24 myfile.com	decimal value
;		save h:1A myfile.com	hex value
;;
PDV:	CALL	PFN	;parse digit string into SFFNT
	LXI	D,SFFNT
	LXI	H,0
PDV1:	LDAX	D
	CPI	' '
	JZ	PDV4	;If done
	INX	D
	PUSH	D
	SUI	'0'	;convert to binary
	JC	PCE	;If < 0
	CPI	10
	JC	PDV2	;If < 10
	SBI	7
	CPI	10
	JC	PCE	;If nonnumeric
	CPI	16
	JNC	PCE	;If nonnumeric
PDV2:	MOV	C,A
	MVI	B,0
	PUSH	H	;multiply by 10 or 16
	DAD	H
	DAD	H
	POP	D
	LDA	NDISK	;check h:
	CPI	'H'-'A'+1
	CZ	PDV3	;If hex
	DAD	D
	DAD	H
	DAD	B
	POP	D
	JMP	PDV1
;
PDV3:	MOV D,H ! MOV E,L ! RET 
;
PDV4:	MOV	A,L
	RET
;
;	PCC - Process console command.
;	Enter with parsed filename in fcb at SFFNT.
;	Exit	 C = built-in command ordinal
;		   = RCPC if transient program call, or d:
;
PCC:	LXI	H,RCPB	;text table of built-ins
	MVI	C,0	;preset command ordinal
;
PCC1:	MOV	A,C
	CPI	RCPC	;max ordinal
	RNC		;If text table exhausted
;
;	Compare filename with built-in commands.
;
	LXI	D,SFFNT	;preset fcb index
	MVI	B,4	;compare length
PCC2:	LDAX	D
	CMP	M
	JNZ	PCC3	;If mismatch
	INX	D	;advance fcb index
	INX	H	;advance text index
	DCR	B
	JNZ	PCC2	;loop for 4 char
;
;	We have a match on 4 characters.
;
	LDAX	D	;check 5th char
	CPI	' '
	JNZ	PCC4	;If not space, mismatch
;
;	We have a hit on built-in command at ordinal C.
;
	MOV	A,C
	RET
;
;	Skip to next text table entry.
;
PCC3:	INX	H
	DCR	B
	JNZ	PCC3	;loop to end of entry
;
;	HL is positioned to next text table entry.
;
PCC4:	INR	C	;advance command ordinal
	JMP	PCC1
;
;	Simulate warmboot.
;
RCP0:	LDA	RDSK
	MOV	C,A
;
;	RCP - Resident Console Processor.
;	Main program.
;	Enter at RCP to clear the command buffer.
;	Enter at RCP1 from coldboot.
;
RCP:	XRA	A	;clear command buffer
	STA	CBUFC
;
;	Entry	 C = 4/user number, 4/current disk
;
RCP1:	LXI	SP,STACK
	PUSH	B	;save current disk
	MOV	A,C	;set requested user
	RAR ! RAR ! RAR ! RAR
	ANI	0FH
	MOV	E,A
	CALL	PUN1	;process set user
	CALL	DSI	;disk system initialize
	STA	SUBF
	POP	B	;set requested disk
	MOV	A,C
	ANI	0FH
	STA	CDISK
	CALL	CLC	;conditional login CDISK
	CALL	SUD	;preset user & disk in 0004
;
;	Process any preset command.
;
	LDA	CBUFC
	ORA	A
	JNZ	RCP3	;If a command is present
;
;	Issue system console prompt.
;
RCP2:	LXI	SP,STACK
	CALL	RPS	;disable paging
	CALL	EOL	;cr,lf
	IF	USRPRM
	CALL	PUN	;get user number
	ORA	A
	CNZ	DPC0	;If not user 0
	ENDIF
	CALL	GCD	;get current disk
	ADI 'A'    ! CALL CCO
	MVI A,'>'  ! CALL CCO
;
;	Get next command.
;
	CALL	PNC
RCP3:	CALL	SDA	;set DMA = RBUF
	CALL	GCD	;get current disk
	STA	CDISK
	CALL	PFN	;parse filename
	CNZ	PCE	;If ambiguous, error
;
	LDA	NDISK	;stated disk d:
	ORA	A
	CNZ	LDR	;If not built-in
;
;	Could be a built-in command.
;
RCP4:	CALL	PCC	;A=command ordinal
	LXI	H,RCP5	;set return on stack
	PUSH	H
	LXI	H,RCPA	;processor address table
	CALL	AWT
	XCHG
	PCHL		;go to processor
;
;	Built-in commands exit to RCP5.
;
RCP5:	CALL	SDC	;return to CDISK
RCP6:	CALL	PFN	;parse next argument
	LDA	SFFNT
	SUI	' '
	LXI	H,NDISK	;d:
	ORA	M
	JNZ	RCP4	;If anything found
	JMP	RCP2
;
;	Address table of command processors.
;	Table entry	16/processor address
;	Parallels text table RCPB
;
RCPA	EQU	$
	DW	DIR	;directory
	DW	ERA	;erase
	DW	TYP	;type
	DW	SAV	;save
	DW	REN	;rename
	DW	USR	;user
	DW	PAG	;page
	DW	LDR	;loader
;
;	Text table of built-in commands.
;	Parallels RCPA
;
RCPB	EQU	$
	DB	'DIR '
	DB	'ERA '
	DB	'TYPE'
	DB	'SAVE'
	DB	'REN '
	DB	'USER'
	DB	'PAGE'
RCPC	EQU	($-RCPB)/4	;max ordinal
;
;
;	DIR - Process directory display.
;	DIR d:afn
;
DIR:	CALL	PFN	;parse d:afn
	CALL	SDN	;select d:
	CALL	CFN	;check f1
	JNZ	DIR2	;If filename stated
;
;	Display all files in the directory.
;	Fill fcb with "?".
;
	MVI	B,8+3
DIR1:	MVI	M,'?'
	INX	H
	DCR	B
	JNZ	DIR1	;loop over name & type
;
;	Filename is in fcb.
;
DIR2:	MVI	E,0	;display column
	PUSH	D
	CALL	FNF	;find named file
	LXI	B,DIRA	;"no file"
	CZ	MSG	;If file not found
;
DIR3:	JZ	DIR12	;If done
	DCR	A	;directory ordinal
	RRC ! RRC ! RRC	;*32
	ANI	60H
	MOV	C,A
	MVI	A,10	;get t2
	CALL	GCC
	RAL		;carry=t2'
	JC	DIR11	;If "system" file
;
	POP	D	;advance display column
	MOV	A,E
	INR	E
	PUSH	D
;
;	A = display column.
;
	ANI	3
	JNZ	DIR4	;If same display line
;
;	Advance display line.
;
	PUSH	B
	CALL	EOL	;cr,lf
	CALL	GCD	;get current disk
	CALL	DDN	;display disk "d:"
	POP	B
	JMP	DIR5
;
DIR4:	CALL	CCO1	;one space
	MVI	A,':'
	CALL	CCO2
;
;	Display a filename.
;
DIR5:	MVI	B,0	;char counter
DIR6:	MOV	A,B
	CALL	GCC	;get next char
	ANI	7FH
	CPI	' '
	CC	DIR8	;If user byte
;
DIR7:	CALL	CCO2
	INR	B	;advance char count
	MOV	A,B
	CPI	1+8+3
	JNC	DIR10	;If usr & filename processed
;
	CPI	1+8
	JNZ	DIR6	;If not at start of type
;
	CALL	CCO1	;one space for readability
	JMP	DIR6
;
;	Display user.
;
DIR8:	ADI	'a'-1
	CPI	'a'-1
	RNZ		;If not user 0
DIR9:	MVI	A,' '
	RET
;
DIR10:	CALL	DPC	;display file size indicator
DIR11:	CALL	BRK	;check console break
	JNZ	DIR12	;If break
;
	CALL	FNO	;find next occurence
	JMP	DIR3
;
DIR12:	POP	D	;clear stack
	RET
;
DIRA:	DB	'No file',0
;
;	DPC - Display file size indicators.
;	Entry	 C = ordinal of dir entry in buffer
;	Size indicator = (+)page count
;	The + sign indicates nonzero extent,
;	i.e., a large file.
;
DPC:	CALL	CCO1	;one space
	MVI	A,12	;get ex
	CALL	GCC
	ORA	A
	MVI	A,'+'
	CZ	DIR9	;If ex=0, get space
	CALL	CCO2
	MVI	A,15	;get rc
	CALL	GCC
	ORA	A
	JZ	DPC2	;If rc empty 
	RAR
;
;	Decimal display value in A.
;
DPC0:	ACI	0
	MOV	B,A
	XRA	A
DPC1:	ADI	1
	DAA
	DCR	B
	JNZ	DPC1	;loop for B counts
;
DPC2:	PUSH	PSW
	RRC ! RRC ! RRC ! RRC
	CALL	DPC3	;display decimal digit
	POP	PSW
	ANI	0FH
	JMP	DPC4
;
DPC3:	ANI	0FH
	JZ	CCO1	;If blank fill leading zero
DPC4:	ADI	'0'
	JMP	CCO2
;
;	ERA - Process erase command.
;	ERA d:afn
;
;	Note:  Drive  d:  must be stated.
;
;	Syntax to erase all files, is
;		ERA *.* d:*.*
;
ERA:	CALL	PFN	;parse filename
	CPI	11
	CZ	PFN	;If *.*
;
	CALL	SDN	;select d:
	LDA	NDISK
	ORA	A
	JZ	PCE	;If d: not stated
	LXI	D,SFFCB	;fcb
	CALL	DEL
	INR	A
	LXI	B,DIRA	;"No file"
	CZ	MSG	;If not found
	RET
;
;	TYP - Process display ASCII file.
;	TYPE d:ufn
;
TYP:	CALL	PFN	;parse filename
	JNZ	PCE	;If ambiguous
	CALL	SDN	;select d:
	CALL	ONF	;open file
	JZ	TYP3	;If not found
;
	CALL	EOL	;cr,lf
	LXI	H,TBUFI	;mark buffer empty
	MVI	M,80H
	INX	H	;set page size
	MOV	E,M
	CALL	SPS
TYP1:	LXI	H,TBUFI
	MOV	A,M
	CPI	80H
	JC	TYP2	;If buffer not empty
;
	PUSH	H
	CALL	RDF	;read named file
	POP	H
	RNZ		;If eoi
;
	XRA	A	;reset buffer index
	MOV	M,A
TYP2:	INR	M	;advance buffer index
	LXI	H,RBUF
	CALL	HLA	;HL=HL+A
	MOV	A,M	;get char
	CPI	1AH
	RZ		;If cntl-Z, end of file
;
	CALL	FCC	;filter control codes
	CNC	CCO	;If printable character
	CALL	BRK
	JZ	TYP1	;If not console break
	RET
;
TYP3:	CALL	SDC	;go back to CDISK
	JMP	PCE	;echo with "?"
;
;	SAV - Process copy memory image to disk.
;	SAVE n d:ufn
;	SAVE n *	sets save area fwa = n
;
SAV:	CALL	PDV	;get n=page count
	PUSH	H
	CALL	PFN	;parse d:ufn
	JNZ	SAV6	;If ambiguous
;
	CALL	SDN	;select d:
	LXI	D,SFFCB	;fcb
	PUSH	D	;create new file
	CALL	DEL
	POP	D
	CALL	CNF
	POP	H	;page count
	JZ	SAV3	;If no directory space
;
	XRA	A	;reset next record
	STA	SFFNR
	DAD	H	;HL=record count
	LXI	D,RTPA	;fwa of saved area
SAVA	EQU	$-2
SAV1:	MOV	A,H
	ORA	L
	JZ	SAV2	;If done
;
	DCX	H	;advance record count
	PUSH	H
	LXI	H,RECSIZ	;advance memory loc
	DAD	D
	PUSH	H
	CALL	SDA1	;set DMA
	LXI	D,SFFCB	;write disk record
	CALL	WDR
	POP	D	;memory loc
	POP	H	;sector count
	JNZ	SAV3	;If write error
	JMP	SAV1
;
;	Close the file.
;
SAV2:	LXI	D,SFFCB
	CALL	CLO
	JNZ	SAV4	;If no error
;
;	We have a write error, or a close error.
;
SAV3:	LXI	B,SAVB	;"No space"
	CALL	MSG
SAV4:	CALL	SDA	;restore DMA=0080
;
;	Restore TPA fwa.
;
SAV5:	LXI	H,RTPA	;restore save area fwa
	PUSH	H
;
;	Process SAVE n *.
;	Set save area fwa = n
;
SAV6:	POP	H
	SHLD	SAVA
	RET
;
SAVB:	DB	'No space',0
;
;	REN - Process rename a file.
;	REN a:new=b:old
;	REN x=d:	sets LDR path = d:
;	REN x=*		displays LDR path=d:
;	REN *		simulates warmboot
;
REN:	CALL	PFN	;parse a:new
	JNZ	RCP0	;If ambiguous
;
	CALL	SDN	;select a:
	CALL	FNF	;find named file
	JNZ	REN5	;If new name exists
;
;	Move a:new into fcb RBT area.
;
	LXI	H,SFFCB
	LXI	D,SFRBT
	MVI	B,16
	CALL	MMB
;
	LHLD	CNEXT	;get next nonblank char
	XCHG
	CALL	ILS
	CPI	'='
	JNZ	REN4	;If syntax error
;
	XCHG
	INX	H
	SHLD	CNEXT
;
	LDA	NDISK	;save a:
	PUSH	PSW
	CALL	PFN	;parse b:old
	POP	B	;set B=a:
	JNZ	REN7	;If ambiguous
;
	CALL	CAS	;HL=.ndisk, A=b:
	JZ	REN1	;If b: not specified, ok
;
	CMP	B
	JNZ	REN6	;If b: ne a:
;
REN1:	MOV	M,B	;restore NDISK = a:
	CALL	FNF	;find b:old
	JZ	REN2	;of old file not found
;
	LXI	D,SFFCB	;rename the file
	CALL	RNF
	RNZ		;If file found
;
;	File not found.
;
REN2:	LXI	B,DIRA	;"No file"
REN3:	JMP	MSG
;
;	Syntax error.
;
REN4:	CALL	SDC	;go back to CDISK
	JMP	PCE	;echo with "?"
;
;	File already exists.
;
REN5:	LXI	B,RENA	;"File exists"
	JMP	REN3
;
;	Process REN x=d:
;	Set loader search path first disk.
;	x = any nonexistent filename
;	d = first disk to search
;
REN6:	INX	H	;set PDISK=d:
	MOV	M,A
;
;	Display LDR path.
;
REN7:	LXI	B,RENB	;"path="
	CALL	MSG
	LDA	PDISK	;display path disk
	DCR	A
	JMP	DDN
;
RENA:	DB	'File exists',0
RENB:	DB	'Path=',0
;
;	USR - Process change control point.
;	USER n
;
USR:	CALL	PDV	;get n
	ANI	0FH
USRA	EQU	$-1
	MOV	E,A
;
;	Go to control point n.
;
	CALL	PUN1
	CALL	SUD	;update user in 0004
	RET
;
;	PAG - Process set size of the display page.
;	PAGE n
;
PAG:	CALL	PDV	;get A=n, lines/page
	STA	PAGES	;set page size
	RET
;
;	CCT - Copy command text to RBUF.
;	Copy command text less "a:prog" to 0080.
;	Exit	 B = character count
;
CCT:	LHLD	CNEXT
	MVI	B,0	;reset char count
	LXI	D,RBUF+1
;
CCT1:	MOV A,M
	STAX D
	ORA A   ! RZ	;If end of command string
;
	INX H ! INX D ! INR B
	JMP	CCT1
;
;	MIN - Select smaller of two values.
;	Entry	HL = value1
;		DE = value2
;	Exit	HL = MIN(HL,DE)
;
MIN:	MOV A,L ! SUB E
	MOV A,H ! SBB D
	RC		;If HL<DE
;
	XCHG
	RET
;
;	LDR - Process load user program.
;	Also processes change current disk command.
;
;	a:
;	a:prog b:file1 c:file2 argstring
;
LDR:	CALL	CFN	;check f1
	JNZ	LDR1	;If program being called
;
;	Process a:
;	Change current disk.
;
	CALL	CAS	;get a:
	RZ		;If null command
;
;	R: will rerun the current user program.
;
	CPI	'R'-'A'+1
	JZ	LDR4	;If in-place rerun requested
;
;	Go to disk a:
;
	DCR	A
	STA	CDISK
	CALL	SEL	;select a:
	CALL	SUD	;update disk in 0004
	RET
;
;
;	Process a:prog b:file1 c:file2 argstring.
;	Call a:prog.COM
;
LDR1:	CALL	SDP	;select first search disk
	LXI	D,SFTYP	;check filetype stated
	LDAX	D
	STA	LOFLG	;set/clear load-only
	CPI	' '
	LXI	H,LDRA	;"COM"
	CZ	M3B	;If command call
;
	CALL	OCF	;open a:prog.COM
	JZ	LDR6	;If file not found
;
	LHLD	RDOS+1	;TPA upper limit
	LXI	D,RCPFWA
	CALL	MIN	;HL=memtop
	XCHG
	LHLD	SAVA	;set load point
	SHLD	LDRL
LDR2:	PUSH D ! PUSH H
	XCHG
	CALL	SDA1	;set DMA
	CALL	RDF	;read disk record
	POP	H	;advance DMA
	JNZ	LDR3	;If end of file, or error
;
	LXI	D,RECSIZ
	DAD	D
	POP	D	;memtop
	CALL	MIN
	LXI	B,LDRA	;"Too big"
	JNC	MSG	;If file would overlay RCP
	JMP	LDR2
;
;	Check disk read error.
;
LDR3:	POP	H	;clear stack
	DCR	A
	JNZ	LDR6	;If read error
;
;	The user's program has been loaded.
;
	CALL	SDC	;go back to CDISK
	CALL	CCT	;copy command text
	MOV	A,B	;set char count
	STA	RBUF
	CALL	PFN	;parse b:file1 into FNT area
;
	MVI	A,16	;parse c:file2 into RBT area
	CALL	PFN1
	XRA	A	;clear "next record" byte
	STA	SFFNR
;
	LXI	D,RFCB	;move two FNTs to 005C
	LXI	H,SFFCB
	MVI	B,33	;byte count
	CALL	MMB
;
;	Call the user's program.
;
LDR4:	CALL	EOL	;cr,lf
	CALL	SAV5	;restore load pt=RTPA
	CALL	SDA	;set DMA=RBUF
	LDA	LOFLG
	CPI	' '
	CZ	RTPA	;If not load-only
LDRL	EQU	$-2
;
;	User's transient program may return here.
;
LDR5:	LXI	SP,STACK
	CALL	SCD	;select CDISK
	JMP	RCP2	;go issue console prompt
;
;	COM file not found.
;
LDR6:	CALL	SDC	;go back to CDISK
	JMP	PCE	;echo "prog?"
;
LDRA:	DB	'COM'	;command filetype
LDRB:	DB	' file too big',0
;
;	Stack area.
;
	DS	2*8
STACK	EQU	$
;
;	Data space.
;
LOFLG:	DB	' '	;nonblank=load only
TBUFI:	DB	0	;TYPE command buffer index
PAGES:	DB	24	;lines/page  00=disable paging
;
;	General purpose file control block.
;
SFFCB:	DB	0
SFFNT:	DB	'        '
SFTYP:	DB	'   '
	DB	0,0,0,0
SFRBT:	DS	16	;RBT area
SFFNR:	DB	0	;next record
SFRRN:	DB	0,0,0
;
;	Batch processing area.
;
SUBF:	DB	0	;0=no sub  x=sub disk+1
;
;	Batch command file fcb.
;
BCFCB:	DB	0,'$?$     SUB',0,0
BCFS2:	DB	0	;s2
BCFRC:	DB	0	;record count
	DS	16	;RBT area
BCFNR:	DB	0	;next record
	DB	0,0,0
	DB	0FFH
